define([
    'backbone',
    '../models/organization',
    'backbone.paginator'
], function(Backbone, OrganizationModel){

    var OrganizationsCollection = Backbone.Paginator.requestPager.extend({
        model: OrganizationModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadorganization/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            isGrid: function(){ return this.isGrid; },
            customPaginate: function(){ return this.customPaginate; },
            detailedInfo: function(){ return this.detailedInfo; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            if(this.customPaginate) {
                this.perPage = this.customPaginate;
            }

            this.filterUsed = response.filterUsed;
            this.desktopMasks = response.desktopMasks;
            this.mobileMasks = response.mobileMasks;
            this.moneyFormat = response.moneyFormat;
            this.customerGroups = response.groups;
            this.organizationIndustries = response.industries;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return OrganizationsCollection;
});