define([
    'backbone',
    '../collections/lead-notes',
    'text!../templates/paginator.html',
    'text!../templates/notes.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment', 'carousel', 'swipecarousel'
], function(Backbone,
            LeadNotesCollection, PaginatorTmpl, LeadNotesTmpl, i18n, moment, carousel, swipecarousel
){

    var LeadsNoteView = Backbone.View.extend({
        el: $('#lead-notes-list'),
        events: {
            'click a[data-role=delete]': 'deleteNote',
            'click td.lead-grid-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.notes = new LeadNotesCollection();

            this.notes.on('reset', this.renderNotes, this);
            this.notes.on('add', this.renderNotes, this);
            this.notes.on('destroy', this.renderNotes, this);
        },
        render: function(){
            this.notes.pager();
        },
        renderNotes: function(){
            this.$el.empty();
            this.$el.html(_.template(LeadNotesTmpl, {'notesCollection': this.notes.toJSON(), 'i18n': i18n, 'moment' : moment}));

            var swiper = new swipecarousel('.swiper-container', {
                slidesPerView: 2,
                spaceBetween: 10,
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                    //type: "fraction",
                },
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                }
            });

        },
        deleteNote: function(e){
            var cid = $(e.currentTarget).data('note-id'),
                model = this.notes.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                }
            });
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.notes.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.notes.goTo(this.notes.firstPage);
                        break;
                    case 'last':
                        this.notes.goTo(this.notes.totalPages);
                        break;
                    case 'prev':
                        this.notes.requestPreviousPage();
                        break;
                    case 'next':
                        this.notes.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadsNoteView;
});