define([
    'backbone',
    '../models/lead-timeline',
    'backbone.paginator'
], function(Backbone, LeadTimelineModel){

    var LeadsTimelineCollection = Backbone.Paginator.requestPager.extend({
        model: LeadTimelineModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadstimeline/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            timelineType:function(){return this.timelineType},
            leadId:function(){return this.leadId},
            organizationId:function(){return this.organizationId}

        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.moneyFormat = response.moneyFormat;
            this.customerGroups = response.groups;
            this.leadStages = response.stages;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            this.usersList = response.users;
            this.currentUserId = response.currentUserId;
            this.currencySymbol = response.currencySymbol;
            this.userTimezoneOffset = response.userTimezoneOffset;
            this.gatewayLabelsList = response.gatewayLabelsList;

            return this.server_api.count ? response.data : response;
        }

    });

    return LeadsTimelineCollection;
});