define([
    'backbone',
    '../models/lead-email-sequence-log',
    'backbone.paginator'
], function(Backbone, LeadEmailSequenceLogModel){

    var LeadEmailSequenceLogCollection = Backbone.Paginator.requestPager.extend({
        model: LeadEmailSequenceLogModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leademailsequencelog/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     100,
            totalPages:  100
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            leadId:function(){return this.leadId},
            fromYear:function(){return this.fromYear},
            fromMonth:function(){return this.fromMonth}
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            this.currentYear = response.currentYear;
            this.currentMonth = response.currentMonth;
            this.listOfDays = response.listOfDays;
            this.totalEmailsSent = response.totalEmailsSent;
            this.totalSmsSent = response.totalSmsSent;
            this.totalEmailsDelayed = response.totalEmailsDelayed;
            this.totalSmsDelayed = response.totalSmsDelayed;
            this.listOfWeeks = response.listOfWeeks;
            this.dateNow = response.dateNow;
            this.fullMonthName = response.fullMonthName;
            this.currentUserTimeZone = response.currentUserTimeZone;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadEmailSequenceLogCollection;
});