define([
    'backbone',
    'text!../templates/organization-custom-param-grid-select-value-row.html',
    'i18n!../../../nls/config_'+$('#lead-organization-custom-fields-leads-config-system-language').val()+'_ln.js'
], function(Backbone, OrganizationCustomGridSelectValueTmpl, i18n){
    var OrganizationCustomParamsFormView = Backbone.View.extend({
        el: $('#organization-custom-params-main-div'),
        events: {
            'submit #organization-custom-params-form': 'submit',
            'submit #organization-custom-params-form-dropdown': 'submitDropdownForm',
            'keyup .param_name': 'updateParamsLabel',
            'click #organization-field-type': 'selectType',
            'click .add-selection-btn': 'addSelection',
            'click button.item-remove': 'deleteSelection',
            'click .close-screen': 'closeDropdownScreen'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#organization-custom-params-main-div');
            this.$el.find('#organization-custom-params-form').attr('action', $('#website_url').val()+'api/leads/organizationcustomparamsconfig');
            this.$el.find('#organization-custom-params-form-dropdown').attr('action', $('#website_url').val()+'api/leads/organizationcustomparamsconfig');
        },
        render: function(){
            return this;
        },
        updateParamsLabel: function(e) {
            var currentName = $(e.currentTarget).val();
            $(e.currentTarget).closest('form').find('.param_label').val(currentName);
        },
        selectType: function(e){
            var target = $(e.currentTarget);
            this.$el.find('.checkbox-default-values').hide();

            $('.param_name').val('');
            $('.param_label').val('');
            $('#organization-custom-params-form-save').val('Add custom field');

            if(!$('.message').hasClass('mt20px')){
                $('.message').addClass('mt20px');
            }

            if(target.val() == 'checkbox'){
                this.$el.find('.checkbox-default-values').show();
                $('.message').removeClass('mt20px');
            }else if(target.val() == 'select' || target.val() == 'radio'){
                $('.wrap').remove();
                $('#organization-custom-param-type').val(target.val());
                $('#manage-organization-dropdown-container').show('slide', { direction: 'right'});
            }else{
                this.$el.find('.organization-custom-param-id').val('');
            }
        },
        addSelection: function(){
            $('.option-list-holder').append(_.template(OrganizationCustomGridSelectValueTmpl, {'optionData': ''}));
        },
        deleteSelection: function(e){
            e.preventDefault();
            var thisEl = $(e.currentTarget),
                selectionId = thisEl.data('cid');

            if(selectionId != ''){
                showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function() {
                    $.ajax({
                        url: $('#website_url').val()+'api/leads/organizationcustomparamsconfig/id/'+selectionId+'/customDropdownSelectionFlag/customDropdownSelectionFlag',
                        type: 'DELETE'
                    }).done(function(response) {
                        thisEl.closest('.wrap').remove();
                        showMessage('deleted', false, 5000);
                    }).fail(function(response){
                        showMessage('error', true, 5000);
                    });
                });
                return false;
            }else{
                thisEl.closest('.wrap').remove();
            }
        },
        closeDropdownScreen: function(){
            var self= this;

            $('#manage-organization-dropdown-container').hide('slide', { direction: 'right'});
            self.$el.trigger('OrganizationCustomParamsForm:created');
        },
        submit: function(e){
            e.preventDefault();
            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize();

            this.sendAjax(formParams, form, self);

        },
        submitDropdownForm: function (e) {
            e.preventDefault();
            var self = this,
                form = $(e.currentTarget),
                isValid = true,
                dropdownValues = $('.wrap'),
                dropdownValRes = [],
                dropdownIdsRes = [];

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            if(!dropdownValues.length){
                showMessage(_.isUndefined(i18n['Add one selection please'])?'Add one selection please':i18n['Add one selection please'], true);
                return false;
            }

            _.each(dropdownValues, function (el) {
                if($(el).find('input').val() != ''){
                    var selectionId = $(el).find('input').data('selection-id');
                    if(selectionId != '') {
                        dropdownIdsRes.push(selectionId);
                    }
                    dropdownValRes.push($(el).find('input').val());
                }
            });
            dropdownValRes = dropdownValRes.join(',');
            $('#organization-custom-param-name').val(dropdownValRes);

            dropdownIdsRes = dropdownIdsRes.join(',');
            $('#organization-custom-param-options-ids').val(dropdownIdsRes);

            var formParams = form.serialize();

            this.sendAjax(formParams, form, self);
        },
        sendAjax: function (formParams, form, self) {
            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                self.$el.trigger('OrganizationCustomParamsForm:created');
                showMessage(response.responseText, false, 5000);
                $('#manage-organization-dropdown-container').hide('slide', { direction: 'right'});
                $('#organization-field-type').val('text');
                form.find('input[type="text"]').val('');
                form.find('.checkbox-default-values').hide();
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        }
    });

    return OrganizationCustomParamsFormView;
});
