define([
    'backbone',
    '../collections/lead-source.js',
    'text!../templates/paginator.html',
    'text!../templates/source-row.html',
    'i18n!../../../nls/config_'+$('#lead-source-leads-config-system-language').val()+'_ln.js'
], function(Backbone,
            LeadsSourceCollection, PaginatorTmpl, LeadSourceRowTmpl, i18n
){

    var LeadSourceGridView = Backbone.View.extend({
        el: $('#lead-source-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteLeadSource',
            'blur .lead-source-edit-attribute'  : 'editLeadSource',
            'click td.lead-source-grid-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.leadSources = new LeadsSourceCollection();
            this.$el =  $('#lead-source-grid-table');
            this.leadSources.on('reset', this.renderLeadSources, this);
            this.leadSources.on('add', this.renderLeadSources, this);
            this.leadSources.on('destroy', this.renderLeadSources, this);
        },
        render: function(){
            this.leadSources.pager();
        },
        renderLeadSources: function(){
            this.$el.find('tbody').empty();
            this.leadSources.each(this.renderLeadSource, this);
            this.leadSources.info()['i18n'] = i18n;
            if((this.leadSources.length == 0) && (this.leadSources.currentPage != 0)){
                this.leadSources.requestPreviousPage();
            }
            this.$('td.lead-source-grid-paginator').html(this.templates.paginator(this.leadSources.information));
        },
        renderLeadSource: function(leadsSourceData){
            this.$el.find('tbody').append(_.template(LeadSourceRowTmpl, {'leadsSourceData': leadsSourceData, 'i18n': i18n}));
            return false;
        },
        deleteLeadSource: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.leadSources.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        editLeadSource: function(e)
        {
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                leadSourceId = el.closest('tr').data('lead-source-id'),
                leadSourceModel = this.leadSources.get(leadSourceId),
                attrName =  el.data('attrName');

            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                leadSourceModel.set(attrName, currentValue);
                leadSourceModel.set('secureToken', $('#lead-source-secure-token').val());
                leadSourceModel.save(null, {
                    success: function(model, response){
                        showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.leadSources.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.leadSources.goTo(this.leadSources.firstPage);
                        break;
                    case 'last':
                        this.leadSources.goTo(this.leadSources.information.lastPage);
                        break;
                    case 'prev':
                        this.leadSources.requestPreviousPage();
                        break;
                    case 'next':
                        this.leadSources.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadSourceGridView;
});