define([
    'backbone',
    '../collections/lead-social-services.js',
    'text!../templates/paginator.html',
    'text!../templates/social-service-row.html',
    'i18n!../../../nls/config_'+$('#lead-social-services-leads-config-system-language').val()+'_ln.js'
], function(Backbone,
            LeadsSocialServicesCollection, PaginatorTmpl, LeadSocialServiceRowTmpl, i18n
){

    var LeadSocialServicesGridView = Backbone.View.extend({
        el: $('#lead-social-services-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteSocialService',
            'blur .lead-social-service-edit-attribute'  : 'editSocialService',
            'click td.lead-social-services-grid-paginator a.page': 'navigate',
            'click .lead-social-service-edit-image': 'triggerEditSocialServiceImage'
        },

        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.socialServices = new LeadsSocialServicesCollection();
            this.$el =  $('#lead-social-services-grid-table');
            this.socialServices.on('reset', this.renderSocialServices, this);
            this.socialServices.on('add', this.renderSocialServices, this);
            this.socialServices.on('destroy', this.renderSocialServices, this);
        },
        render: function(){
            this.socialServices.pager();
        },
        renderSocialServices: function(){
            this.$el.find('tbody').empty();
            this.socialServices.each(this.renderSocialService, this);
            this.socialServices.info()['i18n'] = i18n;
            if((this.socialServices.length == 0) && (this.socialServices.currentPage != 0)){
                this.socialServices.requestPreviousPage();
            }
            this.$('td.lead-social-services-grid-paginator').html(this.templates.paginator(this.socialServices.information));
        },
        renderSocialService: function(leadsSocialServicesData){
            this.$el.find('tbody').append(_.template(LeadSocialServiceRowTmpl, {'leadsSocialServicesData': leadsSocialServicesData}));
            return false;
        },
        deleteSocialService: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.socialServices.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        editSocialService: function(e)
        {
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                socialServiceId = el.closest('tr').data('lead-social-service-id'),
                leadSocialServiceModel = this.socialServices.get(socialServiceId),
                attrName =  el.data('attrName');

            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                leadSocialServiceModel.set(attrName, currentValue);
                leadSocialServiceModel.set('secureToken', $('#social-services-secure-token').val());
                leadSocialServiceModel.save(null, {
                    success: function(model, response){
                        showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }
        },
        triggerEditSocialServiceImage: function(e)
        {
            var currentEl = $(e.currentTarget),
                socialServiceId = currentEl.closest('tr').data('lead-social-service-id');


            $('#update-social-service-data').val(socialServiceId);
            $('#social-service-logo-uploader-pickfiles').trigger('click');
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.socialServices.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.socialServices.goTo(this.socialServices.firstPage);
                        break;
                    case 'last':
                        this.socialServices.goTo(this.socialServices.information.lastPage);
                        break;
                    case 'prev':
                        this.socialServices.requestPreviousPage();
                        break;
                    case 'next':
                        this.socialServices.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadSocialServicesGridView;
});
