define([
    'backbone',
    '../models/lead-type.js',
    'i18n!../../../nls/config_'+$('#lead-type-leads-config-system-language').val()+'_ln.js'
], function(Backbone, LeadTypeModel, i18n){
    var LeadTypeFormView = Backbone.View.extend({
        el: $('#lead-type-form'),
        events: {
            'submit': 'submit',
            'keyup #lead-type-name': 'updateTypeLabel',
            'change #default-lead-type': 'changeDefaultLeadType'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-type-form');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leadtype');
        },
        updateTypeLabel: function(e) {
            var currentName = $(e.currentTarget).val();
            $(e.currentTarget).closest('form').find('#lead-type-label').val(currentName);
        },
        render: function(){
            return this;
        },
        changeDefaultLeadType: function(e){
            var typeId = $(e.currentTarget).val(),
                self = this;

            this.leadTypeModel = new LeadTypeModel();

            this.leadTypeModel.fetch({data: {id: typeId},
                'success': function(leadSocialServiceModel){
                    leadSocialServiceModel.set('default', '1');
                    leadSocialServiceModel.set('secureToken', $('#lead-type-secure-token').val());
                    leadSocialServiceModel.save({id: typeId}, {
                        success: function(model, response){
                            showMessage(response.responseText, false, 5000);
                            self.$el.trigger('LeadTypeForm:created');
                        },
                        error: function(model, response){
                            showMessage(response.responseJSON, true, 5000);
                        }
                    });
                }
            });
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true,
                leadTypeLabel = $('#lead-type-label').val();

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize();

            $.ajax({
                url: form.attr('action'),
                type:  'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                 self.$el.trigger('LeadTypeForm:created');
                 showMessage(response.responseText.message, false, 5000);

                var leadTypeId = response.responseText.typeId;
                var htmlOption = '<option value="'+ leadTypeId +'">'+ leadTypeLabel +'</option>';

                $('#default-lead-type').append(htmlOption);
                 form.find('input[type="text"]').val('');
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        }
    });

    return LeadTypeFormView;
});