import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val()
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            selectedUserId: 'getSelectedUserId',
            filterDateFrom: 'getFilterDateFrom',
            filterDateTo: 'getFilterDateTo',
            changedDate: 'getChangedDate',
            oppSalesGeneralInfo:'getOppSalesGeneralInfo',
            filterPeriodMonths:'getFilterPeriodMonths'
        })
    },
    watch: {
        selectedUserId (newUserId, oldUseId) {
            console.log(`Old user id ${oldUseId} - new user id ${newUserId}`);
            if (newUserId !== oldUseId) {
                this.applyFilter();
            }
        },
        changedDate () {
            this.applyFilter();
        }
    },
    methods: {
        async applyFilter() {
            const result = await this.$store.dispatch('getGeneralOppAndSalesStats', {'router':this.$router, 'userId':this.selectedUserId, 'filterDateFrom':this.filterDateFrom, 'filterDateTo':this.filterDateTo, 'filterPeriodMonths':this.filterPeriodMonths});
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreen = true;
            }
        }
    },
    async created(){
        this.applyFilter();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
