import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            loadedScreen: false,
            actionType: 'all',
            websiteUrl: $('#website_url').val(),
            perPageDataValues : {
                '10':10,
                '25':25,
                '50':50,
                '100':100
            },
            columnsHeaders: {},
            listOfDefaultColumnNamesOrder: [],
            options: [],
            columnSelectionModel:[],
            tableColumnOrderName:'',
            restrictColumnEditing:'0',
            columnsModified:false,
            applyColumnOrderToAllUsers:'',
            userPresetsList: [],
            presetId:0,
            currentPresetId:0,
            newPresetName:'',
            presetDefault:false
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            selectedUserId: 'getSelectedUserId',
            engagedLeadsData: 'getEngagedLeadsInfo',
            engagedLeadsAdditionalInfo:'getEngagedLeadsAdditionalInfo',
            toCurrency:'toCurrency',
            oppStats:'getOppStats',
            unescapeValue:'unescapeValue'
        })
    },
    watch: {
        selectedUserId (newUserId, oldUseId) {
            console.log(`Old user id ${oldUseId} - new user id ${newUserId}`);
            if (newUserId !== oldUseId) {
                this.$store.commit('setPaginationData',
                    {
                        engagedLeads: {
                            currentPage: 1,
                            itemsPerPage: 10,
                            totalItems: 0,
                            visiblePages: 4
                        }
                    }
                );

                this.applyFilter();
            }
        }
    },
    methods: {
        changeActionType(actionType) {

            if (actionType !== this.actionType) {
                this.$store.commit('setPaginationData',
                    {
                        engagedLeads: {
                            currentPage: 1,
                            itemsPerPage: 10,
                            totalItems: 0,
                            visiblePages: 4
                        }
                    }
                );
            }

            this.actionType = actionType;
            this.applyFilter();
        },
        async applyFilter() {
            const result = await this.$store.dispatch('getEngagedLeadsData', {'router':this.$router, 'actionType': this.actionType, 'userId':this.selectedUserId});
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreen = true;
            }
        },
        async deleteLead(id) {
            showConfirm(this.$t('message.areYouSure'), async () => {
                const result = await this.$store.dispatch('deleteLead', {'router':this.$router, 'id': id});
                    showMessage(this.$t('message.leadHasBeenDeleted'), false, 1500);
                    const resultData = await this.$store.dispatch('getEngagedLeadsData', {'router':this.$router, 'actionType': this.actionType, 'userId':this.selectedUserId});
                    if(resultData.status === 'error') {
                        showMessage('Please re-login', true, 3000);
                    } else {
                        this.loadedScreen = true;
                    }
            });
        },
        async getInitialData()
        {
            const result = await this.$store.dispatch('getEngagedLeadsData', {'router':this.$router, 'actionType': this.actionType, 'userId':this.selectedUserId});
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreen = true;
            }

            this.newPresetName = '';
            this.tableColumnOrderName = result['tableColumnsInfo']['tableColumnOrderName'];
            this.userPresetsList = result['tableColumnsInfo']['userPresetsList'];
            this.presetId = result['tableColumnsInfo']['presetId'];
            this.restrictColumnEditing = result['tableColumnsInfo']['restrictColumnEditing'];

            this.listOfDefaultColumnNamesOrder = result['tableColumnsInfo']['listOfDefaultColumnNamesOrder'];
            let columnHeaders = result['tableColumnsInfo']['columnHeaders'],
                definedColumnOrder = result['tableColumnsInfo']['definedColumnOrder'];

            let columnHeadersList = {},
                self = this,
                options = [];

            _.each(columnHeaders, function(columnHeader, index) {
                if(typeof columnHeader.skipVUETranslator === 'undefined') {
                    columnHeader.message = self.$t('message.'+columnHeader.message);
                }

                columnHeadersList[index] = columnHeader;
                if (columnHeader.editable) {
                    options.push(columnHeader);
                }
            });

            if (this.userPresetsList[this.presetId]['is_default'] == '1') {
                this.presetDefault = true;
            }

            this.columnsHeaders = columnHeadersList;
            this.options = options;

            _.each(definedColumnOrder, function(columnHeader, index) {
                self.columnSelectionModel[index] = columnHeaders[columnHeader];
                self.listOfDefaultColumnNamesOrder[index] = columnHeader;
            });
        },
        async markAsDefault(event)
        {
            let isChecked = event.target.checked,
                self = this;

            if (isChecked === true) {
                showConfirm(this.$t('message.areYouSure'), async () => {
                    const result = await this.$store.dispatch('updatePreset', {'router':this.$router, 'id': this.presetId, 'isDefault':'1', 'tableName':this.tableColumnOrderName});
                    this.getInitialData();

                }, function(){
                    self.presetDefault = false;
                });
            } else {
                showConfirm(this.$t('message.areYouSureDefaultPreset'), async () => {
                    const result = await this.$store.dispatch('updatePreset', {'router':this.$router, 'id': this.presetId, 'isDefault':'0', 'tableName':this.tableColumnOrderName});

                    this.getInitialData();
                }, function(){
                    self.presetDefault = true;
                });
            }
        },
        async loadPreset()
        {
            let userPresetsList = this.userPresetsList,
                self = this,
                presetId = this.presetId,
                fieldsData = userPresetsList[presetId]['fields_data'],
                columnHeaders = this.columnsHeaders;

            if (this.userPresetsList[presetId]['is_default'] == '1') {
                this.presetDefault = true;
            } else {
                this.presetDefault = false;
            }

            _.each(fieldsData, function(columnHeader, index) {
                self.columnSelectionModel[index] = columnHeaders[columnHeader];
                self.listOfDefaultColumnNamesOrder[index] = columnHeader;

            });
        },
        async deletePreset()
        {
            if (this.presetId == '0') {
                return false;
            }

            showConfirm(this.$t('message.areYouSure'), async () => {
                const result = await this.$store.dispatch('deletePreset', {'router':this.$router, 'id': this.presetId});

                if(result.status === 'error') {
                    showMessage('Please re-login', true, 3000);
                } else {
                    showMessage(this.$t('message.leadPresetDeleted'), false, 1500);
                    this.getInitialData();
                }
            });
        },
        changeTableColumn(event, columnIndex) {
            this.listOfDefaultColumnNamesOrder[columnIndex] = event.target.value;
            if (this.presetId == '0' && this.restrictColumnEditing == '1') {
                return false;
            }

            this.columnsModified = true;
        },
        headerTableChanged(event, columnIndex){
            this.listOfDefaultColumnNamesOrder[columnIndex] = event.name;
            this.columnsModified = true;
        },
        async discardColumnOrder(){
            this.columnsModified = false;
            this.loadPreset();
        },
        async saveColumnOrder(type)
        {
            let tableColumnOrder = [],
                newPresetName = this.newPresetName,
                presetId = '';

            if (type === 'update') {
                presetId = this.presetId;
                if (this.restrictColumnEditing == '1' && this.presetId == '0') {
                    return false;
                }
            } else {
                if (newPresetName === '') {
                    showMessage(this.$t('message.pleaseSpecifyPresetName'), true, 1500);
                    return false;
                }
            }

            _.each(this.columnSelectionModel, function(columnHeader, index) {
                if (typeof columnHeader !== 'undefined') {
                    tableColumnOrder[index] = columnHeader.name;
                }
            });

            showConfirm(this.$t('message.areYouSure'), async () => {
                const result = await this.$store.dispatch('saveColumnTableOrder', {'router':this.$router, 'userId':this.selectedUserId, 'tableName':this.tableColumnOrderName, 'tableColumnOrder':tableColumnOrder, 'presetName':newPresetName, 'presetId':presetId});
                if(result.status === 'error') {
                    showMessage(result.message, true, 3000);
                    return false;
                }

                this.applyColumnOrderToAllUsers = false;
                this.columnsModified = false;
                this.getInitialData();
            });
        },
    },
    async created(){
        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
