import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            itemsQuantity:0,
            informationMsgAd:this.$t('message.toEnsureThatAllContactsAddedAd'),
            campaign:'select',
            advertisingList:[],
            leadSendEmailServiceQuantityBlockEl:'hidden',
            leadSendEmailServiceQuantityBlockProcessing:'hidden',
            itemsProcessed:0,
            leadSendEmailServiceQuantity:this.$t('message.contactsHaveBeenSuccessfullyAdded'),
            horizontalLineEl:'hidden',
            originalLabelEl:'',
            originalLabel1:this.$t('message.youreNowAdding'),
            additionalLabelEl:'hide',
            additionalLabel1:this.$t('message.youreNowAddingAll'),
            originalLabel:this.$t('message.recordsWithAnEmailAddressToYourCampaignList'),
            additionalLabel:this.$t('message.recordsWithAnEmailAddressMatchingYourFilterToYourCampaignList'),
            originalLabel2:this.$t('message.checkThisBoxIfYouWishToAddAll'),
            additionalLabel2:this.$t('message.uncheckThisBoxIfYouWishToAdd'),
            additionalCountSelectedLeads:0,
            originalLabelMain2:this.$t('message.recordsMatchingYourFilter'),
            additionalLabelMain2:this.$t('message.selectedRecords'),
            emailServiceBlock:'hidden',
            useFilter:false,
            sendToEmailServiceEl:'hidden',
            disabled:false,
            emailMarketingFunction:'assign',
            campaignSelectedListsIds: {},
            campaignSelectedListsLabels: {},
            beforeSelectedCampaign: {
                'campaign': ''
            },
            adAudienceLimitMsg:'',
            addNewLists:'hidden',
            newListName:'',
            subscribeList:[],
            checkedLists:[],
            sendToEmailService:this.$t('message.addContactToList'),
        }
    },
    components: {
    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedItemsData:'getCheckedItems',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            ucFirstAllText:'ucFirstAllText',
        })
    },
    watch: {


    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveMassAction', 0);
        },
        async submitRegularForm()
        {
            let self = this;

            this.itemsProcessed = 0;
            this.emailServiceBlock = 'hidden';
            this.leadSendEmailServiceQuantityBlockEl = 'hidden';


            let marketingCampaignsName = this.campaign,
                checkedLists = this.checkedLists;

            if (marketingCampaignsName === 'select'){
                showMessage(this.$t('message.pleaseChooseService'), true, 5000);
                this.emailServiceBlock = '';
                return false;
            }

            if (checkedLists.length === 0){
                showMessage(this.$t('message.pleaseChooseList'), true, 5000);
                this.emailServiceBlock = '';
                return false;
            }

            this.disabled = true;

            let lists = [];
            this.campaignSelectedListsIds[marketingCampaignsName] = [];
            this.campaignSelectedListsLabels[marketingCampaignsName] = [];

            var audinceListsIds = [],
                audinceListsLabels = [];
            checkedLists.forEach(function(listId, index) {
                audinceListsIds.push(listId);

                self.subscribeList.forEach(function(sList, i) {
                    if (listId == sList.id) {
                        audinceListsLabels.push(sList.name);
                    }
                });
            });

            this.campaignSelectedListsIds[marketingCampaignsName] = audinceListsIds;
            this.campaignSelectedListsLabels[marketingCampaignsName] = audinceListsLabels;

            delete this.campaignSelectedListsIds[''];
            delete this.campaignSelectedListsLabels[''];

            lists['ids'] = this.campaignSelectedListsIds;
            lists['names'] = this.campaignSelectedListsLabels;

            this.sendToRemarketingList(lists, 0, []);
        },
        async sendToRemarketingList(lists, stepToRemarketingListService, accountErrors)
        {
            this.beforeSelectedCampaign.campaign = '';
            this.campaignSelectedListsIds = {};
            this.campaignSelectedListsLabels = {};

            let filters = toRaw(this.filterData),
                matchingFilter = 0;

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            if (this.useFilter) {
                matchingFilter = 1;
            }

            const resultsendToRemarketingList = await this.$store.dispatch('sendToRemarketingListMassAction', {
                'router': this.$router,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'marketingCampaignsName': this.campaign,
                'lists': JSON.stringify(lists['ids']),
                'listsLabels': JSON.stringify(lists['names']),
                'filters' : filters,
                'matchingFilter': matchingFilter,
                'stepToRemarketingListService' : stepToRemarketingListService,
                'accountErrors': accountErrors,
                'filterQuantity': this.itemsQuantity,
                'requestType': this.emailMarketingFunction
            });

            this.leadSendEmailServiceQuantityBlockProcessing = '';

            if (parseInt(resultsendToRemarketingList.error) === 1 && typeof resultsendToRemarketingList.message !== 'undefined') {
                showMessage(resultsendToRemarketingList.message, true, 5000);
                return false;
            }

            let quantity = parseInt(resultsendToRemarketingList.responseText.quantity);
            this.itemsProcessed = this.itemsProcessed + quantity;

            if (parseInt(resultsendToRemarketingList.error) === 0){
                let accountErrors = [];
                if (resultsendToRemarketingList.responseText.accountErrors) {
                    accountErrors = resultsendToRemarketingList.responseText.invalidLeads;
                }
                this.sendToRemarketingList(lists, stepToRemarketingListService + 1, accountErrors);
            } else {
                this.leadSendEmailServiceQuantityBlockProcessing = 'hidden';
                if (typeof resultsendToRemarketingList.responseText.accountErrors !== 'undefined') {
                    let errorMessage = resultsendToRemarketingList.responseText.message,
                        errorInformation = '<p>';

                    for (const [value, errorName] of Object.entries(resultsendToRemarketingList.responseText.accountErrors)) {
                        for (const [lkey, lname] of Object.entries(lists.ids)) {
                            if (lkey != '') {
                                lname.forEach(function(llname, llkey){
                                    if (typeof errorName[llname] !== 'undefined') {
                                        errorInformation += lkey + ': ' + lists.names[lkey][llkey] + '(' + llname + ') has error: ' + errorName[llname] + '<br />';
                                    }
                                });
                            }
                        }
                    }

                    errorInformation += '</p>';

                    if (_.isEmpty(resultsendToRemarketingList.responseText.accountErrors)) {
                        if (this.emailMarketingFunction === 'assign') {
                            showMessage(this.$t('message.addedToAdAudienceList'), false, 5000);
                        } else {
                            showMessage(this.$t('message.removedFromAdAudienceList'), false, 5000);
                        }
                    } else {
                        showMessage(errorMessage + errorInformation, true, 5000);
                    }
                    this.disabled = false;
                    this.emailServiceBlock = '';
                    this.leadSendEmailServiceQuantityBlockEl = '';
                } else {
                    this.leadSendEmailServiceQuantityBlockEl = '';
                    if (this.emailMarketingFunction === 'assign') {
                        showMessage(this.$t('message.addedToAdAudienceList'), false, 5000);
                    } else {
                        showMessage(this.$t('message.removedFromAdAudienceList'), false, 5000);
                    }
                    this.disabled = false;
                    this.emailServiceBlock = '';
                }
            }
        },
        async getInitialData()
        {
            if (Object.keys(this.checkedItemsData).length === 0) {
                showMessage(this.$t('message.pleaseChooseAtLeastOneLead'), true, 3000);
                this.closeMassAction();
            }

            let filters = toRaw(this.filterData);

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            const result = await this.$store.dispatch('countLeadsMassAction', {
                'router': this.$router,
                'filters': filters,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'uniqueEmail': 1,
                'advertising': 1,
            });

            if (parseInt(result.error) !== 1) {
                this.itemsQuantity = parseInt(result.responseText.quantity);
                this.additionalCountSelectedLeads = parseInt(result.responseText.additionalQuantity);

                if (parseInt(this.itemsQuantity) === 1) {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactHasBeenSuccessfullyAdded');
                } else {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactsHaveBeenSuccessfullyAdded');
                }

                if (parseInt(this.itemsQuantity) === 1) {
                    this.originalLabel = this.$t('message.recordWithAnEmailAddressToYourCampaignList');
                    this.additionalLabel = this.$t('message.recordMatchingYourFilterToYourCampaignList');
                }

                if (this.itemsQuantity > 0) {
                    this.advertisingList = result.responseText.advertisingList;

                    this.originalLabel = this.$t('message.recordsWithAnEmailAddressToYourCampaignList');
                    this.additionalLabel = this.$t('message.recordsWithAnEmailAddressMatchingYourFilterToYourCampaignList');

                    if (parseInt(this.additionalCountSelectedLeads) === 1) {
                        this.originalLabelMain2 = this.$t('message.recordMatchingYourFilter');
                        this.additionalLabelMain2 = this.$t('message.selectedRecord');
                    }

                    this.loadedScreen = true;
                }
            } else {
                showMessage(this.$t('message.noLeadsHaveBeenFoundWithEmailAddress'), true, 5000);
                this.closeMassAction();
            }
        },
        async selectCampaign()
        {
            let checkedLeadRows = Object.keys(this.checkedItemsData).join(','),
                filters = toRaw(this.filterData),
                self = this;

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            var audinceListsIds = [],
                audinceListsLabels = [];
            this.checkedLists.forEach(function(listId, index) {
                audinceListsIds.push(listId);

                self.subscribeList.forEach(function(sList, i) {
                    if (listId == sList.id) {
                        audinceListsLabels.push(sList.name);
                    }
                });
            });

            this.campaignSelectedListsIds[this.beforeSelectedCampaign.campaign] = audinceListsIds;
            this.campaignSelectedListsLabels[this.beforeSelectedCampaign.campaign] = audinceListsLabels;

            if (this.campaign !== 'select') {
                this.beforeSelectedCampaign.campaign = this.campaign;
                if (this.campaign === 'adwords') {
                    this.adAudienceLimitMsg = this.$t('message.googleAdsThrottleTheirApi');
                } else {
                    this.adAudienceLimitMsg = this.$t('message.fbAdsThrottleTheirApi');
                }
            } else {
                this.beforeSelectedCampaign.campaign = '';
                this.adAudienceLimitMsg = '';
            }

            if (this.useFilter) {
                this.countServiceLeads(filters, 0, checkedLeadRows);
                this.originalLabelEl = 'hide';
                this.additionalLabelEl = '';
            } else {
                this.countServiceLeads(filters, checkedLeadRows, null);
                this.originalLabelEl = '';
                this.additionalLabelEl = 'hide';
            }

            this.leadSendEmailServiceQuantityBlockProcessing = 'hidden';
            this.itemsProcessed = 0;
            this.leadSendEmailServiceQuantityBlockEl = 'hidden';
            this.emailServiceBlock = 'hidden';
            this.addNewLists = 'hidden';

            if (this.campaign !== 'select') {
                const resultService = await this.$store.dispatch('getAdvertisingServiceMassAction', {
                    'router': this.$router,
                    'serviceName': this.campaign,
                });

                if (parseInt(resultService.error) === 1){
                    if (resultService.responseText.message == 'No ad account assigned to this website') {
                        let youNeedConnect = this.$t('message.youNeedConnectFb');

                        if (this.campaign === 'adwords') {
                            youNeedConnect = this.$t('message.youNeedConnectGoogle');
                        }

                        let connectionMessage = (youNeedConnect)
                            + ' ' + '<a href="' + this.websiteUrl + '/plugin/leads/run/advertiserAccountConfig/" target="_blank" title="Click to open config" style="text-decoration: underline;">' + (this.$t('message.here')) +'</a>'
                            + ' ' + (this.$t('message.toAccessTheConfigurationPanel'));
                        showMessage(connectionMessage, true, 6000);
                    } else {
                        showMessage(resultService.responseText.message, false, 1000);
                    }

                    this.subscribeList = [];
                    this.sendToEmailServiceEl = 'hidden';
                    this.emailServiceBlock = 'hidden';
                    this.addNewLists = 'hidden';
                    this.horizontalLineEl = 'hidden';
                    this.campaign = 'select';
                    this.adAudienceLimitMsg = '';
                    return false;
                } else {
                    this.subscribeList = [];
                    let list = resultService.responseText.list;

                    if (list !== null && list.length > 0) {
                        this.subscribeList = list;
                    } else {
                        showMessage(this.$t('message.noAvailableLists'), true, 5000);
                    }

                    this.sendToEmailServiceEl = '';
                    this.emailServiceBlock = '';
                    this.addNewLists = '';
                    this.horizontalLineEl = '';
                }
            } else {
                this.sendToEmailServiceEl = 'hidden';
                this.horizontalLineEl = 'hidden';
                this.subscribeList = [];
            }
        },
        async matchingFilter(event)
        {
            let isChecked = event.target.checked,
                filters = toRaw(this.filterData),
                checkedLeads = Object.keys(this.checkedItemsData).join(',');

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            this.useFilter = false;

            if (isChecked === true) {
                this.useFilter = true;
                this.countServiceLeads(filters, 0, checkedLeads);
                this.originalLabelEl = 'hide';
                this.additionalLabelEl = '';
            } else {
                this.countServiceLeads(filters, checkedLeads, null);
                this.originalLabelEl = '';
                this.additionalLabelEl = 'hide';
            }
        },
        async addNewList()
        {
            let self = this,
                listName = this.newListName.replace(/[^a-zA-Z0-9-_ ]/g, '');
            if (listName != '') {
                this.newListName = listName;
                showConfirm(this.$t('message.areYouSureWantAddNewList'), async () => {
                    const result = await this.$store.dispatch('addAdvertiserlistMassAction', {
                        'router': this.$router,
                        'listName': self.newListName,
                        'account': self.campaign,
                    });

                    if (parseInt(result.error) === 1) {
                        showMessage(result.responseText.message, true, 2000);
                        return false;
                    } else {
                        if (typeof result.responseText.listId === 'undefined') {
                            showMessage(result.responseText.message, true, 2000);
                        } else {
                            showMessage('(list: '+result.responseText.listId+') created successfully', false, 2000);
                            self.subscribeList.push({id: result.responseText.listId, name: self.newListName});
                            self.newListName = '';

                            // let filters = toRaw(self.filterData),
                            //     checkedLeads = Object.keys(self.checkedItemsData).join(',');
                            //
                            // if (this.useFilter) {
                            //     this.countServiceLeads(filters, 0, checkedLeads);
                            //     this.originalLabelEl = 'hide';
                            //     this.additionalLabelEl = '';
                            // } else {
                            //     this.countServiceLeads(filters, checkedLeads, null);
                            //     this.originalLabelEl = '';
                            //     this.additionalLabelEl = 'hide';
                            // }
                        }
                    }
                }, async () => {
                    return false;
                });



            } else {
                showMessage(this.$t('message.pleaseEnterListName'), true, 2000);
            }


        },
        async changeEmailMarketing(event)
        {
            if (this.emailMarketingFunction === 'unassign') {
                this.informationMsgAd = this.$t('message.toEnsureThatAllContactsRemovedAd');
                this.sendToEmailService = this.$t('message.removeContactFromList');
                this.originalLabel1 = this.$t('message.youreNowRemoving');
                this.originalLabel2 = this.$t('message.checkThisBoxIfYouWishToRemoveAll');
                this.additionalLabel1 = this.$t('message.youreNowRemovingAll');
                this.additionalLabel2 = this.$t('message.uncheckThisBoxIfYouWishToRemove');

                if (parseInt(this.itemsQuantity) === 1) {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactHasBeenSuccessfullyRemoved');
                    this.originalLabel = this.$t('message.recordWithAnEmailAddressFromYourCampaignList');
                    this.additionalLabel = this.$t('message.recordMatchingYourFilterFromYourCampaignList');
                } else {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactsHaveBeenSuccessfullyRemoved');
                    this.originalLabel = this.$t('message.recordsWithAnEmailAddressFromYourCampaignList');
                    this.additionalLabel = this.$t('message.recordsMatchingYourFilterFromYourCampaignList');
                }
            } else {
                this.informationMsgAd = this.$t('message.toEnsureThatAllContactsAddedAd');
                this.sendToEmailService = this.$t('message.addContactToList');
                this.originalLabel1 = this.$t('message.youreNowAdding');
                this.originalLabel2 = this.$t('message.checkThisBoxIfYouWishToAddAll');
                this.additionalLabel1 = this.$t('message.youreNowAddingAll');
                this.additionalLabel2 = this.$t('message.uncheckThisBoxIfYouWishToAdd');

                if (parseInt(this.itemsQuantity) === 1) {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactHasBeenSuccessfullyAdded');
                    this.originalLabel = this.$t('message.recordWithAnEmailAddressToYourCampaignList');
                    this.additionalLabel = this.$t('message.recordMatchingYourFilterToYourCampaignList');
                } else {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactsHaveBeenSuccessfullyAdded');
                    this.originalLabel = this.$t('message.recordsWithAnEmailAddressToYourCampaignList');
                    this.additionalLabel = this.$t('message.recordsWithAnEmailAddressMatchingYourFilterToYourCampaignList');
                }
            }
        },
        async countServiceLeads(filters, checkedLeads, additionalParams)
        {
            const result = await this.$store.dispatch('countLeadsMassAction', {
                'router': this.$router,
                'filters': filters,
                'leadIds': checkedLeads,
                'uniqueEmail': 1,
                'additionalParams': additionalParams,
            });

            this.itemsQuantity = parseInt(result.responseText.quantity);
            this.additionalCountSelectedLeads = parseInt(result.responseText.additionalQuantity);

            let countSelectedLeads = this.itemsQuantity,
                additionalCountSelectedLeads = this.additionalCountSelectedLeads;

            this.originalLabel = this.$t('message.recordsWithAnEmailAddressToYourCampaignList');
            this.additionalLabel = this.$t('message.recordsWithAnEmailAddressMatchingYourFilterToYourCampaignList');
            this.originalLabelMain2 = this.$t('message.recordsMatchingYourFilter');
            this.additionalLabelMain2 = this.$t('message.selectedRecords');

            if (this.emailMarketingFunction === 'unassign') {
                this.originalLabel = this.$t('message.recordsWithAnEmailAddressFromYourCampaignList');
                this.additionalLabel = this.$t('message.recordsMatchingYourFilterFromYourCampaignList');

                this.leadSendEmailServiceQuantity = this.$t('message.contactsHaveBeenSuccessfullyRemoved');
                if (parseInt(countSelectedLeads) === 1) {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactHasBeenSuccessfullyRemoved');
                }
            } else {
                this.leadSendEmailServiceQuantity = this.$t('message.contactsHaveBeenSuccessfullyAdded');
                if (parseInt(countSelectedLeads) === 1) {
                    this.leadSendEmailServiceQuantity = this.$t('message.contactHasBeenSuccessfullyAdded');
                }
            }

            if (parseInt(countSelectedLeads) === 1) {
                this.originalLabel = this.$t('message.recordWithAnEmailAddressToYourCampaignList');
                this.additionalLabel = this.$t('message.recordMatchingYourFilterToYourCampaignList');

                if (this.emailMarketingFunction === 'unassign') {
                    this.originalLabel = this.$t('message.recordWithAnEmailAddressFromYourCampaignList');
                    this.additionalLabel = this.$t('message.recordMatchingYourFilterFromYourCampaignList');
                }
            }

            if (parseInt(additionalCountSelectedLeads) === 1) {
                this.originalLabelMain2 = this.$t('message.recordMatchingYourFilter');
                this.additionalLabelMain2 = this.$t('message.selectedRecord');
            }
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
