import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import { isProxy, toRaw } from 'vue';
import moment from "moment";
import plupload from "plupload";

export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            loadedScreenData: false,
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            websiteUrl: $('#website_url').val(),
            imageMagnificPopupExtensions:[],
            uploader:'',
            uploadedSizeCount:0,
            uploadedFiles:[],
            uploadedFilesList:[],
            failedFilesUpload:[],
            uploadStarted:false,
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getDocumentsAdditionalSubTabData',
            documentsData: 'getDocumentsSubTabData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
        })
    },
    methods: {
        async loadData() {

            const result = await this.$store.dispatch('documentsSubTab', {'router':this.$router, 'leadId': this.leadId});

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                return false;
            } else {
                this.imageMagnificPopupExtensions = result.imageMagnificPopupExtensions;
                this.loadedScreenData = true;
                setTimeout(() =>  $('.tooltip').tooltip(),  100);
                setTimeout(() =>  this.initUploader(),  100);
            }
        },
        initUploader() {
            let options = {
                runtimes: 'html5,flash,html4',
                browse_button: 'upload-file-button-dragdrop',
                container: 'uploader-documents-block',
                rename         : true,
                max_file_size  : this.generalAdditionalInfo.allowedUploadData.fileSize+'mb',
                max_file_count : this.generalAdditionalInfo.allowedUploadData.fileUploads,
                url: this.websiteUrl+'api/leads/leaddocuments/',
                unique_names: false,
                multipart_params: {
                    'secureToken':document.getElementById('leads-screen-config-token').value,
                    'leadId':this.leadId,
                },
                multi_selection: true,
                dragdrop: true,
                drop_element: 'upload-file-button-dragdrop',
            };

            if (this.uploader === '') {

                this.uploader = new plupload.Uploader(options);

                this.uploader.init();

                this.uploader.bind('BeforeUpload', _.bind(this.beforePhotoUpload, this));
                this.uploader.bind('FilesAdded', _.bind(this.filesPhotoAdded, this));
                this.uploader.bind('UploadProgress', _.bind(this.uploadPhotoProgress, this));
                this.uploader.bind('FileUploaded', _.bind(this.filePhotoUploaded, this));
                this.uploader.bind('Error', _.bind(this.handleUploadErrorsPhoto, this));
                this.uploader.bind('UploadComplete', _.bind(this.uploadCompletePhoto, this));
            }
        },
        beforePhotoUpload: function(up, file) {
            this.uploadStarted = true;
            $('#progressbar-uploader-documents-file').fadeIn().progressbar({value: 0});
            $('#progressbar-uploader-documents-text').fadeIn();
        },
        uploadPhotoProgress: function(up, file) {
            $('#progressbar-uploader-documents-file').progressbar({value: file.percent}).text(file.name);
            $('#progressbar-uploader-documents-text').text(' ' +this.$t('message.documentsSubIsUploading') + ' (' + file.percent + '%)');
        },
        filesPhotoAdded (up, files) {
            let failedFilesUploadAdditionalFiltered = [];

            this.failedFilesUploadAdditional = {};

            if (files.length) {
                _.each(this.failedFilesUploadAdditional, function (fileName, key) {
                    _.each(files, function (fileN, k) {
                        if (parseInt(fileN.id) === parseInt(key)) {
                            failedFilesUploadAdditionalFiltered.push(fileName);
                        }
                    });

                });

                if (failedFilesUploadAdditionalFiltered.length) {
                    this.failedFilesUploadAdditional = failedFilesUploadAdditionalFiltered;
                } else {
                    this.failedFilesUploadAdditional = {};
                }
            }

            this.uploader.settings.multipart_params.multipleFiles = 0;
            if (files.length > 1) {
                this.uploader.settings.multipart_params.multipleFiles = 1;
            }

            this.uploader.settings.multipart_params.secureToken = document.getElementById('leads-screen-config-token').value;
            this.failedFilesUpload = [];
            this.uploader.start();
        },
        filePhotoUploaded: function (up, file, info) {
            let response = JSON.parse(info.response);
            if (parseInt(response.error) === 0) {
                this.uploadedFiles.push(response.fileStoredName);
                this.uploadedFilesList.push({
                    'name': file.name,
                    'fileStoredName': response.fileStoredName,
                    'size': file.size
                });
                this.maxUploadedFiles += 1;
            } else {
                let errorMessage = '';
                if (typeof response.fileName !== 'undefined' && response.fileName != '') {
                    if (typeof (response.message) === 'object') {
                        for (var i in response.message) {
                            errorMessage += '<li>' + response.message[i] + '</li>';
                        }
                    } else {
                        errorMessage += '<li> ' + 'File' + ' \'' + response.fileName + '\' (' + response.message + ')' + '</li>';
                    }
                }

                if (typeof response.fileName !== 'undefined' && response.type === 'mmsMaxSize') {
                    if (errorMessage !== '') {
                        errorMessage + '</br>' + response.message;
                    } else {
                        errorMessage = response.message;
                    }
                }

                this.failedFilesUpload.push(errorMessage);
            }
        },
        handleUploadErrorsPhoto: function(up, err) {
            this.failedFilesUploadAdditional = {};

            let errorMessage = '';

            if (err.code === -600) {
                errorMessage = '<li> ' + 'The file ' + ' \'\"' + (err.file ? err.file.name : "") + '\" size exceeds the limit allowed and cannot be uploaded' + '</li>';
            } else {
                errorMessage = '<li> ' + 'File' + ' \'' + (err.file ? err.file.name : "") + '\' (' + err.message + ')' + '</li>';
            }

            this.failedFilesUploadAdditional[err.file.id] = errorMessage;
            showMessage(errorMessage, true, 3000);
        },
        uploadCompletePhoto: function(up, files, response) {
            $('#progressbar-uploader-photo-documents-file').delay(800).fadeOut();
            $('#progressbar-uploader-photo-documents-text').delay(800).fadeOut();
            let msg = '';
            if (this.failedFilesUploadAdditional.length) {
                let msg = 'Photos uploaded';
                if (this.failedFilesUpload.length) {
                    _.each(this.failedFilesUpload, function (fileName, key) {
                        msg += fileName;
                    });
                }
                msg += '</ul>';
                showMessage(msg, true, 3000);
            } else {
                if (this.failedFilesUpload.length) {
                    if (up.files.length === this.failedFilesUpload.length) {
                        if (up.files.length > 1) {
                            let msg = this.$t('message.documentsSubFilesNotUploaded') + '</br>';
                        } else {
                            let msg = this.$t('message.documentsSubFileNotUploaded') + '</br>';
                        }

                        msg += '<ul>';
                        _.each(this.failedFilesUpload, function (fileName, key) {
                            msg += fileName;
                        });
                        msg += '</ul>';

                        showMessage(msg, true, 3000);
                    } else if (up.files.length > this.failedFilesUpload.length) {
                        let msg = this.$t('message.documentsSubFilesUploaded');
                        msg += ' </br>' + this.$t('message.documentsSubExcept') + '</br>';
                        msg += '<ul>';
                        _.each(this.failedFilesUpload, function (fileName, key) {
                            msg += fileName;
                        });
                        msg += '</ul>';
                        showMessage(msg, true, 3000);
                    }
                } else {

                }
            }

            if (!this.failedFilesUpload.length && !this.failedFilesUploadAdditional.length) {
                showMessage(this.$t('message.smsSubFilesUploaded'), false, 3000);
            }

            this.failedFilesUploadAdditional = {};
            this.uploader.splice();
            this.uploadStarted = false;
            this.updateDocumentsGridData();
        },
        mimeTypeMessage()
        {
            let mimetypes = '<div>' + this.$t('message.documentsSubFileUploadMaxSize') + ': ' + this.generalAdditionalInfo.uploadMaxSize + '</div>';
            mimetypes += this.$t('message.documentsSubMaximumFilesPerUpload') + ':' + this.generalAdditionalInfo.allowedUploadData.fileUploads + ' ' + this.$t('message.documentsSubFiles') + '<div>';
            mimetypes += this.$t('message.documentsSubFilesExtensionFormats') + ': ' + '<div>';
            for (const [key, value] of Object.entries(this.generalAdditionalInfo.mimeTypes)) {
                mimetypes += ' *.'+ value + ' ';
            }
            mimetypes += '</div>';

            return mimetypes;
        },
        async removeDocument(id)
        {
            let self = this;
            showConfirm(this.$t('message.documentsSubAreYouSureWantToDelete'), async () => {
                const result = await this.$store.dispatch('deleteDocument', {'router':this.$router, 'id':id});
                if (typeof result.error !== 'undefined' && parseInt(result.error) === 1) {
                    return false;
                } else {
                    self.updateDocumentsGridData();
                }
            }, async () => {

            });
        },
        async updateDocumentsGridData()
        {
            const result = await this.$store.dispatch('documentsSubTab', {'router':this.$router, 'leadId': this.leadId});
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            setTimeout(() => $('._lbox').magnificPopup({type: 'image'}),  100);
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
