import { createApp } from 'vue';
import { createRouter, createWebHistory } from 'vue-router';
import { createI18n } from 'vue-i18n';
import App from './components/app/index.vue';
import {store} from './config/store/';
//import routes from './config/routing/routes';
import messages from './localization';

import VueClipboard from 'vue-clipboard2';
import "regenerator-runtime/runtime";

const userWebApp =  createApp(App);

const i18n = createI18n({
    locale: 'en', // set locale
    messages,
})

//userWebApp.use(router);
userWebApp.use(i18n);
userWebApp.use(store);
userWebApp.use(VueClipboard);

userWebApp.mount('#ai-chat-bot');



