export const saveConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/imaprules/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#imap-rules-token').val(),
                'ruleName':payload.ruleName,
                'ruleEmail':payload.ruleEmail,
                'imapConfigId':payload.imapConfigId,
                'ruleElements':payload.ruleElements
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const updateConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/imaprules/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'secureToken' : $('#imap-rules-token').val(),
                'ruleName':payload.ruleName,
                'ruleEmail':payload.ruleEmail,
                'imapConfigId':payload.imapConfigId,
                'ruleElements':payload.ruleElements,
                'id':payload.ruleId
            })
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const deleteConfigRecord = ({commit, state, dispatch}, payload) => {
        showLoader();
        return new Promise((resolve, reject) => {
            $.ajax({
                'url': $('#website_url').val() + 'api/leads/imaprules/id/' + payload.id,
                'type': 'DELETE',
                'dataType': 'json'
            }).done(async function (response) {
                hideLoader();
                if (response.status === 'error') {
                    resolve(response);
                } else {
                    resolve(response);
                }

            }).fail(async function (response) {
                hideLoader();
                resolve({name: 'login', 'message': 'Please re-login'});
            });
        });
};

export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/imaprules/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.imapRulesConfig.itemsPerPage,
                'offset': (state.pagination.imapRulesConfig.currentPage - 1) * state.pagination.imapRulesConfig.itemsPerPage,
                'id': payload.ruleId
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setPaginationData', {imapRulesConfig: {totalItems: response.totalRecords}});
                commit('setConfigDataInfo', response.data);
                commit('setAdditionalInfo', response.additionalInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

