
export const saveConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadimap/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken'       : $('#sales-person-config-token').val(),
                'service_name'      : payload.serviceName,
                'owner_id'          : payload.leadOwner,
                'host'              : payload.host,
                'login'             : payload.login,
                'password'          : payload.password,
                'encryption'        : payload.encryption,
                'process_all_emails': payload.processAllEmails
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const deleteConfigRecord = ({commit, state, dispatch}, payload) => {
        showLoader();
        return new Promise((resolve, reject) => {
            $.ajax({
                'url': $('#website_url').val() + 'api/leads/leadimap/id/' + payload.id,
                'type': 'DELETE',
                'dataType': 'json'
            }).done(async function (response) {
                hideLoader();
                if (response.status === 'error') {
                    resolve(response);
                } else {
                    resolve(response);
                }

            }).fail(async function (response) {
                hideLoader();
                resolve({name: 'login', 'message': 'Please re-login'});
            });
        });
}

export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadimap/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'salesOnly': 1,
                'id': payload.id,
                'limit': state.pagination.salesPersonImapConfig.itemsPerPage,
                'offset': (state.pagination.salesPersonImapConfig.currentPage - 1) * state.pagination.salesPersonImapConfig.itemsPerPage
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setPaginationData', {salesPersonImapConfig: {totalItems: response.totalRecords}});
                commit('setConfigDataInfo', response.data);
                commit('setLeadOwners', response.leadOwners);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const checkImapStatusData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/checkImapConnections/',
            'type': 'POST',
            'dataType': 'json',
            'data': {'salesOnly': 1, 'imapRowsIds' : payload.id},
        }).done(async function (response) {
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function (response) {
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const updateImapServiceName = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadimap/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'id': payload.id,
                'serviceName': payload.serviceName,
                'secureToken': $('#sales-person-config-token').val(),
                'fastSave' : 1
            })
        }).done(function(response){
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const updateImapConfig = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadimap/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify( {
                'secureToken'       : $('#sales-person-config-token').val(),
                'id'                : payload.imapId,
                'service_name'      : payload.serviceName,
                'owner_id'          : payload.leadOwner,
                'host'              : payload.host,
                'login'             : payload.login,
                'password'          : payload.password,
                'encryption'        : payload.encryption,
                'process_all_emails': payload.processAllEmails
            })
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}
