import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            registerMojo: false,
            loadedForm: false,
            loadedGrid: false,
            adAccountId: '',
            account: '',
            createListingsBlock: false,
            accountList: '',
            listName: '',
            websiteUrl: $('#website_url').val(),
            accountsId: true,
            accountsDefault:true,
            facebookAcc: false,
            link: '',
            listingsPreview: false,
            adListsPreview: [],
            localeMapping: localeMapping,
            locale: $('#system-language-advertiser-account').val()
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        configDataInfo: function() {
            return this.$store.getters.getConfigDataInfo;
        },
        advertiserTypes: function() {
            return this.$store.getters.getAdvertiserTypes;
        }
    },
    methods: {
        async deleteConfigItem(id){
            showConfirm(this.$t('message.areYouShure'), async () => {
                const result = await this.$store.dispatch('deleteConfigRecord', {'id': id});
                console.log('deleteTab',result);
                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(resultConfigData.status === 'error') {

                    } else {
                        this.loadedGrid = true;
                        if(resultConfigData.advertiserAccountsConfig.totalRecords) {
                            this.createListingsBlock = true;
                        }
                    }
                }
            });
        },
        async addNewAccount(e){
            let account = this.account;

            if(account == '') {
                showMessage(this.$t('message.pleaseSelectAccount'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {
                'account':this.account,
                'adAccountId':this.adAccountId
            });
            console.log('addNewAccount',result);

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                this.adAccountId = '';
                this.account = '';
                this.accountsId = false;
                showMessage(result.message, false, 2000);
                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(resultConfigData.status === 'error') {

                } else {
                    this.loadedGrid = true;
                    if(resultConfigData.advertiserAccountsConfig.totalRecords) {
                        this.createListingsBlock = true;
                    }
                }
            }
        },
        async addNewList(e){
            let accountList = this.accountList;
            let listName = this.listName;

            if(accountList == '') {
                showMessage(this.$t('message.pleaseSelectAccount'), true, 2000);
                return false;
            }

            if(listName == '') {
                showMessage(this.$t('message.pleaseEnterListName'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('addListToAccount', {
                'account':this.accountList,
                'listName':this.listName.replace(/[^a-zA-Z0-9-_ ]/g, '')
            });

            if (result.error === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                if(typeof result.listId === 'undefined') {
                    showMessage(result.message, true, 2000);
                } else {
                    showMessage('(list: '+result.listId+') created successfully', false, 2000);
                }
                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});

                this.listName = '';
                this.accountList = '';
                this.listingsPreview = false;
                this.adListsPreview = [];
            }
        },
        async getVerification(id) {
            const result = await this.$store.dispatch('getVerification', {'id': id});
            console.log('getVerification',result);

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);

                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                return false;
            } else {
                showMessage(result.message, false, 2000);

                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                return true;
            }
        },
        async getAdvAccountConnectionData(e) {
            let advertiserType = e.target.value;

            if(advertiserType == 'facebook') {
                const result = await this.$store.dispatch('getAdvAccountConnectionStatus', {'advertiserType': advertiserType});
                console.log('getAdvAccountConnectionStatus', result);
                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                }
                if(result.type == 'facebook') {
                    this.accountsId = false;
                    this.accountsDefault = false;
                    this.facebookAcc = true;
                    this.link = result.link;
                } else {
                    this.accountsId = true;
                    this.accountsDefault = true;
                    this.facebookAcc = false;
                }
            } else {
                this.accountsId = true;
                this.accountsDefault = true;
                this.facebookAcc = false;
                this.link = '';
            }
        },
        async getAccountStatusesData() {
            var self = this;
            const resultConnected = await this.$store.dispatch('checkAdvertiserConnectionAccounts', {});

            let accountsStatuses = resultConnected.accountsStatuses;
            console.log('checkAdvertiserConnectionAccounts', accountsStatuses);
            let bothConnected = true;

            const resultConfigData = await self.$store.dispatch('getConfigSavedData', {'router':self.$router});

            $.each(accountsStatuses, function(key, accStatus) {
                if(accStatus != 'connected') {
                    bothConnected = false;
                }
            });

            if(!bothConnected) {
                setTimeout(function () {
                    self.getAccountStatusesData();
                }, 60000);
            }
        },
        async getAdvAccountCreatedLists(e) {
            let serviceName = e.target.value;

            const result = await this.$store.dispatch('getAdvAccountCreatedListsData', {'serviceName': serviceName});
            console.log('getAdvAccountCreatedListsData', result);
            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            }
            if(result.list.length) {
                this.listingsPreview = true;
                this.adListsPreview = result.list;
            } else {
                this.listingsPreview = false;
                this.adListsPreview = [];
            }

        }
    },
    async created(){
        this.$i18n.locale = this.localeMapping[this.locale];

        var self = this;
        const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
        console.log('created', result);

        if(result.status === 'error') {
            if(result.errorMojoConnection) {
                this.loadedForm = true;
                this.registerMojo = true;
            } else {
                if(result.message != '') {
                    showMessage(result.message, true, 3000);
                } else {
                    showMessage('Please re-login', true, 3000);
                }
            }
        } else {
            this.loadedForm = true;
            this.accountsId = false;
            this.accountsDefault = true;
            this.facebookAcc = false;

            this.loadedGrid = true;
            this.adListsPreview = [];
            if(result.advertiserAccountsConfig.totalRecords) {
                this.createListingsBlock = true;
            }
            setTimeout(function () {
                self.getAccountStatusesData();
            }, 30000);
        }
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
