<?php


class Emailsequence_Models_Models_SubscribeSmsModel extends Application_Model_Models_Abstract {

    const STATUS_SUBSCRIBED = 'subscribed';

    const STATUS_UNSUBSCRIBED = 'unsubscribed';

    /**
     * Status of user subscription ('subscribed', 'unsubscribed')
     *
     * @var string
     */
    protected $_status = '';

    /**
     * unique unsubscribe code
     *
     * @var string
     */
    protected $_code = '';

    /**
     * system user id
     *
     * @var string
     */
    protected $_userId = '';

    /**
     * external flag for lead
     *
     * @var string
     */
    protected $_external = '';

    /**
     *  Lead email
     *
     * @var string
     */
    protected $_externalEmail = '';

    /**
     *  Mobile number
     *
     * @var string
     */
    protected $_mobileNumber = '';

    protected $_unsubscribedAt = '';

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->_status;
    }

    /**
     * @param string $status
     * @return string
     */
    public function setStatus($status)
    {
        $this->_status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->_code;
    }

    /**
     * @param string $code
     * @return string
     */
    public function setCode($code)
    {
        $this->_code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserId()
    {
        return $this->_userId;
    }

    /**
     * @param string $userId
     * @return string
     */
    public function setUserId($userId)
    {
        $this->_userId = $userId;

        return $this;
    }

    /**
     * @return string
     */
    public function getExternal()
    {
        return $this->_external;
    }

    /**
     * @param string $external
     */
    public function setExternal($external)
    {
        $this->_external = $external;

        return $this;
    }

    /**
     * @return string
     */
    public function getExternalEmail()
    {
        return $this->_externalEmail;
    }

    /**
     * @param string $externalEmail
     */
    public function setExternalEmail($externalEmail)
    {
        $this->_externalEmail = $externalEmail;

        return $this;
    }

    /**
     * @return string
     */
    public function getMobileNumber()
    {
        return $this->_mobileNumber;
    }

    /**
     * @param string $mobileNumber
     * @return string
     */
    public function setMobileNumber($mobileNumber)
    {
        $this->_mobileNumber = $mobileNumber;

        return $this;
    }

    /**
     * @return string
     */
    public function getUnsubscribedAt()
    {
        return $this->_unsubscribedAt;
    }

    /**
     * @param string $unsubscribedAt
     * @return string
     */
    public function setUnsubscribedAt($unsubscribedAt)
    {
        $this->_unsubscribedAt = $unsubscribedAt;

        return $this;
    }




}

