<?php

/**
 * SubscribeMapper.php
 *
 *
 * @method Emailsequence_Models_Mapper_SubscribeMapper getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Emailsequence_Models_Mapper_SubscribeMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Emailsequence_Models_Dbtables_SubscribeDbtable';

    protected $_model = 'Emailsequence_Models_Models_SubscribeModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'status' => $model->getStatus(),
            'user_id' => $model->getUserId(),
            'code' => $model->getCode(),
            'external' => $model->getExternal(),
            'external_email' => $model->getExternalEmail()
        );

        $id = $model->getId();
        if (empty($id)) {
            return $this->getDbTable()->insert($data);
        } else {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            return $this->getDbTable()->update($data, $where);
        }

    }

    /**
     * Find by system user id
     *
     * @param int $userId system user id
     * @return mixed
     * @throws Exception
     */
    public function findByUserId($userId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('user_id = ?', $userId);
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_cartstatusemail_subscribe')
            ->where($where);

        return $this->getDbTable()->getAdapter()->fetchRow($select);
    }

    /**
     * Find subscribe info by code
     *
     * @param string $code
     * @return mixed
     * @throws Exception
     */
    public function findByCode($code)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('pcs.code = ?', $code);
        $select = $this->getDbTable()->getAdapter()->select()->from(array('pcs' => 'plugin_cartstatusemail_subscribe'),
            array('pcs.user_id', 'u.email', 'pcs.status'))
            ->join(array('u' => 'user'), 'u.id=pcs.user_id', array())
            ->where($where);

        $result = $this->getDbTable()->getAdapter()->fetchRow($select);

        if(empty($result)) {
            $select = $this->getDbTable()->getAdapter()->select()->from(array('pcs' => 'plugin_cartstatusemail_subscribe'),
                        array('pcs.user_id', 'pcs.status', 'email' => 'pcs.external_email'))
                    ->where($where);

            $result = $this->getDbTable()->getAdapter()->fetchRow($select);
        }
        return $result;
    }

    /**
     * Find subscribe info by code and user system email
     *
     * @param string $code unique code
     * @param string $email system user email
     * @return mixed
     * @throws Exception
     */
    public function findByCodeEmail($code, $email)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('pcs.code = ?', $code);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('u.email = ?', $email);
        $select = $this->getDbTable()->getAdapter()->select()->from(array('pcs' => 'plugin_cartstatusemail_subscribe'),
            array('pcs.user_id', 'u.email', 'pcs.status'))
            ->join(array('u' => 'user'), 'u.id=pcs.user_id', array())
            ->where($where);

        return $this->getDbTable()->getAdapter()->fetchRow($select);
    }

    /**
     * Change subscription status
     *
     * @param string $code unique code
     * @param string $status (subscribed, unsubscribed)
     * @return mixed
     * @throws Exception
     */
    public function updateStatus($code, $status = Emailsequence::SUBSCRIBED_STATUS_SUBSCRIBED)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("code = ?", $code);
        $storeTimezone =  Models_Mapper_ShoppingConfig::getInstance()->getConfigParam('timezone');
        if (!empty($storeTimezone)) {
            $unsubscribedAt = date(Tools_System_Tools::DATE_MYSQL, strtotime(date('Y-m-d', strtotime('now')) .'+'.Tools_EmailSequenceTools::getTimezoneShift('UTC', $storeTimezone).'hours'));
        } else {
            $unsubscribedAt = date(Tools_System_Tools::DATE_MYSQL, strtotime('now'));
        }

        return $this->getDbTable()->update(array('status' => $status, 'unsubscribed_at' => $unsubscribedAt), $where);
    }


    public function getUnsubscribed($fromDate, $toDate)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('pcs.unsubscribed_at >= ?', $fromDate);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('pcs.unsubscribed_at < ?', $toDate);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('pcs.status = ?', Emailsequence::SUBSCRIBED_STATUS_UNSUBSCRIBED);
        $select = $this->getDbTable()->getAdapter()->select()->from(array('pcs' => 'plugin_cartstatusemail_subscribe'), array('u.email', 'u.full_name', 'pcs.unsubscribed_at'))
            ->join(array('u'=> 'user'), 'u.id=pcs.user_id', array())
            ->where($where);
        return $this->getDbTable()->getAdapter()->fetchAssoc($select);

    }

    /**
     * Find subscription info by user email
     *
     * @param string $email user email
     * @return mixed
     * @throws Exception
     */
    public function findByEmail($email)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('u.email = ?', $email);
        $select = $this->getDbTable()->getAdapter()->select()->from(array('pcs' => 'plugin_cartstatusemail_subscribe'),
            array('pcs.user_id', 'u.email', 'pcs.status', 'pcs.code'))
            ->join(array('u' => 'user'), 'u.id=pcs.user_id', array())
            ->where($where);

        return $this->getDbTable()->getAdapter()->fetchRow($select);
    }

    /**
     * Find by external lead email
     *
     * @param $email
     * @return mixed
     * @throws Exception
     */
    public function findByExternalLeadEmail($email)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('external_email = ?', $email);
        $select = $this->getDbTable()->getAdapter()->select()->from('plugin_cartstatusemail_subscribe')
            ->where($where);

        return $this->getDbTable()->getAdapter()->fetchRow($select);
    }

    /**
     * Find by external lead email
     *
     * @param $email
     * @return Emailsequence_Models_Models_SubscribeModel
     * @throws Exception
     */
    public function findModelByExternalLeadEmail($email)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('external_email = ?', $email);

        return $this->_findWhere($where);
    }
}

