<?php

/**
 * EmailSequenceTriggersMapper.php
 *
 *
 * @method Emailsequence_Models_Mapper_EmailSequenceTriggersMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */

class Emailsequence_Models_Mapper_EmailSequenceTriggersMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Emailsequence_Models_Dbtables_EmailSequenceTriggersDbtable';

    protected $_model = 'Emailsequence_Models_Models_EmailSequenceTriggersModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'sequence_settings_id' => $model->getSequenceSettingsId(),
            'trigger_id' => $model->getTriggerId(),
            'trigger_enabled' => $model->getTriggerEnabled()
        );

        $sequenceTriggerModel = $this->getBySequenceTriggerId($data['sequence_settings_id'], $data['trigger_id']);
        if (!$sequenceTriggerModel instanceof Emailsequence_Models_Models_EmailSequenceTriggersModel) {
            $this->getDbTable()->insert($data);
        } else {
            $where = $this->getDbTable()->getAdapter()->quoteInto('sequence_settings_id = ?', $data['sequence_settings_id']);
            $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('trigger_id = ?', $data['trigger_id']);
            $this->getDbTable()->update($data, $where);
        }

        return $model;
    }


    /**
     * Get by triggers by sequence id
     *
     * @param string $where SQL where clause
     * @param string $order OPTIONAL An SQL ORDER clause.
     * @param int $limit OPTIONAL An SQL LIMIT count.
     * @param int $offset OPTIONAL An SQL LIMIT offset.
     * @param bool $withoutCount flag to get with or without records quantity
     * @param bool $singleRecord flag fetch single record
     * @return array
     * @throws Exception
     */
    public function getBySequenceId(
        $where = null,
        $order = null,
        $limit = null,
        $offset = null,
        $withoutCount = false,
        $singleRecord = false
    ) {

        $selectColumns = array(
            'pcs.triggerName',
            'pcs.id',
            'pet.sequence_settings_id',
            'pet.trigger_id',
            'pet.trigger_enabled',
            'pes.sequence_name',
            'calculatedPeriod' => new Zend_Db_Expr("CASE `lagType` WHEN 'month' THEN `period`*30*24 WHEN 'day' THEN `period`*24 ELSE `period` END")
        );

        $select = $this->getDbTable()->getAdapter()->select()->from(array('pet' => 'plugin_emailsequence_triggers'),
            $selectColumns)
            ->join(array('pcs' => 'plugin_cartstatusemail_settings'), 'pet.trigger_id=pcs.id')
            ->joinLeft(array('pes' => 'plugin_emailsequence_settings'), 'pes.id=pet.sequence_settings_id');

        if (!empty($order)) {
            $select->order($order);
        }

        if (!empty($where)) {
            $select->where($where);
        }

        $select->limit($limit, $offset);

        $data = $this->getDbTable()->getAdapter()->fetchAll($select);
        if ($withoutCount === false) {
            $select->reset(Zend_Db_Select::COLUMNS);
            $select->reset(Zend_Db_Select::FROM);
            $select->reset(Zend_Db_Select::LIMIT_OFFSET);
            $select->reset(Zend_Db_Select::LIMIT_COUNT);

            $count = array(
                'count' => new Zend_Db_Expr('COUNT(pcs.id)'),
                'calculatedPeriod' => new Zend_Db_Expr("CASE `lagType` WHEN 'month' THEN `period`*30*24 WHEN 'day' THEN `period`*24 ELSE `period` END")
            );
            $select->from(array('pet' => 'plugin_emailsequence_triggers'), $count)
                ->join(array('pcs' => 'plugin_cartstatusemail_settings'), 'pet.trigger_id=pcs.id')
                ->joinLeft(array('pes' => 'plugin_emailsequence_settings'), 'pes.id=pet.sequence_settings_id');

            $count = $this->getDbTable()->getAdapter()->fetchRow($select);

            return array(
                'totalRecords' => $count['count'],
                'data' => $data,
                'offset' => $offset,
                'limit' => $limit
            );
        } else {
            return $data;
        }

    }

    /**
     * Get sequence by sequence id and trigger id
     *
     * @param int $sequenceId sequence id
     * @param int $triggerId trigger id
     * @return null
     * @throws Exception
     */
    public function getBySequenceTriggerId($sequenceId, $triggerId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('sequence_settings_id = ?', $sequenceId);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('trigger_id = ?', $triggerId);

        return $this->_findWhere($where);
    }

    /**
     * Delete sequence
     *
     * @param int $sequenceId sequence id
     * @param int $triggerId trigger id
     * @throws Exception
     */
    public function deleteTrigger($triggerId, $sequenceId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('sequence_settings_id = ?', $sequenceId);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto('trigger_id = ?', $triggerId);
        $this->getDbTable()->getAdapter()->delete('plugin_emailsequence_triggers', $where);
    }


}

