<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platfroms allow them to do with
// text.
//
// Copyright (C) 2006-2017  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client\Type;

/**
 * @package Kaltura
 * @subpackage Client
 */
class UiConf extends \Kaltura\Client\ObjectBase
{
	public function getKalturaObjectType()
	{
		return 'KalturaUiConf';
	}
	
	public function __construct(\SimpleXMLElement $xml = null)
	{
		parent::__construct($xml);
		
		if(is_null($xml))
			return;
		
		if(count($xml->id))
			$this->id = (int)$xml->id;
		if(count($xml->name))
			$this->name = (string)$xml->name;
		if(count($xml->description))
			$this->description = (string)$xml->description;
		if(count($xml->partnerId))
			$this->partnerId = (int)$xml->partnerId;
		if(count($xml->objType))
			$this->objType = (int)$xml->objType;
		if(count($xml->objTypeAsString))
			$this->objTypeAsString = (string)$xml->objTypeAsString;
		if(count($xml->width))
			$this->width = (int)$xml->width;
		if(count($xml->height))
			$this->height = (int)$xml->height;
		if(count($xml->htmlParams))
			$this->htmlParams = (string)$xml->htmlParams;
		if(count($xml->swfUrl))
			$this->swfUrl = (string)$xml->swfUrl;
		if(count($xml->confFilePath))
			$this->confFilePath = (string)$xml->confFilePath;
		if(count($xml->confFile))
			$this->confFile = (string)$xml->confFile;
		if(count($xml->confFileFeatures))
			$this->confFileFeatures = (string)$xml->confFileFeatures;
		if(count($xml->config))
			$this->config = (string)$xml->config;
		if(count($xml->confVars))
			$this->confVars = (string)$xml->confVars;
		if(count($xml->useCdn))
		{
			if(!empty($xml->useCdn))
				$this->useCdn = true;
			else
				$this->useCdn = false;
		}
		if(count($xml->tags))
			$this->tags = (string)$xml->tags;
		if(count($xml->swfUrlVersion))
			$this->swfUrlVersion = (string)$xml->swfUrlVersion;
		if(count($xml->createdAt))
			$this->createdAt = (int)$xml->createdAt;
		if(count($xml->updatedAt))
			$this->updatedAt = (int)$xml->updatedAt;
		if(count($xml->creationMode))
			$this->creationMode = (int)$xml->creationMode;
		if(count($xml->html5Url))
			$this->html5Url = (string)$xml->html5Url;
		if(count($xml->version))
			$this->version = (string)$xml->version;
		if(count($xml->partnerTags))
			$this->partnerTags = (string)$xml->partnerTags;
	}
	/**
	 * 
	 * @var int
	 * @readonly
	 */
	public $id = null;

	/**
	 * Name of the uiConf, this is not a primary key
	 * @var string
	 */
	public $name = null;

	/**
	 * 
	 * @var string
	 */
	public $description = null;

	/**
	 * 
	 * @var int
	 * @readonly
	 */
	public $partnerId = null;

	/**
	 * 
	 * @var \Kaltura\Client\Enum\UiConfObjType
	 */
	public $objType = null;

	/**
	 * 
	 * @var string
	 * @readonly
	 */
	public $objTypeAsString = null;

	/**
	 * 
	 * @var int
	 */
	public $width = null;

	/**
	 * 
	 * @var int
	 */
	public $height = null;

	/**
	 * 
	 * @var string
	 */
	public $htmlParams = null;

	/**
	 * 
	 * @var string
	 */
	public $swfUrl = null;

	/**
	 * 
	 * @var string
	 * @readonly
	 */
	public $confFilePath = null;

	/**
	 * 
	 * @var string
	 */
	public $confFile = null;

	/**
	 * 
	 * @var string
	 */
	public $confFileFeatures = null;

	/**
	 * 
	 * @var string
	 */
	public $config = null;

	/**
	 * 
	 * @var string
	 */
	public $confVars = null;

	/**
	 * 
	 * @var bool
	 */
	public $useCdn = null;

	/**
	 * 
	 * @var string
	 */
	public $tags = null;

	/**
	 * 
	 * @var string
	 */
	public $swfUrlVersion = null;

	/**
	 * Entry creation date as Unix timestamp (In seconds)
	 * @var int
	 * @readonly
	 */
	public $createdAt = null;

	/**
	 * Entry creation date as Unix timestamp (In seconds)
	 * @var int
	 * @readonly
	 */
	public $updatedAt = null;

	/**
	 * 
	 * @var \Kaltura\Client\Enum\UiConfCreationMode
	 */
	public $creationMode = null;

	/**
	 * 
	 * @var string
	 */
	public $html5Url = null;

	/**
	 * UiConf version
	 * @var string
	 * @readonly
	 */
	public $version = null;

	/**
	 * 
	 * @var string
	 */
	public $partnerTags = null;

}
