<?php

/**
 * GIT VERSION: 10813
 *
 * Some of the following constants are automatically filled in when
 * the build process is run. If you change them in site/index.php
 * and rerun the build process your changes will be lost
 *
 * APP_PATH   absolute path to the php files of the app
 * DEBUG_MODE flag to enable easier debugging and development
 * CACHE_ID   unique string to bust js/css browser caching for a new build
 * SITE_ID    random site id used for page keys
 */
define('APP_PATH', '/home/ushindi/tikipack/24.10/tiki-24.10/vendor_bundled/vendor/jason-munro/cypht/');
define('VENDOR_PATH', APP_PATH.'vendor/');
define('WEB_ROOT', '');
define('DEBUG_MODE', false);
define('CACHE_ID', 'M4m7WOsK5pTlGSPwRSK%2FTbNrdqImCBhMScGOhmjNkR4%3D');
define('SITE_ID', 'Esu3qbZ66YkTb7H9JUSXSI5k6O5Ezc8Fq%2FiZIvWTfqGhtU29epZ5ZIugoR1YBAV3n5dI5xCQWJT8icNHUAxXbg%3D%3D');
define('JS_HASH', 'sha512-/XJl+06GlXu5d9Bk89NAQCTplwgKUyGLvxW7az86YTLpT1gge/5z/OaNDTop9kMYReoxQdGBqp2LL0aiFRX3GA==');
define('CSS_HASH', 'sha512-xLNZJee+VrsDdqv5wOZNbF9tzpckCCNzUKE97UxXPUNkl2scv88qS8lXx5dEhysIwbqzBOXNnpBK8nUyRVGCsw==');

/* show all warnings in debug mode */
if (DEBUG_MODE) {
    error_reporting(E_ALL | E_STRICT);
}

/* config file location */
define('CONFIG_FILE', APP_PATH.'hm3.rc');

/* don't let anything output content until we are ready */
ob_start();

/* set default TZ */
date_default_timezone_set( 'UTC' );

/* get includes */
require APP_PATH.'lib/framework.php';

/* get configuration */
$config = new Hm_Site_Config_File(CONFIG_FILE);

/* setup ini settings */
if (!$config->get('disable_ini_settings')) {
    require APP_PATH.'lib/ini_set.php';
}

/* process the request */
new Hm_Dispatch($config);

/* log some debug stats about the page */
if (DEBUG_MODE) {
    Hm_Debug::load_page_stats();
    Hm_Debug::show();
}
