<?php
/**
 * Checkout Payment Section
 *
 * This template can be overridden by copying it to yourtheme/kkart/checkout/payment.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 3.5.3
 */

defined( 'ABSPATH' ) || exit;

if ( ! is_ajax() ) {
	do_action( 'kkart_review_order_before_payment' );
}
?>
<div id="payment" class="kkart-checkout-payment">
	<?php if ( KKART()->cart->needs_payment() ) : ?>
		<ul class="kkart_payment_methods payment_methods methods">
			<?php
			if ( ! empty( $available_gateways ) ) {
				foreach ( $available_gateways as $gateway ) {
					kkart_get_template( 'checkout/payment-method.php', array( 'gateway' => $gateway ) );
				}
			} else {
				echo '<li class="kkart-notice kkart-notice--info kkart-info">' . apply_filters( 'kkart_no_available_payment_methods_message', KKART()->customer->get_billing_country() ? esc_html__( 'Sorry, it seems that there are no available payment methods for your state. Please contact us if you require assistance or wish to make alternate arrangements.', 'kkart' ) : esc_html__( 'Please fill in your details above to see available payment methods.', 'kkart' ) ) . '</li>'; // @codingStandardsIgnoreLine
			}
			?>
		</ul>
	<?php endif; ?>
	<div class="form-row place-order">
		<noscript>
			<?php
			/* translators: $1 and $2 opening and closing emphasis tags respectively */
			printf( esc_html__( 'Since your browser does not support JavaScript, or it is disabled, please ensure you click the %1$sUpdate Totals%2$s button before placing your order. You may be charged more than the amount stated above if you fail to do so.', 'kkart' ), '<em>', '</em>' );
			?>
			<br/><button type="submit" class="button alt" name="kkart_checkout_update_totals" value="<?php esc_attr_e( 'Update totals', 'kkart' ); ?>"><?php esc_html_e( 'Update totals', 'kkart' ); ?></button>
		</noscript>

		<?php kkart_checkout_terms(); ?>

		<?php do_action( 'kkart_review_order_before_submit' ); ?>

		<?php echo apply_filters( 'kkart_order_button_html', '<button type="submit" class="button alt" name="kkart_checkout_place_order" id="place_order" value="' . esc_attr( $order_button_text ) . '" data-value="' . esc_attr( $order_button_text ) . '">' . esc_html( $order_button_text ) . '</button>' ); // @codingStandardsIgnoreLine ?>

		<?php do_action( 'kkart_review_order_after_submit' ); ?>

		<?php wp_nonce_field( 'kkart-process_checkout', 'kkart-process-checkout-nonce' ); ?>
	</div>
</div>
<?php
if ( ! is_ajax() ) {
	do_action( 'kkart_review_order_after_payment' );
}
