<?php
/**
 * Class for parameter-based Reports querying
 */

namespace Automattic\Kkart\Admin\API\Reports;

defined( 'ABSPATH' ) || exit;

/**
 * Admin\API\Reports\Query
 */
abstract class Query extends \KKART_Object_Query {

	/**
	 * Get report data matching the current query vars.
	 *
	 * @return array|object of KKART_Product objects
	 */
	public function get_data() {
		/* translators: %s: Method name */
		return new \WP_Error( 'invalid-method', sprintf( __( "Method '%s' not implemented. Must be overridden in subclass.", 'kkart' ), __METHOD__ ), array( 'status' => 405 ) );
	}
}
