<?php
/**
 * Kkart Template Hooks
 *
 * Action/filter hooks used for Kkart functions/templates.
 *
 * @package Kkart\Templates
 * @version 2.1.0
 */

defined( 'ABSPATH' ) || exit;

add_filter( 'body_class', 'kkart_body_class' );
add_filter( 'post_class', 'kkart_product_post_class', 20, 3 );

/**
 * WP Header.
 *
 * @see kkart_generator_tag()
 */
add_filter( 'get_the_generator_html', 'kkart_generator_tag', 10, 2 );
add_filter( 'get_the_generator_xhtml', 'kkart_generator_tag', 10, 2 );

/**
 * Content Wrappers.
 *
 * @see kkart_output_content_wrapper()
 * @see kkart_output_content_wrapper_end()
 */
add_action( 'kkart_before_main_content', 'kkart_output_content_wrapper', 10 );
add_action( 'kkart_after_main_content', 'kkart_output_content_wrapper_end', 10 );

/**
 * Sale flashes.
 *
 * @see kkart_show_product_loop_sale_flash()
 * @see kkart_show_product_sale_flash()
 */
add_action( 'kkart_before_shop_loop_item_title', 'kkart_show_product_loop_sale_flash', 10 );
add_action( 'kkart_before_single_product_summary', 'kkart_show_product_sale_flash', 10 );

/**
 * Breadcrumbs.
 *
 * @see kkart_breadcrumb()
 */
add_action( 'kkart_before_main_content', 'kkart_breadcrumb', 20, 0 );

/**
 * Sidebar.
 *
 * @see kkart_get_sidebar()
 */
add_action( 'kkart_sidebar', 'kkart_get_sidebar', 10 );

/**
 * Archive descriptions.
 *
 * @see kkart_taxonomy_archive_description()
 * @see kkart_product_archive_description()
 */
add_action( 'kkart_archive_description', 'kkart_taxonomy_archive_description', 10 );
add_action( 'kkart_archive_description', 'kkart_product_archive_description', 10 );

/**
 * Product loop start.
 */
add_filter( 'kkart_product_loop_start', 'kkart_maybe_show_product_subcategories' );

/**
 * Products Loop.
 *
 * @see kkart_result_count()
 * @see kkart_catalog_ordering()
 */
add_action( 'kkart_before_shop_loop', 'kkart_result_count', 20 );
add_action( 'kkart_before_shop_loop', 'kkart_catalog_ordering', 30 );
add_action( 'kkart_no_products_found', 'kkart_no_products_found' );

/**
 * Product Loop Items.
 *
 * @see kkart_template_loop_product_link_open()
 * @see kkart_template_loop_product_link_close()
 * @see kkart_template_loop_add_to_cart()
 * @see kkart_template_loop_product_thumbnail()
 * @see kkart_template_loop_product_title()
 * @see kkart_template_loop_category_link_open()
 * @see kkart_template_loop_category_title()
 * @see kkart_template_loop_category_link_close()
 * @see kkart_template_loop_price()
 * @see kkart_template_loop_rating()
 */
add_action( 'kkart_before_shop_loop_item', 'kkart_template_loop_product_link_open', 10 );
add_action( 'kkart_after_shop_loop_item', 'kkart_template_loop_product_link_close', 5 );
add_action( 'kkart_after_shop_loop_item', 'kkart_template_loop_add_to_cart', 10 );
add_action( 'kkart_before_shop_loop_item_title', 'kkart_template_loop_product_thumbnail', 10 );
add_action( 'kkart_shop_loop_item_title', 'kkart_template_loop_product_title', 10 );

add_action( 'kkart_before_subcategory', 'kkart_template_loop_category_link_open', 10 );
add_action( 'kkart_shop_loop_subcategory_title', 'kkart_template_loop_category_title', 10 );
add_action( 'kkart_after_subcategory', 'kkart_template_loop_category_link_close', 10 );

add_action( 'kkart_after_shop_loop_item_title', 'kkart_template_loop_price', 10 );
add_action( 'kkart_after_shop_loop_item_title', 'kkart_template_loop_rating', 5 );

/**
 * Subcategories.
 *
 * @see kkart_subcategory_thumbnail()
 */
add_action( 'kkart_before_subcategory_title', 'kkart_subcategory_thumbnail', 10 );

/**
 * Before Single Products Summary Div.
 *
 * @see kkart_show_product_images()
 * @see kkart_show_product_thumbnails()
 */
add_action( 'kkart_before_single_product_summary', 'kkart_show_product_images', 20 );
add_action( 'kkart_product_thumbnails', 'kkart_show_product_thumbnails', 20 );

/**
 * After Single Products Summary Div.
 *
 * @see kkart_output_product_data_tabs()
 * @see kkart_upsell_display()
 * @see kkart_output_related_products()
 */
add_action( 'kkart_after_single_product_summary', 'kkart_output_product_data_tabs', 10 );
add_action( 'kkart_after_single_product_summary', 'kkart_upsell_display', 15 );
add_action( 'kkart_after_single_product_summary', 'kkart_output_related_products', 20 );

/**
 * Product Summary Box.
 *
 * @see kkart_template_single_title()
 * @see kkart_template_single_rating()
 * @see kkart_template_single_price()
 * @see kkart_template_single_excerpt()
 * @see kkart_template_single_meta()
 * @see kkart_template_single_sharing()
 */
add_action( 'kkart_single_product_summary', 'kkart_template_single_title', 5 );
add_action( 'kkart_single_product_summary', 'kkart_template_single_rating', 10 );
add_action( 'kkart_single_product_summary', 'kkart_template_single_price', 10 );
add_action( 'kkart_single_product_summary', 'kkart_template_single_excerpt', 20 );
add_action( 'kkart_single_product_summary', 'kkart_template_single_meta', 40 );
add_action( 'kkart_single_product_summary', 'kkart_template_single_sharing', 50 );

/**
 * Reviews
 *
 * @see kkart_review_display_gravatar()
 * @see kkart_review_display_rating()
 * @see kkart_review_display_meta()
 * @see kkart_review_display_comment_text()
 */
add_action( 'kkart_review_before', 'kkart_review_display_gravatar', 10 );
add_action( 'kkart_review_before_comment_meta', 'kkart_review_display_rating', 10 );
add_action( 'kkart_review_meta', 'kkart_review_display_meta', 10 );
add_action( 'kkart_review_comment_text', 'kkart_review_display_comment_text', 10 );

/**
 * Product Add to cart.
 *
 * @see kkart_template_single_add_to_cart()
 * @see kkart_simple_add_to_cart()
 * @see kkart_grouped_add_to_cart()
 * @see kkart_variable_add_to_cart()
 * @see kkart_external_add_to_cart()
 * @see kkart_single_variation()
 * @see kkart_single_variation_add_to_cart_button()
 */
add_action( 'kkart_single_product_summary', 'kkart_template_single_add_to_cart', 30 );
add_action( 'kkart_simple_add_to_cart', 'kkart_simple_add_to_cart', 30 );
add_action( 'kkart_grouped_add_to_cart', 'kkart_grouped_add_to_cart', 30 );
add_action( 'kkart_variable_add_to_cart', 'kkart_variable_add_to_cart', 30 );
add_action( 'kkart_external_add_to_cart', 'kkart_external_add_to_cart', 30 );
add_action( 'kkart_single_variation', 'kkart_single_variation', 10 );
add_action( 'kkart_single_variation', 'kkart_single_variation_add_to_cart_button', 20 );

/**
 * Pagination after shop loops.
 *
 * @see kkart_pagination()
 */
add_action( 'kkart_after_shop_loop', 'kkart_pagination', 10 );

/**
 * Product page tabs.
 */
add_filter( 'kkart_product_tabs', 'kkart_default_product_tabs' );
add_filter( 'kkart_product_tabs', 'kkart_sort_product_tabs', 99 );

/**
 * Additional Information tab.
 *
 * @see kkart_display_product_attributes()
 */
add_action( 'kkart_product_additional_information', 'kkart_display_product_attributes', 10 );

/**
 * Checkout.
 *
 * @see kkart_checkout_login_form()
 * @see kkart_checkout_coupon_form()
 * @see kkart_order_review()
 * @see kkart_checkout_payment()
 * @see kkart_checkout_privacy_policy_text()
 * @see kkart_terms_and_conditions_page_content()
 * @see kkart_get_pay_buttons()
 */
add_action( 'kkart_before_checkout_form', 'kkart_checkout_login_form', 10 );
add_action( 'kkart_before_checkout_form', 'kkart_checkout_coupon_form', 10 );
add_action( 'kkart_checkout_order_review', 'kkart_order_review', 10 );
add_action( 'kkart_checkout_order_review', 'kkart_checkout_payment', 20 );
add_action( 'kkart_checkout_terms_and_conditions', 'kkart_checkout_privacy_policy_text', 20 );
add_action( 'kkart_checkout_terms_and_conditions', 'kkart_terms_and_conditions_page_content', 30 );
add_action( 'kkart_checkout_before_customer_details', 'kkart_get_pay_buttons', 30 );

/**
 * Cart widget
 */
add_action( 'kkart_widget_shopping_cart_buttons', 'kkart_widget_shopping_cart_button_view_cart', 10 );
add_action( 'kkart_widget_shopping_cart_buttons', 'kkart_widget_shopping_cart_proceed_to_checkout', 20 );
add_action( 'kkart_widget_shopping_cart_total', 'kkart_widget_shopping_cart_subtotal', 10 );

/**
 * Cart.
 *
 * @see kkart_cross_sell_display()
 * @see kkart_cart_totals()
 * @see kkart_get_pay_buttons()
 * @see kkart_button_proceed_to_checkout()
 * @see kkart_empty_cart_message()
 */
add_action( 'kkart_cart_collaterals', 'kkart_cross_sell_display' );
add_action( 'kkart_cart_collaterals', 'kkart_cart_totals', 10 );
add_action( 'kkart_proceed_to_checkout', 'kkart_get_pay_buttons', 10 );
add_action( 'kkart_proceed_to_checkout', 'kkart_button_proceed_to_checkout', 20 );
add_action( 'kkart_cart_is_empty', 'kkart_empty_cart_message', 10 );

/**
 * Footer.
 *
 * @see  kkart_print_js()
 * @see kkart_demo_store()
 */
add_action( 'wp_footer', 'kkart_print_js', 25 );
add_action( 'wp_footer', 'kkart_demo_store' );

/**
 * Order details.
 *
 * @see kkart_order_details_table()
 * @see kkart_order_again_button()
 */
add_action( 'kkart_view_order', 'kkart_order_details_table', 10 );
add_action( 'kkart_thankyou', 'kkart_order_details_table', 10 );
add_action( 'kkart_order_details_after_order_table', 'kkart_order_again_button' );

/**
 * Order downloads.
 *
 * @see kkart_order_downloads_table()
 */
add_action( 'kkart_available_downloads', 'kkart_order_downloads_table', 10 );

/**
 * Auth.
 *
 * @see kkart_output_auth_header()
 * @see kkart_output_auth_footer()
 */
add_action( 'kkart_auth_page_header', 'kkart_output_auth_header', 10 );
add_action( 'kkart_auth_page_footer', 'kkart_output_auth_footer', 10 );

/**
 * Comments.
 *
 * Disable Jetpack comments.
 */
add_filter( 'jetpack_comment_form_enabled_for_product', '__return_false' );

/**
 * My Account.
 */
add_action( 'kkart_account_navigation', 'kkart_account_navigation' );
add_action( 'kkart_account_content', 'kkart_account_content' );
add_action( 'kkart_account_orders_endpoint', 'kkart_account_orders' );
add_action( 'kkart_account_view-order_endpoint', 'kkart_account_view_order' );
add_action( 'kkart_account_downloads_endpoint', 'kkart_account_downloads' );
add_action( 'kkart_account_edit-address_endpoint', 'kkart_account_edit_address' );
add_action( 'kkart_account_payment-methods_endpoint', 'kkart_account_payment_methods' );
add_action( 'kkart_account_add-payment-method_endpoint', 'kkart_account_add_payment_method' );
add_action( 'kkart_account_edit-account_endpoint', 'kkart_account_edit_account' );
add_action( 'kkart_register_form', 'kkart_registration_privacy_policy_text', 20 );

/**
 * Notices.
 */
add_action( 'kkart_cart_is_empty', 'kkart_output_all_notices', 5 );
add_action( 'kkart_shortcode_before_product_cat_loop', 'kkart_output_all_notices', 10 );
add_action( 'kkart_before_shop_loop', 'kkart_output_all_notices', 10 );
add_action( 'kkart_before_single_product', 'kkart_output_all_notices', 10 );
add_action( 'kkart_before_cart', 'kkart_output_all_notices', 10 );
add_action( 'kkart_before_checkout_form_cart_notices', 'kkart_output_all_notices', 10 );
add_action( 'kkart_before_checkout_form', 'kkart_output_all_notices', 10 );
add_action( 'kkart_account_content', 'kkart_output_all_notices', 5 );
add_action( 'kkart_before_customer_login_form', 'kkart_output_all_notices', 10 );
add_action( 'kkart_before_lost_password_form', 'kkart_output_all_notices', 10 );
add_action( 'before_kkart_pay', 'kkart_output_all_notices', 10 );
add_action( 'kkart_before_reset_password_form', 'kkart_output_all_notices', 10 );
