<?php
/**
 * Admin View: Notice - Update
 *
 * @package Kkart\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$update_url = wp_nonce_url(
	add_query_arg( 'do_update_kkart', 'true', admin_url( 'admin.php?page=kkart-settings' ) ),
	'kkart_db_update',
	'kkart_db_update_nonce'
);

?>
<div id="message" class="updated kkart-message kkart-connect">
	<p>
		<strong><?php esc_html_e( 'Kkart database update required', 'kkart' ); ?></strong>
	</p>
	<p>
		<?php
			esc_html_e( 'Kkart has been updated! To keep things running smoothly, we have to update your database to the newest version.', 'kkart' );

			/* translators: 1: Link to docs 2: Close link. */
			printf( ' ' . esc_html__( 'The database update process runs in the background and may take a little while, so please be patient. Advanced users can alternatively update via %1$sWP CLI%2$s.', 'kkart' ), '<a href="https://github.com/kkart/kkart/wiki/Upgrading-the-database-using-WP-CLI">', '</a>' );
		?>
	</p>
	<p class="submit">
		<a href="<?php echo esc_url( $update_url ); ?>" class="kkart-update-now button-primary">
			<?php esc_html_e( 'Update Kkart Database', 'kkart' ); ?>
		</a>
		<a href="https://docs.kkart.com/document/how-to-update-kkart/" class="button-secondary">
			<?php esc_html_e( 'Learn more about updates', 'kkart' ); ?>
		</a>
	</p>
</div>
