<?php
/**
 * Tools Administration Screen.
 *
 * @package SitePad
 * @subpackage Administration
 */

/** SitePad Administration Bootstrap */
require_once( dirname( __FILE__ ) . '/admin.php' );
/** SitePad Translation Installation API */
require_once( ABSPATH . 'site-admin/includes/translation-install.php' );

if ( ! current_user_can( 'manage_options' ) ) {
	wp_die( __( 'Sorry, you are not allowed to manage options for this site.' ) );
}

$title       = __( 'SiteMap Settings' );

include( ABSPATH . 'site-admin/admin-header.php' );

// Save sitemap data to database
function sitepad_save_sitemap() {
	// Check nonce
	check_admin_referer( 'sitepad-options' );
	
	$msg = array();
	// Does the user want to enable sitemap ? 
	$enable_sitemap = optPOST('enable_sitemap');
	$ssl_secured = optPOST('ssl_secured');
	if($enable_sitemap == 'on'){
		
		$data = array();
		$data['enable_sitemap'] = $enable_sitemap;
		$data['ssl_secured'] = $ssl_secured;
		$data['sitemap'] = optPOST('sitemap');
		
		$ids = get_posts(array(
			'exclude' => '1,2',
			'order' => 'ASC',
			'fields'      => 'ids', // Only get post IDs
			'post_type'   => 'page',
			'numberposts' => -1,
		));
				
		foreach($ids as $pid){
			
			$data[$pid]['include'] = optPOST('include_pages_'.$pid);
			$data[$pid]['priority'] = optPOST('changeprior_pages_'.$pid);
			$data[$pid]['frequency'] = optPOST('changefreq_pages_'.$pid);
		
		}
		
		$data = json_encode($data);
		update_option('sitepad_sitemap', $data);
		$msg['success'] = "Sitemap settings have been saved successfully!";
		
	}else{
		
		$data = array();
		$data = json_encode($data);
		update_option('sitepad_sitemap', $data);
		$msg['success'] = "Sitemap has been disabled successfully!";
	}
	
	return $msg;
}

// Fetch sitemap data
function sitepad_fetch_sitemap() {
	
	$sitemap_data = get_option('sitepad_sitemap');
	$sitemap_data = json_decode($sitemap_data, true);
		
	// We do not have any sitemap data
	if(empty($sitemap_data)){
		return false;
	}
	
	if($sitemap_data['enable_sitemap'] == 'on'){
		return json_encode($sitemap_data);
	}
	
	return false;
}

if(isset($_POST['sitemap_save'])){
	$msg = sitepad_save_sitemap();
	
	if(!empty($msg['success'])){
		echo '<div id="message" class="updated notice is-dismissible"><p>'.__($msg['success']).'</p></div>';
	}else{
		echo '<div id="message" class="error notice is-dismissible"><p>'.__('Unable to save siteMap data for some reason').'</p></div>';
	}
}

?>

<script type="text/javascript">
jQuery('document').ready(function(){
	load_sitemap_div();
});

function load_sitemap_div(){
	var js = [[]];
	js = jQuery.parseJSON('<?php echo sitepad_fetch_sitemap(); ?>');
	
	if(js){
		if(js.enable_sitemap == 'on'){
			jQuery('#enable_sitemap').attr('checked','checked');
		}
		
		if(js.ssl_secured == 'on'){
			jQuery('#ssl_secured').attr('checked','checked');
		}
		
		if(js.sitemap == 'manual'){
			
			jQuery('#sitemap_manual').attr('checked', 'checked');
			show_sitemap('manual');
			
			
			for(x in js){
				if(typeof js[x] === "object") {
				jQuery('#include_'+x+'_pages option[value="'+js[x]['include']+'"]').attr('selected', 'selected');
				jQuery('#changeprior_'+x+'_pages option[value="'+js[x]['priority']+'"]').attr('selected', 'selected');
				jQuery('#changefreq_'+x+'_pages option[value="'+js[x]['frequency']+'"]').attr('selected', 'selected');
				}
			}
		
			
		}else{
			jQuery('#sitemap_auto').attr('checked', 'checked');
			show_sitemap('auto');
		}
	}
}

function show_sitemap(id){
	if(id == 'auto'){
		jQuery('#manual_sitemap').css('display','none');
	}else if(id == 'manual'){
		jQuery('#manual_sitemap').css('display','table-row');
	}
}

</script>
<form id="sitemap_form" class="table_form" method="post" action="sitemap.php" novalidate="novalidate">
<?php wp_nonce_field('sitepad-options'); ?>
<div class="wrap">
	<!-- Sitemap div start -->
	<div id="sitemap_data" class="bg">
		<h1><?php echo $title; ?> 
			<a href="<?php echo home_url('/sitemap.xml');?>" class="button button-primary ml-4"><?php echo __('View SiteMap') ?></a>
		</h1>
		<hr />
		<div class="sitemap-txt" id="publish_meta">
			<table class="form-table" width="100%" >
			<tbody>
			<tr>
				<td style="text-align: left" width="30%">
					<?php echo __('Enable Sitemap') ?>:
				</td>
				<td width="70%" style="text-align: left">
					<input name="enable_sitemap" type="checkbox" id="enable_sitemap"/>
				</td>
			</tr>
			<tr>
				<td style="text-align: left" width="30%">
					<?php echo __('Use SSL for Sitemap URLs') ?> ?:
				</td>
				<td width="70%" style="text-align: left">
					<input name="ssl_secured" type="checkbox" id="ssl_secured"/>
				</td>
			</tr>
			<tr>				
				<td style="text-align: left" width="30%">
					<?php echo __('Manage SiteMap Settings') ?>:
				</td>
				<td width="70%" style="text-align: left">
					<input type="radio" name="sitemap" value="auto" id="sitemap_auto" onclick="show_sitemap(this.value);" /><?php echo __('Automatically') ?> &nbsp;&nbsp;&nbsp;
					<input type="radio" name="sitemap" value="manual" id="sitemap_manual" onclick="show_sitemap(this.value);"/><?php echo __('Manually') ?>
				</td>
			</tr>
			<tr id="manual_sitemap">								
				<td colspan="2" width="100%">
				<hr />
				<div>
				<table style="min-width:70%">
				<tr>
					<td width="25%" style="text-align: left"><b><?php echo __('Pages') ?></b></td>
					<td width="25%" style="text-align: center"><b><?php echo __('Include') ?></b></td>
					<td width="25%" style="text-align: center"><b><?php echo __('Priority') ?></b></td>
					<td width="25%" style="text-align: center"><b><?php echo __('Frequency') ?></b></td>
				</tr>
				<?php
				
				$sm_post_ids = get_posts(array(
					'exclude' => '1,2',
					'order' => 'ASC',
					'posts_per_page' => -1,
					'fields'      => 'ids', // Only get post IDs
					'post_type'   => 'page',
				));
				
				foreach($sm_post_ids as $page){
					$can_edit_post = current_user_can('edit_post', $page);
					
					if($can_edit_post){
						
						$post_data = get_post($page);
						
						echo '<tr>
						<td style="text-align: left" width="25%">'.$post_data->post_title.'</td>
						<td style="text-align: center" width="25%">
						<select name="include_pages_'.$page.'" id="include_'.$page.'_pages">
							<option value="include">Include</option>
							<option value="exclude">Exclude</option>
						</select>
						</td>
						<td style="text-align: center" width="25%">
						<select name="changeprior_pages_'.$page.'" id="changeprior_'.$page.'_pages">
							<option value="0.0">None</option>
							<option value="0.1">0.1</option>
							<option value="0.2">0.2</option>
							<option value="0.3">0.3</option>
							<option value="0.4">0.4</option>
							<option value="0.5">0.5</option>
							<option value="0.6" '.($post_data->post_name != 'home' ? 'selected' : '').'>0.6</option>
							<option value="0.7">0.7</option>
							<option value="0.8">0.8</option>
							<option value="0.9">0.9</option>
							<option value="1.0" '.($post_data->post_name == 'home' ? 'selected' : '').'>1.0</option>
						</select>
						</td>
						<td style="text-align: center" width="25%">
						<select name="changefreq_pages_'.$page.'" id="changefreq_'.$page.'_pages">
							<option value="none">None</option>
							<option value="always">Always</option>
							<option value="hourly">Hourly</option>
							<option value="daily" '.($post_data->post_name == 'home' ? 'selected' : '').'>Daily</option>
							<option value="weekly">Weekly</option>
							<option value="monthly" '.($post_data->post_name != 'home' ? 'selected' : '').'>Monthly</option>
							<option value="yearly">Yearly</option>
							<option value="never">Never</option>
						</select>
						</td>
						</tr>';
					}
				}										
				?>
				</table>
				</div>
				</td>
			</tr>
			</tbody>
			</table>
			<br />
			<button name="sitemap_save" class="button button-primary"><?php echo __('Save') ?></button>
		</div>
	</div>
	<!-- Sitemap div end -->
</div>
</form>
<!-- Wrap div end -->
<?php
include( ABSPATH . 'site-admin/admin-footer.php' );
