import { useState, useRef } from '@wordpress/element';
import { LabelControl } from './label';

export const SliderControl = (props) =>{
	
	const { prop, label, value, setAttributes } = props;
	const { name } = prop['c'];
	const { min, max, step } = prop;
	const sliderRef = useRef(null);
	
	const handleInputChange = (e) => {

		let newValue = parseFloat(e.target.value);

		if (!isNaN(max) && newValue > max) {
			newValue = max;
		}

		if(prop?.units){
			newValue = setUnit(newValue);
		}

		setAttributes({[name]: newValue});
	};

	const setUnit = (val) => {
		var unit = sliderRef.current.querySelectorAll('.pagelayer-elp-units .selected')[0].innerHTML;
		
		if(Array.isArray(val)){
			for(var i in val){
				if(val[i].length < 1){
					continue;
				}
				val[i] = parseFloat(val[i])+unit;
			}
		}else{
			val = parseFloat(val)+unit;
		}
		
		return val;
	}
	
	return (
		<div className="components-base-control pagelayer-base-control" ref={sliderRef}>
			<LabelControl {...props}/>
			<div className="pagelayer-elp-slider-div">
				<input
					type="range"
					className="pagelayer-elp-slider"
					value={parseFloat(value)}
					min={min}
					max={max}
					step={step}
					onChange={handleInputChange}
				/>
				<input
					type="number"
					className="pagelayer-elp-slider-value"
					value={parseFloat(value)}
					min={min}
					max={max}
					step={step}
					onChange={handleInputChange}
				/>
			</div>
		</div>
	);
}