import { __ } from '@wordpress/i18n';
import { InnerBlocks, useInnerBlocksProps, useBlockProps } from '@wordpress/block-editor';
import { useEffect } from '@wordpress/element';
import { select } from '@wordpress/data';

export const RenderColBlock = (props) =>{
	
	const { _props, data} = props;
	const { clientId } = _props;
	const { atts, tmp, id} = data;
	const { getBlockOrder } = select( 'core/block-editor' );
	
	const hasChildBlocks = getBlockOrder( clientId ).length > 0;
	const hasChildClass = hasChildBlocks ? 'pagelayer-has-child': '';
	
	const ALLOWED_BLOCKS = wp.blocks.getBlockTypes().map(block => block.name).filter(blockName => blockName !== 'pagelayer/pl-col');
	
	const InnerBlocksProps = {
		templateLock: false,
		renderAppender: hasChildBlocks ? undefined : InnerBlocks.ButtonBlockAppender,
		allowedBlocks:ALLOWED_BLOCKS
	};
	
	const newProps = { className:`pagelayer-col-holder ${hasChildClass}` };
	const innerProps = useInnerBlocksProps(newProps, InnerBlocksProps);
		
	return (
		<>
			{ atts?.bg_video_src && (
				<div className="pagelayer-background-video" dangerouslySetInnerHTML={{ __html: atts.vid_src}}/>
			) }
			{ atts?.bg_slider && (
				<div className="pagelayer-bgimg-slider" dangerouslySetInnerHTML={{ __html: atts.slider}}/>
			)}
			{ atts?.parallax_img && (
				<div className="pagelayer-parallax-window">
					<img className="pagelayer-img" src={atts.parallax_img_src} title={tmp['parallax_img-title']} alt={tmp['parallax_img-alt']} />
				</div>
			)}
			{ atts?.overlay_type && (<div className="pagelayer-background-overlay"></div>)}
			<div {...innerProps} />
		</>
	);
}
