<?php

//////////////////////////////////////////////////////////////
//===========================================================
// class.php
//===========================================================
// KKART
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Pulkit Gupta
// Date:	   23rd Jan 2017
// Time:	   23:00 hrs
// Site:	   http://kkart.com/wordpress (KKART)
// ----------------------------------------------------------
// Please Read the Terms of use at http://kkart.com/tos
// ----------------------------------------------------------
//===========================================================
// (c)Kkart Team
//===========================================================
//////////////////////////////////////////////////////////////

// Are we being accessed directly ?
if(!defined('KKART_VERSION')) {
	exit('Hacking Attempt !');
}

global $pagelayer;

// Price
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_price', array(
		'name' => __('Product Price'),
		'group' => 'kkart',
		'use_inside' => ['pl_kkart_archive_item'],
		'edit_props' => ['.kkart-regular-price' => '_regular_price', '.kkart-sale-price' => '_sale_price'],
		'html' => '<div class="kkart-price-holder">
			<del if="{{show_reg_price}}" class="kkart-price-amount">
				<span class="kkart-Price-currencySymbol">{{currency}}</span><bdi class="kkart-regular-price">{{regular_price}}</bdi>
			</del>
			<span if="{{show_sale_price}}" class="kkart-price-amount kkart-sale-price-cnt">
				<span class="kkart-Price-currencySymbol">{{currency}}</span><bdi class="kkart-sale-price">{{sale_price}}</bdi>
			</span>
			<span if="{{reg_var_price_min}}" class="kkart-Price-currencySymbol">{{reg_var_price_min}}</span>
			<span if="{{reg_var_price_max}}" class="kkart-Price-currencySymbol"> - {{reg_var_price_max}}</span>
		</div>',
		'params' => array(
			'prices' => array(
				'type' => 'radio',
				'label' => __('Price'),
				'default' => 'regular',
				'list' => [
					'regular' => __('Regular Price'),
					'sale' => __('Sale Price'),
				],
			),
			'rp_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'show' => ['prices' => 'regular'],
				'css' => ['{{element}} .kkart-price-holder del' => 'color:{{val}}'],
			),
			'rp_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'show' => ['prices' => 'regular'],
				'css' => [
					'{{element}} .kkart-price-holder del' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				]
			),
			'sp_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'show' => ['prices' => 'sale'],
				'css' => ['{{element}} .kkart-sale-price-cnt' => 'color:{{val}}'],
			),
			'sp_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'show' => ['prices' => 'sale'],
				'css' => [
					'{{element}} .kkart-sale-price-cnt' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				]
			),
			'p_position' => array(
				'type' => 'checkbox',
				'label' => __('Flip regular price'),
				'addClass' => ['{{element}} .kkart-price-holder' => 'kkart-price-flip'],
			),
			'space' => array(
				'type' => 'spinner',
				'label' => __('Space'),
				'css' => ['{{element}} .kkart-price-amount' => 'margin-right:{{val}}px;']
			),
		),
	)
);

// Image gallery
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_img_gallery', array(
		'name' => __('Product gallery'),
		'group' => 'kkart',
		'html' => '<div class="kkart-image-gallery-holder kkart-gallery-position-{{gposition}}">
			<div class="kkart-primary-image-container kkart-primary-image-{{palign}}">{{primary_image}}
				<div if="{{slider_controls}}" class="primary-slider-controls">
					<button type="button" class="primary-image-prev"><i class="fas fa-chevron-left"></i></button>
					<button type="button" class="primary-image-next"><i class="fas fa-chevron-right"></i></button>
				</div>
			</div>
			<div class="kkart-product-gallery-container kkart-product-gallery-container-{{gposition}}-{{galign}}">
				<ul class="kkart-product-gallery-ul">{{gallery_html}}</ul>
			</div>
		</div>',
		'params' => array(
			'hide_gallery' => array(
				'type' => 'checkbox',
				'label' => __('Hide Gallery'),
				'css' => ['{{element}} .kkart-product-gallery-container' => 'display: none']
			),
			'size' => array(
				'type' => 'select',
				'label' => 'Gallery Image Size',
				'default' => 'thumbnail',
				'list' => array(
					'full' => __('Full'),
					'large' => __('Large'),
					'medium' => __('Medium'),
					'thumbnail' => __('Thumbnail'),
					'custom' => __('Custom'),
				),
			),
			'gcustom_size' => array(
				'type' => 'dimension',
				'label' => 'Gallery Image Custom Size',
				'units' => ['px', 'em', '%'],
				'screen' => 1,
				'css' => ['{{element}} .kkart-gallery-item img' => 'width: {{val[0]}}; height: {{val[1]}};'],
				'req' => array(
					'size' => 'custom'
				),
			),
			'galign' => array(
				'type' => 'radio',
				'label' => 'Gallery Image Alignment',
				'default' => 'left',
				'addAttr' => 'align="{{align}}"',
				'css' => ['{{element}} .kkart-product-gallery-container' => 'text-align: {{val}}', '{{element}} .kkart-product-gallery-container .kkart-product-gallery-ul' => 'text-align: {{val}}'],
				'list' => array(
					'left' => __('Start'),
					'center' => __('Center'),
					'right' => __('End'),
				)
			),
			'gposition' => array(
				'label' => 'Gallery Container Position',
				'type' => 'radio',
				'default' => 'bottom',
				'list' => array(
					'left' => __('Left'),
					'top' => __('Top'),
					'right' => __('Right'),
					'bottom' => __('Bottom')
				)
			),
			
			'gcolumns' => array(
				'type' => 'spinner',
				'label' => __('Gallery Image Count'),
				'default' => 5,
				'addAttr' => ['{{element}} .kkart-product-gallery-ul' => 'data-slides-count={{gcolumns}}'],
			),
			'gholder_size' => array(
				'type' => 'dimension',
				'label' => 'Gallery Holder Size',
				'units' => ['px', 'em', '%'],
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-gallery-ul' => 'width: {{val[0]}}; height: {{val[1]}};'],
			),
			'hover_slider' => array(
				'type' => 'checkbox',
				'label' => __('Hover Slider'),
				'default' => '',
				'addAttr' => ['{{element}} .kkart-product-gallery-ul' => 'data-slides-hover={{hover_slider}}'],
			),
		),
		'gimg_border_style' => array(
			'gimg_bor_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'default' => '',
				//'no_val' => 1,// Dont set any value to element
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				)
			),	
			'gimg_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .kkart-product-active' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => array(
					'gimg_bor_hover' => ''
				),
			),
			'gimg_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#42414f',
				'css' => ['{{element}} .kkart-product-active' => 'border-color: {{val}};'],
				'req' => array(
					'!gimg_border_type' => ''
				),
				'show' => array(
					'gimg_bor_hover' => ''
				),
			),
			'gimg_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-active' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => [
					'!gimg_border_type' => ''
				],
				'show' => array(
					'gimg_bor_hover' => ''
				),
			),
			'gimg_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-active' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!gimg_border_type' => '',
				),
				'show' => array(
					'gimg_bor_hover' => '',
				),
			),
			'gimg_border_type_hover' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .kkart-product-gimage:hover' => 'border-style: {{val}}' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => array(
					'gimg_bor_hover' => 'hover'
				),
			),
			'gimg_border_color_hover' => array(
				'type' => 'color',
				'label' => __('Border Color Hover'),
				'default' => '#42414f',
				'css' => ['{{element}} .kkart-product-gimage:hover' => 'border-color: {{val}};'],
				'req' => array(
					'!gimg_border_type_hover' => ''
				),
				'show' => array(
					'gimg_bor_hover' => 'hover'
				),
			),
			'gimg_border_width_hover' => array(
				'type' => 'padding',
				'label' => __('Border Width Hover'),
				'screen' => 1,
				'css' => [
					'{{element}} .kkart-product-gimage:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px;'
				],
				'req' => [
					'!gimg_border_type_hover' => ''
				],
				'show' => array(
					'gimg_bor_hover' => 'hover'
				),
			),
			'gimg_border_radius_hover' => array(
				'type' => 'padding',
				'label' => __('Border Radius Hover'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-gimage:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!gimg_border_type_hover' => '',
				),
				'show' => array(
					'gimg_bor_hover' => 'hover',
				),
			),
		),
		'primary_image' => array(
			'palign' => array(
				'label' => 'Primary Image Alignment',
				'type' => 'radio',
				'default' => 'center',
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right')
				)
			),
			'pspace' => array(
				'label' => 'Margin',
				'type' => 'padding',
				'screen' => 1,
				'css' => ['{{element}} .kkart-primary-image-container' => 'margin-top: {{val[0]}}px; margin-right: {{val[1]}}px; margin-bottom: {{val[2]}}px; margin-left: {{val[3]}}px'],
			),
			'pzoom' => array(
				'type' => 'checkbox',
				'label' => __('Zoom'),
				'default' => '',
				'addAttr' => ['{{element}} .kkart-primary-image-container' => 'data-zoom={{pzoom}}'],
			),
			'slider_controls' => array(
				'type' => 'checkbox',
				'label' => __('Slider Controls'),
				'default' => '',
			),
			'controls_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .primary-slider-controls [class*="primary-image-"]' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
					'{{element}} .pagelayer-btn-holder' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				],
				'req' => ['!slider_controls' => ''],
			),
			'controls_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'default' => '',
				//'no_val' => 1,// Dont set any value to element
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				),
				'req' => ['!slider_controls' => '']
			),
			'controls_background' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'defaul' => 'none',
				'css' => ['.primary-slider-controls [class*="primary-image-"]' => 'background:{{val}}'],
				'show' => ['controls_hover' => ''],
				'req' => ['!slider_controls' => '' ]
			),
			'controls_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'defaul' => '#000',
				'css' => ['.primary-slider-controls [class*="primary-image-"]' => 'color:{{val}}'],
				'show' => ['controls_hover' => ''],
				'req' => ['!slider_controls' => '' ]
			),
			'control_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [
					'.primary-slider-controls [class*="primary-image-"]' => 'border-style: {{val}};',
				],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => ['controls_hover' => ''],
				'req' => ['!slider_controls' => '' ]
			),
			'control_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#42414f',
				'css' => ['.primary-slider-controls [class*="primary-image-"]' => 'border-color: {{val}};'],
				'show' => ['controls_hover' => ''],
				'req' => ['!slider_controls' => '', '!control_border_type' => '']
			),
			'control_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['.primary-slider-controls [class*="primary-image-"]' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'show' => ['controls_hover' => ''],
				'req' => ['!slider_controls' => '', '!control_border_type' => '']
			),
			'control_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['.primary-slider-controls [class*="primary-image-"]' => 'border-top-left-radius: {{val[0]}}px; border-top-right-radius: {{val[1]}}px; border-bottom-right-radius: {{val[2]}}px; border-bottom-left-radius: {{val[3]}}px'],
				'show' => ['controls_hover' => ''],
				'req' => ['!slider_controls' => '', '!control_border_type' => '']
			),
			'controls_background_hover' => array(
				'type' => 'color',
				'label' => __('Background Hover'),
				'defaul' => 'none',
				'css' => ['.primary-slider-controls [class*="primary-image-"]:hover' => 'background:{{val}}'],
				'show' => ['controls_hover' => 'hover'],
				'req' => ['!slider_controls' => '' ]
			),
			'controls_color_hover' => array(
				'type' => 'color',
				'label' => __('Color Hover'),
				'defaul' => 'none',
				'css' => ['.primary-slider-controls [class*="primary-image-"]:hover' => 'color:{{val}}'],
				'show' => ['controls_hover' => 'hover'],
				'req' => ['!slider_controls' => '' ]
			),
			'control_border_type_hover' => array(
				'type' => 'select',
				'label' => __('Hover Border Type'),
				'css' => [
					'.primary-slider-controls [class*="primary-image-"]:hover' => 'border-style: {{val}};',
				],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => ['controls_hover' => 'hover'],
				'req' => ['!slider_controls' => '' ]
			),
			'control_border_color_hover' => array(
				'type' => 'color',
				'label' => __(' Hover Border Color'),
				'default' => '#42414f',
				'css' => ['.primary-slider-controls [class*="primary-image-"]:hover' => 'border-color: {{val}};'],
				'show' => ['controls_hover' => 'hover'],
				'req' => ['!slider_controls' => '', '!control_border_type_hover' => '']
			),
			'control_border_width_hover' => array(
				'type' => 'padding',
				'label' => __('Hover Border Width'),
				'screen' => 1,
				'css' => ['.primary-slider-controls [class*="primary-image-"]:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'show' => ['controls_hover' => 'hover'],
				'req' => ['!slider_controls' => '', '!control_border_type_hover' => '']
			),
			'control_border_radius_hover' => array(
				'type' => 'padding',
				'label' => __('Hover Border Radius'),
				'screen' => 1,
				'css' => ['.primary-slider-controls [class*="primary-image-"]:hover' => 'border-top-left-radius: {{val[0]}}px; border-top-right-radius: {{val[1]}}px; border-bottom-right-radius: {{val[2]}}px; border-bottom-left-radius: {{val[3]}}px'],
				'show' => ['controls_hover' => 'hover'],
				'req' => ['!slider_controls' => '', '!control_border_type_hover' => '']
			),
		),
		'styles' => array(
			'primary_image' => __('Primary Image'),
			'gimg_border_style' => __('Gallery Image Border Style')
		)
	)
);

// Add to cart
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_add_to_cart', array(
		'name' => __('Add To Cart'),
		'icon' => 'fas fa-cart-arrow-down',
		'group' => 'kkart',
		'html' => '<div class="kkart-add-to-cart-holder">
			{{kkart_cart_form}}
		</div>',
		'params' => array(
			'cart_text' => array(
				'type' => 'text',
				'label' => __('Cart Text'),
				'default' => __('Add To Cart'),
			),
			'cart_icon' => array(
				'type' => 'icon',
				'label' => __('Icon'),
				'default' => '',
			),
			'cart_icon_position' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'default' => 'kkart-cart-btn-icon-left',
				'addClass' => ['{{element}} .kkart-cart-btn-holder' => '{{val}}'],
				'list' => array(
					'kkart-cart-btn-icon-left' => __('Left'),
					'kkart-cart-btn-icon-right' => __('Right')
				),
			),
			'cart_icon_spacing' => array(
				'type' => 'slider',
				'label' => __('Icon Spacing'),
				'min' => 1,
				'step' => 1,
				'max' => 100,
				'default' => 5,
				'screen' => 1,
				'css' => ['{{element}} .kkart-cart-btn-icon' => 'padding: 0 {{val}}px;'],
				'req' => array(
					'!cart_icon' => 'none'
				),
			),
		),
		'cart_quantity' => array(
			'show_quantity' => array(
				'type' => 'checkbox',
				'label' => __('Show Quantity'),
				'default' => 'true'
			),
			'quantity_layout' => array(
				'type' => 'select',
				'label' => __('Quantity Layout'),
				'css' => ['{{element}} .kkart-cart-btn-holder, {{element}} .kkart-product-quantity-holder' => 'display: {{val}};'],
				'default' => 'inline-block',
				'list' => array(
					'block' => __('Block'),
					'inline-block' => __('Inline')
				),
				'req' => ['!show_quantity' => ''],
			),
			'quantity_box_width' => array(
				'type' => 'spinner',
				'label' => __('Quantity Box Width'),
				'min' => 10,
				'step' => 1,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-quantity input[type="number"]' => 'width: {{val}}px;'],
				'req' => ['!show_quantity' => ''],
			),
			'quantity_box_height' => array(
				'type' => 'spinner',
				'label' => __('Quantity Box Height'),
				'min' => 15,
				'step' => 1,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-quantity input[type="number"]' => 'height: {{val}}px;'],
				'req' => ['!show_quantity' => ''],
			),
			'input_background_color' => array(
				'type' => 'color',
				'label' => __('Input Background Color'),
				'default' => '#fff',
				'css' => ['{{element}} .kkart-product-quantity input[type="number"]' => 'background-color:{{val}}'],
				'req' => ['!show_quantity' => ''],
				'show' => ['!show_quantity' => ''],
			),
			'input_text_color' => array(
				'type' => 'color',
				'label' => __('Input Text Color'),
				'default' => '#000',
				'css' => ['{{element}} .kkart-product-quantity input[type="number"]' => 'color:{{val}}'],
				'req' => ['!show_quantity' => ''],
				'show' => ['!show_quantity' => ''],
			),
			'input_button_style' => array(
				'type' => 'checkbox',
				'label' => __('Input Button Style'),
				'default' => '',
				'css' => ['{{element}} .kkart-product-quantity input[type="number"]' => '-moz-appearance:auto'],
				'req' => ['!show_quantity' => ''],
				'show' => ['!show_quantity' => ''],
			),
			'button_width' => array(
				'type' => 'spinner',
				'label' => __('Button Width'),
				'step' => '1',
				'default' => '25',
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus, {{element}} .kkart-product-quantity .kkart-plus' => 'width:{{val}}px'],
				'req' => ['!show_quantity' => ''],
				'show' => ['!show_quantity' => ''],
			),
			'button_height' => array(
				'type' => 'spinner',
				'label' => __('Button Height'),
				'step' => '1',
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus, {{element}} .kkart-product-quantity .kkart-plus' => 'height:{{val}}px'],
				'req' => ['!show_quantity' => ''],
				'show' => ['!show_quantity' => ''],
			),
			'button_background_color' => array(
				'type' => 'color',
				'label' => __('Button Background Color'),
				'default' => '#fff',
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus,{{element}} .kkart-product-quantity .kkart-plus' => 'background-color:{{val}}'],
				'req' => ['!show_quantity' => ''],
				'show' => ['!show_quantity' => ''],
			),
			'button_text_color' => array(
				'type' => 'color',
				'label' => __('Button Text Color'),
				'default' => '#000',
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus,{{element}} .kkart-product-quantity .kkart-plus' => 'color:{{val}}'],
				'req' => ['!show_quantity' => ''],
				'show' => ['!show_quantity' => ''],
			),
			'typography' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-minus, {{element}} .kkart-plus' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				],
			),
			'quantity_style' => array(
				'type' => 'select',
				'label' => __('Separate Box'),
				'addClass' => ['{{element}} .kkart-product-quantity' => 'kkart-quantity-style-{{val}}'],
				'list' => array(
					'rounded' => __('Rounded'),
					'' => __('Boxed')
				),
			),
			'quantity_border_color' =>array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#efefef',
				'css' => ['{{element}} .kkart-product-quantity' => 'border-color:{{val}}'],
				'show' => ['quantity_style' => ''],
			),
			
			'quantity_border_size' =>array(
				'type' => 'padding',
				'label' => __('Border Size'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-quantity' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'show' => ['quantity_style' => ''],
			),
			'quantity_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-quantity' => 'border-radius: {{val[0]}}px; {{val[1]}}px {{val[2]}}px {{val[3]}}px'],
				'show' => ['quantity_style' => ''],
			),
			'show_seperator' => array(
				'type' => 'checkbox',
				'label' => __('Show Seperator'),
				'default' => '',
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus' => 'border-right: 1px solid #efefef;', '{{element}} .kkart-product-quantity .plus' => 'border-left: 1px solid #efefef;'],
				'show' => ['quantity_style' => ''],
			),
			'seperator_border_color' => array(
				'type' => 'color',
				'label' => __('Seperator Border Color'),
				'default' => '#efefef',
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus' => 'border-right-color: {{val}};', '{{element}} .kkart-product-quantity .kkart-plus' => 'border-left-color: {{val}};'],
				'req' => ['quantity_style' => '','!show_seperator' => ''],
			),
			'seperator_border_size' =>array(
				'type' => 'spinner',
				'label' => __('Seperator Border Size'),
				'min' => 1,
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus' => 'border-right-width: {{val}}px;', '{{element}} .kkart-product-quantity .kkart-plus' => 'border-left-width: {{val}}px;'],
				'req' => ['quantity_style' => '','!show_seperator' => ''],
			),
			'spacing' => array(
				'type' => 'spinner',
				'label' => __('Spacing'),
				'min' => '2',
				'css' => ['{{element}} .kkart-quantity-style-rounded input[type="number"]' => 'margin-left:{{val}}px; margin-right:{{val}}px;'],
				'req' => ['quantity_style' => 'rounded'],
			),
			'input_border_type' => array(
				'type' => 'select',
				'label' => __('Input Border Type'),
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'css' => ['{{element}} .kkart-quantity-style-rounded input[type="number"]' => 'border-style:{{val}}'],
				'req' => ['quantity_style' => 'rounded'],
			),
			'input_border_color' => array(
				'type' => 'color',
				'label' => __('Input Border Color'),
				'default' => '#fff',
				'css' => ['{{element}} .kkart-quantity-style-rounded input[type="number"]' => 'border-color:{{val}}'],
				'req' => ['quantity_style' => 'rounded', '!input_border_type' => ''],
			),
			'input_border_width' => array(
				'type' => 'padding',
				'label' => __('Input Border Width'),
				'screen' => '1',
				'css' => ['{{element}} .kkart-quantity-style-rounded input[type="number"]' => 'border-top-width:{{val[0]}}px; border-left-width:{{val[1]}}px; border-bottom-width:{{val[2]}}px; border-right-width:{{val[3]}}px'],
				'req' => ['quantity_style' => 'rounded', '!input_border_type' => ''],
			),
			'input_border_radius' => array(
				'type' => 'padding',
				'label' => __('Input Border Radius'),
				'screen' => '1',
				'css' => ['{{element}} .kkart-quantity-style-rounded input[type="number"]' => 'border-top-left-radius:{{val[0]}}px; border-top-right-radius:{{val[1]}}px; border-bottom-right-radius:{{val[2]}}px; border-bottom-left-radius:{{val[3]}}px'],
				'req' => ['quantity_style' => 'rounded', '!input_border_type' => ''],
			),
			'button_border_type' => array(
				'type' => 'select',
				'label' => __('Button Border Type'),
				'default' => 'solid',
				'list' => [
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'css' => ['{{element}} .kkart-quantity-style-rounded .kkart-minus, {{element}} .kkart-quantity-style-rounded .kkart-plus' => 'border-style:{{val}}'],
				'req' => ['quantity_style' => 'rounded'],
			),
			'button_border_color' => array(
				'type' => 'color',
				'label' => __('Button Border Color'),
				'default' => '#000',
				'css' => ['{{element}} .kkart-quantity-style-rounded .kkart-minus, {{element}} .kkart-quantity-style-rounded .kkart-plus' => 'border-color:{{val}}'],
				'req' => ['quantity_style' => 'rounded'],
			),
			'button_border_width' => array(
				'type' => 'padding',
				'label' => __('Button Border Width'),
				'screen' => '1',
				'default' => '2,2,2,2',
				'css' => ['{{element}} .kkart-quantity-style-rounded .kkart-minus, {{element}} .kkart-quantity-style-rounded .kkart-plus' => 'border-top-width:{{val[0]}}px; border-left-width:{{val[1]}}px; border-bottom-width:{{val[2]}}px; border-right-width:{{val[3]}}px;'],
				'req' => ['quantity_style' => 'rounded'],
			),
			'button_border_radius' => array(
				'type' => 'padding',
				'label' => __('Button Border Radius'),
				'screen' => '1',
				'default' => '25,25,25,25',
				'css' => ['{{element}} .kkart-quantity-style-rounded .kkart-minus, {{element}} .kkart-quantity-style-rounded .kkart-plus' => 'border-top-left-radius:{{val[0]}}px; border-top-right-radius:{{val[1]}}px; border-bottom-right-radius:{{val[2]}}px; border-bottom-left-radius:{{val[3]}}px'],
				'req' => ['quantity_style' => 'rounded'],
			),
		),
		'cart_btn_style' => array(
			'btn_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-cart-btn-text' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
					'{{element}} .pagelayer-btn-holder' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				],
			),
			'cart_type' => array(
				'type' => 'select',
				'label' => __('Button Type'),
				'default' => 'pagelayer-btn-default',
				'addClass' => ['{{element}} .kkart-cart-btn-holder' => '{{val}}'],
				'list' => array(
					'pagelayer-btn-default' => __('Default'),
					'pagelayer-btn-primary' => __('Primary'),
					'pagelayer-btn-secondary' => __('Secondary'),
					'pagelayer-btn-success' => __('Success'),
					'pagelayer-btn-info' => __('Information'),
					'pagelayer-btn-warning' => __('Warning'),
					'pagelayer-btn-danger' => __('Danger'),
					'pagelayer-btn-dark' => __('Dark'),
					'pagelayer-btn-light' => __('Light'),
					'pagelayer-btn-link' => __('Link'),
					'pagelayer-btn-custom' => __('Custom')
				),
			),
			'cart_size' => array(
				'type' => 'select',
				'label' => __('Button Size'),
				'default' => 'pagelayer-btn-small',
				'addClass' => ['{{element}} .kkart-cart-btn-holder' => '{{val}}'],
				'list' => array(
					'pagelayer-btn-mini' => __('Mini'),
					'pagelayer-btn-small' => __('Small'),
					'pagelayer-btn-large' => __('Large'),
					'pagelayer-btn-extra-large' => __('Extra Large'),
					'pagelayer-btn-double-large' => __('Double Large'),
					'pagelayer-btn-custom' => __('Custom'),
				)
			),
			'btn_custom_size' => array(
				'type' => 'spinner',
				'label' => __('Button Custom Size'),
				'min' => 1,
				'step' => 1,
				'max' => 100,
				'default' => 5,
				'screen' => 1,
				'css' => ['{{element}} .kkart-cart-btn-holder' => 'padding: calc({{val}}px / 2) {{val}}px;'],
				'req' => array(
					'cart_size' => ['pagelayer-btn-custom'],
				),
			),
			'btn_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'default' => '',
				//'no_val' => 1,// Dont set any value to element
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				),
				'req' => array(
					'cart_type' => ['pagelayer-btn-custom'],
				),
			),
			'btn_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'default' => '#818a91',
				'css' => [
					'{{element}} .kkart-cart-btn-holder' => 'background-color: {{val}};',
				],
				'req' => array(
					'cart_type' => ['pagelayer-btn-custom'],
				),
				'show' => array(
					'btn_hover' => ''
				),
			),
			'btn_color' => array(
				'type' => 'color',
				'label' => __('Button Color'),
				'default' => '#ffffff',
				'css' => ['{{element}} .kkart-cart-btn-holder' => 'color: {{val}};'],
				'req' => array(
					'cart_type' => ['pagelayer-btn-custom'],
				),
				'show' => array(
					'btn_hover' => ''
				),
			),
			'btn_hover_delay' => array(
				'type' => 'spinner',
				'label' => __('Button Hover Delay'),
				'desc' => __('Time to delay the hover in ms'),
				'min' => 0,
				'step' => 100,
				'max' => 5000,
				'default' => 400,
				'css' => ['{{element}} .kkart-cart-btn-holder' => '-webkit-transition: all {{val}}ms !important; transition: all {{val}}ms !important;'],
				'show' => array(
					'cart_type' => ['pagelayer-btn-custom'],
					'btn_hover' => 'hover'
				),
			),
			'btn_bg_color_hover' => array(
				'type' => 'color',
				'label' => __('Background Hover Color'),
				'default' => '',
				'css' => [
					'{{element}} .kkart-cart-btn-holder:hover' => 'background-color: {{val}};',
				],
				'req' => array(
					'cart_type' => ['pagelayer-btn-custom'],
				),
				'show' => array(
					'btn_hover' => 'hover',
				),
			),
			'btn_color_hover' => array(
				'type' => 'color',
				'label' => __('Hover Color'),
				'default' => '',
				'css' => ['{{element}} .kkart-cart-btn-holder:hover' => 'color: {{val}};'],
				'req' => array(
					'cart_type' => ['pagelayer-btn-custom'],
				),
				'show' => array(
					'btn_hover' => 'hover'
				),
			),
			'btn_shadow' => array(
				'type' => 'box_shadow',
				'label' => __('Shadow'),
				'css' => ['{{element}} .kkart-cart-btn-holder' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
			),
			'btn_shadow_hover' => array( // This is actually box shadow hover
				'type' => 'box_shadow',
				'label' => __('Box Shadow Hover'),
				'css' => ['{{element}} .kkart-cart-btn-holder' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}} !important;'],
			),
		),
		'cart_border_style' => [
			'btn_bor_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'default' => '',
				//'no_val' => 1,// Dont set any value to element
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				)
			),	
			'btn_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [
					'{{element}} .kkart-cart-btn-holder' => 'border-style: {{val}};',
					],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => array(
					'btn_bor_hover' => ''
				),
			),
			'btn_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#42414f',
				'css' => ['{{element}} .kkart-cart-btn-holder' => 'border-color: {{val}};'],
				'req' => array(
					'!btn_border_type' => ''
				),
				'show' => array(
					'btn_bor_hover' => ''
				),
			),
			'btn_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-cart-btn-holder' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => [
					'!btn_border_type' => ''
				],
				'show' => array(
					'btn_bor_hover' => ''
				),
			),
			'btn_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-cart-btn-holder' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!btn_border_type' => '',
				),
				'show' => array(
					'btn_bor_hover' => '',
				),
			),
			'btn_border_type_hover' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [
					'{{element}} .kkart-cart-btn-holder:hover' => 'border-style: {{val}}'
				],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => array(
					'btn_bor_hover' => 'hover'
				),
			),
			'btn_border_color_hover' => array(
				'type' => 'color',
				'label' => __('Border Color Hover'),
				'default' => '#42414f',
				'css' => ['{{element}} .kkart-cart-btn-holder:hover' => 'border-color: {{val}};'],
				'req' => array(
					'!btn_border_type_hover' => ''
				),
				'show' => array(
					'btn_bor_hover' => 'hover'
				),
			),
			'btn_border_width_hover' => array(
				'type' => 'padding',
				'label' => __('Border Width Hover'),
				'screen' => 1,
				'css' => [
					'{{element}} .kkart-cart-btn-holder:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px;'
				],
				'req' => [
					'!btn_border_type_hover' => ''
				],
				'show' => array(
					'btn_bor_hover' => 'hover'
				),
			),
			'btn_border_radius_hover' => array(
				'type' => 'padding',
				'label' => __('Border Radius Hover'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-cart-btn-holder:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!btn_border_type_hover' => '',
				),
				'show' => array(
					'btn_bor_hover' => 'hover',
				),
			),
		],
		'styles' => array(
			'cart_quantity' => __('Cart Quantity'),
			'cart_btn_style' => __('Cart Button Style'),
			'cart_border_style' => __('Cart Border Style'),
		)
	)
);

// Cart items holder
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_cart_items', array(
		'name' => __('Cart Items'),
		'icon' => 'fas fa-cart-plus',
		'group' => 'kkart cart',
		'func' => 'kkart_sc_cart_items',
		'has_group' => [
			'section' => 'params', 
			'prop' => 'elements',
		],
		'holder' => '.kkart-cart-items-holder',
		'html' => '<form class="kkart-cart-form-holder" method="post">
			<div class="kkart-cart-items-holder"></div>
		</form>',
		'params' => array(
			'elements' => array(
				'type' => 'group',
				'label' => __('Inner Row'),
				'sc' => PAGELAYER_SC_PREFIX.'_inner_row', // a.k.a the item being multiplied by the count
				'count' => 1,
				'item_label' => array(
					'default' => __('Inner Row'),
				),
				'item_atts' => [], // orderwise array of attrbutes to be set as per the count given 
				'inner_content' => [ // This is the content within each item which is going to the created i.e. within each SC. This only use for inner rows
					['pl_col' => [
							'inner_content' => [
								['pl_kkart_archive_thumb' => []]
							]
						]
					],
					['pl_col' => [
						'inner_content' => [
								['pl_kkart_title' => ['atts' => ['typo' => ',20,,700,,,Solid,,,,', 'link' => 'true']]],
								['pl_kkart_cart_price' => ['atts' => ['price_type' => 'product_sub_total']]],
								['pl_kkart_cart_variable' => []],
								['pl_kkart_cart_item_quantity' => []],
								['pl_kkart_cart_update' => ['atts' => ['ele_custom_pos' => 'true', 'ele_width' => 'initial']]],
								['pl_kkart_cart_item_remove' => ['atts' => ['ele_custom_pos' => 'true', 'ele_width' => 'initial']]],
							],
						]
					],
				],
				'hide' => 1,
			),
		),
	)
);

// Cart item counter
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_cart_variable', array(
		'name' => __('Cart Variable Meta'),
		'group' => 'kkart cart',
		'func' => 'kkart_sc_cart_variable',
		'html' => '<div class="kkart-cart-variables-holder">{{variable_meta}}</div>',
		'params' => array(
			'color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-cart-variables-holder' => 'color: {{val}};'],
			),
		),
	)
);

// Cart item counter
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_cart_item_quantity', array(
		'name' => __('Cart Item Quantity'),
		'group' => 'kkart cart',
		'icon' => 'fas fa-luggage-cart',
		'func' => 'kkart_sc_cart_item_quantity',
		'html' => '<div class="kkart-cart-item-quantity-holder">
			{{form_html}}
		</div>',
		'params' => array(
			'quantity_box_width' => array(
				'type' => 'spinner',
				'label' => __('Quantity Box Width'),
				'min' => 10,
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-quantity input[type="number"]' => 'width: {{val}}px;'],
			),
			'quantity_box_height' => array(
				'type' => 'spinner',
				'label' => __('Quantity Box Height'),
				'min' => 15,
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-quantity' => 'height: {{val}}px;'],
			),
			'input_background_color' => array(
				'type' => 'color',
				'label' => __('Input Background Color'),
				'css' => ['{{element}} .kkart-product-quantity input[type="number"]' => 'background-color:{{val}}'],
			),
			'input_text_color' => array(
				'type' => 'color',
				'label' => __('Input Text Color'),
				'css' => ['{{element}} .kkart-product-quantity input[type="number"]' => 'color:{{val}}'],
			),
			'input_button_style' => array(
				'type' => 'checkbox',
				'label' => __('Input Button Style'),
				'default' => '',
				'css' => ['{{element}} .kkart-product-quantity input[type="number"]' => '-moz-appearance:auto'], // Not working
			),
			'button_width' => array(
				'type' => 'spinner',
				'label' => __('Button Width'),
				'default' => '25',
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus, {{element}} .kkart-product-quantity .kkart-plus' => 'width:{{val}}px'],
			),
			'button_background_color' => array(
				'type' => 'color',
				'label' => __('Button Background Color'),
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus,{{element}} .kkart-product-quantity .kkart-plus' => 'background-color:{{val}}'],
			),
			'button_text_color' => array(
				'type' => 'color',
				'label' => __('Button Color'),
				'css' => ['{{element}} .kkart-minus, {{element}} .kkart-plus' => 'color:{{val}}'],
			),
			'typography' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-minus, {{element}} .kkart-plus' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				],
			),
			'quantity_style' => array(
				'type' => 'select',
				'label' => __('Separate Box'),
				'addClass' => ['{{element}} .kkart-product-quantity' => 'kkart-quantity-style-{{val}}'],
				'list' => array(
					'rounded' => __('Rounded'),
					'' => __('Boxed')
				),
			),
			'quantity_border_color' =>array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#efefef',
				'css' => ['{{element}} .kkart-product-quantity' => 'border-color:{{val}}'],
				'show' => ['quantity_style' => ''],
			),
			'quantity_border_size' =>array(
				'type' => 'padding',
				'label' => __('Border Size'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-quantity' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'show' => ['quantity_style' => ''],
			),
			'quantity_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-quantity' => 'border-radius: {{val[0]}}px; {{val[1]}}px {{val[2]}}px {{val[3]}}px'],
				'show' => ['quantity_style' => ''],
			),
			'show_seperator' => array(
				'type' => 'checkbox',
				'label' => __('Show Seperator'),
				'default' => '',
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus' => 'border-right: 1px solid #efefef;', '{{element}} .kkart-product-quantity .plus' => 'border-left: 1px solid #efefef;'],
				'show' => ['quantity_style' => ''],
			),
			'seperator_border_color' => array(
				'type' => 'color',
				'label' => __('Seperator Border Color'),
				'default' => '#efefef',
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus' => 'border-right-color: {{val}};', '{{element}} .kkart-product-quantity .kkart-plus' => 'border-left-color: {{val}};'],
				'req' => ['quantity_style' => '','!show_seperator' => ''],
			),
			'seperator_border_size' =>array(
				'type' => 'spinner',
				'label' => __('Seperator Border Size'),
				'min' => 1,
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-quantity .kkart-minus' => 'border-right-width: {{val}}px;', '{{element}} .kkart-product-quantity .kkart-plus' => 'border-left-width: {{val}}px;'],
				'req' => ['quantity_style' => '','!show_seperator' => ''],
			),
			'spacing' => array(
				'type' => 'spinner',
				'label' => __('Spacing'),
				'min' => '2',
				'css' => ['{{element}} .kkart-quantity-style-rounded input[type="number"]' => 'margin-left:{{val}}px; margin-right:{{val}}px;'],
				'req' => ['quantity_style' => 'rounded'],
			),
			'input_border_type' => array(
				'type' => 'select',
				'label' => __('Input Border Type'),
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'css' => ['{{element}} .kkart-quantity-style-rounded input[type="number"]' => 'border-style:{{val}}'],
				'req' => ['quantity_style' => 'rounded'],
			),
			'input_border_color' => array(
				'type' => 'color',
				'label' => __('Input Border Color'),
				'default' => '#fff',
				'css' => ['{{element}} .kkart-quantity-style-rounded input[type="number"]' => 'border-color:{{val}}'],
				'req' => ['quantity_style' => 'rounded', '!input_border_type' => ''],
			),
			'input_border_width' => array(
				'type' => 'padding',
				'label' => __('Input Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-quantity-style-rounded input[type="number"]' => 'border-top-width:{{val[0]}}px; border-left-width:{{val[1]}}px; border-bottom-width:{{val[2]}}px; border-right-width:{{val[3]}}px'],
				'req' => ['quantity_style' => 'rounded', '!input_border_type' => ''],
			),
			'input_border_radius' => array(
				'type' => 'padding',
				'label' => __('Input Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-quantity-style-rounded input[type="number"]' => 'border-top-left-radius:{{val[0]}}px; border-top-right-radius:{{val[1]}}px; border-bottom-right-radius:{{val[2]}}px; border-bottom-left-radius:{{val[3]}}px'],
				'req' => ['quantity_style' => 'rounded', '!input_border_type' => ''],
			),
			'button_border_type' => array(
				'type' => 'select',
				'label' => 'button_border_type',
				'default' => 'solid',
				'list' => [
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'css' => ['{{element}} .kkart-quantity-style-rounded .kkart-minus, {{element}} .kkart-quantity-style-rounded .kkart-plus' => 'border-style:{{val}}'],
				'req' => ['quantity_style' => 'rounded'],
			),
			'button_border_color' => array(
				'type' => 'color',
				'label' => __('Button Border Color'),
				'default' => '#000',
				'css' => ['{{element}} .kkart-quantity-style-rounded .kkart-minus, {{element}} .kkart-quantity-style-rounded .kkart-plus' => 'border-color:{{val}}'],
				'req' => ['quantity_style' => 'rounded'],
			),
			'button_border_width' => array(
				'type' => 'padding',
				'label' => __('Button Border Width'),
				'screen' => '1',
				'default' => '2,2,2,2',
				'css' => ['{{element}} .kkart-quantity-style-rounded .kkart-minus, {{element}} .kkart-quantity-style-rounded .kkart-plus' => 'border-top-width:{{val[0]}}px; border-left-width:{{val[1]}}px; border-bottom-width:{{val[2]}}px; border-right-width:{{val[3]}}px;'],
				'req' => ['quantity_style' => 'rounded'],
			),
			'button_border_radius' => array(
				'type' => 'padding',
				'label' => __('Button Border Radius'),
				'screen' => '1',
				'default' => '25,25,25,25',
				'css' => ['{{element}} .kkart-quantity-style-rounded .kkart-minus, {{element}} .kkart-quantity-style-rounded .kkart-plus' => 'border-top-left-radius:{{val[0]}}px; border-top-right-radius:{{val[1]}}px; border-bottom-right-radius:{{val[2]}}px; border-bottom-left-radius:{{val[3]}}px'],
				'req' => ['quantity_style' => 'rounded'],
			),
		),
	)
);

// Cart item Remove
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_cart_item_remove', array(
		'name' => __('Cart Item Remove'),
		'group' => 'kkart cart',
		'icon' => 'far fa-trash-alt',
		'func' => 'kkart_sc_cart_item_remove',
		'html' => '<a href="#" data-cart-key="{{cart_item_key}}"class="kkart-item-remove-link">
			<i if="{{icon}}" class="{{icon}} pagelayer-btn-icon" ></i>
			<span if="{{text}}" class="pagelayer-btn-icon">{{text}}</span>
		</a>',
		'params' => array(
			'icon' => array(
				'type' => 'icon',
				'label' => __('Icon'),
				'default' => 'fas fa-trash-alt',
			),
			'text' => array(
				'type' => 'text',
				'label' => __('Text'),
			),
			'color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-item-remove-link' => 'color:{{val}}' ],
			),
			'padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'screen' => 1,
				'css' => ['{{element}} .pagelayer-btn-icon' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
			'typography' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-item-remove-link' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'spacing_between' => array(
				'type' => 'slider',
				'label' => __('Spacing Between'),
				'css' => ['{{element}} .pagelayer-btn-icon' => 'padding-right:{{val}}px' ],
			),
		),
	)
);

// Cart item update
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_cart_update', array(
		'name' => __('Cart Update Button'),
		'group' => 'kkart cart',
		'func' => 'kkart_sc_cart_item_update',
		'html' => '<button if={{not_sold_individually}} type="submit" name="update_cart" class="kkart-items-update" value="Cart Update" aria-disabled="true" data-cart-key="{{cart_item_key}}">
			<i if="{{icon}}" class="{{icon}} pagelayer-btn-icon"></i>
			<span if="{{text}}" class="pagelayer-btn-icon">{{text}}</span>
		</button>
		<input type="hidden" id="kkart-cart-nonce" name="kkart-cart-nonce" value="{{kkart_cart_nonce}}">',
		'params' => array(
			'icon' => array(
				'type' => 'icon',
				'label' => __('Icon'),
			),
			'text' => array(
				'type' => 'text',
				'label' => __('Text'),
				'default' => __('Update Cart'),
			),
			'bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} .kkart-items-update' => 'background-color:{{val}}' ],
			),
			'color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-items-update' => 'color:{{val}}' ],
			),
			'padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-items-update' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
			'typography' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-items-update' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'spacing_between' => array(
				'type' => 'slider',
				'label' => __('Spacing Between'),
				'css' => ['{{element}} .pagelayer-btn-icon' => 'padding-right:{{val}}px' ],
			),
		),
	)
);

// Cart item count
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_cart_item_count', array(
		'name' => __('Cart Item Count'),
		'group' => 'kkart cart',
		//'use_inside' => ['pl_kkart_archive_item'],
		'html' => '<div class="kkart-cart-item-count">
			<span if="{{before}}">{{before}}</span>{{item_count}}<span if="{{after}}">{{after}}</span>
		</div>',
		'params' => array(
			'before' => array(
				'type' => 'text',
				'label' => __('Before'),
			),
			'after' => array(
				'type' => 'text',
				'label' => __('After'),
			),
			'title_colors' => array(
				'type' => 'radio',
				'label' => __('Colors'),
				'list' => array(
					'' => __('Normal'), 
					'hover' => __('Hover'), 
				)
			),
			'color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'default' => '#0986c0',
				'css' => ['{{element}} .kkart-cart-item-count, {{element}} .kkart-cart-item-count *' => 'color:{{val}}'],
				'show' => ['title_colors' => '']
			),
			'typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => ['{{element}} .kkart-cart-item-count' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
				'show' => ['title_colors' => '']
			),
			'color_hover' => array(
				'type' => 'color',
				'label' => __('Color'),
				'default' => '#0986c0',
				'css' => ['{{element}} .kkart-cart-item-count:hover, {{element}} .kkart-cart-item-count:hover *' => 'color:{{val}}'],
				'show' => ['title_colors' => 'hover']
			),
			'typo_hover' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => ['{{element}} .kkart-cart-item-count:hover' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
				'show' => ['title_colors' => 'hover']
			),
			'align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'list' => [
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				],
				'css' => ['{{element}} .kkart-cart-item-count' => 'text-align: {{val}}'],
			),
		)
	)
);

// Cart item totals
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_cart_price', array(
		'name' => __('Cart Prices'),
		'group' => 'kkart cart',
		'func' => 'kkart_sc_cart_price',
		'html' => '<div class="kkart-price-block">
			<div if="{{title}}">{{title}}</div>
			<div class="kkart-cart-item-price-holder">
				<span class="kkart-cart-item-price" data-pricetype={{price_type}}>{{item_price}}</span>
			</div>
		</div>',
		'params' => array(
			'title_hide' => array(
				'type' => 'checkbox',
				'label' => __('Hide title'),
			),	
			'title' => array(
				'label' => __('Price'),
				'type' => 'text',
				'default' => __('Price'),
				'req' => ['title_hide' =>  '']
			),	
			'price_type' => array(
				'type' => 'select',
				'label' => __('Price Type'),
				'default' => 'price',
				'list' => [
					'price' => __('Price'),
					'sub_total' => __('Sub Total'),
					'grand_total' => __('Grand Total '),
					'all_items_total' => __('All Items Total'),
					'discount' => __('Discount'),
					'delivery_charges' => __('Delivery Charges'),
					'product_sub_total' => __('Product Sub Total'),
					'tax' => __('Tax'),
				],
			),
		),
	)
);

pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_product_variation', array(
		'name' => __('Variation'),
		'group' => 'kkart',
		'func' => 'kkart_sc_product_variation',
		'not_visible' => 1,
		'html' => '<div class="kkart-variable-product">{{product_variation_html}}</div>',
		'params' => array(
			'selection_type' =>array(
				'type' => 'select',
				'label' => __('Selection Type'),
				'default' => 'dropdown',
				'list' => array(
					'dropdown' => __('Dropdown'),
					'checkbox' => __('Checkbox')
				),
			),	
			'checkbox_options' => array(
				'type' => 'select',
				'label' => __('Checkbox Style'),
				'default' => 'text',
				'list' => array(
					'text' => __('Text'),
					'image' => __('Image')
				),
				'req' => [ 'selection_type' => 'checkbox' ]
			)	
		)
	)
);

pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_cart_price_holder', array(
		'name' => __('Cart Price Holder'),
		'group' => 'kkart_cart',
		'icon' => 'fas fa-dollar-sign',
		'func' => 'kkart_sc_cart_prices',
		'has_group' => [
			'section' => 'params', 
			'prop' => 'elements'
		],
		'holder' => '.kkart_cart_price_holder',
		'html' => '<div if={{show_coupon}} class="coupon_holder">'. kkart_checkout_coupon_form(array(), false).'</div>
		<div class="kkart_cart_price_holder"></div>
		<a if={{checkout_proceed_link}} href={{checkout_proceed_link}} class="kkart-cart-checkout-button">Checkout</button>',
		'params' => array(
			'hide_coupon'=>array(
				'type' => 'checkbox',
				'label' => __('Hide Coupon'),
			),
			'coupon_position'=>array(
				'type' => 'checkbox',
				'label' => __('Coupon after pricing'),
				'css' => [ '{{element}} .kkart_cart_price_holder' => 'order:-1'],
				'show' => ['!hide_coupon' => 'true']
			),
			'elements'=> array(
				'type' => 'group',
				'label' => __('Prices'),
				'sc' => PAGELAYER_SC_PREFIX.'_kkart_cart_price',
				'count' => 6,
				'item_label' => array(
					'default' => __('Price'),
					'param' => 'title'
				),
				'item_atts' => array(
					['title' => 'Sub Total', 'price_type' => 'sub_total'],
					['title' => 'Items Total', 'price_type' => 'all_items_total'],
					['title' => 'Delivery Charges', 'price_type' => 'delivery_charges'],
					['title' => 'Discount', 'price_type' => 'discount'],
					['title' => 'Tax', 'price_type' => 'tax'],
					['title' => 'Grand Total', 'price_type' => 'grand_total'],
				),
				'hide' => 1
			)
		),
		'checkout_button' => array(
			'hide_checkout' => array(
				'type' => 'checkbox',
				'label' => __('Hide Checkout Button'),
				'css' => [ '{{element}} .kkart-cart-checkout-button' => 'display:none']
			),
			'checkout_btn_colors' => array(
				'type' => 'radio',
				'label' => __('Button Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
			),
			'checkout_btn_bg'=> array(
				'label' => __('Background Color'),
				'type' => 'color',
				'css' => ['{{element}} .kkart-cart-checkout-button' => 'background-color:{{val}}'],
				'show' => ['checkout_btn_colors' => '']
			),
			'checkout_btn_color'=> array(
				'label' => __('Color'),
				'type' => 'color',
				'css' => ['{{element}} .kkart-cart-checkout-button' => 'color:{{val}}'],
				'show' => ['checkout_btn_colors' => '']
			),
			'checkout_btn_hover_bg'=> array(
				'label' => __('Background Color'),
				'type' => 'color',
				'css' => ['{{element}} .kkart-cart-checkout-button:hover' => 'background-color:{{val}}'],
				'show' => ['checkout_btn_colors' => 'hover']
			),
			'checkout_btn_hover_color'=> array(
				'label' => __('Color'),
				'type' => 'color',
				'css' => ['{{element}} .kkart-cart-checkout-button:hover' => 'color:{{val}}'],
				'show' => ['checkout_btn_colors' => 'hover']
			),
			'checkout_btn_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .kkart-cart-checkout-button' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'checkout_border_colors' => array(
				'type' => 'radio',
				'label' => __('Border Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
				'req' => ['!checkout_btn_border_type' => '']
			),
			'checkout_btn_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-cart-checkout-button' => 'border-color: {{val}};'],
				'req' => ['!checkout_btn_border_type' => ''],
				'show' => ['checkout_border_colors' => '']
			),
			'checkout_btn_border_hover' => array(
				'type' => 'color',
				'label' => __('Border Hover'),
				'css' => ['{{element}} .kkart-cart-checkout-button:hover' => 'border-color: {{val}};'],
				'req' => ['!checkout_btn_border_type' => ''],
				'show' => ['checkout_border_colors' => 'hover']
			),
			'checkout_btn_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-cart-checkout-button' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!checkout_btn_border_type' => '']
			),
			'checkout_btn_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-cart-checkout-button' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
			),
			'checkout_btn_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-cart-checkout-button' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
			'checkout_btn_display' => array(
				'type' => 'select',
				'label' => __('Display'),
				'screen' => 1,
				'default' => '',
				'css' => ['{{element}} .kkart-cart-checkout-button' => 'display:{{val}}'],
				'list' => array(
					'' => __('Full'),
					'inline-block' => __('Inline'),
				),
			),
			'checkout_btn_width' => array(
				'type' => 'slider',
				'label' => __('Width'),
				'default' => 100,
				'min' => 1,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} a.kkart-cart-checkout-button' => 'width:{{val}}%'],
			),
		),
		'styles' => array(
			'checkout_button' => __('Checkout Button')
		)
	)
);

// Buy now Button
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_buy_now', array(
		'name' => __('Buy Now'),
		'icon' => 'fa fa-shopping-basket',
		'group' => 'kkart',
		'func' => 'kkart_sc_buy_now',
		'use_inside' => ['pl_kkart_archive_item'],
		'html' => '<div if="{{buy_now_show}}" class="kkart-buy-now-holder">
			<a href="{{buy_now_url}}" class="kkart-buy-now">
				<span if="{{buy_now_text}}">{{buy_now_text}}</span>
				<i if="{{buy_now_icon}}" class="kkart-buy-now-icon {{buy_now_icon}}"></i>
			</a>
		</div>',
		'params' => array(
			'buy_now_text' => array(
				'type' => 'text',
				'label' => __('Text'),
				'default' => 'Buy Now',
			),
			'full_width' => array(
				'type' => 'checkbox',
				'label' => __('Stretch'),
				'screen' => 1,
				'css' => ['{{element}} a' => 'width: 100%; text-align: center;']
			),
			'btn_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-buy-now' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				],
			),
			'align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'default' => 'left',
				'screen' => 1,
				'css' => 'text-align: {{val}}',
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right')
				),
				'req' => array(
					'full_width' => ''
				)
			),
		),
		'btn_style' => [
			'type' => array(
				'type' => 'select',
				'label' => __('Button Type'),
				'default' => 'pagelayer-btn-default',
				'list' => array(
					'pagelayer-btn-default' => __('Default'),
					'pagelayer-btn-primary' => __('Primary'),
					'pagelayer-btn-secondary' => __('Secondary'),
					'pagelayer-btn-success' => __('Success'),
					'pagelayer-btn-info' => __('Information'),
					'pagelayer-btn-warning' => __('Warning'),
					'pagelayer-btn-danger' => __('Danger'),
					'pagelayer-btn-dark' => __('Dark'),
					'pagelayer-btn-light' => __('Light'),
					'pagelayer-btn-link' => __('Link'),
					'' => __('Custom')
				),
				'addClass' => ['{{element}} .kkart-buy-now' => '{{val}}'],
			),
			'size' => array(
				'type' => 'select',
				'label' => __('Size'),
				'default' => '',
				'list' => array(
					'pagelayer-btn-mini' => __('Mini'),
					'pagelayer-btn-small' => __('Small'),
					'pagelayer-btn-large' => __('Large'),
					'pagelayer-btn-extra-large' => __('Extra Large'),
					'pagelayer-btn-double-large' => __('Double Large'),
					'' => __('Custom'),
				),
				'addClass' => ['{{element}} .kkart-buy-now' => '{{val}}'],
			),
			'btn_custom_size' => array(
				'type' => 'spinner',
				'label' => __('Custom Size'),
				'min' => 1,
				'max' => 100,
				'default' => 10,
				'screen' => 1,
				'css' => ['{{element}} .kkart-buy-now' => 'padding: calc({{val}}px / 2) {{val}}px;'],
				'req' => ['size' => ''],
			),
			'btn_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				),
				'req' => ['type' => ''],
			),
			'btn_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'default' => '#818a91',
				'css' => ['{{element}} .kkart-buy-now' => 'background-color: {{val}};'],
				'req' => ['type' => ''],
				'show' => ['btn_hover' => ''],
			),
			'btn_color' => array(
				'type' => 'color',
				'label' => __('Button Color'),
				'default' => '#ffffff',
				'css' => ['{{element}} .kkart-buy-now' => 'color: {{val}};'],
				'req' => ['type' => ''],
				'show' => ['btn_hover' => ''],
			),
			'btn_hover_delay' => array(
				'type' => 'spinner',
				'label' => __('Button Hover Delay'),
				'desc' => __('Time to delay the hover in ms'),
				'min' => 0,
				'step' => 100,
				'max' => 5000,
				'default' => 400,
				'css' => ['{{element}} .kkart-buy-now' => '-webkit-transition: all {{val}}ms !important; transition: all {{val}}ms !important;'],
				'show' => ['type' => '', 'btn_hover' => 'hover'],
			),
			'btn_bg_color_hover' => array(
				'type' => 'color',
				'label' => __('Background Hover Color'),
				'css' => ['{{element}} .kkart-buy-now:hover, {{element}} .pagelayer-btn-anim-slide:after' => 'background-color: {{val}};'],
				'req' => ['type' => ''],
				'show' =>['btn_hover' => 'hover'],
			),
			'btn_color_hover' => array(
				'type' => 'color',
				'label' => __('Hover Color'),
				'css' => ['{{element}} .kkart-buy-now:hover' => 'color: {{val}};'],
				'req' => ['type' => ''],
				'show' => ['btn_hover' => 'hover'],
			),
			'btn_shadow' => [
				'type' => 'box_shadow',
				'label' => __('Shadow'),
				'css' => ['{{element}} .kkart-buy-now' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
			],
			'btn_shadow_hover' => [ // This is actually box shadow hover
				'type' => 'box_shadow',
				'label' => __('Box Shadow Hover'),
				'css' => ['{{element}} .kkart-buy-now:hover' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}} !important;'],
			],
		],
		'border_style' => [
			'btn_bor_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				)
			),	
			'btn_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => ['{{element}} .kkart-buy-now' => 'border-style: {{val}};'],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => ['btn_bor_hover' => ''],
			),
			'btn_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#42414f',
				'css' => ['{{element}} .kkart-buy-now' => 'border-color: {{val}};'],
				'req' => ['!btn_border_type' => ''],
				'show' => ['btn_bor_hover' => ''],
			),
			'btn_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-buy-now' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => [
					'!btn_border_type' => ''
				],
				'show' => ['btn_bor_hover' => ''],
			),
			'btn_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-buy-now' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => ['!btn_border_type' => ''],
				'show' => ['btn_bor_hover' => ''],
			),
			'btn_border_type_hover' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => ['{{element}} .kkart-buy-now:hover' => 'border-style: {{val}}'],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => ['btn_bor_hover' => 'hover'],
			),
			'btn_border_color_hover' => array(
				'type' => 'color',
				'label' => __('Border Color Hover'),
				'default' => '#42414f',
				'css' => ['{{element}} .kkart-buy-now:hover' => 'border-color: {{val}};'],
				'req' => ['!btn_border_type_hover' => ''],
				'show' => ['btn_bor_hover' => 'hover'],
			),
			'btn_border_width_hover' => array(
				'type' => 'padding',
				'label' => __('Border Width Hover'),
				'screen' => 1,
				'css' => [
					'{{element}} .kkart-buy-now:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px;'
				],
				'req' => ['!btn_border_type_hover' => ''],
				'show' => ['btn_bor_hover' => 'hover'],
			),
			'btn_border_radius_hover' => array(
				'type' => 'padding',
				'label' => __('Border Radius Hover'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-buy-now:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => ['!btn_border_type_hover' => ''],
				'show' => ['btn_bor_hover' => 'hover'],
			),
		],
		'icon_style' => [
			'buy_now_icon' => array(
				'type' => 'icon',
				'label' => __('Icon'),
			),
			'icon_position' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'list' => array(
					'kkart-buy-now-icon-left' => __('Left'),
					'' => __('Right')
				),
				'addClass' => ['{{element}} .kkart-buy-now' => '{{val}}'],
				'req' => ['!buy_now_icon' => 'none'],
			),
			'icon_spacing' => array(
				'type' => 'slider',
				'label' => __('Icon Spacing'),
				'min' => 1,
				'max' => 100,
				'default' => 5,
				'screen' => 1,
				'css' => ['{{element}} .kkart-buy-now-icon' => 'padding: 0 {{val}}px;'],
				'req' => ['!buy_now_icon' => 'none'],
			),
		],
		'styles' => array(
			'btn_style' => __('Button Styles'),
			'border_style' => __('Border Style'),
			'icon_style' => __('Icon Style')
		),
	)
);

// Cart Proceed Button
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_checkout_proceed_btn', array(
		'name' => __('Checkout Proceed Button'),
		'group' => 'kkart cart',
		'html' => '<div class="kkart-checkout-proceed-holder">
			<a href="{{checkout_proceed_link}}" class="kkart-checkout-proceed">
				<span if="{{checkout_proceed_text}}">{{checkout_proceed_text}}</span>
				<i if="{{checkout_proceed_icon}}" class="kkart-checkout-proceed-icon {{checkout_proceed_icon}}"></i>
			</a>
		</div>',
		'params' => array(
			'checkout_proceed_text' => array(
				'type' => 'text',
				'label' => __('Text'),
				'default' => 'Proceed To Checkout',
			),
			'full_width' => array(
				'type' => 'checkbox',
				'label' => __('Stretch'),
				'screen' => 1,
				'css' => ['{{element}} a' => 'width: 100%; text-align: center;']
			),
			'btn_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-checkout-proceed' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
					'{{element}} .kkart-checkout-proceed-holder' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				],
			),
			'align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'default' => 'left',
				'screen' => 1,
				'css' => 'text-align: {{val}}',
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right')
				),
				'req' => array(
					'full_width' => ''
				)
			),
		),
		'btn_style' => [
			'type' => array(
				'type' => 'select',
				'label' => __('Button Type'),
				'default' => 'pagelayer-btn-default',
				'list' => array(
					'pagelayer-btn-default' => __('Default'),
					'pagelayer-btn-primary' => __('Primary'),
					'pagelayer-btn-secondary' => __('Secondary'),
					'pagelayer-btn-success' => __('Success'),
					'pagelayer-btn-info' => __('Information'),
					'pagelayer-btn-warning' => __('Warning'),
					'pagelayer-btn-danger' => __('Danger'),
					'pagelayer-btn-dark' => __('Dark'),
					'pagelayer-btn-light' => __('Light'),
					'pagelayer-btn-link' => __('Link'),
					'' => __('Custom')
				),
				'addClass' => ['{{element}} .kkart-checkout-proceed' => '{{val}}'],
			),
			'size' => array(
				'type' => 'select',
				'label' => __('Size'),
				'default' => 'pagelayer-btn-large',
				'list' => array(
					'pagelayer-btn-mini' => __('Mini'),
					'pagelayer-btn-small' => __('Small'),
					'pagelayer-btn-large' => __('Large'),
					'pagelayer-btn-extra-large' => __('Extra Large'),
					'pagelayer-btn-double-large' => __('Double Large'),
					'' => __('Custom'),
				),
				'addClass' => ['{{element}} .kkart-checkout-proceed' => '{{val}}'],
			),
			'btn_custom_size' => array(
				'type' => 'spinner',
				'label' => __('Custom Size'),
				'min' => 1,
				'step' => 1,
				'max' => 100,
				'default' => 5,
				'screen' => 1,
				'css' => ['{{element}} .kkart-checkout-proceed' => 'padding: calc({{val}}px / 2) {{val}}px;'],
				'req' => array(
					'size' => '',
				),
			),
			'btn_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'default' => '',
				//'no_val' => 1,// Dont set any value to element
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				),
				'req' => array(
					'type' => '',
				),
			),
			'btn_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'default' => '#818a91',
				'css' => [
					'{{element}} .kkart-checkout-proceed' => 'background-color: {{val}};',
				],
				'req' => array(
					'type' => '',
				),
				'show' => array(
					'btn_hover' => ''
				),
			),
			'btn_color' => array(
				'type' => 'color',
				'label' => __('Button Color'),
				'default' => '#ffffff',
				'css' => ['{{element}} .kkart-checkout-proceed' => 'color: {{val}};'],
				'req' => array(
					'type' => '',
				),
				'show' => array(
					'btn_hover' => ''
				),
			),
			'btn_hover_delay' => array(
				'type' => 'spinner',
				'label' => __('Button Hover Delay'),
				'desc' => __('Time to delay the hover in ms'),
				'min' => 0,
				'step' => 100,
				'max' => 5000,
				'default' => 400,
				'css' => ['{{element}} .kkart-checkout-proceed' => '-webkit-transition: all {{val}}ms !important; transition: all {{val}}ms !important;'],
				'show' => array(
					'type' => '',
					'btn_hover' => 'hover'
				),
			),
			'btn_bg_color_hover' => array(
				'type' => 'color',
				'label' => __('Background Hover Color'),
				'default' => '',
				'css' => [
					'{{element}} .kkart-checkout-proceed:hover, {{element}} .pagelayer-btn-anim-slide:after' => 'background-color: {{val}};',
				],
				'req' => array(
					'type' => '',
				),
				'show' => array(
					'btn_hover' => 'hover',
				),
			),
			'btn_color_hover' => array(
				'type' => 'color',
				'label' => __('Hover Color'),
				'css' => ['{{element}} .kkart-checkout-proceed:hover' => 'color: {{val}};'],
				'req' => array(
					'type' => '',
				),
				'show' => array(
					'btn_hover' => 'hover'
				),
			),
			'btn_shadow' => [
				'type' => 'box_shadow',
				'label' => __('Shadow'),
				'css' => ['{{element}} .kkart-checkout-proceed' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
			],
			'btn_shadow_hover' => [ // This is actually box shadow hover
				'type' => 'box_shadow',
				'label' => __('Box Shadow Hover'),
				'css' => ['{{element}} .kkart-checkout-proceed:hover' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}} !important;'],
			],
		],
		'border_style' => [
			'btn_bor_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'default' => '',
				//'no_val' => 1,// Dont set any value to element
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				)
			),	
			'btn_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => ['{{element}} .kkart-checkout-proceed' => 'border-style: {{val}};'],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => array(
					'btn_bor_hover' => ''
				),
			),
			'btn_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#42414f',
				'css' => ['{{element}} .kkart-checkout-proceed' => 'border-color: {{val}};'],
				'req' => array(
					'!btn_border_type' => ''
				),
				'show' => array(
					'btn_bor_hover' => ''
				),
			),
			'btn_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-checkout-proceed' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => [
					'!btn_border_type' => ''
				],
				'show' => array(
					'btn_bor_hover' => ''
				),
			),
			'btn_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-checkout-proceed' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!btn_border_type' => '',
				),
				'show' => array(
					'btn_bor_hover' => '',
				),
			),
			'btn_border_type_hover' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => ['{{element}} .kkart-checkout-proceed:hover' => 'border-style: {{val}}'],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => array(
					'btn_bor_hover' => 'hover'
				),
			),
			'btn_border_color_hover' => array(
				'type' => 'color',
				'label' => __('Border Color Hover'),
				'default' => '#42414f',
				'css' => ['{{element}} .kkart-checkout-proceed:hover' => 'border-color: {{val}};'],
				'req' => array(
					'!btn_border_type_hover' => ''
				),
				'show' => array(
					'btn_bor_hover' => 'hover'
				),
			),
			'btn_border_width_hover' => array(
				'type' => 'padding',
				'label' => __('Border Width Hover'),
				'screen' => 1,
				'css' => [
					'{{element}} .kkart-checkout-proceed:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px;'
				],
				'req' => [
					'!btn_border_type_hover' => ''
				],
				'show' => array(
					'btn_bor_hover' => 'hover'
				),
			),
			'btn_border_radius_hover' => array(
				'type' => 'padding',
				'label' => __('Border Radius Hover'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-checkout-proceed:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!btn_border_type_hover' => '',
				),
				'show' => array(
					'btn_bor_hover' => 'hover',
				),
			),
		],
		'icon_style' => [
			'checkout_proceed_icon' => array(
				'type' => 'icon',
				'label' => __('Icon'),
				'default' => '',
			),
			'icon_position' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'default' => '',
				'list' => array(
					'kkart-checkout-icon-left' => __('Left'),
					'' => __('Right')
				),
				'addClass' => ['{{element}} .kkart-checkout-proceed' => '{{val}}'],
				'req' => array(
					'!checkout_proceed_icon' => 'none'
				),
			),
			'icon_spacing' => array(
				'type' => 'slider',
				'label' => __('Icon Spacing'),
				'min' => 1,
				'step' => 1,
				'max' => 100,
				'default' => 5,
				'screen' => 1,
				'css' => ['{{element}} .kkart-checkout-proceed-icon' => 'padding: 0 {{val}}px;'],
				'req' => array(
					'!checkout_proceed_icon' => 'none'
				),
			),
		],
		'styles' => array(
			'btn_style' => __('Button Styles'),
			'border_style' => __('Border Style'),
			'icon_style' => __('Icon Style')
		),
	)
);

// Checkout form holder
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_checkout_form', array(
		'name' => __('Checkout form Holder'),
		'group' => 'kkart Checkout',
		'func' => 'kkart_sc_checkout_form',
		'html' => '<div class="kkart-checkout-holder">
			{{checkout_form}}
		</div>
		<div class="kkart-checkout-container"></div>',
		'params' => array(
			'tab_colors' => array(
				'type' => 'radio',
				'label' => __('Tab Colors'),
				'list' => array(
					'' => __('Normal'),
					'active' => __('Active'),
				),
			),
			'active_tab_bgcolor' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'default' => '#000000',
				'css' => [ '{{element}} .kkart-checkout-active-tab .kkart-checkout-tab-header' => 'background-color:{{val}}!important'],
				'show' => ['tab_colors' => 'active']
			),
			'active_tab_text' =>array(
				'label' => __('Color'),
				'type' => 'color',
				'default' => '#FFFFFF',
				'css' => ['{{element}} .kkart-checkout-active-tab .kkart-checkout-tab-header' => 'color:{{val}}!important'],
				'show' => ['tab_colors' => 'active']
			),
			'inactive_tab' =>array(
				'label' => __('Background Color'),
				'type' => 'color',
				'default' => '#cccccc',
				'css' => ['{{element}} .kkart-checkout-tab-header' => 'background-color:{{val}}'],
				'show' => ['tab_colors' => '']
			),
			'inactive_tab_text' =>array(
				'label' => __('Color'),
				'type' => 'color',
				'default' => '#000000',
				'css' => ['{{element}} .kkart-checkout-tab-header' => 'color:{{val}}'],
				'show' => ['tab_colors' => '']
			),
			'tab_spacing' =>array(
				'type' => 'spinner',
				'label' => __('Spacing'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-checkout-holder > div:not(:last-child)' => 'margin-bottom:{{val}}px'],
				'show' => ['tab_colors' => '']
			)
		),
		'proceed_button'=> array(
			'proceed_colors' => array(
				'type' => 'radio',
				'label' => __('Button Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
			),
			'proceed_button_bg_color'=> array(
				'label' => __('Background Color'),
				'type' => 'color',
				'css' => ['{{element}} .checkout-tabs-proceed' => 'background-color:{{val}}'],
				'show' => ['proceed_colors' => '']
			),
			'proceed_button_text_color'=> array(
				'label' => __('Color'),
				'type' => 'color',
				'css' => ['{{element}} .checkout-tabs-proceed' => 'color:{{val}}'],
				'show' => ['proceed_colors' => '']
			),
			'proceed_button_hover_bg'=> array(
				'label' => __('Background Color'),
				'type' => 'color',
				'css' => ['{{element}} .checkout-tabs-proceed:hover' => 'background-color:{{val}}'],
				'show' => ['proceed_colors' => 'hover']
			),
			'proceed_button_hover_color'=> array(
				'label' => __('Color'),
				'type' => 'color',
				'css' => ['{{element}} .checkout-tabs-proceed:hover' => 'color:{{val}}'],
				'show' => ['proceed_colors' => 'hover']
			),
			'proceed_button_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .checkout-tabs-proceed' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'proceed_border_colors' => array(
				'type' => 'radio',
				'label' => __('Border Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
				'req' => ['!proceed_button_border_type' => '']
			),
			'proceed_button_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .checkout-tabs-proceed' => 'border-color: {{val}};'],
				'req' => ['!proceed_button_border_type' => ''],
				'show' => ['proceed_border_colors' => '']
			),
			'proceed_button_border_hover' => array(
				'type' => 'color',
				'label' => __('Border Hover'),
				'css' => ['{{element}} .checkout-tabs-proceed:hover' => 'border-color: {{val}};'],
				'req' => ['!proceed_button_border_type' => ''],
				'show' => ['proceed_border_colors' => 'hover']
			),
			'proceed_button_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .checkout-tabs-proceed' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!proceed_button_border_type' => '']
			),
			'proceed_button_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .checkout-tabs-proceed' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
			),
			'proceed_button_button_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'screen' => 1,
				'css' => ['{{element}} .checkout-tabs-proceed' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
			
		),
		'edit_button'=> array(
			'edit_colors' => array(
				'type' => 'radio',
				'label' => __('Edit Button Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
			),
			'edit_button_bg_color'=> array(
				'label' => __('Background Color'),
				'type' => 'color',
				'css' => ['{{element}} .checkout_edit_button' => 'background-color:{{val}}'],
				'show' => ['edit_colors' => '']
			),
			'edit_button_color'=> array(
				'label' => __('Color'),
				'type' => 'color',
				'css' => ['{{element}} .checkout_edit_button' => 'color:{{val}}'],
				'show' => ['edit_colors' => '']
			),
			'edit_button_hover_bg'=> array(
				'label' => __('Background Color'),
				'type' => 'color',
				'css' => ['{{element}} .checkout_edit_button:hover' => 'background-color:{{val}}'],
				'show' => ['edit_colors' => 'hover']
			),
			'edit_button_hover_color'=> array(
				'label' => __('Color'),
				'type' => 'color',
				'css' => ['{{element}} .checkout_edit_button:hover' => 'color:{{val}}'],
				'show' => ['edit_colors' => 'hover']
			),
			'edit_button_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .checkout_edit_button' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'edit_border_colors' => array(
				'type' => 'radio',
				'label' => __('Border Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
				'req' => ['!edit_button_border_type' => '']
			),
			'edit_button_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .checkout_edit_button' => 'border-color: {{val}};'],
				'req' => ['!edit_button_border_type' => ''],
				'show' => ['edit_border_colors' => '']
			),
			'edit_button_border_hover' => array(
				'type' => 'color',
				'label' => __('Border Hover'),
				'css' => ['{{element}} .checkout_edit_button:hover' => 'border-color: {{val}};'],
				'req' => ['!edit_button_border_type' => ''],
				'show' => ['edit_border_colors' => 'hover']
			),
			'edit_button_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .checkout_edit_button' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!edit_button_border_type' => '']
			),
			'edit_button_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .checkout_edit_button' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
			),
			'edit_button_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'screen' => 1,
				'css' => ['{{element}} .checkout_edit_button' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
		),
		'billing_here_button' => array(
			'billing_here_colors' => array(
				'type' => 'radio',
				'label' => __('Billing Here Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
			),
			'billing_here' => array(
				'type' => 'text',
				'label' => __('Billing Here Button'),
				'default' => 'Use This',
				'addAttr' => ['{{element}} .kkart-addresses-holder' => 'data-here-text="{{billing_here}}"'],
				'req' => ['form_type' => '']
			),
			'here_btn_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-billing-here' => 'background-color:{{val}}'],
				'show' => ['billing_here_colors'=> '']
			),
			'btn_text_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-billing-here' => 'color:{{val}}'],
				'show' => ['billing_here_colors' => '']
			),
			'btn_hover_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-billing-here:hover' => 'background-color:{{val}}'],
				'show' => ['billing_here_colors'=> 'hover']
			),
			'billing_hover_text_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-billing-here:hover' => 'color:{{val}}'],
				'show' => ['billing_here_colors'=> 'hover']
			),
			'billing_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .kkart-billing-here' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'billing_border_colors' => array(
				'type' => 'radio',
				'label' => __('Border Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
				'req' => ['!billing_border_type' => ''],
			),
			'billing_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-billing-here' => 'border-color: {{val}};'],
				'req' => ['!billing_border_type' => ''],
				'show' => ['billing_border_colors' => '']
			),
			'billing_border_hover' => array(
				'type' => 'color',
				'label' => __('Border Hover'),
				'css' => ['{{element}} .kkart-billing-here:hover' => 'border-color: {{val}};'],
				'req' => ['!billing_border_type' => ''],
				'show' => ['billing_border_colors' => 'hover']
			),
			'billing_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-here' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!billing_border_type' => '']
			),
			'btn_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-here' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
			),
			'btn_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-here' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
			'here_btn_display' => array(
				'type' => 'select',
				'label' => __('Display'),
				'screen' => 1,
				'default' => '',
				'css' => ['{{element}} .kkart-billing-here' => 'display:{{val}}'],
				'list' => array(
					'' => __('Full'),
					'inline-block' => __('Inline'),
				),
			),
			'here_btn_width' => array(
				'type' => 'slider',
				'label' => __('Width'),
				'min' => 1,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-here' => 'width:{{val}}%'],
			),
		),
		'billing_edit_button' => array(
			'billing_edit' => array(
				'type' => 'text',
				'label' => __('Billing Edit'),
				'default' => 'Edit',
				'addAttr' => ['{{element}} .kkart-addresses-holder' => 'data-edit-text="{{billing_edit}}"'],
			),
			'billing_edit_colors' => array(
				'type' => 'radio',
				'label' => __('Billing Edit Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
			),
			'edit_btn_bgcolor' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-billing-edit' => 'background-color:{{val}}'],
				'show' => ['billing_edit_colors' => '']
			),
			'edit_btn_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-billing-edit' => 'color:{{val}}'],
				'show' => ['billing_edit_colors' => '']
			),
			'edit_btn_hover_bgcolor' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-billing-edit:hover' => 'background-color:{{val}}'],
				'show' => ['billing_edit_colors' => 'hover']
			),
			'edit_btn_hover_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-billing-edit:hover' => 'color:{{val}}'],
				'show' => ['billing_edit_colors' => 'hover']
			),
			'edit_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .kkart-billing-edit' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'edit_border_colors' => array(
				'type' => 'radio',
				'label' => __('Border Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
				'req' => ['!edit_border_type' => '']
			),
			'edit_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-billing-edit' => 'border-color: {{val}};'],
				'req' => ['!edit_border_type' => ''],
				'show' => ['edit_border_colors' => '']
			),
			'edit_border_hover' => array(
				'type' => 'color',
				'label' => __('Border Hover'),
				'css' => ['{{element}} .kkart-billing-edit:hover' => 'border-color: {{val}};'],
				'req' => ['!edit_border_type' => ''],
				'show' => ['edit_border_colors' => 'hover']
			),
			'edit_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-edit' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!edit_border_type' => ''],
			),
			'edit_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-edit' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
			),
			'edit_btn_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-edit' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
			'edit_btn_display' => array(
				'type' => 'select',
				'label' => __('Display'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-edit' => 'display:{{val}}'],
				'list' => array(
					'' => __('Full'),
					'inline-block' => __('Inline'),
				),
			),
			'edit_btn_width' => array(
				'type' => 'slider',
				'label' => __('Width'),
				'min' => 1,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-edit' => 'width:{{val}}%'],
			),
			
		),
		'delete_button' => array(
			'billing_delete_colors' => array(
				'type' => 'radio',
				'label' => __('Billing Delete Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
			),
			'billing_delete' => array(
				'type' => 'text',
				'label' => __('Billing Delete'),
				'default' => 'Delete',
				'addAttr' => ['{{element}} .kkart-addresses-holder' => 'data-delete-text="{{billing_delete}}"'],
			),
			'del_btn_bgcolor' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-billing-delete' => 'background-color:{{val}}'],
				'show' => ['billing_delete_colors' => '']
			),
			'del_btn_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-billing-delete' => 'color:{{val}}'],
				'show' => ['billing_delete_colors' => '']
			),
			'del_btn_hover_bgcolor' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-billing-delete:hover' => 'background-color:{{val}}'],
				'show' => ['billing_delete_colors' => 'hover']
			),
			'del_btn_hover_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-billing-delete:hover' => 'color:{{val}}'],
				'show' => ['billing_delete_colors' => 'hover']
			),
			'del_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .kkart-billing-delete' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'del_border_colors' => array(
				'type' => 'radio',
				'label' => __('Border Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
				'req' => ['!del_border_type' => '']
			),
			'del_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-billing-delete' => 'border-color: {{val}};'],
				'req' => ['!del_border_type' => ''],
				'show' => ['del_border_colors' => '']
			),
			'del_border_hover' => array(
				'type' => 'color',
				'label' => __('Border Hover'),
				'css' => ['{{element}} .kkart-billing-delete:hover' => 'border-color: {{val}};'],
				'req' => ['!del_border_type' => ''],
				'show' => ['del_border_colors' => 'hover']
			),
			'del_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-delete' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!del_border_type' => '']
			),
			'del_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-delete' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
			),
			'del_btn_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-delete' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
			'del_btn_display' => array(
				'type' => 'select',
				'label' => __('Display'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-delete' => 'display:{{val}}'],
				'list' => array(
					'' => __('Full'),
					'inline-block' => __('Inline'),
				),
			),
			'del_btn_width' => array(
				'type' => 'slider',
				'label' => __('Width'),
				'min' => 1,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} .kkart-billing-delete' => 'width:{{val}}%'],
			),			
		),
		'add_address' => array(
			'add_addre_text' => array(
				'type' => 'text',
				'label' => __('Add Address Text'),
				'default' => '+ Add New Address',
			),
			'add_addre_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-address-form-headding' => 'color:{{val}}' ]
			),
			'add_font_weight' => array(
				'type' => 'select',
				'label' => __('Font Weight'),
				'default' => 'normal',
				'list' => array(
					'normal' => __('Normal'),
					'bold' => __('Bold'),
					'bolder' => __('Bolder'),
					'lighter' => __('Lighter')
				),
				'css' => [ '{{element}} .kkart-address-form-headding' => 'font-weight:{{val}}' ]
			)
		),
		'form_save_button' => array(
			'billing_save_colors' => array(
				'type' => 'radio',
				'label' => __('Billing Save Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
			),
			'save_addre_text' => array(
				'type' => 'text',
				'label' => __('Save Address Text'),
				'default' => 'Save',
			),
			'save_btn_bgcolor' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-save-address-form' => 'background-color:{{val}}'],
				'show' => ['billing_save_colors' => '']
			),
			'save_btn_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-save-address-form' => 'color:{{val}}'],
				'show' => ['billing_save_colors' => '']
			),
			'save_btn_hover_bgcolor' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-save-address-form:hover' => 'background-color:{{val}}'],
				'show' => ['billing_save_colors' => 'hover']
			),
			'save_btn_hover_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-save-address-form:hover' => 'color:{{val}}'],
				'show' => ['billing_save_colors' => 'hover']
			),
			'save_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .kkart-save-address-form' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'billing_save_border_colors' => array(
				'type' => 'radio',
				'label' => __('Border Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
				'req' => ['!save_border_type' => '']
			),
			'billing_savebt_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-save-address-form' => 'border-color: {{val}};'],
				'req' => ['!save_border_type' => ''],
				'show' => ['billing_save_border_colors' => '']
			),
			'billing_savebt_border_hover' => array(
				'type' => 'color',
				'label' => __('Border Hover'),
				'css' => ['{{element}} .kkart-save-address-form:hover' => 'border-color: {{val}};'],
				'req' => ['!save_border_type' => ''],
				'show' => ['billing_save_border_colors' => 'hover']
			),
			'billing_savebt_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-save-address-form' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!save_border_type' => '']
			),
			'save_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-save-address-form' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
			),
			'save_btn_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-save-address-form' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
			'save_btn_display' => array(
				'type' => 'select',
				'label' => __('Display'),
				'screen' => 1,
				'default' => '',
				'css' => ['{{element}} .kkart-save-address-form' => 'display:{{val}}'],
				'list' => array(
					'' => __('Full'),
					'inline-block' => __('Inline'),
				),
			),
			'save_btn_width' => array(
				'type' => 'slider',
				'label' => __('Width'),
				'min' => 1,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} .kkart-save-address-form' => 'width:{{val}}%'],
			),
		),
		'form_cancel_button' => array(
			'billing_cancel_colors' => array(
				'type' => 'radio',
				'label' => __('Billing Cancel Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
			),	
			'cancel_addre_text' => array(
				'type' => 'text',
				'label' => __('Cancel Address Text'),
				'default' => 'Cancel',
			),
			'cancel_btn_bgcolor' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-cancel-address-form' => 'background-color:{{val}}'],
				'show' => ['billing_cancel_colors' => '']
			),
			'cancel_btn_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-cancel-address-form' => 'color:{{val}}'],
				'show' => ['billing_cancel_colors' => '']
			),
			'cancel_btn_hover_bgcolor' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-cancel-address-form:hover' => 'background-color:{{val}}'],
				'show' => ['billing_cancel_colors' => 'hover']
			),
			'cancel_button_hover_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-cancel-address-form:hover' => 'color:{{val}}'],
				'show' => ['billing_cancel_colors' => 'hover']
			),
			'cancel_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .kkart-cancel-address-form' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'billing_cancel_border_colors' => array(
				'type' => 'radio',
				'label' => __('Border Colors'),
				'list' => array(
					'' => __('Normal Color'),
					'hover' => __('Hover Color'),
				),
				'req' => ['!cancel_border_type' => '']
			),
			'billing_cancelbt_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-cancel-address-form' => 'border-color: {{val}};'],
				'req' => ['!cancel_border_type' => ''],
				'show' => ['billing_cancel_border_colors' => '']
			),
			'billing_cancelbt_border_hover' => array(
				'type' => 'color',
				'label' => __('Border Hover'),
				'css' => ['{{element}} .kkart-cancel-address-form:hover' => 'border-color: {{val}};'],
				'req' => ['!cancel_border_type' => ''],
				'show' => ['billing_cancel_border_colors' => 'hover']
			),
			'billing_cancelbt_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-cancel-address-form' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!cancel_border_type' => '']
			),
			'billing_cancelbt_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-cancel-address-form' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
			),
			'cancel_btn_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-cancel-address-form' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
			'cancel_btn_display' => array(
				'type' => 'select',
				'label' => __('Display'),
				'screen' => 1,
				'default' => '',
				'css' => ['{{element}} .kkart-cancel-address-form' => 'display:{{val}}'],
				'list' => array(
					'' => __('Full'),
					'inline-block' => __('Inline'),
				),
			),
			'cancel_btn_width' => array(
				'type' => 'slider',
				'label' => __('Width'),
				'min' => 1,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} .kkart-cancel-address-form' => 'width:{{val}}%'],
			),
			
		),
		'address_block' => array(
			'address_block_colors' => array(
				'type' => 'radio',
				'label' => __('Address Block Color'),
				'list' => array(
					'' => __('Normal'),
					'active' => __('Active')
				)
			),
			'address_block_color' =>array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-address-details' => 'color:{{val}}'],
				'show' => [ 'address_block_colors' => '']
			),
			'address_block_bgcolor' =>array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-address-details' => 'background-color:{{val}}'],
				'show' => [ 'address_block_colors' => '']
			),
			'active_block_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} .kkart-active-address-details' => 'color:{{val}}'],
				'show' => [ 'address_block_colors' => 'active']
			),
			'active_block_bgcolor' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [ '{{element}} .kkart-active-address-details' => 'background-color:{{val}}'],
				'show' => [ 'address_block_colors' => 'active']
			)
		),
		'styles' => array(
			'proceed_button' => __('Proceed Button'),
			'edit_button' => __('Edit Button'),
			'billing_here_button' => __('Billing Here Button'),
			'billing_edit_button' => __('Billing Edit Button'),
			'delete_button' => __('Billing Delete Button'),
			'add_address' => __('Add Address Text'),
			'form_save_button' => __('Save Button'),
			'form_cancel_button' => __('Cancel Button'),
			'address_block' => __('Address Block')
		)
	)
);

// Order information
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_order_info',array(
		'name' => __('Order Info'),
		'group' => 'kkart received',
		'func' => 'kkart_sc_order_info',
		'html' => '<div class="kkart-order-info-holder">
			<div if="{{show_failed}}" class="kkart-order-failed-holder">{{failed_text}}</div>
			<div if="{{show_info}}" class="kkart-order-info-holder">{{info_text}}</div>
			<div if="{{show_not_found}}" class="kkart-order-not-found-holder">{{order_not_found_txt}}</div>
		</div>',
		'params' => array(
			'editor_view' => array(
				'type' => 'select', 
				'label' => __('Order views on editor'), 
				'list' => array(
					'' => __('Order info'),
					'failed' => __('Order failed'),
					'not_found' => __('Order not Found'),
				),
			),
			'info_text' => array(
				'type' => 'textarea', 
				'label' => __('Order Success Text'), 
				'default' => '<p><strong>Thank you. Your order has been received.</strong></p>
				<p>Order number : <strong>$order_number</strong></p>
				<p>Date : <strong>$order_date</strong></p>
				<p>Email : <strong>$billing_email</strong></p>
				<p>Total : <strong>$order_total</strong></p>
				<p if="$payment_method">Payment method : <strong>$payment_method</strong></p>', 
				'desc' => 'You can use the varibles - $order_number, $order_date, $billing_email, $order_total, $payment_method. and also you can use [if] attribute like(if="$payment_method") to skip empty variable holders',
			),
			'align' => array(
				'type' => 'radio', 
				'label' => __('alignment'), 
				'default' => 'left', 
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				),
				'css' => ['{{element}} .kkart-order-info-holder' => 'text-align:{{val}}']
			),
			'color' => array(
				'type' => 'color', 
				'label' => __('color'), 
				'css' => ['{{element}} .kkart-order-info-holder *' => 'color:{{val}}']
			),
			'typography' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-order-info-holder' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				]
			),
		),
		'order_failed' => array(
			'failed_text' => array(
				'type' => 'textarea', 
				'label' => __('Order Failed Text'), 
				'default' => '<p>Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.</p>', 
			),
			'failed_color' => array(
				'type' => 'color', 
				'label' => __('color'), 
				'css' => ['{{element}} .kkart-order-info-holder .kkart-order-failed-holder *' => 'color:{{val}}']
			),
			'failed_typography' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-order-info-holder .kkart-order-failed-holder' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				]
			),
			'failed_btns' => array(
				'type' => 'radio', 
				'label' => __('buttons'), 
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				)
			),
			'failed_btn_color' => array(
				'type' => 'color', 
				'label' => __('color'), 
				'css' => ['{{element}} .kkart-order-failed-holder .button' => 'color:{{val}}'],
				'show' => ['failed_btns' => '']
			),
			'failed_btn_bgcolor' => array(
				'type' => 'color', 
				'label' => __('bgcolor'), 
				'css' => ['{{element}} .kkart-order-failed-holder .button' => 'background-color:{{val}}'],
				'show' => ['failed_btns' => '']
			),
			'failed_btn_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-order-failed-holder .button' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				],
				'show' => ['failed_btns' => '']
			),
			'failed_btn_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .kkart-order-failed-holder .button' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => ['failed_btns' => '']
			),
			'failed_btn_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-order-failed-holder .button' => 'border-color: {{val}};'],
				'req' => ['!failed_btn_border_type' => ''],
				'show' => ['failed_btns' => '']
			),
			'failed_btn_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-order-failed-holder .button' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!failed_btn_border_type' => ''],
				'show' => ['failed_btns' => '']
			),
			'failed_btn_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-order-failed-holder .button' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => ['!failed_btn_border_type' => ''],
				'show' => ['failed_btns' => '']
			),
			'failed_btn_color_hover' => array(
				'type' => 'color', 
				'label' => __('color'), 
				'css' => ['{{element}} .kkart-order-failed-holder .button:hover' => 'color:{{val}}'],
				'show' => ['failed_btns' => 'hover']
			),
			'failed_btn_bgcolor_hover' => array(
				'type' => 'color', 
				'label' => __('bgcolor'), 
				'css' => ['{{element}} .kkart-order-failed-holder .button:hover' => 'background-color:{{val}}'],
				'show' => ['failed_btns' => 'hover']
			),
			'failed_btn_typo_hover' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-order-failed-holder .button:hover' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				],
				'show' => ['failed_btns' => 'hover']
			),
			'failed_btn_border_type_hover' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} .kkart-order-failed-holder .button:hover' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => ['failed_btns' => 'hover']
			),
			'failed_btn_border_color_hover' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-order-failed-holder .button:hover' => 'border-color: {{val}};'],
				'req' => ['!failed_btn_border_type_hover' => ''],
				'show' => ['failed_btns' => 'hover']
			),
			'failed_btn_border_width_hover' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-order-failed-holder .button:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!failed_btn_border_type_hover' => ''],
				'show' => ['failed_btns' => 'hover']
			),
			'failed_btn_radius_hover' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-order-failed-holder .button:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => ['!failed_btn_border_type_hover' => ''],
				'show' => ['failed_btns' => 'hover']
			),
			'failed_btn_padding' => array(
				'type' => 'padding',
				'label' => __('Button Padding'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-order-failed-holder .button' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
			'failed_btn_space' => array(
				'type' => 'spinner',
				'label' => __('Button Spacing'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-order-failed-holder .button:first-child' => 'margin-right:{{val}}px'],
			),
		),
		'order_not_found' => array(
			'order_not_found_txt' => array(
				'type' => 'textarea', 
				'label' => __('Order Not Found'), 
				'default' => 'Unfortunately your order is not found. Please attempt your purchase again.', 
			),
			'not_found_color' => array(
				'type' => 'color', 
				'label' => __('color'), 
				'css' => ['{{element}} .kkart-order-info-holder .kkart-order-not-found-holder *' => 'color:{{val}}']
			),
			'not_found_typography' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-order-info-holder .kkart-order-not-found-holder' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				]
			),
		),
		'styles' => array(
			'order_failed' => __('Order failed'),
			'order_not_found' => __('Order not found'),
		),
	)
);

// Order Details
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_order_details',array(
		'name' => __('Order Details'),
		'group' => 'kkart received',
		'func' => 'kkart_sc_order_details',
		'html' => '<div class="kkart-order-details-holder">
			<div if="show_downloads" class="kkart-order-download-details">
				<div class="kkart-download-title">{{download_title}}</div>
				{{download_details}}
			</div>
			<div class="kkart-order-details">
				<div class="kkart-order-details-title">{{order_title}}</div>
				{{order_details}}
			</div>
		</div>',
		'params' => array(
			'order_title' => array(
				'type' => 'text',
				'label' => __('Order Title'),
				'default' => '<h2>Order details</h2>',
			),
			'order_title_color' => array(
				'type' => 'color', 
				'label' => __('Order color'), 
				'css' => ['{{element}} .kkart-order-details-title' => 'color:{{val}}']
			),
			'order_title_typography' => array(
				'type' => 'typography',
				'label' => __('Order typography'),
				'css' => [
					'{{element}} .kkart-order-details-title' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				]
			),
			'download_title' => array(
				'type' => 'text',
				'label' => __('Download Title'),
				'default' => '<h2>Downloads</h2>',
			),
			'download_title_color' => array(
				'type' => 'color', 
				'label' => __('Download color'), 
				'css' => ['{{element}} .kkart-order-details-title' => 'color:{{val}}']
			),
			'download_title_typography' => array(
				'type' => 'typography',
				'label' => __('Download typography'),
				'css' => [
					'{{element}} .kkart-order-details-title' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				]
			),
		),
	)
);

// Order Address
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_order_address',array(
		'name' => __('Order Address'),
		'group' => 'kkart received',
		'func' => 'kkart_sc_order_address',
		'html' => '<div class="kkart-order-address-holder">
			<div class="kkart-billing-details">
				<div class="kkart-billing-title">{{billing_title}}</div>
				{{billing_details}}
			</div>
			<div if="{{show_shipping}}" class="kkart-shipping-details">
				<div class="kkart-shipping-title">{{shipping_title}}</div>
				{{shipping_details}}
			</div>
		</div>',
		'params' => array(
			'billing_title' => array(
				'type' => 'text',
				'label' => __('Billing Title'),
				'default' => '<h2>Billing Address</h2>',
			),
			'shipping_title' => array(
				'type' => 'text',
				'label' => __('Shipping Title'),
				'default' => '<h2>Shipping Address</h2>',
			)
		),
	)
);

// Order pay
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_order_pay',array(
		'name' => __('Order Pay'),
		'group' => 'kkart Checkout',
		'icon' => 'fas fa-money-bill-alt',
		'func' => 'kkart_sc_order_pay',
		'html' => '<div class="kkart-order-pay-holder">
			{{messages}}
			<div if="{{show_login}}" class="kkart-order-pay-login">{{order_pay_login}}</div>
			<div if="{{show_pay_form}}" class="kkart-order-pay-form">{{order_pay_form}}</div>
			<div if="{{show_details}}" class="kkart-order-pay-details">{{order_pay_details}}</div>
		</div>',
		'params' => array(
			'pay_color' => array(
				'type' => 'color', 
				'label' => __('color'), 
				'css' => ['{{element}} .kkart-order-pay-holder *' => 'color:{{val}}']
			),
			'pay_typography' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-order-pay-holder' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				]
			),
		),
		'button_style' => array(
			'pay_btns' => array(
				'type' => 'radio', 
				'label' => __('buttons'), 
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				)
			),
			'pay_btn_color' => array(
				'type' => 'color', 
				'label' => __('color'), 
				'css' => ['{{element}} #place_order' => 'color:{{val}}'],
				'show' => ['pay_btns' => '']
			),
			'pay_btn_bgcolor' => array(
				'type' => 'color', 
				'label' => __('bgcolor'), 
				'css' => ['{{element}} #place_order' => 'background-color:{{val}}'],
				'show' => ['pay_btns' => '']
			),
			'pay_btn_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} #place_order' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				],
				'show' => ['pay_btns' => '']
			),
			'pay_btn_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} #place_order' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => ['pay_btns' => '']
			),
			'pay_btn_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} #place_order' => 'border-color: {{val}};'],
				'req' => ['!pay_btn_border_type' => ''],
				'show' => ['pay_btns' => '']
			),
			'pay_btn_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} #place_order' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!pay_btn_border_type' => ''],
				'show' => ['pay_btns' => '']
			),
			'pay_btn_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} #place_order' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => ['!pay_btn_border_type' => ''],
				'show' => ['pay_btns' => '']
			),
			'pay_btn_color_hover' => array(
				'type' => 'color', 
				'label' => __('color'), 
				'css' => ['{{element}} #place_order:hover' => 'color:{{val}}'],
				'show' => ['pay_btns' => 'hover']
			),
			'pay_btn_bgcolor_hover' => array(
				'type' => 'color', 
				'label' => __('bgcolor'), 
				'css' => ['{{element}} #place_order:hover' => 'background-color:{{val}}'],
				'show' => ['pay_btns' => 'hover']
			),
			'pay_btn_typo_hover' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} #place_order:hover' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
				],
				'show' => ['pay_btns' => 'hover']
			),
			'pay_btn_border_type_hover' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [ '{{element}} #place_order:hover' => 'border-style: {{val}};' ],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => ['pay_btns' => 'hover']
			),
			'pay_btn_border_color_hover' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} #place_order:hover' => 'border-color: {{val}};'],
				'req' => ['!pay_btn_border_type_hover' => ''],
				'show' => ['pay_btns' => 'hover']
			),
			'pay_btn_border_width_hover' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} #place_order:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!pay_btn_border_type_hover' => ''],
				'show' => ['pay_btns' => 'hover']
			),
			'pay_btn_radius_hover' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} #place_order:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => ['!pay_btn_border_type_hover' => ''],
				'show' => ['pay_btns' => 'hover']
			),
			'pay_btn_padding' => array(
				'type' => 'padding',
				'label' => __('Button Padding'),
				'screen' => 1,
				'css' => ['{{element}} #place_order' => 'padding-top: {{val[0]}}px; padding-right: {{val[1]}}px; padding-bottom: {{val[2]}}px; padding-left: {{val[3]}}px'],
			),
		),
		'styles' => array(
			'button_style' => __('Button Style'),
		)
	)
);

///////////////////////////////////
// Widget copied from pagelayer
///////////////////////////////////

// Product Rating
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_product_rating', array(
		'name' => __('Product Rating'),
		'group' => 'kkart',
		'use_inside' => ['pl_kkart_archive_item'],
		'html' => '<div class="kkart-product-rating">
				<div if="{{show_rating}}" class="pagelayer-stars-container" title="{{product_rating}}/5" pagelayer-stars-value="{{product_rating}}" pagelayer-stars-count="5"></div>
				<div if="{{show_review_count}}" class="kkart-review-link">
					<span if="{{show_review_brackets}}">(</span>
					<span if="{{product_review_count}}" class="count">{{product_review_count}}</span>
					<span if="{{count_text}}" class="kkart-count-text"> {{count_text}}</span>
					<span if="{{show_review_brackets}}">)</span>
				</div>
			</div>',
		'params' => array(
			'show_rating' => array(
				'type' => 'checkbox',
				'label' => __('Show Rating'),
				'default' => 'true',
			),
			'align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'css' => ['{{element}} .kkart-product-rating' => 'width:100%;text-align: {{val}}'],
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				),
			),
			'star_color' => array(
				'type' => 'color',
				'label' => __('Star Color'),
				'css' => ['{{element}} .pagelayer-stars-icon:before' => 'color: {{val}}'],
				'req' => ['!show_rating' => ''],
			),
			'star_emp_color' => array(
				'type' => 'color',
				'label' => __('Empty Star Color'),
				'css' => ['{{element}} .pagelayer-stars-container' => 'color: {{val}}'],
				'req' => ['!show_rating' => ''],
			),
			'star_size' => array(
				'type' => 'slider',
				'label' => __('Star Size'),
				'units' => [ 'px', 'em' ],
				'step' => 0.1,
				'css' => ['{{element}} .pagelayer-stars-container' => 'font-size:{{val}}'],
				'req' => ['!show_rating' => ''],
			),
			'space_between_stars' => array(
				'type' => 'slider',
				'label' => __('Space Between Stars'),
				'units' => [ 'px', 'em' ],
				'step' => 0.1,
				'css' => ['{{element}}  .pagelayer-stars-icon' => 'letter-spacing: {{val}}'],
				'req' => ['!show_rating' => ''],
			),
		),
		'review_count_style' => array(
			'show_review_count' => array(
				'type' => 'checkbox',
				'label' => __('Show Review Count'),
				'default' => 'true',
			),
			'count_text' => array(
				'type' => 'text',
				'label' => __('Count Text'),
				'np' => 1,
				'default' => 'customer review',
				'edit' => '.kkart-count-text',
				'req' => ['!show_review_count' => ''],
			),
			'review_link_color' => array(
				'type' => 'color',
				'label' => __('Link Color'),
				'css' => ['{{element}} .kkart-review-link' => 'color: {{val}}'],
				'req' => ['!show_review_count' => ''],
			),
			'typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => ['{{element}} .kkart-review-link' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
				'req' => ['!show_review_count' => ''],
			),
			'show_review_brackets' => array(
				'type' => 'checkbox',
				'label' => __('Show Review Brackets'),
				'default' => 'true',
			),
			'space_between' => array(
				'type' => 'slider',
				'label' => __('Space Between'),
				'units' => [ 'px', 'em' ],
				'step' => 1,
				'css' => ['{{element}}  .kkart-review-link' => 'margin-left
				: {{val}}'],
				'req' => ['!show_review_count' => ''],
			),
		),
		'styles' =>[
			'review_count_style' => __('Review Count Style'),
		],
	)
);

// Product Meta
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_meta', array(
		'name' => __('Product meta'),
		'icon' => 'fa fa-info',
		'group' => 'kkart',
		'edit_props' => ['.sku_value' => '_sku'],
		'html' => '<div class="kkart-product-meta kkart-meta-{{display}}"> 
				<span class="sku_wrapper" if="{{sku_value}}"><span class="sku_label" if="{{sku_label}}">{{sku_label}}: </span><span class="sku_value">{{sku_value}}</span></span>
				<span class="posted_in" if="{{category_value}}">{{category_label}}{{category_value}}</span>
				<span class="tagged_as" if="{{tag_value}}">{{tag_label}}{{tag_value}}</span>
			</div>',
		'params' => array(
			'sku_label' => array(
				'type' => 'text',
				'label' => __('SKU label'),
				'default' => 'SKU',
				'edit' => '.sku_label',
			),
			'align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'css' => ['{{element}} .kkart-product-meta' => 'text-align: {{val}}'],
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				),
			),
			'display' => array(
				'type' => 'radio',
				'label' => __('Display'),
				'css' => ['{{element}} .kkart-product-meta > span' => 'display: {{val}}'],
				'list' => array(
					'inline-block' => __('Inline Block'),
					'block' => __('Block'),
				),
			),
			'space_between' => array(
				'type' => 'slider',
				'label' => __('Space Between'),
				'step' => 0.1,
				'css' => [
					'{{element}} .kkart-product-meta:not(.kkart-meta-block) > span:not(:first-child)' => 'margin-left: {{val}}px',
					'{{element}} .kkart-product-meta.kkart-meta-block > span:not(:last-child)' => 'margin-bottom: {{val}}px',
				],
			),
			
			'meta_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-product-meta span' => 'color: {{val}}'],
			),
			'typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => ['{{element}} .kkart-product-meta span' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
			),
			'link_color' => array(
				'type' => 'color',
				'label' => __('Link Color'),
				'css' => ['{{element}} .kkart-product-meta a' => 'color: {{val}}'],
			),
			'linl_typo' => array(
				'type' => 'typography',
				'label' => __('Link typography'),
				'css' => ['{{element}} .kkart-product-meta a' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
			),
			
		),
	)
);

// Product short description
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_short_desc', array(
		'name' => __('Product Short Description'),
		'icon' => 'far fa-file-alt',
		'group' => 'kkart',
		'edit_props' => ['.kkart-short-desc' => 'post_excerpt'],
		'html' => '<div class="kkart-short-desc">{{product_short_desc}}</div>',
		'params' => array(
			'align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'css' => ['{{element}} .kkart-short-desc' => 'text-align: {{val}}'],
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				),
			),
			'meta_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-short-desc' => 'color: {{val}}'],
			),
			'typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => ['{{element}} .kkart-short-desc' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
			),			
		),
	)
);

// Products style
$products_style = array(
	'column_gap' => array(
		'type' => 'slider',
		'label' => __('Column Gap'),
		'units' => ['px', '%'],
		'screen' => 1,
		'default' => 20,
		'step' => 0.2,
		'max' => 100,
		'css' => ['{{element}} ul.products li.product' => 'margin-right: {{val}}'],
	),
	'row_gap' => array(
		'type' => 'slider',
		'label' => __('Row Gap'),
		'units' => ['px', '%'],
		'screen' => 1,
		'default' => 20,
		'step' => 0.2,
		'max' => 100,
		'css' => ['{{element}} ul.products li.product' => 'margin-bottom: {{val}}'],
	),
	'align' => array(
		'type' => 'radio',
		'label' => __('Alignment'),
		'list' => array(
			'left' => __('Left'),
			'center' => __('Center'),
			'right' => __('Right'),
		),
		'addAttr' => ['{{element}} .pagelayer-product-related-container' => 'pagelayer-content-align="{{align}}"'],
		'css' => ['{{element}} ul.products li.product' => 'text-align:{{val}}'],
	),
	'img_lable' => array(
		'type' => 'heading',
		'label' => __('Image'),
	),
	'img_border_type' => array(
		'type' => 'select',
		'label' => __('Border Type'),
		'css' => ['{{element}} .attachment-kkart_thumbnail' => 'border-style: {{val}}',
		],
		'list' => [
			'' => __('None'),
			'solid' => __('Solid'),
			'double' => __('Double'),
			'dotted' => __('Dotted'),
			'dashed' => __('Dashed'),
			'groove' => __('Groove'),
		],
	),
	'img_border_width' => array(
		'type' => 'padding',
		'label' => __('Border Width'),
		'screen' => 1,
		'css' => ['{{element}} .attachment-kkart_thumbnail' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'
		],
		'req' => [
			'!img_border_type' => ''
		],
	),
	'img_border_color_hover' => array(
		'type' => 'color',
		'label' => __('Color'),
		'css' => ['{{element}} .attachment-kkart_thumbnail' => 'border-color: {{val}}'],
		'show' => ['img_border_type' => ''],
	),
	'img_border_radius' => array(
		'type' => 'padding',
		'label' => __('Border Radius'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => ['{{element}} .attachment-kkart_thumbnail' => 'border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}}; -webkit-border-radius:  {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};-moz-border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};',
		],
	),
	'img_spacing' => array(
		'type' => 'slider',
		'label' => __('Spacing'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => ['{{element}} .attachment-kkart_thumbnail' => 'margin-bottom: {{val}}'],
	),
	'title_lable' => array(
		'type' => 'heading',
		'label' => __('Title'),
	),
	'title_color' => array(
		'type' => 'color',
		'label' => __('Color'),
		'css' => [
			'{{element}} ul.products li.product .kkart-loop-product__title' => 'color: {{val}}', 
			'{{element}} ul.products li.product .kkart-loop-category__title' => 'color: {{val}}' 
		],
	),
	'title_typo' => array(
		'type' => 'typography',
		'label' => __('Typography'),
		'css' => [
			'{{element}}  ul.products li.product .kkart-loop-product__title' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
			'{{element}}  ul.products li.product .kkart-loop-category__title' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
		],
	),
	'title_spacing' => array(
		'type' => 'slider',
		'label' => __('Spacing'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => [
			'{{element}} ul.products li.product .kkart-loop-product__title' => 'margin-bottom: {{val}}', 
			'{{element}} ul.products li.product .kkart-loop-category__title' => 'margin-bottom: {{val}}' 
		],
	),
	'rating_lable' => array(
		'type' => 'heading',
		'label' => __('Stars Rating'),
	),
	'star_color' => array(
		'type' => 'color',
		'label' => __('Star Color'),
		'css' => ['{{element}} ul.products li.product .star-rating' => 'color: {{val}}'],
	),
	'empty_star_color' => array(
		'type' => 'color',
		'label' => __('Empty Star Color'),
		'css' => ['{{element}} ul.products li.product .star-rating::before' => 'color: {{val}}'],
	),
	'star_size' => array(
		'type' => 'slider',
		'label' => __('Star Size'),
		'max' => 5,
		'step' => 0.1,
		'css' => ['{{element}} ul.products li.product .star-rating' => 'font-size: {{val}}em'],
	),
	'star_spacing' => array(
		'type' => 'slider',
		'label' => __('Spacing'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => ['{{element}} ul.products li.product .star-rating' => 'margin-bottom: {{val}}'],
	),
	'price_lable' => array(
		'type' => 'heading',
		'label' => __('Price Style'),
	),
	'price_color' => array(
		'type' => 'color',
		'label' => __('Color'),
		'css' => [
			'{{element}} ul.products li.product .price' => 'color: {{val}}',
			'{{element}} ul.products li.product .price ins' => 'color: {{val}}',
			'{{element}} ul.products li.product .price ins .amount' => 'color: {{val}}',
		],
	),
	'price_typo' => array(
		'type' => 'typography',
		'label' => __('Typography'),
		'css' => ['{{element}} ul.products li.product .price' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
	),
	'reg_price_lable' => array(
		'type' => 'heading',
		'label' => __('Regular Price'),
	),
	'reg_price_color' => array(
		'type' => 'color',
		'label' => __('Color'),
		'css' => [
			'{{element}} ul.products li.product .price del .amount' => 'color:{{val}}',
			'{{element}} ul.products li.product .price del' => 'color:{{val}}'
		]
	),
	'reg_price_typo' => array(
		'type' => 'typography',
		'label' => __('Typography'),
		'css' => [
			'{{element}} ul.products li.product .price del .amount' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;',
			'{{element}} ul.products li.product .price del' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
		],
	),
	'button_lable' => array(
		'type' => 'heading',
		'label' => __('Button'),
	),
	'button_colors'=> array(
		'type' => 'radio',
		'label' => '',
		'list' => array(
			'' => __('Normal'),
			'hover' => __('Hover'),
		),
	),
	'btn_color'=> array(
		'type' => 'color',
		'label' => __('Color'),
		'css' => ['{{element}} ul.products li.product .button' => 'color:{{val}}'],
		'show' => [ 'button_colors' => '' ],
	),
	'btn_bg_color'=> array(
		'type' => 'color',
		'label' => __('Background Color'),
		'css' => ['{{element}} ul.products li.product .button' => 'background-color:{{val}}'],
		'show' => [ 'button_colors' => '' ],
	),
	'btn_border_color'=> array(
		'type' => 'color',
		'label' => __('Border Color'),
		'css' => ['{{element}} ul.products li.product .button' => 'border-color:{{val}}'],
		'show' => [ 'button_colors' => '' ],
	),
	'btn_hover_color'=> array(
		'type' => 'color',
		'label' => __('Color'),
		'css' => ['{{element}} ul.products li.product .button:hover' => 'color:{{val}}'],
		'show' => [ 'button_colors' => 'hover' ],
	),
	'btn_bg_hover_color'=> array(
		'type' => 'color',
		'label' => __('Background Color'),
		'css' => ['{{element}} ul.products li.product .button:hover' => 'background-color:{{val}}'],
		'show' => [ 'button_colors' => 'hover' ],
	),
	'btn_border_hover_color'=> array(
		'type' => 'color',
		'label' => __('Border Color'),
		'css' => ['{{element}} ul.products li.product .button:hover' => 'border-color:{{val}}'],
		'show' => [ 'button_colors' => 'hover' ],
	),
	'btnb_typo' => array(
		'type' => 'typography',
		'label' => __('Typography'),
		'css' => ['{{element}} ul.products li.product .button' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
	),
	'btn_border_type' => array(
		'type' => 'select',
		'label' => __('Border Type'),
		'css' => ['{{element}} ul.products li.product .button' => 'border-style: {{val}}',
		],
		'list' => [
			'' => __('None'),
			'solid' => __('Solid'),
			'double' => __('Double'),
			'dotted' => __('Dotted'),
			'dashed' => __('Dashed'),
			'groove' => __('Groove'),
		],
	),
	'btn_border_width' => array(
		'type' => 'padding',
		'label' => __('Border Width'),
		'screen' => 1,
		'css' => ['{{element}} ul.products li.product .button' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px',
		],
		'req' => [
			'!btn_border_type' => ''
		],
	),
	'btn_border_radius' => array(
		'type' => 'padding',
		'label' => __('Border Radius'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => ['{{element}} ul.products li.product .button' => 'border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}}; -webkit-border-radius:  {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};-moz-border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};',
		],
	),
	'btn_text_padding' => array(
		'type' => 'padding',
		'label' => __('Padding'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => ['{{element}} ul.products li.product .button' => 'padding: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}}; -webkit-border-radius:  {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};-moz-border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};',
		],
	),
	'btn_spacing' => array(
		'type' => 'slider',
		'label' => __('Spacing'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => ['{{element}} ul.products li.product .button' => 'margin-top:{{val}}'],
	),			
	'view_cart_lable' => array(
		'type' => 'heading',
		'label' => __('View Cart'),
	),
	'view_cart_color' => array(
		'type' => 'color',
		'label' => __('Color'),
		'css' => ['{{element}} .kkart-view-btn' => 'color: {{val}}'],
	),
	'view_cart_typo' => array(
		'type' => 'typography',
		'label' => __('Typography'),
		'css' => ['{{element}} .kkart-view-btn' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
	),
);

// Products heading style
$products_heading = array(
	'heading_show'=> array(
		'type' => 'checkbox',
		'label' => __('Heading Style'),
		'default' => 'true',
		'addAttr' => ['{{element}} .pagelayer-product-related-container' => 'pagelayer-heading-show="{{heading_show}}"'],
	),
	'heading_color'=> array(
		'type' => 'color',
		'label' => __('Color'),
		'css' => ['{{element}} .products > h2' => 'color: {{val}}'],
		'req' => ['heading_show' => 'true'],
	),
	'heading_typo' => array(
		'type' => 'typography',
		'label' => __('Typography'),
		'css' => ['{{element}} .products > h2' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
		'req' => ['heading_show' => 'true'],
	),
	'heading_align'=> array(
		'type' => 'radio',
		'label' => __('Alignment'),
		'list' => array(
			'left' => __('Left'),
			'center' => __('Center'),
			'right' => __('Right'),
		),
		'css' => ['{{element}} .products > h2' => 'text-align: {{val}}'],
		'req' => ['heading_show' => 'true'],
	),
	'heading_spacing' => array(
		'type' => 'slider',
		'label' => __('Spacing'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => ['{{element}} .products > h2' => 'margin-bottom: {{val}}'],
		'req' => ['heading_show' => 'true'],
	),	
);

// Products box style
$products_box = array(
	'box_border_type' => array(
		'type' => 'select',
		'label' => __('Border Type'),
		'css' => ['{{element}} ul.products li.product' => 'border-style: {{val}}',
		],
		'list' => [
			'' => __('None'),
			'solid' => __('Solid'),
			'double' => __('Double'),
			'dotted' => __('Dotted'),
			'dashed' => __('Dashed'),
			'groove' => __('Groove'),
		],
	),
	'box_border_width' => array(
		'type' => 'padding',
		'label' => __('Border Width'),
		'screen' => 1,
		'css' => ['{{element}} ul.products li.product' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px',
		],
		'req' => [
			'!box_border_type' => ''
		],
	),
	'box_border_radius' => array(
		'type' => 'padding',
		'label' => __('Border Radius'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => ['{{element}} ul.products li.product' => 'border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}}; -webkit-border-radius:  {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};-moz-border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};',
		],
	),
	'box_padding' => array(
		'type' => 'padding',
		'label' => __('Padding'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => ['{{element}} ul.products li.product' => 'border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}}; -webkit-border-radius:  {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};-moz-border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};',
		],
	),
	'box_colors' => array(
		'type' => 'radio',
		'label' => '',
		'list' => array(
			'' => __('Normal'),
			'hover' => __('Hover'),
		),
	),
	'box_bg_color' => array(
		'type' => 'color',
		'label' => __('Background Color'),
		'css' => ['{{element}} ul.products li.product' => 'background-color: {{val}}'],
		'show' => ['box_colors' => ''],
	),
	'box_border_color' => array(
		'type' => 'color',
		'label' => __('Border Color'),
		'css' => ['{{element}} ul.products li.product' => 'border-color: {{val}}'],
		'show' => ['box_colors' => ''],
	),
	'box_shadow' => [
		'type' => 'box_shadow',
		'label' => __('Shadow'),
		'css' => ['{{element}} ul.products li.product' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}} !important;'],
		'show' => ['box_colors' => ''],
	],
	'box_bg_hover_color' => array(
		'type' => 'color',
		'label' => __('Background Color'),
		'css' => ['{{element}} ul.products li.product:hover' => 'background-color: {{val}}'],
		'show' => ['box_colors' => 'hover'],
	),
	'box_border_hover_color' => array(
		'type' => 'color',
		'label' => __('Border Color'),
		'css' => ['{{element}} ul.products li.product:hover' => 'border-color: {{val}}'],
		'show' => ['box_colors' => 'hover'],
	),
	'box_hover_shadow' => [
		'type' => 'box_shadow',
		'label' => __('Shadow'),
		'css' => ['{{element}} ul.products li.product:hover' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}} !important;'],
		'show' => ['box_colors' => 'hover'],
	],
);

// Products sale flash style
$products_sale_flash = array(
	'sale_flash' => array(
		'type' => 'checkbox',
		'label' => __('Sale Flash'),
		'default' => 'true', 
		'addAttr' => ['{{element}} .pagelayer-product-related-container' => 'pagelayer-sale-flash="{{sale_flash}}"'],
	),
	'flash_color' => array(
		'type' => 'color',
		'label' => __('Color'),
		'css' => ['{{element}} ul.products li.product span.onsale' => 'color: {{val}}'],
		'req' => [ 'sale_flash' => 'true'],
	),
	'flash_bg_color' => array(
		'type' => 'color',
		'label' => __('Background Color'),
		'css' => ['{{element}} ul.products li.product span.onsale' => 'background-color: {{val}}'],
		'req' => [ 'sale_flash' => 'true'],
	),
	'flash_typo' => array(
		'type' => 'typography',
		'label' => __('Typography'),
		'css' => ['{{element}} ul.products li.product span.onsale' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
		'req' => [ 'sale_flash' => 'true'],
	),
	'flash_border_radius' => array(
		'type' => 'padding',
		'label' => __('Border Radius'),
		'units' => [ 'px', '%' ],
		'screen' => 1,
		'css' => ['{{element}} .ul.products li.product span.onsale' => 'border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}}; -webkit-border-radius:  {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};-moz-border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};',
		],
		'req' => [ 'sale_flash' => 'true'],
	),
	'flash_width' => array(
		'type' => 'slider',
		'label' => __('Width'),
		'units' => [ 'px', '%' ],
		'css' => ['{{element}} ul.products li.product span.onsale' => 'min-width: {{val}};'],
		'req' => [ 'sale_flash' => 'true'],
	),
	'flash_height' => array(
		'type' => 'slider',
		'label' => __('Height'),
		'units' => [ 'px', '%' ],
		'css' => ['{{element}} ul.products li.product span.onsale' => 'min-height: {{val}}; line-height: {{val}};'],
		'req' => [ 'sale_flash' => 'true'],
	),
	'flash_distance' => array(
		'type' => 'slider',
		'label' => __('Distance'),
		'units' => [ 'px', '%' ],
		'max' => 20,
		'css' => ['{{element}} ul.products li.product span.onsale' => 'margin: {{val}};'],
		'req' => [ 'sale_flash' => 'true'],
	),
	'flash_position' => array(
		'type' => 'radio',
		'label' => __('Position'),
		'list' => array(
			'left' => __('Left'),
			'right' => __('Right'),
		),
		'css' => ['{{element}} ul.products li.product span.onsale' => 'left:auto; right:auto; {{val}} : 0;'],
		'req' => [ 'sale_flash' => 'true'],
	),
);

// TODO: create this form scretch
// Product related
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_product_related', array(
		'name' => __('Related Upsell Products'),
		'group' => 'kkart',
		'not_visible' => 1,
		'html' => '<div class="pagelayer-product-related-container">
			{{related_products}}
		</div>',
		'params' => array(
			'select_product' => array(
				'type' => 'select',
				'label' => __('Product Type'),
				'default' => 'related',
				'list' => array(
					'related' => __('Related'),
					'upsell' => __('Upsell'),
				),
			),
			'posts_per_page' => array(
				'type' => 'spinner',
				'label' => __('Products Per Page'),
				'default' => 4,
				'max' => 20,
				'req' => ['select_product' => 'related'],
			),
			'columns' => array(
				'type' => 'spinner',
				'label' => __('Columns'),
				'screen' => 1,
				'default' => 4,
				'min' => 1,
				'max' => 12,
			),		
			'order_by' => array(
				'type' => 'select',
				'label' => __('Order By'),
				'default' => 'date',
				'list' => array(
					'date' => __('Date'),
					'title' => __('Title'),
					'price' => __('Price'),
					'popularity' => __('Popularity'),
					'rating' => __('Rating'),
					'rand' => __('Random'),
					'menu_order' => __('Menu Order'),
				),
			),
			'order' => array(
				'type' => 'select',
				'label' => __('Order'),
				'default' => 'asc',
				'list' => array(
					'asc' => __('ASC'),
					'desc' => __('DESC'),
				),
			),
		),
		'products_style' => $products_style,
		'heading_style' => $products_heading,
		'box_style' => $products_box,
		'sale_flash_style' => $products_sale_flash,
		'styles' =>[
			'products_style' => __('Products Style'),
			'heading_style' => __('Heading Styles'),
			'box_style' => __('Box Style'),
			'sale_flash_style' => __('Flash Sale Style'),
		],
	)
);

// kkart breadcrumb
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_breadcrumb', array(
		'name' => __('Kkart Breadcrumb'),
		'group' => 'kkart',
		'html' => '<div class="pagelayer-woo-breadcrumb-container">'. kkart_sc_breadcrumb() .'</div>',
		'params' => array(
			'color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-breadcrumb' => 'color:{{val}}'],
 			),
			'link_color' => array(
				'type' => 'color',
				'label' => __('Link Color'),
				'css' => ['{{element}} .kkart-breadcrumb > a' => 'color:{{val}}'],
 			),
			'typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => ['{{element}} .kkart-breadcrumb' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
			),
			'align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'css' => ['{{element}} .kkart-breadcrumb' => 'text-align:{{val}}'],
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				),
 			),
		),
	)
);

// Product pages
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_pages', array(
		'name' => __('kkart pages'),
		'group' => 'kkart',
		'html' => '<div class="pagelayer-product-pages-container">{{page_content}}</div>',
		'params' => array(
			'pages' => array(
				'type' => 'select',
				'label' => __('Pages'),
				'css' => ['{{element}} .kkart-breadcrumb' => 'color:{{val}}'],
				'list' => array(
					'' => __( 'Select' ),
					'kkart_cart' => __('Cart Page'),
					//'product_page' => __('Single Product Page'),
					'kkart_checkout' => __('Checkout Page'),
					'kkart_order_tracking' => __('Order Tracking Form'),
					'kkart_my_account' => __('My Account'),
				),
 			),
		),
	)
);

// TODO: create this form scretch
// Product pages
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_product_categories', array(
		'name' => __('Product Categories'),
		'group' => 'kkart',
		'html' => '<div class="pagelayer-product-categories-container">{{product_categories}}</div>',
		'params' => array(
			'columns' => array(
				'type' => 'spinner',
				'label' => __('Columns'),
				'screen' => 1,
				'default' => 4,
				'max' => 12,
			),
			'number' => array(
				'type' => 'spinner',
				'label' => __('Limit'),
				'default' => 4,
			),
			'source' => array(
				'type' => 'select',
				'label' => __('Source'),
				'list' => array(
					'' => __('Show All'),
					'by_id' => __('Manual Selection'),
					'by_parent' => __('By Parent'),
					'current_subcategories' => __('Current Sub-Categories'),
				),
			),
			'by_id' => array(
				'type' => 'multiselect',
				'label' => __('Categories'),
				'list' => kkart_get_product_cat(),
				'req' => ['source' => 'by_id'],
			),
			'parent' => array(
				'type' => 'select',
				'label' => __('Parent'),
				'list' => [ '0' => __('Only Top Level') ] + kkart_get_product_cat(),
				'req' => ['source' => 'by_parent'],
			),
			'hide_empty' => array(
				'type' => 'checkbox',
				'label' => __('Hide Empty'),
			),
			'orderby' => array(
				'type' => 'select',
				'label' => __('Order By'),
				'default' => 'name',
				'list' => array(
					'name' => __('Name'),
					'slug' => __('Slug'),
					'description' => __('Description'),
					'count' => __('Count'),
				),
			),
			'order' => array(
				'type' => 'select',
				'label' => __('Order'),
				'default' => 'desc',
				'list' => array(
					'asc' => __('ASC'),
					'desc' => __('DESC'),
				),
			),
		),
		'products_style' => array(
			'column_gap' => array(
				'type' => 'slider',
				'label' => __('Column Gap'),
				'units' => ['px', '%'],
				'screen' => 1,
				'default' => 20,
				'step' => 0.2,
				'max' => 100,
				'css' => ['{{element}} ul.products li.product' => 'margin-right: {{val}}'],
			),
			'row_gap' => array(
				'type' => 'slider',
				'label' => __('Row Gap'),
				'units' => ['px', '%'],
				'screen' => 1,
				'default' => 20,
				'step' => 0.2,
				'max' => 100,
				'css' => ['{{element}} ul.products li.product' => 'margin-bottom: {{val}}'],
			),
			'align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				),
				'css' => ['{{element}} ul.products li.product' => 'text-align:{{val}}'],
			),
			'img_lable' => array(
				'type' => 'heading',
				'label' => __('Image'),
			),
			'img_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => ['{{element}} a > img' => 'border-style: {{val}}',
				],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'img_border_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} a > img' => 'border-color: {{val}}'],
				'show' => ['!img_border_type' => ''],
			),
			'img_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} a > img' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'
				],
				'req' => [
					'!img_border_type' => ''
				],
			),
			'img_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'units' => [ 'px', '%' ],
				'screen' => 1,
				'css' => ['{{element}} a > img' => 'border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}}; -webkit-border-radius:  {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};-moz-border-radius: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};',
				],
			),
			'img_spacing' => array(
				'type' => 'slider',
				'label' => __('Spacing'),
				'units' => [ 'px', '%' ],
				'screen' => 1,
				'css' => ['{{element}} a > img' => 'margin-bottom: {{val}}'],
			),
			'title_lable' => array(
				'type' => 'heading',
				'label' => __('Title'),
			),
			'title_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-loop-category__title' => 'color: {{val}}'],
			),
			'title_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-loop-category__title' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'title_spacing' => array(
				'type' => 'slider',
				'label' => __('Spacing'),
				'units' => [ 'px', '%' ],
				'screen' => 1,
				'css' => [
					'{{element}} .kkart-loop-category__title' => 'margin-bottom: {{val}}' 
				],
			),
			'count_lable' => array(
				'type' => 'heading',
				'label' => __('Count'),
			),
			'count_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-loop-category__title .count' => 'color: {{val}}'],
			),
			'count_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-loop-category__title .count' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
		),
		'styles' =>[
			'products_style' => __('Products Style'),
		],
	)
);

// Archives Product
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_product_archives', array(
		'name' => __('Product Archives'),
		'group' => 'kkart archive',
		'has_group' => [
			'section' => 'params', 
			'prop' => 'elements',
			'loop' => 1,
		],
		'holder' => '.kkart-porduct-archives',
		'html' => '<div class="kkart-porduct-archives"></div>',
		'params' => array(
			'elements' => array(
				'type' => 'group',
				'label' => __('Items'),
				'sc' => PAGELAYER_SC_PREFIX.'_kkart_archive_item',
				'count' => 1,
				'item_label' => array(
					'default' => __('Items'),
				),
				'hide' => 1,
			),
			'cols' => array(
				'type' => 'select',
				'label' => __('Cols'),
				'screen' => 1,
				'list' => array(
					'' => __('Default'),
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
					'7' => '7',
					'8' => '8',
					'9' => '9',
					'10' => '10',
					'11' => '11',
					'12' => '12',
				),
				'css' => ['{{element}} .kkart-porduct-archives' => 'grid-template-columns: repeat({{val}}, 1fr);'],
 			),
			'allow_order' => array(
				'type' => 'checkbox',
				'label' => __('Allow Order'),
				'default' => 'true',
 			),
			'show_result' => array(
				'type' => 'checkbox',
				'label' => __('Show Result Counter'),
				'default' => 'true',
 			),
			'no_found' => array(
				'type' => 'textarea',
				'label' => __('Not Found Message'),
				'default' => __('Products not found.'),
 			),
		),
		'pagination_style' => array(
			'pagination_spacing' => array(
				'type' => 'slider',
				'label' => __('Spacing'),
				'css' => ['{{element}} nav.kkart-pagination' => 'margin-top:{{val}}px'],
 			),
			'pagination_border' => array(
				'type' => 'select',
				'label' => __('Border'),
				'list' => array(
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				),
				'css' => ['{{element}} nav.kkart-pagination ul' => 'border-style: {{val}} !important'],
 			),
			'pagination_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} nav.kkart-pagination ul' => 'border-color:{{val}} !important'],
				'req' => ['!pagination_border' => '']
 			),
			'pagination_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'units' => [ 'px', '%' ],
				'screen' => 1,
				'css' => ['{{element}} nav.kkart-pagination ul' => 'border-radius:{{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}} !important'],
				'req' => ['!pagination_border' => '']
 			),
			'pagination_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Size'),
				'css' => ['{{element}} nav.kkart-pagination ul' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important;'],
				'req' => ['!pagination_border' => '']
 			),
			'pagination_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'units' => [ 'px', '%' ],
				'screen' => 1,
				'css' => ['{{element}} nav.kkart-pagination ul' => 'padding: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}}'],
 			),
			'pagination_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} nav.kkart-pagination' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'pagination_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} nav.kkart-pagination ul' => 'background-color:{{val}}']
			),
			'pagination_shadow' => array(
				'type' => 'box_shadow',
				'label' => __('Shadow'),
				'css' => ['{{element}} nav.kkart-pagination ul' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}};'],
			),
		),
		'pagination_link_style' => array( 
			'pagination_colors' => array(
				'type' => 'radio',
				'label' => __('Colors'),
				'list' => array(
					'normal' => __('Normal'),
					'hover' => __('Hover'),
					'active' => __('Active'),
				),
 			),
			'pagination_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} nav.kkart-pagination ul li a' => 'color:{{val}} !important;'],
				'show' => ['pagination_colors' => 'normal'],
 			),
			'pagination_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} nav.kkart-pagination ul li a' => 'background-color:{{val}} !important;'],
				'show' => ['pagination_colors' => 'normal'],
 			),
			'pagination_color_hover' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} nav.kkart-pagination ul li a:hover' => 'color:{{val}} !important;'],
				'show' => ['pagination_colors' => 'hover'],
 			),
			'pagination_bg_color_hover' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} nav.kkart-pagination ul li a:hover' => 'background-color:{{val}} !important;'],
				'show' => ['pagination_colors' => 'hover'],
 			),
			'pagination_color_active' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => [ '{{element}} nav.kkart-pagination ul li span.current' => 'color:{{val}} !important;' ],
				'show' => ['pagination_colors' => 'active'],
 			),
			'pagination_bg_color_active' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} nav.kkart-pagination ul li span.current' => 'background-color:{{val}} !important;'],
				'show' => ['pagination_colors' => 'active'],
 			),
			'pagination_link_border' => array(
				'type' => 'select',
				'label' => __('Border'),
				'list' => array(
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				),
				'css' => ['{{element}} nav.kkart-pagination ul li' => 'border-style: {{val}} !important'],
			),
			'pagination_link_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} nav.kkart-pagination ul li' => 'border-color:{{val}} !important'],
				'req' => ['!pagination_link_border' => '']
 			),
			'pagination_link_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'units' => [ 'px', '%' ],
				'screen' => 1,
				'css' => ['{{element}} nav.kkart-pagination ul li' => 'border-radius:{{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}} !important'],
				'req' => ['!pagination_link_border' => '']
 			),
			'pagination_link_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Size'),
				'css' => ['{{element}} nav.kkart-pagination ul li' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important;'],
				'req' => ['!pagination_link_border' => '']
 			),
			'space_between' => array(
				'type' => 'slider',
				'label' => __('Space Between'),
				'css' => ['{{element}} nav.kkart-pagination ul li:not(:last-child)' => 'margin-right:{{val}}px;'],
 			),
			'pagination_link_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'units' => [ 'px', '%' ],
				'screen' => 1,
				'css' => ['{{element}} nav.kkart-pagination ul li a, {{element}} nav.kkart-pagination ul li span' => 'padding: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}}'],
 			),
		),
		'styles' =>[
			'pagination_style' => __('Pagination Style'),
			'pagination_link_style' => __('Pagination Link Style')
		],
	)
);

// Archive Products items
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_archive_item', array(
		'name' => __('Product Archive Item'),
		'group' => 'kkart archive',
		'has_group' => [
			'section' => 'params', 
			'prop' => 'elements',
		],
		'not_visible' => 1,
		'widget_group' => 1,
		'holder' => '.kkart-product-archives-item',
		'html' => '<div class="kkart-product-archives-item"></div>',
		'params' => array(
			'elements' => array(
				'type' => 'group',
				'label' => __('Inner Row'),
				'sc' => PAGELAYER_SC_PREFIX.'_inner_row',
				'count' => 1,
				'item_label' => array(
					'default' => __('Inner Row'),
				),
				'inner_content' => [
					['pl_col' => [
						'inner_content' => [
							['pl_kkart_sale' => []],
							['pl_kkart_archive_thumb' => []],
							['pl_kkart_title' => ['atts' => ['link' => 'true']]],
							['pl_kkart_price' => []],
							['pl_kkart_product_rating' => []],
							['pl_kkart_archive_crt_btn' => ['atts' => ['ele_margin' => '5px,5px,0,0', 'ele_custom_pos' => 'true','ele_width' => 'initial']]],
							['pl_kkart_buy_now' => ['atts' => ['ele_margin' => '5px,5px,0,0', 'ele_custom_pos' => 'true', 'ele_width' => 'initial']]]
						]],
					]
				],
				'hide' => 1,
			),
		),
	)
);

// Archive Products thumbnail
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_archive_thumb', array(
		'name' => __('Product Archive Thumbnail'),
		'icon' => 'fas fa-archive',
		'group' => 'kkart archive',
		'use_inside' => ['pl_kkart_archive_item'],
		'html' => '<a class="kkart-thumb-link" if-ext="{{product_link}}" href="{{product_link}}"><div class="kkart-product-thumbnail">{{product_thumb}}</div></a>',
		'params' => array(
			'unlink' => array(
				'label' => __('Unlink to Product Page'),
				'type' => 'checkbox',
				'desc' => __('Image links to a single product. If you wish, you can unlink using this option!'),
			),
			'gallery' => array(
				'label' => __('Gallery'),
				'type' => 'checkbox',
				'addAttr' => ['{{element}} .kkart-thumbnail-gallery' => 'data-slides-items="1"'],
			),
			'slider_animation' => array(
				'type' => 'select',
				'label' => __('Animation In'),
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-animate-in="{{slider_animation}}"'],
				'list' => $pagelayer->anim_in_options,
				'req' => ['!gallery' => ''],
			),
			'slideout_anim' => array(
				'type' => 'select',
				'label' => __('Animation Out'),
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-animate-out="{{slideout_anim}}"'],
				'list' => $pagelayer->anim_out_options,
				'req' => ['!gallery' => ''],
			),
			'controls' => array(
				'type' => 'select',
				'label' => __('Slider Controls'),
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-controls="{{controls}}"'],
				'list' => array(
					'' => __('Arrows and Pager'),
					'arrows' => __('Arrows'),
					'pager' => __('Pager'),
					'none' => __('None'),
				),
				'req' => ['!gallery' => ''],
			),
			'pause' => array(
				'type' => 'slider',
				'label' => __('Slideshow Speed'),
				'default' => 5000,
				'min' => 200,
				'max' => 20000,
				'step' => 100,
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-autoplay-timeout="{{pause}}"'],
				'req' => ['!gallery' => ''],
			),
			'speed' => array(
				'type' => 'slider',
				'label' => __('Animation Speed(s)'),
				'addAttr' => ['.pagelayer-image-slider-ul' => 'data-slides-smart-speed="{{speed}}"'],
				'default' => 800,
				'min' => 200,
				'max' => 10000,
				'step' => 100,
				'req' => ['!gallery' => ''],
			),
			'loop' => array(
				'type' => 'checkbox',
				'label' => __('Loop'),
				'desc' => __('Loop images in slider'),
				'default' => 'true',
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-loop="{{loop}}"'],
				'req' => ['!gallery' => ''],
			),
			'adaptive_height' => array(
				'type' => 'checkbox',
				'label' => __('Slider Height'),
				'desc' => __('The slider height should change on the fly according to the current slide'),
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-auto-height="{{adaptive_height}}"'],
				'req' => ['!gallery' => ''],
			),
			'auto' => array(
				'type' => 'checkbox',
				'label' => __('Auto Start'),
				'desc' => __('Check to auto start slider'),
				'default' => 'true',
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-autoplay="{{auto}}"'],
				'req' => ['!gallery' => ''],
			),
			'auto_hover' => [
				'type' => 'checkbox',
				'label' => __('Pause on hover'),
				'desc' => __('If enabled, the slider will pause when you hover over the slider'),
				'default' => 'true',
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-autoplay-hover-pause="{{auto_hover}}"'],
				'req' => ['!gallery' => ''],
			],
		),
		'image_styles' => array(
			'box_heihgt' => array(
				'type' => 'slider',
				'label' => __('Image Box Height'),
				'min' => 0,
				'screen' => 1,
				'units' => ['px', 'em'],
				'css' => ['{{element}} .kkart-product-thumbnail' => 'height:{{val}} '],
			),
			'img_width' => array(
				'type' => 'slider',
				'label' => __('Image Width'),
				'min' => 0,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-thumbnail .kkart-thumb-img' => 'width:{{val}}%'],
			),
			'img_heihgt' => array(
				'type' => 'slider',
				'label' => __('Image Height'),
				'min' => 0,
				'screen' => 1,
				'units' => ['%', 'px'],
				'css' => ['{{element}} .kkart-product-thumbnail .kkart-thumb-img' => 'height:{{val}};object-fit:cover;'],
			),
			'img_align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'screen' => 1,
				'list' => array(
					'flex-start' => __('Left'),
					'center' => __('Center'),
					'flex-end' => __('Right'),
				),
				'css' => ['{{element}} .kkart-product-thumbnail' => 'justify-content:{{val}}'],
			),
			'img_align_vert' => array(
				'type' => 'radio',
				'label' => __('Vertical Align'),
				'screen' => 1,
				'list' => array(
					'flex-start' => __('Left'),
					'center' => __('Center'),
					'flex-end' => __('Right'),
				),
				'css' => ['{{element}} .kkart-product-thumbnail' => 'align-items:{{val}}'],
			),
		),
		'arrow_styles' => $pagelayer->slider_arrow_styles,
		'pager_styles' => $pagelayer->slider_pager_styles,
		'styles' => [
			'image_styles' => __('Image Styles'),
			'arrow_styles' => __('Arrow Styles'),
			'pager_styles' => __('Pager Styles'),
		],
	)
);

// Archive Products add to cart button
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_archive_crt_btn', array(
		'name' => __('Archive Add To Cart'),
		'group' => 'kkart archive',
		'use_inside' => ['pl_kkart_archive_item'],
		'html' => '<div class="kkart-crt-btn-holder">
				<a if="{{archive_crt_btn_text}}" href="{{archive_crt_btn_link}}" data-quantity="{{archive_crt_btn_qty}}" class="kkart-archive-crt-btn {{archive_crt_btn_class}} {{size}} {{btn_type}}" data-product_id="{{archive_crt_btn_id}}" data-product_sku="{{archive_crt_btn_sku}}" aria-label="{{archive_crt_btn_label}}">{{archive_crt_btn_text}}</a>
				
				<div class="kkart-quantity-holder" data-quantity="{{archive_crt_btn_qty}}" data-product_id="{{archive_crt_btn_id}}" data-product_sku="{{archive_crt_btn_sku}}" data-cart-key="{{cart_item_key}}" if="{{kkart_quantity_holder}}" >{{kkart_quantity_holder}}</div>
				
				<div class="kkart-view-btn-holder" if="{{kkart_view_cart}}">{{kkart_view_cart}}</div>
			</div>',
		'params' => array(
			'archive_crt_btn_text' => array(
				'type' => 'text',
				'label' => __('Button Text'),
				'default' => 'Add To Cart',
				'edit' => '.kkart-archive-crt-btn',
			),
			'typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => ['{{element}} .kkart-archive-crt-btn' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
			),
			'size' => array(
				'type' => 'select',
				'label' => __('Size'),
				'default' => 'pagelayer-btn-custom',
				'list' => array(
					'pagelayer-btn-mini' => __('Mini'),
					'pagelayer-btn-small' => __('Small'),
					'pagelayer-btn-large' => __('Large'),
					'pagelayer-btn-extra-large' => __('Extra Large'),
					'pagelayer-btn-double-large' => __('Double Large'),
					'pagelayer-btn-custom' => __('Custom'),
				),
			),
			'custom_size' => array(
				'type' => 'spinner',
				'label' => __('Custom Size'),
				'min' => 1,
				'max' => 100,
				'default' => 10,
				'screen' => 1,
				'css' => ['{{element}} .kkart-archive-crt-btn' => 'padding: calc({{val}}px / 2) {{val}}px !important;'],
				'req' => array(
					'size' => ['pagelayer-btn-custom'],
				),
			),
			'btn_type' => array(
				'type' => 'select',
				'label' => __('Button type'),
				'default' => 'pagelayer-btn-default',
				'list' => array(
					'pagelayer-btn-default' => __('Default'),
					'pagelayer-btn-primary' => __('Primary'),
					'pagelayer-btn-secondary' => __('Secondary'),
					'pagelayer-btn-success' => __('Success'),
					'pagelayer-btn-info' => __('Information'),
					'pagelayer-btn-warning' => __('Warning'),
					'pagelayer-btn-danger' => __('Danger'),
					'pagelayer-btn-dark' => __('Dark'),
					'pagelayer-btn-light' => __('Light'),
					'pagelayer-btn-link' => __('Link'),
					'pagelayer-btn-custom' => __('Custom')
				),
			),
			'btn_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				),
				'req' => array(
					'btn_type' => ['pagelayer-btn-custom'],
				),
			),
			'btn_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [
					'{{element}} .kkart-archive-crt-btn' => 'background-color: {{val}};',
				],
				'req' => array(
					'btn_type' => ['pagelayer-btn-custom'],
				),
				'show' => array(
					'btn_hover' => ''
				),
			),
			'btn_color' => array(
				'type' => 'color',
				'label' => __('Button Color'),
				'css' => ['{{element}} .kkart-archive-crt-btn' => 'color: {{val}};'],
				'req' => array(
					'btn_type' => ['pagelayer-btn-custom'],
				),
				'show' => array(
					'btn_hover' => ''
				),
			),
			'btn_hover_delay' => array(
				'type' => 'spinner',
				'label' => __('Button Hover Delay'),
				'desc' => __('Time to delay the hover in ms'),
				'min' => 0,
				'step' => 100,
				'max' => 5000,
				'default' => 400,
				'css' => ['{{element}} .kkart-archive-crt-btn' => '-webkit-transition: all {{val}}ms !important; transition: all {{val}}ms !important;'],
				'show' => array(
					'btn_type' => ['pagelayer-btn-custom'],
					'btn_hover' => 'hover'
				),
			),
			'btn_bg_color_hover' => array(
				'type' => 'color',
				'label' => __('Background Hover Color'),
				'css' => [
					'{{element}} .kkart-archive-crt-btn:hover' => 'background-color: {{val}};',
				],
				'req' => array(
					'btn_type' => ['pagelayer-btn-custom'],
				),
				'show' => array(
					'btn_hover' => 'hover',
				),
			),
			'btn_color_hover' => array(
				'type' => 'color',
				'label' => __('Hover Color'),
				'css' => ['{{element}} .kkart-archive-crt-btn:hover' => 'color: {{val}};'],
				'req' => array(
					'btn_type' => ['pagelayer-btn-custom'],
				),
				'show' => array(
					'btn_hover' => 'hover'
				),
			),
			'btn_shadow' => array(
				'type' => 'box_shadow',
				'label' => __('Shadow'),
				'css' => ['{{element}} .kkart-archive-crt-btn' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
			),
			'btn_shadow_hover' => array( // This is actually box shadow hover
				'type' => 'box_shadow',
				'label' => __('Box Shadow Hover'),
				'css' => ['{{element}} .kkart-archive-crt-btn:hover' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}} !important;'],
			),
			'show_view_cart' => array(
				'type' => 'checkbox',
				'label' => __('Show view cart for editor'),
			),
			'show_quantity_holder' => array(
				'type' => 'checkbox',
				'label' => __('Show quantity holder for editor'),
			)
		),
		'btn_border_style' => [
			'btn_bor_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'default' => '',
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				)
			),	
			'btn_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [
					'{{element}} .kkart-archive-crt-btn' => 'border-style: {{val}};',
					],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => array(
					'btn_bor_hover' => ''
				),
			),
			'btn_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-archive-crt-btn' => 'border-color: {{val}};'],
				'req' => array(
					'!btn_border_type' => ''
				),
				'show' => array(
					'btn_bor_hover' => ''
				),
			),
			'btn_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-archive-crt-btn' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => [
					'!btn_border_type' => ''
				],
				'show' => array(
					'btn_bor_hover' => ''
				),
			),
			'btn_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-archive-crt-btn' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!btn_border_type' => '',
				),
				'show' => array(
					'btn_bor_hover' => '',
				),
			),
			'btn_border_type_hover' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [
					'{{element}} .kkart-archive-crt-btn:hover' => 'border-style: {{val}}'
				],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => array(
					'btn_bor_hover' => 'hover'
				),
			),
			'btn_border_color_hover' => array(
				'type' => 'color',
				'label' => __('Border Color Hover'),
				'default' => '#42414f',
				'css' => ['{{element}} .kkart-archive-crt-btn:hover' => 'border-color: {{val}};'],
				'req' => array(
					'!btn_border_type_hover' => ''
				),
				'show' => array(
					'btn_bor_hover' => 'hover'
				),
			),
			'btn_border_width_hover' => array(
				'type' => 'padding',
				'label' => __('Border Width Hover'),
				'screen' => 1,
				'css' => [
					'{{element}} .kkart-archive-crt-btn:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px;'
				],
				'req' => [
					'!btn_border_type_hover' => ''
				],
				'show' => array(
					'btn_bor_hover' => 'hover'
				),
			),
			'btn_border_radius_hover' => array(
				'type' => 'padding',
				'label' => __('Border Radius Hover'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-archive-crt-btn:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!btn_border_type_hover' => '',
				),
				'show' => array(
					'btn_bor_hover' => 'hover',
				),
			),
		],
		'view_cart_btn_style' => array(
			'view_crt_btn_text' => array(
				'type' => 'text',
				'label' => __('View Cart Text'),
				'default' => __('View cart'),
				'edit' => '.kkart-view-btn',
				'addAttr' => ['{{element}} .kkart-crt-btn-holder' => 'data-view-btn-text="{{view_crt_btn_text}}"']
			),
			'view_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => ['{{element}} .kkart-view-btn' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
			),
			'view_custom_size' => array(
				'type' => 'spinner',
				'label' => __('Custom Size'),
				'min' => 1,
				'max' => 100,
				'default' => 10,
				'screen' => 1,
				'css' => ['{{element}} .kkart-view-btn' => 'padding: calc({{val}}px / 2) {{val}}px !important;'],
			),
			'view_btn_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				),
			),
			'view_btn_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => [
					'{{element}} .kkart-view-btn' => 'background-color: {{val}};',
				],
				'show' => array(
					'view_btn_hover' => ''
				),
			),
			'view_btn_color' => array(
				'type' => 'color',
				'label' => __('Button Color'),
				'css' => ['{{element}} .kkart-view-btn' => 'color: {{val}};'],
				'show' => array(
					'view_btn_hover' => ''
				),
			),
			'view_btn_hover_delay' => array(
				'type' => 'spinner',
				'label' => __('Button Hover Delay'),
				'desc' => __('Time to delay the hover in ms'),
				'min' => 0,
				'step' => 100,
				'max' => 5000,
				'default' => 400,
				'css' => ['{{element}} .kkart-view-btn' => '-webkit-transition: all {{val}}ms !important; transition: all {{val}}ms !important;'],
				'show' => array(
					'view_btn_hover' => 'hover'
				),
			),
			'view_bg_color_hover' => array(
				'type' => 'color',
				'label' => __('Background Hover Color'),
				'css' => [
					'{{element}} .kkart-view-btn:hover' => 'background-color: {{val}};',
				],
				'show' => array(
					'view_btn_hover' => 'hover',
				),
			),
			'view_btn_color_hover' => array(
				'type' => 'color',
				'label' => __('Hover Color'),
				'css' => ['{{element}} .kkart-view-btn:hover' => 'color: {{val}};'],
				'show' => array(
					'view_btn_hover' => 'hover'
				),
			),
			'view_btn_shadow' => array(
				'type' => 'box_shadow',
				'label' => __('Shadow'),
				'css' => ['{{element}} .kkart-view-btn' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
			),
			'view_btn_shadow_hover' => array( // This is actually box shadow hover
				'type' => 'box_shadow',
				'label' => __('Box Shadow Hover'),
				'css' => ['{{element}} .kkart-view-btn:hover' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}} !important;'],
			),
			'veiw_cart_spacing' => array(
				'type' => 'spinner',
				'label' => __('Spacing'),
				'css' => ['{{element}} .kkart-view-btn-holder' => 'margin-left:{{val}}px; margin-right:{{val}}px'],
			),
		),
		'view_cart_border_style' => array(
			'view_btn_bor_hover' => array(
				'type' => 'radio',
				'label' => __('State'),
				'default' => '',
				'list' => array(
					'' => __('Normal'),
					'hover' => __('Hover'),
				)
			),	
			'view_btn_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [
					'{{element}} .kkart-view-btn' => 'border-style: {{val}};',
					],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => array(
					'view_btn_bor_hover' => ''
				),
			),
			'view_btn_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-view-btn' => 'border-color: {{val}};'],
				'req' => array(
					'!view_btn_border_type' => ''
				),
				'show' => array(
					'view_btn_bor_hover' => ''
				),
			),
			'view_btn_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-view-btn' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => [
					'!view_btn_border_type' => ''
				],
				'show' => array(
					'view_btn_bor_hover' => ''
				),
			),
			'view_btn_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-view-btn' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!view_btn_border_type' => '',
				),
				'show' => array(
					'view_btn_bor_hover' => '',
				),
			),
			'view_border_type_hover' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [
					'{{element}} .kkart-view-btn:hover' => 'border-style: {{val}}'
				],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'show' => array(
					'view_btn_bor_hover' => 'hover'
				),
			),
			'view_border_color_hover' => array(
				'type' => 'color',
				'label' => __('Border Color Hover'),
				'css' => ['{{element}} .kkart-view-btn:hover' => 'border-color: {{val}};'],
				'req' => array(
					'!view_border_type_hover' => ''
				),
				'show' => array(
					'view_btn_bor_hover' => 'hover'
				),
			),
			'view_border_width_hover' => array(
				'type' => 'padding',
				'label' => __('Border Width Hover'),
				'screen' => 1,
				'css' => [
					'{{element}} .kkart-view-btn:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px;'
				],
				'req' => [
					'!view_border_type_hover' => ''
				],
				'show' => array(
					'view_btn_bor_hover' => 'hover'
				),
			),
			'view_border_radius_hover' => array(
				'type' => 'padding',
				'label' => __('Border Radius Hover'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-view-btn:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!view_border_type_hover' => '',
				),
				'show' => array(
					'view_btn_bor_hover' => 'hover',
				),
			),
		),
		'quantity_holder_style' => array(
			'quantityh_background_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} .kkart-quantity-holder' => 'background-color:{{val}}']
			),
			'quantityh_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => ['{{element}} .kkart-quantity-holder' => 'border-style: {{val}};'],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'quantityh_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-quantity-holder' => 'border-color: {{val}};'],
				'req' => ['!quantityh_border_type' => ''],
			),
			'quantityh_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-quantity-holder' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!quantityh_border_type' => ''],
			),
			'quantityh_borderh_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-quantity-holder' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => ['!quantityh_border_type' => ''],
			),
			'quantityh_padding' =>array(
				'type' => 'slider',
				'label' => __('Padding'),
				'css' => ['{{element}} .kkart-quantity-holder' => 'padding:{{val}}px']
			),
			'quantityh_spacing' => array(
				'type'=> 'spinner',
				'label' => __('Space Between'),
				'css' => ['{{element}} .kkart-quantity-close' => 'margin-left:{{val}}px;'],
			),
		),
		'quantity-style' => array(
			'quantity_color' => array(
				'type' => 'color',
				'label' => __('Text Color'),
				'css' => ['{{element}} .kkart-quantity, {{element}} .kkart-quantity-input' => 'color:{{val}}']
			),
			'quantity_background_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} .kkart-quantity' => 'background-color:{{val}}']
			),
			'quantity_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => ['{{element}} .kkart-quantity' => 'border-style: {{val}};',  '{{element}} .kkart-quantity-input' => 'border-left-style: {{val}}; border-right-style:{{val}};'],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'quantity_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-quantity' => 'border-color: {{val}};', '{{element}} .kkart-quantity-input' => 'border-left-color: {{val}};      border-right-color: {{val}};'],
				'req' => ['!quantity_border_type' => ''],
			),
			'quantity_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-quantity' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px', '{{element}} .kkart-quantity-input' => 'border-left-width: {{val[3]}}px; border-right-width:{{val[1]}}px;'],
				'req' => ['!quantity_border_type' => ''],
			),
			'quantity_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-quantity' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => ['!quantity_border_type' => ''],
			),
			'quantity_input_width' =>array(
				'type' => 'spinner',
				'label' => __('Input Text Width'),
				'min' => 2,
				'step' => 0.1,
				'css' => ['{{element}} .kkart-quantity-input' => 'width:{{val}}em !important'],
			),
			'quantity_size' => array(
				'type' => 'spinner',
				'label' => __('Size'),
				'min' => 1,
				'step' => 1,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} .kkart-minus, {{element}} .kkart-plus, {{element}} .kkart-quantity-input' => 'padding: calc({{val}}px / 2) {{val}}px !important;'],
			),
		),
		'quantity-close-style' => array(
			'quantityc_color' => array(
				'type' => 'color',
				'label' => __('Text Color'),
				'css' => ['{{element}} .kkart-quantity-close' => 'color:{{val}}']
			),
			'quantityc_background_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} .kkart-quantity-close' => 'background-color:{{val}}']
			),
			'quantityc_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [
					'{{element}} .kkart-quantity-close' => 'border-style: {{val}};',
					],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'quantityc_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-quantity-close' => 'border-color: {{val}};'],
				'req' => ['!quantityc_border_type' => ''],
			),
			'quantityc_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-quantity-close' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => ['!quantityc_border_type' => ''],
			),
			'quantityc_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-quantity-close' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => ['!quantityc_border_type' => ''],
			),
			'quantityc_size' => array(
				'type' => 'spinner',
				'label' => __('Size'),
				'min' => 1,
				'step' => 1,
				'max' => 100,
				'screen' => 1,
				'css' => ['{{element}} .kkart-quantity-close' => 'padding: calc({{val}}px / 2) {{val}}px !important;'],
			),
		),
		'styles' =>[
			'btn_border_style' => __('Button Border Style'),
			'quantity_holder_style' => __('Quantity Holder Style'),
			'quantity-style' => __('Quantity Style'),
			'quantity-close-style' => __('Quantity Close Style'),
			'view_cart_btn_style' => __('View Cart Button'),
			'view_cart_border_style' => __('View Cart Border'),
		],
	)
);

// Archive Products add to cart button
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_sale', array(
		'name' => __('Sale Flash'),
		'group' => 'kkart archive',
		'use_inside' => ['pl_kkart_archive_item'],
		'html' => '<div class="kkart-sale-flash kkart-onsale {{sale_type}} kkart-sale-position-{{sale_position}}" if="{{is_on_sale}}">
			<span class="kkart-sale-discount" if="{{show_discount}}">{{sale_discount}}</span>&nbsp;
			<span class="kkart-sale-text" if="{{sale_text}}">{{sale_text}}</span>
		</div>',
		'params' => array(
			'show_discount' => array(
				'type' => 'checkbox',
				'label' => __('Show Discount'),
				'default' => 'true',
			),
			'sale_text' => array(
				'type' => 'text',
				'label' => __('Text'),
				'default' => __('Off'),
				'edit' => '.kkart-sale-text'
			),
			'sale_text_position' => array(
				'type' => 'radio',
				'label' => __('Text Alignment'),
				'list' => array(
					'kkart-sale-text-left' => __('Left'),
					'' => __('Right')
				),
				'addClass' => '{{val}}',
				'css' => '{{val}}',
				'show' => ['!show_discount' => ''],
			),
			'typography' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => ['{{element}} .kkart-onsale' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
 			),
			'background_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} .kkart-onsale' => 'background-color:{{val}};'],
			),
			'color' => array(
				'type' => 'color',
				'label' => __('Text Color'),
				'css' => ['{{element}} .kkart-onsale' => 'color:{{val}};'],
			),
		),
		'sale_style' => array(
			'sale_type' => array(
				'type' => 'select',
				'label' => __('Badge Type'),
				'list' => array(
					'kkart-onsale-circle' => __('Circle'),
					'kkart-onsale-ribbon' => __('Ribbon'),
				),
				'default' => 'kkart-onsale-circle',
			),
			'width' => array(
				'type' => 'slider',
				'label' => __('Width'),
				'max' => 1200,
				'units' => ['px', 'em', '%'],
				'screen' => 1,
				'css' => ['{{element}} .kkart-onsale' => 'width: {{val}};'],
			),
			'height' => array(
				'type' => 'slider',
				'label' => __('Height'),
				'max' => 1200,
				'units' => ['px', 'em', '%'],
				'screen' => 1,
				'css' => ['{{element}} .kkart-onsale' => 'height: {{val}};'],
			),
			'spacing' => array(
				'type' => 'spinner',
				'label' => __('Spacing'),
				'default' => '2',
				'min' => '0',
				'css' => ['{{element}} .kkart-onsale' => 'padding: {{val}}px'],
			),
			'sale_position' => array(
				'type' => 'radio',
				'label' => __('Position'),
				'default' => 'right',
				'list' => array(
					'left' => __('Left'),
					'right' => __('Right'),
				),
			),
			'rotate'  => array(
				'type' => 'spinner',
				'label' => __('Rotate'),
				'css' => ['{{element}} .kkart-onsale-ribbon' => 'transform:rotate({{val}}deg);'],
				'req' => array(
					'!sale_type' => ['kkart-onsale-circle'],
				),
			),
		),
		'border_style' => [	
			'border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => [
					'{{element}} .kkart-onsale' => 'border-style: {{val}};',
					],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .kkart-onsale' => 'border-color: {{val}};'],
				'req' => array(
					'!border_type' => ''
				),
			),
			'border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-onsale' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
				'req' => [
					'!border_type' => ''
				],
			),
			'border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-onsale' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
				'req' => array(
					'!border_type' => ''
				),
				'show' => array(
					'!sale_type' => 'kkart-onsale-circle',
				),
			),
		],
		'styles' => array(
			'sale_style' => __('Sale Style'),
			'border_style' => __('Border Style'),
		),
	)
);

// Product Title
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_title', array(
		'name' => __('Product Title'),
		'group' => 'kkart',
		'use_inside' => ['pl_kkart_archive_item'],
		'edit_props' => ['.kkart-title' => 'post_title'],
		'html' => '<div class="kkart-product-title">
			<a class="pagelayer-ele-link" if-ext="{{link}}" href="{{product_link}}">
				<span if="{{before}}">{{before}} </span>
				<span class="kkart-title" >{{product_title}}</span>
				<span if="{{after}}"> {{after}}</span>
			</a>
		</div>',
		'params' => array(
			'before' => array(
				'type' => 'text',
				'label' => __('Before'),
				'np' => 1,
			),
			'after' => array(
				'type' => 'text',
				'label' => __('After'),
				'np' => 1,
			),
			'link' => array(
				'type' => 'checkbox',
				'label' => __('Link to Product Page'),
				'default' => true,
			),
			'title_colors' => array(
				'type' => 'radio',
				'label' => __('Colors'),
				'list' => array(
					'' => __('Normal'), 
					'hover' => __('Hover'), 
				)
			),
			'color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'default' => '#0986c0',
				'css' => ['{{element}} .kkart-product-title, {{element}} .kkart-product-title *' => 'color:{{val}}'],
				'show' => ['title_colors' => '']
			),
			'typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'default' => ',25,,700,,,solid,,,,',
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-title' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
				'show' => ['title_colors' => '']
			),
			'color_hover' => array(
				'type' => 'color',
				'label' => __('Color'),
				'default' => '#0986c0',
				'css' => ['{{element}} .kkart-product-title:hover, {{element}} .kkart-product-title:hover *' => 'color:{{val}}'],
				'show' => ['title_colors' => 'hover']
			),
			'typo_hover' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-product-title:hover' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
				'show' => ['title_colors' => 'hover']
			),
			'align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'list' => [
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				],
				'css' => ['{{element}} .kkart-product-title' => 'text-align: {{val}}'],
			),
		)
	)
);

// TODO: create this
// Products
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_products', array(
		'name' => __('Products'),
		'group' => 'kkart',
		'has_group' => [
			'section' => 'params', 
			'prop' => 'elements',
			'loop' => 1,
		],
		'holder' => '.pagelayer-products-container',
		'child_selector' => '>.pagelayer-owl-stage-outer>.pagelayer-owl-stage>.pagelayer-owl-item',
		'html' => '<h3 if={{product_title}} class="pagelayer-product-title">{{product_title}}</h3>
		<div class="pagelayer-products-container"></div>',
		'params' => array(
			'elements' => array(
				'type' => 'group',
				'label' => __('Items'),
				'sc' => PAGELAYER_SC_PREFIX.'_kkart_archive_item',
				'count' => 1,
				'item_label' => array(
					'default' => __('Items'),
				),
				'hide' => 1,
			),
			'view' => array(
				'type' => 'select',
				'label' => __('View Type'),	
				'list' => array(
					'' => __('Grid'),
					'slider' => __('Slider'),
				),
				'addClass' => ['{{element}} .pagelayer-products-container' => 'pagelayer-owl-holder pagelayer-owl-carousel pagelayer-owl-theme']
			),
			'cols' => array(
				'type' => 'select',
				'label' => __('Cols'),
				'screen' => 1,
				'list' => array(
					'' => __('Default'),
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
					'7' => '7',
					'8' => '8',
					'9' => '9',
					'10' => '10',
					'11' => '11',
					'12' => '12',
				),
				'css' => ['{{element}} .pagelayer-products-container' => 'grid-template-columns: repeat({{val}}, 1fr);'],
				'req' => ['view' => ''],
 			),
			'limit' => array(
				'type' => 'spinner',
				'label' => __('Total number of products'),
				'desc' => __('Default 12 products will be shown'),
			),
			'product_title' => array(
				'type' => 'text',
				'label' => __('Title'),
				'default' => __('You may also like this'),
 			),
			'no_found' => array(
				'type' => 'textarea',
				'label' => __('Not Found Messages'),
				'default' => __('Products not found.'),
 			),
		),
		'query' => array(
			'source' => array(
				'type' => 'select',
				'label' => __('Source'),
				'default' => 'recent_products',
				'list' => array(
					'pagelayer_current_query' => __('Currunt Query'),
					'recent_products' => __('Recent Products'),
					'sale_products' => __('Sale Products'),
					'best_selling_products' => __('Best Selling Products'),
					'top_rated_products' => __('Top Rated Products'),
					'featured_products' => __('Featured Product'),
					'upsell_product' => __('Upsell Product'),
					'cross_sell_product' => __('Cross sell Product'),
					'related_products' => __('Related Products'),
					'by_id' => __('Manual Selection'),
				),
			),
			'ids' => array(
				'type' => 'multiselect',
				'label' => __('Products'),
				'list' => pagelayer_post_list_by_type('product'),
				'req' => ['source' => 'by_id'],
			),
			'orderby' => array(
				'type' => 'select',
				'label' => __('Order By'),
				'default' => 'date',
				'list' => array(
					'date' => __('Date'),
					'title' => __('Title'),
					'price' => __('Price'),
					'popularity' => __('Popularity'),
					'rating' => __('Rating'),
					'rand' => __('Rand'),
					'menu_order' => __('Menu Order'),
				),
			),
			'order' => array(
				'type' => 'select',
				'label' => __('Order'),
				'default' => 'ASC',
				'list' => array(
					'ASC' => __('ASC'),
					'DESC' => __('DESC'),
				),
			),
		),
		'slider_options' => array(
			'slide_items' => array(
				'type' => 'spinner',
				'label' => __pl('number_of_items'),
				'min' => 1,
				'step' => 1,
				'max' => 10,
				'default' => 3,
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-items="{{slide_items}}"'],
			),
			'slider_animation' => array(
				'type' => 'select',
				'label' => __pl('animation_in'),
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-animate-in="{{slider_animation}}"'],
				'list' => $pagelayer->anim_in_options,
				'req' => ['slide_items' => '1']
			),
			'slideout_anim' => array(
				'type' => 'select',
				'label' => __pl('animation_out'),
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-animate-out="{{slideout_anim}}"'],
				'list' => $pagelayer->anim_out_options,
				'req' => ['slide_items' => '1']
			),
			'controls' => array(
				'type' => 'select',
				'label' => __pl('slider_controls'),
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-controls="{{controls}}"'],
				'list' => array(
					'' => __pl('Arrows and Pager'),
					'arrows' => __pl('Arrows'),
					'pager' => __pl('Pager'),
					'none' => __pl('none'),
				)
			),
			'pause' => array(
				'type' => 'slider',
				'label' => __pl('image_slider_slideshow_speed_label'),
				'default' => 5000,
				'min' => 200,
				'max' => 20000,
				'step' => 100,
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-autoplay-timeout="{{pause}}"'],
			),
			'speed' => array(
				'type' => 'slider',
				'label' => __pl('slider_animation_speed'),
				'addAttr' => ['.pagelayer-products-container' => 'data-slides-smart-speed="{{speed}}"'],
				'default' => 800,
				'min' => 200,
				'max' => 10000,
				'step' => 100
			),
			'loop' => array(
				'type' => 'checkbox',
				'label' => __pl('image_slider_loop'),
				'desc' => __pl('image_slider_loop_desc'),
				'default' => 'true',
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-loop="{{loop}}"'],
			),
			'adaptive_height' => array(
				'type' => 'checkbox',
				'label' => __pl('slider_height'),
				'desc' => __pl('slider_height_desc'),
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-auto-height="{{adaptive_height}}"'],
			),
			'auto' => array(
				'type' => 'checkbox',
				'label' => __pl('image_slider_auto'),
				'desc' => __pl('image_slider_auto_desc'),
				'default' => 'true',
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-autoplay="{{auto}}"'],
			),
			'auto_hover' => [
				'type' => 'checkbox',
				'label' => __pl('auto_hover'),
				'desc' => __pl('auto_hover_desc'),
				'default' => 'true',
				'addAttr' => ['{{element}} .pagelayer-owl-holder' => 'data-slides-autoplay-hover-pause="{{auto_hover}}"'],
			],
		),
		'arrow_styles' => $pagelayer->slider_arrow_styles,
		'pager_styles' => $pagelayer->slider_pager_styles,
		'product_title_style' => array(
			'pts_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .pagelayer-product-title' => 'color:{{val}}'],
 			),
			'pts_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .pagelayer-product-title' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
		),
		'no_found_style' => array(
			'nf_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .pagelayer-product-no-found' => 'color:{{val}}'],
 			),
			'nf_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .pagelayer-product-no-found' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
		),
		'styles' =>[
			'query' => __('Query'),
			'slider_options' => __('Slider Options'),
			'arrow_styles' => __('Arrow Styles'),
			'pager_styles' => __('Pager Styles'),
			'no_found_style' => __('No Found Style'),
			'product_title_style' => __('Title Styles'),
		],
	)
);

// TODO: create this
// Product Archives description
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_product_archives_desc', array(
		'name' => __('Product Archives Description'),
		'group' => 'kkart',
		'not_visible' => 1,
		'html' => '<div class="pagelayer-archives-desc-container">'. kkart_get_product_archives_desc() .'</div>',
		'params' => array(
			'align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				),
				'css' => ['{{element}} .pagelayer-archives-desc-container' => 'text-align:{{val}}'],
 			),
			'color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-product-details__short-description' => 'color:{{val}}'],
 			),
			'typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-product-details__short-description' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
		),
	)
);

// TODO: create this
// Product Additional Information
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_addi_info', array(
		'name' => __('Additional Information'),
		'group' => 'kkart',
		'not_visible' => 1,
		'html' => '<div class="kkart-addi-info-container">
				<h2 if="{{product_addi_info_heading}}">{{product_addi_info_heading}}</h2>
				<table class="kkart-product-attributes shop_attributes" if="{{product_addi_info}}">{{product_addi_info}}</table>
			</div>',
		'params' => array(
			'label_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-product-attributes-item__label' => 'color:{{val}}'],
 			),
			'label_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-product-attributes-item__label' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'value_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-product-attributes-item__value' => 'color:{{val}}'],
 			),
			'value_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-product-attributes-item__value' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'heading' => array(
				'type' => 'checkbox',
				'label' => __('Heading Style'),
				'default' => 'true',
				'addAttr' => ['{{element}} .kkart-addi-info-container' => 'pagelayer-show-heading="{{heading}}"'],
 			),
			'heading_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-addi-info-container h2' => 'color:{{val}}'],
				'req' => ['heading' => 'true'],
 			),
			'heading_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-addi-info-container h2' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
				'req' => ['heading' => 'true'],
			),
		),
	)
);

// TODO: create this
// Product Additional Information
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_data_tabs', array(
		'name' => __('Product Data Tabs'),
		'group' => 'kkart',
		'not_visible' => 1,
		'html' => '<div class="pagelayer-data-tabs-container">'. kkart_get_product_data_tabs() .'</div>',
		'params' => array(
			'tabs_colors' => array(
				'type' => 'radio',
				'label' => __('Colors'),
				'list' => array(
					'normal' => __('Normal'),
					'active' => __('Active'),
				),
 			),
			'tabs_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['.kkart {{element}} .kkart-tabs ul.wc-tabs li a' => 'color:{{val}}'],
				'show' => ['tabs_colors' => 'normal'],
 			),
			'tabs_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['.kkart {{element}} .kkart-tabs ul.wc-tabs li' => 'background-color:{{val}}'],
				'show' => ['tabs_colors' => 'normal'],
 			),
			'tabs_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => [
					'.kkart {{element}} .kkart-tabs ul.wc-tabs li' => 'border-color:{{val}}',
					'.kkart {{element}} .kkart-tabs .kkart-Tabs-panel' => 'border-color:{{val}}'
				],
				'show' => ['tabs_colors' => 'normal'],
 			),
			'tabs_color_active' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['.kkart {{element}} .kkart-tabs ul.wc-tabs li.active a' => 'color:{{val}}'],
				'show' => ['tabs_colors' => 'active'],
 			),
			'tabs_bg_color_active' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['.kkart {{element}} .kkart-tabs ul.wc-tabs li.active' => 'background-color:{{val}}'],
				'show' => ['tabs_colors' => 'active'],
 			),
			'tabs_border_color_active' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => [
					'.kkart {{element}} .kkart-tabs .kkart-Tabs-panel' => 'border-color: {{val}}',
					'.kkart {{element}} .kkart-tabs ul.wc-tabs li.active' => 'border-color: {{val}}'
				],
				'show' => ['tabs_colors' => 'active'],
 			),
			'tabs_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'.kkart {{element}} .kkart-tabs ul.wc-tabs li a' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'border_radius' => array(
				'type' => 'slider',
				'label' => __('Border Radius'),
				'css' => ['.kkart {{element}} .kkart-tabs ul.wc-tabs li' => 'border-radius: {{val}}px'],
			),
		),
		'panel_style' => array(
			'panel_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['.kkart {{element}} .kkart-tabs .kkart-Tabs-panel' => 'color: {{val}}'],
 			),
			'panel_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'.kkart {{element}} .kkart-tabs .kkart-Tabs-panel' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'panel_heading' => array(
				'type' => 'heading',
				'label' => __('Heading Style'),
			),
			'panel_heading_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['.kkart {{element}} .kkart-tabs .kkart-Tabs-panel h2' => 'color: {{val}}'],
 			),
			'panel_heading_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'.kkart {{element}} .kkart-tabs .kkart-Tabs-panel h2' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'panel_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'css' => ['.kkart {{element}} .kkart-tabs .kkart-Tabs-panel' => 'border-width: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; margin-top: -{{val[0]}}px'],
			),
			'panel_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'css' => [
					'.kkart {{element}} .kkart-tabs .kkart-Tabs-panel' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;',
					'.kkart {{element}} .kkart-tabs ul.wc-tabs' => 'margin-left: {{val[0]}}px; margin-right: {{val[1]}};'
				],
			),
			'panel_shadow' => array(
				'type' => 'box_shadow',
				'label' => __('Box Shadow'),
				'css' => ['.kkart {{element}} .kkart-tabs .kkart-Tabs-panel' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}};'],
			),
		),
		'styles' => array(
			'panel_style' => __('Panel Style'),
		),
	)
);

// kkart Menu cart
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_menu_cart', array(
		'name' => __('Kkart Menu Cart'),
		'icon' => 'fa fa-shopping-cart',
		'group' => 'kkart',
		'html' => '<div class="pagelayer-woo-menu-cart-container">'. kkart_sc_menu_cart_html() .'</div>',
		'params' => array(
			'icon_type' => array(
				'type' => 'select',
				'label' => __('Icon'),
				'default' => 'fa fa-shopping-cart',
				'list' => array(
					'fa fa-shopping-cart' => __('Cart'),
					'fa fa-shopping-basket' => __('Basket'),
					'fa fa-shopping-bag' => __('Bag'),
				),
 			),
			'items_indicator' => array(
				'type' => 'select',
				'label' => __('Items Indicator'),
				'default' => 'bubble',
				'list' => array(
					'' => __('None'),
					'bubble' => __('Bubble'),
					'plain' => __('Plain'),
				),
				'addAttr' => [ '{{element}} .pagelayer-menu-cart-toggle' => 'pagelayer-icon="{{items_indicator}}"'],
 			),
			'empty_indicator' => array(
				'type' => 'checkbox',
				'label' => __('Empty Indicator'),
				'addAttr' => ['{{element}} .pagelayer-menu-cart-toggle' => 'pagelayer-empty-indicator="{{empty_indicator}}"'],
 			),
			'sub_total' => array(
				'type' => 'checkbox',
				'label' => __('Hide Sub Total'),
				'css' => ['{{element}} .pagelayer-cart-button-text' => 'display:none;']
 			),
			'cart_align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'default' => 'left',
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				),
				'css' => [
					'{{element}} .pagelayer-menu-cart-toggle' => 'text-align:{{val}}'
				],
 			),			
		),
		'mini_cart_style' => array(
			'mini_cart_colors' => array(
				'type' => 'radio',
				'label' => '',
				'list' => array(
					'normal' => __('Normal'),
					'hover' => __('Hover'),
				),
 			),
			'mini_cart_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .pagelayer-cart-button' => 'color:{{val}}'],
				'show' => ['mini_cart_colors' => 'normal'],
 			),
			'cart_icon_color' => array(
				'type' => 'color',
				'label' => __('Cart Icon Color'),
				'css' => ['{{element}} .pagelayer-cart-button-icon' => 'color:{{val}}'],
				'show' => ['mini_cart_colors' => 'normal'],
 			),
			'mini_cart_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} .pagelayer-cart-button' => 'background-color:{{val}}'],
				'show' => ['mini_cart_colors' => 'normal'],
 			),
			'mini_cart_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .pagelayer-cart-button' => 'border-color:{{val}}'],
				'show' => ['mini_cart_colors' => 'normal'],
 			),
			'mini_cart_color_hover' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .pagelayer-cart-button:hover' => 'color:{{val}}'],
				'show' => ['mini_cart_colors' => 'hover'],
 			),
			'cart_icon_color_hover' => array(
				'type' => 'color',
				'label' => __('Cart Icon Color'),
				'css' => ['{{element}} .pagelayer-cart-button-icon:hover' => 'color:{{val}}'],
				'show' => ['mini_cart_colors' => 'hover'],
 			),
			'cart_bg_color_hover' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} .pagelayer-cart-button:hover' => 'background-color:{{val}}'],
				'show' => ['mini_cart_colors' => 'hover'],
 			),
			'cart_border_color_hover' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'css' => ['{{element}} .pagelayer-cart-button:hover' => 'border-color:{{val}}'],
				'show' => ['mini_cart_colors' => 'hover'],
 			),
			'cart_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => ['{{element}} .pagelayer-cart-button' => 'border-style: {{val}}'],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'cart_border_width' => array(
				'type' => 'slider',
				'label' => __('Border Width'),
				'css' => ['{{element}} .pagelayer-cart-button' => 'border-width:{{val}}px'],
				'req' => ['!cart_border_type' => ''],
 			),
			'cart_border_radius' => array(
				'type' => 'slider',
				'label' => __('Border Radius'),
				'units' => [ 'px', 'em', '%' ],
				'css' => ['{{element}} .pagelayer-cart-button' => 'border-radius:{{val}}'],
 			),
			'cart_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .pagelayer-cart-button' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'mini_cart_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'units' => [ 'px', 'em', '%' ],
				'css' => ['{{element}} .pagelayer-cart-button' => 'padding: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}};'],
			),
			'mini_cart_icon' => array(
				'type' => 'heading',
				'label' => __('Icon'),
			),
			'mini_icon_size' => array(
				'type' => 'slider',
				'label' => __('Size'),
				'units' => [ 'px', 'em' ],
				'css' => ['{{element}} .pagelayer-cart-button-icon' => 'font-size:{{val}}'],
			),
			'mini_icon_spacing' => array(
				'type' => 'slider',
				'label' => __('Spacing'),
				'units' => [ 'px', 'em' ],
				'min' => 0,
				'max' => 50,
				'css' => [
					'body:not(.rtl) {{element}} .pagelayer-cart-button-text' => 'margin-right: {{val}}',
					'body.rtl {{element}} .pagelayer-cart-button-text' => 'margin-left: {{val}}',
				],
			),
			'mini_bubble_icon' => array(
				'type' => 'heading',
				'label' => __('Bubble'),
				'req' => ['items_indicator' => 'bubble'],
			),
			'bubble_colors' => array(
				'type' => 'radio',
				'label' => '',
				'default' => 'normal',
				'list' => array(
					'normal' => __('Normal'),
					'hover' => __('Hover'),
				),
				'req' => ['items_indicator' => 'bubble'],
			),
			'bubble_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} [pagelayer-icon="bubble"]  .pagelayer-cart-button-icon[data-counter]:before' => 'color:{{val}}'],
				'show' => ['bubble_colors' => 'normal'],
			),
			'bubble_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} [pagelayer-icon="bubble"] .pagelayer-cart-button-icon[data-counter]:before' => 'background-color:{{val}}'],
				'show' => ['bubble_colors' => 'normal'],
			),
			'bubble_color_hover' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} [pagelayer-icon="bubble"] .pagelayer-cart-button-icon[data-counter]:hover:before' => 'color:{{val}}'],
				'show' => ['bubble_colors' => 'hover'],
			),
			'bubble_bg_color_hover' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} [pagelayer-icon="bubble"] .pagelayer-cart-button-icon[data-counter]:hover:before' => 'background-color:{{val}}'],
				'show' => ['bubble_colors' => 'hover'],
			),
		),
		'container_style' => array(
			'container_position' => array(
				'type' => 'select',
				'label' => __('Position'),
				'default' => 'fixed_right',
				'list' => array(
					'fixed_right' => __('Fixed Right'),
					'fixed_left' => __('Fixed Left'),
					'dropdown' => __('Dropdown'),
				),
				'addAttr' => [ '{{element}} .pagelayer-woo-menu-cart-container' => 'pagelayer-container-position="{{container_position}}"'],
 			),
			'container_align' => array(
				'type' => 'radio',
				'label' => __('Position'),
				'default' => 'left',
				'list' => array(
					'left' => __('Left'),
					'right' => __('Right'),
				),
				'css' => ['{{element}} .pagelayer-menu-cart-container' => '{{val}}:0 !important;'],
				'req' => ['container_position' => 'dropdown'],
 			),
			'cart_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .pagelayer-menu-cart-container' => 'color:{{val}}']
			),
			'cart_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} .pagelayer-menu-cart-container' => 'background-color:{{val}}']
			),
			'container_close' => array(
				'type' => 'slider',
				'label' => __('Close Size'),
				'css' => ['{{element}} .pagelayer-menu-cart-close' => 'font-size:{{val}}px;']
 			),
			'container_width' => array(
				'type' => 'slider',
				'label' => __('Width'),
				'screen' => 1,
				'units' => ['px', '%'],
				'css' => ['{{element}} .pagelayer-menu-cart-container' => 'width:{{val}};']
 			),
			'sub_total_label' => array(
				'type' => 'heading',
				'label' => __('Sub Total'),
			),
			'sub_total_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-mini-cart__total' => 'color: {{val}}'],
 			),
			'sub_total_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-mini-cart__total' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
		),
		'products_style' => array(
			'products_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-mini-cart > .kkart-mini-cart-item' => 'color:{{val}}']
			),
			'products_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} .kkart-mini-cart > .kkart-mini-cart-item' => 'background-color:{{val}}']
			),
			'products_list_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'units' => [ 'px', 'em'],
				'css' => ['{{element}} .kkart-mini-cart > .kkart-mini-cart-item' => 'padding: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}} !important;'],
			),
			'img_label' => array(
				'type' => 'heading',
				'label' => __('Image'),
			),
			'products_img_width' => array(
				'type' => 'slider',
				'label' => __('Width'),
				'default' => '50px',
				'units' => ['px', 'em', '%'],
				'css' => ['{{element}} .kkart-mini-cart-item img' => 'width: {{val}}'],
 			),
			'title_label' => array(
				'type' => 'heading',
				'label' => __('Product Title'),
			),
			'products_title_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-mini-cart-item a' => 'color: {{val}}'],
 			),
			'products_title_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-mini-cart-item a' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'price_label' => array(
				'type' => 'heading',
				'label' => __('Product Price'),
			),
			'products_price_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-mini-cart-item .quantity' => 'color: {{val}}'],
 			),
			'products_price_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-mini-cart-item .quantity' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'remove_label' => array(
				'type' => 'heading',
				'label' => __('Remove Items'),
			),
			'remove_icon_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .remove_from_cart_button' => 'color: {{val}} !important'],
 			),
			'remove_icon_size' => array(
				'type' => 'slider',
				'label' => __('Size'),
				'css' => ['{{element}} .remove_from_cart_button' => 'font-size: {{val}}px'],
			),
		),
		'buttons_style' => array(
			'button_display' => array(
				'type' => 'select',
				'label' => __('Display'),
				'default' => 'inline',
				'list' => array(
					'inline' => __('Inline'),
					'block' => __('Block'),
				),
				'css' => ['{{element}} .kkart-mini-cart__buttons a' => 'display: {{val}}'],
				'addAttr' => ['{{element}} .kkart-mini-cart__buttons' => 'pagelayer-display="{{button_display}}"'],
 			),
			'space_between_btn' => array(
				'type' => 'slider',
				'label' => __('Space Between'),
				'default' => 5,
				'css' => [
					'{{element}} .kkart-mini-cart__buttons[pagelayer-display="inline"] a' => 'margin-left: {{val}}px',
					'{{element}} .kkart-mini-cart__buttons[pagelayer-display="block"] a' => 'margin-bottom: {{val}}px'
				],
 			),
			'btn_padding' => array(
				'type' => 'padding',
				'label' => __('Padding'),
				'units' => [ 'px', 'em'],
				'default' => '5,5,5,5',
				'css' => ['{{element}} .kkart-mini-cart__buttons a' => 'padding: {{val[0]}} {{val[1]}} {{val[2]}} {{val[3]}} !important;'],
			),
			'btn_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'css' => [
					'{{element}} .kkart-mini-cart__buttons' => 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'
				],
			),
			'btn_border_radius' => array(
				'type' => 'slider',
				'label' => __('Border Radius'),
				'units' => [ 'px', 'em'],
				'default' => '50',
				'css' => ['{{element}} .kkart-mini-cart__buttons a' => 'border-radius: {{val}} !important'],
 			),
			'btn_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'default' => '#ffffff',
				'css' => ['{{element}} .kkart-mini-cart__buttons a' => 'color: {{val}}'],
			),
			'btn_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'default' => '#585757',
				'css' => ['{{element}} .kkart-mini-cart__buttons a' => 'background-color: {{val}}'],
			),
			'btn_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'css' => ['{{element}} .kkart-mini-cart__buttons a' => 'border-style: {{val}} !important'],
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
			),
			'btn_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#42414f',
				'css' => ['{{element}} .kkart-mini-cart__buttons a' => 'border-color: {{val}} !important'],
				'req' => array(
					'!btn_border_type' => ''
				),
			),
			'btn_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-mini-cart__buttons a' => 'border-width: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px !important'],
				'req' => [
					'!btn_border_type' => ''
				],
			),
		),
		'styles' => array(
			'mini_cart_style' => __('Mini Cart Style'),
			'container_style' => __('Container Style'),
			'products_style' => __('Products Style'),
			'buttons_style' => __('Buttons Style'),
		),
	)
);

//KKART My Account
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_kkart_myaccount_tabs', array(
		'name' => __('My Account'),
		'group' => 'kkart My Account',
		'html' => '<div if="{{kkart_login_form}}" class="kkart-myaccount-login">{{kkart_login_form}}</div>
			<div class="kkart-myaccount-tabholder" if="{{tab_holder}}">{{tab_holder}}</div>
			<div class="kkart-myaccount-tabcontainer" if="{{tab_content}}">{{tab_content}}</div>',
		'params' => array(
			'vertical' => array(
				'type' => 'checkbox',
				'label' => __('Vertical Tabs'),
				'default' => 'true',
			),
			'vertical_width' => array(
				'type' => 'slider',
				'label' => __('Tabs container width'),
				'default' => 21,
				'min' => 0,
				'max' => 70,
				'step' => 1,
				'screen' => 1,
				'css' => ['{{element}}' => 'width:100%; display: -webkit-flex;
				display: flex;', '{{element}} .kkart-myaccount-tabholder' => '-webkit-flex-basis: {{val}}%; flex-basis:{{val}}%', '{{element}} .kkart-myaccount-tabcontainer' => '-webkit-flex-basis: calc(100% - {{val}}%); flex-basis:calc(100% - {{val}}%)', '{{element}} .kkart-myaccount-tabholder .kkart-tablinks' => 'width: 100%;'],
				'req' => array(
					'vertical' => 'true',
				)
			),
			'myaccount_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'css' => ['{{element}}' => 'border-style: {{val}}'],
			),
			'myaccount_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#eeeeee',
				'req' => [
					'!myaccount_border_type' => ''
				],
				'css' => ['{{element}}' => 'border-color: {{val}}'],
			),
			'myaccount_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'default' => '1,1,1,1',
				'screen' => 1,
				'req' => [
					'!myaccount_border_type' => ''
				],
				'css' => ['{{element}}' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
			),
			'myaccount_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'default' => '1,1,1,1',
				'screen' => 1,
				'req' => [
					'!myaccount_border_type' => ''
				],
				'css' => ['{{element}}' => 'border-top-left-radius: {{val[0]}}px; border-top-right-radius: {{val[1]}}px; border-bottom-right-radius: {{val[2]}}px; border-bottom-left-radius: {{val[3]}}px'],
			),
		),
		'tabs_styles' => [
			'tabs_holder_align' => array(
				'type' => 'radio',
				'label' => __('Alignment'),
				'default' => 'left',
				'screen' => 1,
				'list' => array(
					'left' => __('Left'),
					'center' => __('Center'),
					'right' => __('Right'),
				),
				'css' => ['{{element}} .kkart-myaccount-tabholder' => 'text-align:{{val}}'],
			),
			'tabs_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-myaccount-tabholder .kkart-tablinks' => 'color:{{val}}'],
			),
			'tabs_bg_color' => array(
				'type' => 'color',
				'label' => __('Background color'),
				'css' => ['{{element}} .kkart-myaccount-tabholder' => 'background-color:{{val}}'],
			),
			'tabs_active_color' => array(
				'type' => 'color',
				'label' => __('Active Tab Color'),
				'css' => ['{{element}} .kkart-myaccount-tabholder .kkart-tablinks.kkart-active-tab' => 'color:{{val}} !important', '{{element}} .kkart-myaccount-tabholder .kkart-tablinks:hover' => 'color:{{val}}'],
			),
			'tabs_active_bg_color' => array(
				'type' => 'color',
				'label' => __('Active Tab Background Color'),
				'css' => ['{{element}} .kkart-myaccount-tabholder .kkart-tablinks.kkart-active-tab'=> 'background-color:{{val}} !important', '{{element}} .kkart-myaccount-tabholder .kkart-tablinks:hover' => 'background-color:{{val}}'],
			),
			'tab_title_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-myaccount-tabholder .kkart-tablinks' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
			),
			'tabs_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'default' => '',
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'css' => ['{{element}} .kkart-myaccount-tabholder' => 'border-style: {{val}}'],
			),
			'tabs_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#eeeeee',
				'req' => [
					'!tabs_border_type' => ''
				],
				'css' => ['{{element}} .kkart-myaccount-tabholder' => 'border-color: {{val}}'],
			),
			'tabs_holder_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'default' => '1,1,1,0',
				'screen' => 1,
				'req' => [
					'!tabs_border_type' => ''
				],
				'css' => ['{{element}} .kkart-myaccount-tabholder' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
			),
			'tabs_holder_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'default' => '1,1,1,1',
				'screen' => 1,
				'req' => [
					'!tabs_border_type' => ''
				],
				'css' => ['{{element}} .kkart-myaccount-tabholder' => 'border-top-left-radius: {{val[0]}}px; border-top-right-radius: {{val[1]}}px; border-bottom-right-radius: {{val[2]}}px; border-bottom-left-radius: {{val[3]}}px'],
			),
		],
		'content_styles' => [
			'tabs_content_typo' => array(
				'type' => 'typography',
				'label' => __('Typography'),
				'screen' => 1,
				'css' => ['{{element}} .kkart-myaccount-tabcontainer *' => 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
			),
			'tabs_content_color' => array(
				'type' => 'color',
				'label' => __('Color'),
				'css' => ['{{element}} .kkart-myaccount-tabcontainer' => 'color:{{val}}'],
			),
			'tabs_content_bg_color' => array(
				'type' => 'color',
				'label' => __('Background Color'),
				'css' => ['{{element}} .kkart-myaccount-tabcontainer'=> 'background-color:{{val}}'],
			),
			'tab_padding' => array(
				'type' => 'slider',
				'label' => __('Tabs Padding Label'),
				'min' => 0,
				'max' => 50,
				'step' => 1,
				'screen' => 1,
				'css' => ['{{element}} .kkart-myaccount-tabcontainer' => 'padding: {{val}}px;'],
			),
			'tab_content_border_type' => array(
				'type' => 'select',
				'label' => __('Border Type'),
				'default' => '',
				'list' => [
					'' => __('None'),
					'solid' => __('Solid'),
					'double' => __('Double'),
					'dotted' => __('Dotted'),
					'dashed' => __('Dashed'),
					'groove' => __('Groove'),
				],
				'css' => ['{{element}} .kkart-myaccount-tabcontainer' => 'border-style: {{val}}'],
			),
			'tab_content_border_color' => array(
				'type' => 'color',
				'label' => __('Border Color'),
				'default' => '#eeeeee',
				'req' => [
					'!tab_content_border_type' => ''
				],
				'css' => ['{{element}} .kkart-myaccount-tabcontainer' => 'border-color: {{val}}'],
			),
			'tab_content_border_width' => array(
				'type' => 'padding',
				'label' => __('Border Width'),
				'default' => '1,1,1,1',
				'screen' => 1,
				'req' => [
					'!tab_content_border_type' => ''
				],
				'css' => ['{{element}} .kkart-myaccount-tabcontainer' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
			),
			'tab_content_border_radius' => array(
				'type' => 'padding',
				'label' => __('Border Radius'),
				'default' => '1,1,1,1',
				'screen' => 1,
				'req' => [
					'!tab_content_border_type' => ''
				],
				'css' => ['{{element}} .kkart-myaccount-tabcontainer' => 'border-top-left-radius: {{val[0]}}px; border-top-right-radius: {{val[1]}}px; border-bottom-right-radius: {{val[2]}}px; border-bottom-left-radius: {{val[3]}}px'],
			),
		],
		'styles' => [
			'tabs_styles' => __('Tabs'),
			'content_styles' => __('Content'),
		],
	)
);

