<?php

//////////////////////////////////////////////////////////////
//===========================================================
// body-props-settings.php
//===========================================================
// KKART
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Pulkit Gupta
// Date:       23rd Jan 2017
// Time:       23:00 hrs
// Site:       http://kkart.com/wordpress (KKART)
// ----------------------------------------------------------
// Please Read the Terms of use at http://kkart.com/tos
// ----------------------------------------------------------
//===========================================================
// (c)Kkart Team
//===========================================================
//////////////////////////////////////////////////////////////

// Are we being accessed directly ?
if(!defined('KKART_VERSION')) {
	exit('Hacking Attempt !');
}

// Set body property atts
function kkart_do_shortcode_el_filter($el){
	global $post, $product;
	
	if(empty($product)){
		return $el;
	}
	
	$sale_price_dates_from_timestamp = $product->get_date_on_sale_from( 'edit' ) ? $product->get_date_on_sale_from( 'edit' )->getOffsetTimestamp() : false;
	$sale_price_dates_to_timestamp = $product->get_date_on_sale_to( 'edit' ) ? $product->get_date_on_sale_to( 'edit' )->getOffsetTimestamp() : false;

	$sale_price_dates_from = $sale_price_dates_from_timestamp ? date_i18n( 'Y-m-d', $sale_price_dates_from_timestamp ) : '';
	$sale_price_dates_to   = $sale_price_dates_to_timestamp ? date_i18n( 'Y-m-d', $sale_price_dates_to_timestamp ) : '';
	$downloads = (array) $product->get_downloads();
	$_downloads = array();
	
	// Covert downloads array for shortcode compatibility
	foreach($downloads as $kk => $vv){
		$_downloads['names'][] = $vv['name'];
		$_downloads['hashes'][] = $vv['id'];
		$_downloads['urls'][] = $vv['file'];
	}
	
	$props = array(
		'_regular_price' => $product->get_regular_price('edit'),
		'_sale_price' => $product->get_sale_price('edit'),
		'product_image_gallery' =>  $product->get_gallery_image_ids(),
		'_sale_price_dates_from' =>  esc_attr( $sale_price_dates_from ),
		'_sale_price_dates_to' =>  esc_attr( $sale_price_dates_to ),
		'_downloadable_files' => $_downloads
	);
	
	foreach($props as $prop => $val){
		$el['atts'][$prop] = $val;
		$el['oAtts'][$prop] = $val;
	}
	
	return $el;
}

// Set body property for the KKART product
function kkart_body_props_settings($params){
	global $post;
	
	$product = kkart_get_product($post);
	
	$params['kkart_gallery'] = array(
		'product_image_gallery' => array(
			'type' => 'multi_image',
			'label' => __pl('product_gallery'),
			'default' => ((!empty($product)) ? implode(',', $product->get_gallery_image_ids()) : ''),
			'export-def' => 1,
			'post' => 1,
		),
	);
	
	$params['kkart_pricing'] = array(
		'_downloadable' => array(
			'type' => 'checkbox',
			'label' => __pl('Is Downloadable'),
			'post' => 1,
		),
		'_regular_price' => array(
			'type' => 'spinner',
			'label' => __pl('Regular Price').'('.get_kkart_currency_symbol().')',
			'min' => 0,
			'post' => 1,
		),
		'_sale_price' => array(
			'type' => 'spinner',
			'label' => __pl('Sale Price').'('.get_kkart_currency_symbol().')',
			'min' => 0,
			'post' => 1,
		),
		'sale_time' => array(
			'type' => 'checkbox',
			'label' => __pl('Sale Schedule'),
		),
		'_sale_price_dates_from' => array(
			'type' => 'datetime',
			'label' => __pl('Sale Start Time'),
			'req' => ['sale_time' => 'true'],
			'post' => 1,
		),
		'_sale_price_dates_to' => array(
			'type' => 'datetime',
			'label' => __pl('Sale End Time'),
			'req' => ['sale_time' => 'true'],
			'post' => 1,
		),
		'_downloadable_files' => array(
			'type' => 'downloadable_files',
			'label' => __pl('Downloadable Files'),
			'req' => ['_downloadable' => 'true'],
		),
		'_download_limit' => array(
			'type' => 'text',
			'label' => __pl('Download Limit'),
			'req' => ['_downloadable' => 'true'],
			'desc' => __pl('Leave blank for unlimited re-downloads.'),
		),
		'_download_expiry' => array(
			'type' => 'text',
			'label' => __pl('Download Expiry'),
			'req' => ['_downloadable' => 'true'],
			'desc' => __pl('Enter the number of days before a download link expires, or leave blank.'),
		),
		'_tax_status' => array(
			'type' => 'select',
			'label' => __pl('Tax Status'),
			'list' => array(
				'taxable' => __pl('Taxable'),
				'shipping' => __pl('Shipping Only'),
				'none' => __pl('None'),
			),
			'default' => 'taxable',
			'post' => 1,
		),
		'_tax_class' => array(
			'type' => 'select',
			'label' => __pl('Tax Class'),
			'list' => kkart_get_product_tax_class_options(),
			'default' => 'standard',
			'post' => 1,
		),
	);
	
	$params['kkart_inventory'] = array(
		'_sku' => array(
			'type' => 'text',
			'label' => __pl('SKU (Stock Keeping Unit)'),
			'post' => 1,
		),
		'barcode' => array(
			'type' => 'text',
			'label' => __pl('Barcode (ISBN, UPC, GTIN, etc.)'),
		),
		'_manage_stock' => array(
			'type' => 'checkbox',
			'label' => __pl('Track quantity'),
			'post' => 1,
		),
		'_stock' => array(
			'type' => 'spinner',
			'label' => __pl('Stock quantity'),
			'default' => 1,
			'post' => 1,
			'req' => ['_manage_stock' => 'true'],
		),
		'_backorders' => array(
			'type' => 'select',
			'label' => __pl('Allow backorders?'),
			'post' => 1,
			'list' => array(
				'no' => __pl('Do not allow'),
				'notify' => __pl('Allow, but notify customer'),
				'yes' => __pl('Allow'),
			),
			'req' => ['_manage_stock' => 'true']
		),
		'_low_stock_amount' => array(
			'type' => 'spinner',
			'label' => __pl('Low stock threshold'),
			'default' => 2,
			'post' => 1,
			'req' => ['_manage_stock' => 'true']
		),
		'_stock_status' => array(
			'type' => 'select',
			'label' => __pl('Stock status'),
			'post' => 1,
			'default' => 'instock',
			'list' => array(
				'instock' => __pl('In stock'),
				'outofstock' => __pl('Out Of Stock'),
				'onbackorder' => __pl('On Backorder'),
			),
			'req' => ['_manage_stock' => '']
		),
		'_sold_individually' => array(
			'type' => 'checkbox',
			'label' => __pl('Sold individually'),
			'post' => 1,
		),
	 );
	 
	 $params['kkart_shipping'] = array(
		'_virtual' => array(
			'type' => 'checkbox',
			'label' => __pl('Is Virtual'),
			'post' => 1,	
		),
		'_weight' => array(
			'type' => 'text',
			'label' => __pl('Weight'),
			'post' => 1,
			'req' => ['_virtual' => ''],
		),
		'_length' => array(
			'type' => 'text',
			'label' => __pl('Length'),
			'post' => 1,
			'req' => ['_virtual' => ''],
		),
		'_width' => array(
			'type' => 'text',
			'label' => __pl('Width'),
			'post' => 1,
			'req' => ['_virtual' => ''],
		),
		'_height' => array(
			'type' => 'text',
			'label' => __pl('Height'),
			'post' => 1,
			'req' => ['_virtual' => ''],
		),
	 );
	 
	 $params['kkart_variants'] = array(// TODO: Complite
		'is_variants' => array(
			'type' => 'checkbox',
			'label' => __pl('Is Variants'),
		),
		'product_variants' => array(
			'type' => 'variable_porduct',
			'label' => __pl('Variants'),
		),
	 );
	 
	 $params['kkart_linkedprod'] = array(// TODO: fix
		'upsell' => array(
			'type' => 'text',
			'label' => __pl('Upsell'),
			'post' => 1,
		),
		'cross_sell' => array(
			'type' => 'text',
			'label' => __pl('Cross Sell'),
			'post' => 1,
		),
	 );
	 
	 $params['kkart_advanced'] = array(
		'_purchase_note' => array(
			'type' => 'textarea',
			'label' => __pl('Purchase Note'),
			'post' => 1,
		),
		'menu_order' => array( // TODO: fix
			'type' => 'spinner',
			'label' => __pl('Menu Order'),
			'post' => 1,
		),
		'comment_status' => array(
			'type' => 'checkbox',
			'label' => __pl('Enable Reviews'),
			'post' => 1,
		),
	 );
	 
	 $params['settings']['kkart_gallery'] = __pl('Product Gallery');
	 $params['settings']['kkart_pricing'] = __pl('Product pricing');
	 $params['settings']['kkart_inventory'] = __pl('Product Inventory');
	 $params['settings']['kkart_shipping'] = __pl('Product Shipping');
	 $params['settings']['kkart_variants'] = __pl('Variants');
	 $params['settings']['kkart_linkedprod'] = __pl('Linked Product');
	 $params['settings']['kkart_advanced'] = __pl('Advanced');
	 $params['post_type_cats']['product'] = array('kkart_gallery', 'kkart_pricing', 'kkart_inventory', 'kkart_shipping', 'kkart_variants', 'kkart_linkedprod', 'kkart_advanced' );
	 
	 return $params;
}