<?php
// We need the ABSPATH
if (!defined('ABSPATH')) exit;

global $pagelayer;

// Sidebar
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_sidebar', array(
    'name' => __pl('documentor_sidebar'),
    'group' => 'documentor',
    'html' => '<div class="documentor-sidebar documentor-single">
    <a class="documentor-sidebar-toggler"><i class="fas fa-bars"></i></a>
    <div class="documentor-single-sidebar">
    <div class="documentor-single-sidebar-wrap">
    <form if={{show_search}} role="search" method="get" class="documentor-search-form" action="'. esc_url( home_url( '/' ) ) .'">
    <input type="search" class="documentor-search-field" placeholder="'. esc_attr__( 'Type to search', 'documentor' ) .'" value="'. get_search_query() .'" name="s" autocomplete="off">
    <input type="hidden" name="post_type" value="docs">
    <input if={{hide_parent}} type="hidden" name="child_of" value="'.esc_attr( documentor()->get_current_doc_id() ) .'">    <div class="documentor-dual-ring"></div>
    </form>
    <div class="documentor-search-form-result"></div>
    <div class="documentor_sidebar_nav_list">{{post_html}}</div> 
    </div>
    </div>
    </div>',
    'params' => array(
        'hide_parent' => array(
            'type' => 'checkbox',
            'label' => __pl('hide_parent'),
            'default' => '',
        ),
        'show_child' => array(
            'type' => 'checkbox',
            'label' => __pl('show_child'),
            'default' => 'true',
        ),
        'show_search' => array(
            'type' => 'checkbox',
            'label' => __pl('show_search'),
            'default' => 'true',
        ),
        'hide_count' => array(
            'type' => 'checkbox',
            'label' => __pl('hide_count'),
            'default' => 'true',
            'css' => ['{{element}} .documentor-single-sidebar .documentor-nav-list sup' => 'display:none;'],
        ),
    ),
    'sidebar_styles' => array(
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-nav-list'=> 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}}'=> 'background-color:{{val}}'],
        ),
        'list_style' => array(
            'type' => 'select',
            'label' => __pl('list_style'),
            'np' => 1,
            'default' => 'none',
            'list' => array(
                'none' => __pl('none'),
                'circle' => __pl('list_list_type_circle'),
                'decimal' => __pl('decimal'),
                'square' => __pl('list_list_type_square'),
                'disc' => __pl('list_list_type_disc'),
                'inherit' => __pl('inherit'),
                'upper-roman' => __pl('upper_roman'),
                'upper-alpha' => __pl('upper_alpha'),
                'lower-roman' => __pl('lower_roman'),
                'lower-alpha' => __pl('lower_alpha'),
            ),
            'css' => ['{{element}} .documentor-nav-list li' => 'list-style-type: {{val}};']
        ),
        'link_colors' => array(
            'type' => 'radio',	
            'label' => __pl('colors'),
            'list' => array(
                'normal' => __pl('normal'),
                'hover' => __pl('hover'),
                'active' => __pl('active'),
            ),
        ),
        'link_color' => array(
            'type' => 'color',	
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-nav-list li a, .documentor-nav-list li' => 'color:{{val}} !important'],
            'show' => [ 'link_colors' => 'normal'],
        ),
        'link_hover_color' => array(
            'type' => 'color',	
            'label' => __pl('hover_color'),
            'css' => ['{{element}} .documentor-nav-list li > a:hover, .documentor-nav-list li:hover' => 'color:{{val}} !important'],
            'show' => [ 'link_colors' => 'hover'],
        ),
        'link_current_color' => array(
            'type' => 'color',	
            'label' => __pl('current_color'),
            'css' => ['{{element}} .documentor-nav-list li.current_page_item > a, .documentor-nav-list li.current_page_item' => 'color:{{val}} !important'],
            'show' => [ 'link_colors' => 'active']
        ),
        'padding' => array(
            'type' => 'padding',
            'label' => __pl('padding'),
            'default' => '0,0,0,25',
            'screen' => 1,
            'css' => ['{{element}} .documentor-nav-list' => 'padding-top: {{val[0]}}px !important; padding-right: {{val[1]}}px !important; padding-bottom: {{val[2]}}px !important; padding-left: {{val[3]}}px !important;'],
        ),
        'margin' => array(
            'type' => 'padding',
            'label' => __pl('spacing'),
            'step' => 1,
            'max' => 60,
            'default' => '10',
            'css' => ['{{element}} .documentor-nav-list' => 'margin-top: {{val[0]}}px !important; margin-right: {{val[1]}}px !important; margin-bottom: {{val[2]}}px !important; margin-left: {{val[3]}}px !important'],
        ),
    ),
    'count_styles' => array(
        'ctypo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-nav-list li ul.children a sup'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'count_style_bg' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-nav-list li ul.children a sup' => 'background:{{val}}']
        ),
        'count_style_color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-nav-list li ul.children a sup' => 'color:{{val}}']
        ),
    ),
    'search_style' => array(
        'stypo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-search-form'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'sbgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-search-form'=> 'background-color:{{val}}'],
        ),
        'scolor' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-search-form '=> 'color:{{val}}'],
        ),
        'swidth' => array(
            'type' => 'slider',
            'label' => __pl('width'),
            'units' => ['%', 'px'],
            'min' => 0,
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-form' => 'width: {{val}} !important'],
        ),
        'sheight' => array(
            'type' => 'slider',
            'label' => __pl('height'),
            'units' => ['%', 'px'],
            'min' => 0,
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-form' => 'height: {{val}} !important'],
        ),
        'spadding' => array(
            'type' => 'padding',
            'label' => __pl('padding'),
            'default' => '0,0,0,0',
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-form' => 'padding-top: {{val[0]}}px !important; padding-right: {{val[1]}}px !important; padding-bottom: {{val[2]}}px !important; padding-left: {{val[3]}}px !important;'],
        ),
        'smargin' => array(
            'type' => 'padding',
            'label' => __pl('margin'),
            'step' => 1,
            'max' => 60,
            'default' => '0,0,0,0',
            'css' => ['{{element}} .documentor-search-form' => 'margin-top: {{val[0]}}px !important; margin-right: {{val[1]}}px !important; margin-bottom: {{val[2]}}px !important; margin-left: {{val[3]}}px !important'],
        ),
        'sbox_shadow' => array(
            'type' => 'box_shadow',
            'label' => __pl('box_shadow'),
            'css' => ['{{element}} .documentor-search-form .documentor-search-field' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
        ),
        'sbox_bor_hover' => array(
            'type' => 'radio',
            'label' => __pl('state'),
            'list' => array(
                '' => __pl('normal'),
                'hover' => __pl('hover'),
            )
        ),	
        'sbox_border_type' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-search-form .documentor-search-field' => 'border-style: {{val}} !important;',
                ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'sbox_bor_hover' => ''
            ),
        ),
        'sbox_border_color' => array(
            'type' => 'color',
            'label' => __pl('border_color_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-search-form .documentor-search-field' => 'border-color: {{val}} !important;'],
            'req' => array(
                '!sbox_border_type' => ''
            ),
            'show' => array(
                'sbox_bor_hover' => ''
            ),
        ),
        'sbox_border_width' => array(
            'type' => 'padding',
            'label' => __pl('border_width'),
            'screen' => 1,
            'default' => '1,1,1,1',
            'css' => ['{{element}} .documentor-search-form .documentor-search-field' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important'],
            'req' => [
                '!sbox_border_type' => ''
            ],
            'show' => array(
                'sbox_bor_hover' => ''
            ),
        ),
        'sbox_border_radius' => array(
            'type' => 'padding',
            'label' => __pl('border_radius'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-form .documentor-search-field' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'sbox_bor_hover' => '',
            ),
        ),
        'sbox_border_type_hover' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-search-form .documentor-search-field:hover' => 'border-style: {{val}} !important',	
            ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'sbox_bor_hover' => 'hover'
            ),
        ),
        'sbox_border_color_hover' => array(
            'type' => 'color',
            'label' => __pl('border_color_hover_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-search-form .documentor-search-field:hover' => 'border-color: {{val}} !important'],
            'req' => array(
                '!sbox_border_type_hover' => ''
            ),
            'show' => array(
                'sbox_bor_hover' => 'hover'
            ),
        ),
        'sbox_border_width_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_width_hover'),
            'default' => '1,1,1,1',
            'screen' => 1,
            'css' => [
                '{{element}} .documentor-search-form .documentor-search-field:hover' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important;'
            ],
            'req' => [
                '!sbox_border_type_hover' => ''
            ],
            'show' => array(
                'sbox_bor_hover' => 'hover'
            ),
        ),
        'sbox_border_radius_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_radius_hover'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-form .documentor-search-field:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'sbox_bor_hover' => 'hover',	
            ),
        ),
    ),
    'styles' => array(
        'params' => __pl('sidebar_settings'),
        'sidebar_styles' => __pl('sidebar_styles'),
        'count_styles' => __pl('count_styles'),
        'search_style' => __pl('search_style'),
    ),

));

//Footer
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_footer', array(
    'name' => __pl('documentor_footer'),
    'group' => 'documentor',
    'html' => '<div class="documentor-footer">
    <footer class="entry-footer">
        <div if="{{show_author}}" itemprop="author" itemscope itemtype="https://schema.org/Person">
            <meta itemprop="name" content="'. esc_attr( get_the_author() ) .'" />
            <meta itemprop="url" content="'. esc_attr( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) .'" />
        </div>
        <meta if="{{show_time}}" itemprop="datePublished" content="'. esc_attr( get_the_time( 'c' ) ).'"/>  
        <time if="{{show_date}}" itemprop="dateModified" datetime="'.esc_attr( get_the_modified_date( 'c' ) ) .'">'. 
        sprintf( esc_html__( 'Last modified %s', 'documentor' ), esc_html( get_the_modified_date() ) ).'
        </time>
    </footer>
    </div>',
    'params' => array(
        'show_author' => array(
            'type' => 'checkbox',
            'label' => __pl('show_author'),
            'default' => 'true',
        ),
        'show_date' => array(
            'type' => 'checkbox',
            'label' => __pl('show_date'),
            'default' => 'true',
        ),
        'show_time' => array(
            'type' => 'checkbox',
            'label' => __pl('show_time'),
            'default' => 'true',
        ),
    ),
    'text_styles' => array(
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-footer'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-footer '=> 'background-color:{{val}}'],
            'show' => ['state' => ""],
        ),
        'color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-footer'=> 'color:{{val}}'],
            'show' => ['state' => ""],
        ),
        'align' => array(
            'type' => 'select',
            'label' => __pl('align'),
            'css' => ['{{element}} .documentor-footer footer'=> 'text-align:{{val}}'],
            'list' => array(
                '' => __pl('Left'),
                'center' => __pl('center'),
                'right' => __pl('right '),
            ),
        ),
    ),
    'styles' => array(
        'text_styles' => __pl('text_styles')
    ),

));

//Breadcrumb
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_breadcrumbs', array(
    'name' => __pl('documentor_breadcrumb'),
    'group' => 'documentor',
    'addClass' => 'documentor-single',
    'html' => '<div class="documentor-breadcrumbs">
    <ul class="documentor-single-breadcrumbs" itemscope itemtype="http://schema.org/BreadcrumbList">
    <a class="documentor-sidebar-toggler"><i class="fas fa-bars"></i></a>
    {{post_html}}
    </ul>
    </div>',
    'params' => array(
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-single-breadcrumbs'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-single-breadcrumbs'=> 'background-color:{{val}}'],
        ),
        'state' => array(
            'type' => 'radio',
            'label' => __pl('state'),
            'default' => '',
            'list' => array(
                '' => __pl('normal'),
                'hover' => __pl('hover'),
            )
        ),
        'abgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-single-breadcrumbs a'=> 'background-color:{{val}}'],
            'show' => ['state' => ""],
        ),
        'acolor' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-single-breadcrumbs a'=> 'color:{{val}}'],
            'show' => ['state' => ""],
        ),
        'abgcolor_hover' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-single-breadcrumbs a:hover'=> 'background-color:{{val}}'],
            'show' => ['state' => "hover"],
        ),
        'acolor_hover' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-single-breadcrumbs a:hover'=> 'color:{{val}}'],
            'show' => ['state' => "hover"],
        ),
        'align' => array(
            'type' => 'select',
            'label' => __pl('align'),
            'css' => ['{{element}} .documentor-single-breadcrumbs'=> 'text-align:{{val}}'],
            'list' => array(
                '' => __pl('Left'),
                'center' => __pl('center'),
                'right' => __pl('right '),
            ),
        ),
    ),
    'separator_style' => [
        'separator' => array(
            'type' => 'text',
            'label' => __pl('separator_style'),
            'default' => '/',
        ),
        'separator_color' => array(
            'type' => 'color',
            'label' => __pl('color'),				
            'np' => 1,
            'default' => '#333333',
            'css' => ['{{element}} .delimiter' => 'color:{{val}};']
        ),
    ],
    'styles' => [
        'params' => __pl('breadcrumb'),
        'separator_style' => __pl('separator_style'),
    ]

));

//Feedback
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_feedback', array(
    'name' => __pl('documentor_feedback'),
    'group' => 'documentor',
    'html' => '<div class="documentor-feedback">
    <div class="documentor-single-feedback">
    <div>{{question}}</div>
    <div class="documentor-single-feedback-vote">
    <a href="#" class="documentor-btn" data-id="'. get_the_ID() .'" data-type="positive" title="{{positive_title}}">'.esc_html__( 'Yes', 'documentor' ).'
    {{pcount}}</a>
    <a href="#" class="documentor-btn" data-id="'. get_the_ID() .'" data-type="negative" title="{{negative_title}}">'.esc_html__( 'No', 'documentor' ).'
    {{ncount}}</a>
    </div></div>
    </div>',
    'params' => array(
        'positive_title' => array(
            'type' => 'text',
            'label' => __pl('positive_title'),
            'default' => 'person found this useful',
        ),
        'negative_title' => array(
            'type' => 'text',
            'label' => __pl('negative_title'),
            'default' => 'persons found this not useful',
        ),
        'no_votes' => array(
            'type' => 'text',
            'label' => __pl('no_votes'),
            'default' => 'No votes yet',
        ),
        'question' => array(
            'type' => 'text',
            'label' => __pl('question'),
            'default' => 'Was this page helpful?',
        ),
        'show_counts' => array(
            'type' => 'checkbox',
            'label' => __pl('show_counts'),
            'default' => 'true',
        ),

    ),
    'link_styles' => array(
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-feedback'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-feedback'=> 'color:{{val}}'],
        ),
        'bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-feedback'=> 'background-color:{{val}}'],
        ),
        'padding' => array(
            'type' => 'padding',
            'label' => __pl('padding'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-feedback' => 'padding-top: {{val[0]}}px !important; padding-right: {{val[1]}}px !important; padding-bottom: {{val[2]}}px !important; padding-left: {{val[3]}}px !important;'],
        ),
        'margin' => array(
            'type' => 'padding',
            'label' => __pl('margin'),
            'step' => 1,
            'max' => 60,
            'css' => ['{{element}} .documentor-feedback' => 'margin-top: {{val[0]}}px !important; margin-right: {{val[1]}}px !important; margin-bottom: {{val[2]}}px !important; margin-left: {{val[3]}}px !important'],
        ),

    ),
    'p_styles' => array(
        'plink_colors' => array(
            'type' => 'radio',	
            'label' => __pl('positive_btn_colors'),
            'list' => array(
                'normal' => __pl('normal'),
                'hover' => __pl('hover'),
            ),
        ),
        'plink_color' => array(
            'type' => 'color',	
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-btn[data-type="positive"], .documentor-btn[data-type="positive"] .badge' => 'color:{{val}}'],
            'show' => [ 'plink_colors' => 'normal'],
        ),
        'pbgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-btn[data-type="positive"]'=> 'background-color:{{val}}'],
            'show' => [ 'plink_colors' => 'normal'],
        ),
        'plink_hover_color' => array(
            'type' => 'color',	
            'label' => __pl('hover_color'),
            'css' => ['{{element}} .documentor-btn[data-type="positive"]:hover, .documentor-btn[data-type="positive"]:hover .badge' => 'color:{{val}}'],
            'show' => [ 'plink_colors' => 'hover'],
        ),
        'pbgcolor_hover' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-btn[data-type="positive"]:hover'=> 'background-color:{{val}}'],
            'show' => [ 'plink_colors' => 'hover'],
        ),
        'ppadding' => array(
            'type' => 'padding',
            'label' => __pl('padding'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-btn[data-type="positive"]' => 'padding-top: {{val[0]}}px !important; padding-right: {{val[1]}}px !important; padding-bottom: {{val[2]}}px !important; padding-left: {{val[3]}}px !important;'],
        ),
        'pmargin' => array(
            'type' => 'padding',
            'label' => __pl('margin'),
            'step' => 1,
            'max' => 60,
            'css' => ['{{element}} .documentor-btn[data-type="positive"] ' => 'margin-top: {{val[0]}}px !important; margin-right: {{val[1]}}px !important; margin-bottom: {{val[2]}}px !important; margin-left: {{val[3]}}px !important'],
        ),
    ),
    'n_styles' => array(
        'nlink_colors' => array(
            'type' => 'radio',	
            'label' => __pl('negative_btn_colors'),
            'list' => array(
                'normal' => __pl('normal'),
                'hover' => __pl('hover'),
            ),
        ),
        'nlink_color' => array(
            'type' => 'color',	
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-btn[data-type="negative"], .documentor-btn[data-type="negative"] .badge' => 'color:{{val}}'],
            'show' => [ 'nlink_colors' => 'normal'],
        ),
        'nbgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-btn[data-type="negative"]'=> 'background-color:{{val}}'],
            'show' => [ 'nlink_colors' => 'normal'],
        ),
        'nlink_hover_color' => array(
            'type' => 'color',	
            'label' => __pl('hover_color'),
            'css' => ['{{element}} .documentor-btn[data-type="negative"]:hover, .documentor-btn[data-type="negative"]:hover .badge' => 'color:{{val}}'],
            'show' => [ 'nlink_colors' => 'hover'],
        ),
        'nbgcolor_hover' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-btn[data-type="negative"]:hover'=> 'background-color:{{val}}'],
            'show' => [ 'nlink_colors' => 'hover'],
        ),
        'npadding' => array(
            'type' => 'padding',
            'label' => __pl('padding'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-btn[data-type="negative"]' => 'padding-top: {{val[0]}}px !important; padding-right: {{val[1]}}px !important; padding-bottom: {{val[2]}}px !important; padding-left: {{val[3]}}px !important;'],
        ),
        'nmargin' => array(
            'type' => 'padding',
            'label' => __pl('margin'),
            'step' => 1,
            'max' => 60,
            'css' => ['{{element}} .documentor-btn[data-type="negative"] ' => 'margin-top: {{val[0]}}px !important; margin-right: {{val[1]}}px !important; margin-bottom: {{val[2]}}px !important; margin-left: {{val[3]}}px !important'],
        ),
    ),
    'styles' => array(
        'params' => __pl('feedback_settings'),
        'link_styles' => __pl('feedback_styles'),
        'p_styles' => __pl('positive_styles'),
        'n_styles' => __pl('negative_styles'),
    ),

));

//Feedback Suggestion
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_article', array(
    'name' => __pl('documentor_article'),
    'group' => 'documentor',
    'html' => '<div class="documentor-article">
    <h3 if={{heading}}>{{heading}}<br></h3>
    <div class="documentor-single-articles">
    <ul>{{post_html}}</ul>
    </div>
    </div>',
    'params' => array(
        'heading' => array(
            'type' => 'text',
            'label' => __pl('heading'),
        ),
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-single-articles, {{element}} h3'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-single-articles'=> 'background-color:{{val}}'],
        ),
        'color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-single-articles li  a, {{element}} h3'=> 'color:{{val}} !important'],
        ),
        'hvcolor' => array(
            'type' => 'color',
            'label' => __pl('hover_color'),
            'css' => ['{{element}} .documentor-single-articles a:hover'=> 'color:{{val}} !important'],
        ),
        'align' => array(
            'type' => 'select',
            'label' => __pl('align'),
            'css' => ['{{element}} h3'=> 'text-align:{{val}}'],
            'list' => array(
                '' => __pl('Left'),
                'center' => __pl('center'),
                'right' => __pl('right '),
            ),
        ),
        'box_shadow' => array(
            'type' => 'box_shadow',
            'label' => __pl('box_shadow'),
            'css' => ['{{element}} .documentor-single-articles li a' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
        ),
        'btn_bor_hover' => array(
            'type' => 'radio',
            'label' => __pl('state'),
            'list' => array(
                '' => __pl('normal'),
                'hover' => __pl('hover'),
            )
        ),	
        'btn_border_type' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-single-articles li  a' => 'border-style: {{val}} !important;',
                ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'btn_bor_hover' => ''
            ),
        ),
        'btn_border_color' => array(
            'type' => 'color',
            'label' => __pl('border_color_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-single-articles li  a' => 'border-color: {{val}} !important;'],
            'req' => array(
                '!btn_border_type' => ''
            ),
            'show' => array(
                'btn_bor_hover' => ''
            ),
        ),
        'btn_border_width' => array(
            'type' => 'padding',
            'label' => __pl('border_width'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-single-articles li  a' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important;'],
            'req' => [
                '!btn_border_type' => ''
            ],
            'show' => array(
                'btn_bor_hover' => ''
            ),
        ),
        'btn_border_radius' => array(
            'type' => 'padding',
            'label' => __pl('border_radius'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-single-articles li  a' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px !important; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px !important;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px !important;'],
            'show' => array(
                'btn_bor_hover' => '',
            ),
        ),
        'btn_border_type_hover' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-single-articles li  a:hover' => 'border-style: {{val}} !important;',	
            ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'btn_bor_hover' => 'hover'
            ),
        ),
        'btn_border_color_hover' => array(
            'type' => 'color',
            'label' => __pl('border_color_hover_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-single-articles li  a:hover' => 'border-color: {{val}} !important;'],
            'req' => array(
                '!btn_border_type_hover' => ''
            ),
            'show' => array(
                'btn_bor_hover' => 'hover'
            ),
        ),
        'btn_border_width_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_width_hover'),
            'screen' => 1,
            'css' => [
                '{{element}} .documentor-single-articles li  a:hover' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important;'
            ],
            'req' => [
                '!btn_border_type_hover' => ''
            ],
            'show' => array(
                'btn_bor_hover' => 'hover'
            ),
        ),
        'btn_border_radius_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_radius_hover'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-single-articles li  a:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px !important; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px !important;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px !important;'],
            'show' => array(
                'btn_bor_hover' => 'hover',	
            ),
        ),
    )

));

//Adjacent Links
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_adjacent_links', array(
    'name' => __pl('documentor_adjacent_links'),
    'group' => 'documentor',
    'html' => '<div class="documentor-adjacent-links">{{post_html}}</div>',
    'params' => array(
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-btn'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'link_colors' => array(
            'type' => 'radio',	
            'label' => __pl('colors'),
            'default' => 'normal',
            'list' => array(
                'normal' => __pl('normal'),
                'hover' => __pl('hover'),
            ),
        ),
        'bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-btn'=> 'background-color:{{val}}'],
            'show' => [ 'link_colors' => 'normal'],
        ),
        'color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-btn'=> 'color:{{val}}'],
            'show' => [ 'link_colors' => 'normal'],
        ),
        'bgcolor_hover' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-btn:hover'=> 'background-color:{{val}}'],
            'show' => [ 'link_colors' => 'hover'],
        ),
        'color_hover' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-btn:hover'=> 'color:{{val}}'],
            'show' => [ 'link_colors' => 'hover'],
        ),
        'link_rotate' => array(
			'type' => 'spinner',
			'label' => __pl('Rotate'),
            'addClass' => 'documentor_rotated_link',
			'min' => 0,
			'max' => 360,
			'step' => 1,
			'screen' => 1,
			'css' => ['{{element}}' => 'transform: rotate({{val}}deg)'],
		),
        'box_shadow' => array(
            'type' => 'box_shadow',
            'label' => __pl('box_shadow'),
            'css' => ['{{element}} .documentor-btn' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
        ),
        'btn_bor_hover' => array(
            'type' => 'radio',
            'label' => __pl('state'),
            'list' => array(
                '' => __pl('normal'),
                'hover' => __pl('hover'),
            )
        ),	
        'btn_border_type' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-btn' => 'border-style: {{val}};',
                ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'btn_bor_hover' => ''
            ),
        ),
        'btn_border_color' => array(
            'type' => 'color',
            'label' => __pl('border_color_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-btn' => 'border-color: {{val}};'],
            'req' => array(
                '!btn_border_type' => ''
            ),
            'show' => array(
                'btn_bor_hover' => ''
            ),
        ),
        'btn_border_width' => array(
            'type' => 'padding',
            'label' => __pl('border_width'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-btn' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
            'req' => [
                '!btn_border_type' => ''
            ],
            'show' => array(
                'btn_bor_hover' => ''
            ),
        ),
        'btn_border_radius' => array(
            'type' => 'padding',
            'label' => __pl('border_radius'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-btn' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'btn_bor_hover' => '',
            ),
        ),
        'btn_border_type_hover' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-btn:hover' => 'border-style: {{val}}',	
            ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'btn_bor_hover' => 'hover'
            ),
        ),
        'btn_border_color_hover' => array(
            'type' => 'color',
            'label' => __pl('border_color_hover_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-btn:hover' => 'border-color: {{val}};'],
            'req' => array(
                '!btn_border_type_hover' => ''
            ),
            'show' => array(
                'btn_bor_hover' => 'hover'
            ),
        ),
        'btn_border_width_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_width_hover'),
            'screen' => 1,
            'css' => [
                '{{element}} .documentor-btn:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px;'
            ],
            'req' => [
                '!btn_border_type_hover' => ''
            ],
            'show' => array(
                'btn_bor_hover' => 'hover'
            ),
        ),
        'btn_border_radius_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_radius_hover'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-btn:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'btn_bor_hover' => 'hover',	
            ),
        ),
    )

));

//Title
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_title', array(
    'name' => __pl('documentor_title'),
    'group' => 'documentor',
    'html' => '<div class="documentor-title"><h1>{{title}}</h1></div>',
    'params' => array(
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-title h1'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-title h1'=> 'background-color:{{val}} !important;'],
        ),
        'color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-title h1'=> 'color:{{val}} !important;'],
        ),
    )

));

// Archive Box
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_archive_box', array(
    'name' => __pl('documentor_archive_box'),
    'group' => 'documentor',
    'html' => '<div class="documentor-archive-box documentor-archive"><ul class="documentor-archive-list">{{post_html}}</ul></div>',
    'params' => array(
        'show_articles' => array(
            'type' => 'checkbox',
            'label' => __pl('show_articles'),
            'default' => 'true',
        ),
        'articles_depth' => array(
            'type' => 'text',
            'label' => __pl('articles_depth'),
            'default' => '1',
            // 'desc' => 'Accepts -1 (any depth), 0 (all pages), 1 (top-level pages only), and n (pages to the given n depth)',
        ),
        'hide_count' => array(
            'type' => 'checkbox',
            'label' => __pl('hide_count'),
            'default' => 'true',
            'css' => ['{{element}} .documentor-nav-list sup' => 'display:none;'],
        ),
        'columns' => array(
            'type' => 'select',
            'label' => __pl('columns_count'),
            'default' => 3,
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list' => 'display: grid; grid-template-columns: repeat({{val}},1fr);'],
            'list' => array(
                1 => __pl('1'),
                2 => __pl('2'),
                3 => __pl('3'),
                4 => __pl('4'),
                5 => __pl('5'),
                6 => __pl('6'),
                7=> __pl('7'),
                8 => __pl('8'),
                9 => __pl('9'),
                10 => __pl('10')
            )
        ),
        'col_gap' => array(
            'type' => 'slider',
            'label' => __pl('col_gap'),
            'min' => 0,
            'step' => 1,
            'max' => 100,
            'default' => 0,
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list' => 'grid-column-gap: {{val}}px;'],
        ),
        'row_gap' => array(
            'type' => 'slider',
            'label' => __pl('row_gap'),
            'min' => 0,
            'step' => 1,
            'max' => 100,
            'default' => 0,
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list' => 'grid-row-gap: {{val}}px;'],
        ),
    ),
    'box_style' => array(
        'box_bor_hover' => array(
            'type' => 'radio',
            'label' => __pl('state'),
            'list' => array(
                '' => __pl('normal'),
                'hover' => __pl('hover'),
            )
        ),
        'box_shadow' => array(
            'type' => 'box_shadow',
            'label' => __pl('box_shadow'),
            'css' => ['{{element}} .documentor-archive-list-item' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
            'show' => array(
                'box_bor_hover' => ''
            ),
        ),	
        'box_border_type' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-archive-list-item' => 'border-style: {{val}} !important;',
                ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'box_bor_hover' => ''
            ),
        ),
        'box_border_color' => array(
            'type' => 'color',
            'label' => __pl('border_color_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-archive-list-item' => 'border-color: {{val}} !important;'],
            'req' => array(
                '!box_border_type' => ''
            ),
            'show' => array(
                'box_bor_hover' => ''
            ),
        ),
        'box_border_width' => array(
            'type' => 'padding',
            'label' => __pl('border_width'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list-item' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important'],
            'req' => [
                '!box_border_type' => ''
            ],
            'show' => array(
                'box_bor_hover' => ''
            ),
        ),
        'box_border_radius' => array(
            'type' => 'padding',
            'label' => __pl('border_radius'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list-item' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'box_bor_hover' => '',
            ),
        ),
        'box_shadow_hover' => array(
            'type' => 'box_shadow',
            'label' => __pl('box_shadow'),
            'css' => ['{{element}} .documentor-archive-list-item:hover' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
            'show' => array(
                'box_bor_hover' => 'hover'
            ),
        ),
        'box_border_type_hover' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-archive-list-item:hover' => 'border-style: {{val}} !important',	
            ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'box_bor_hover' => 'hover'
            ),
        ),
        'box_border_color_hover' => array(
            'type' => 'color',
            'label' => __pl('border_color_hover_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-archive-list-item:hover' => 'border-color: {{val}} !important;'],
            'req' => array(
                '!box_border_type_hover' => ''
            ),
            'show' => array(
                'box_bor_hover' => 'hover'
            ),
        ),
        'box_border_width_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_width_hover'),
            'screen' => 1,
            'css' => [
                '{{element}} .documentor-archive-list-item:hover' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important;'
            ],
            'req' => [
                '!box_border_type_hover' => ''
            ],
            'show' => array(
                'box_bor_hover' => 'hover'
            ),
        ),
        'box_border_radius_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_radius_hover'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list-item:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'box_bor_hover' => 'hover',	
            ),
        ),
    ),
    'category_style' => array(
        'cat_typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-archive-list .documentor-archive-list-category'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'cat_color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-archive-list .documentor-archive-list-category'=> 'color:{{val}}'],
        ),
        'cat_hover_color' => array(
            'type' => 'color',
            'label' => __pl('hover_color'),
            'css' => ['{{element}} .documentor-archive-list .documentor-archive-list-category:hover'=> 'color:{{val}}'],
        ),
    ),
    'heading_styles' => array(
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-archive-list > .documentor-archive-list-item .documentor-archive-list-item-title > span h2,.documentor-archive-list > .documentor-archive-list-item .documentor-archive-list-item-title > span span'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-archive-list > .documentor-archive-list-item .documentor-archive-list-item-title > span h2'=> 'color:{{val}}'],
        ),
        'hover_color' => array(
            'type' => 'color',
            'label' => __pl('hover_color'),
            'css' => ['{{element}} .documentor-archive-list > .documentor-archive-list-item .documentor-archive-list-item-title:hover > span h2'=> 'color:{{val}}'],
        ),
        'countcolor' => array(
            'type' => 'color',
            'label' => __pl('count_color'),
            'css' => ['{{element}} .documentor-archive-list > .documentor-archive-list-item .documentor-archive-list-item-title > span span'=> 'color:{{val}}'],
        ),
        'hicon' => array(
            'type' => 'icon',
            'label' => __pl('icon'),
            'default' => 'fas fa-bars',
        ),
        'hicon_color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-archive-list .documentor-archive-list-item-title i' => 'color:{{val}}'],
        ),
        'hicon_size' => array(
            'type' => 'slider',
            'label' => __pl('size'),
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list .documentor-archive-list-item-title  i' => 'font-size: {{val}}px;'],
        ),
        'hicon_space' => array(
            'type' => 'slider',
            'label' => __pl('icon_spacing'),
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list .documentor-archive-list-item-title i' => 'padding-right: {{val}}px;'],
        ),
        'hcount_space' => array(
            'type' => 'slider',
            'label' => __pl('count_spacing'),
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list > .documentor-archive-list-item .documentor-archive-list-item-title > span span' => 'padding-bottom: {{val}}px;'],
        ),
        'hpadding' => array(
            'type' => 'padding',
            'label' => __pl('padding'),
            'default' => '0,0,0,0',
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list > .documentor-archive-list-item .documentor-archive-list-item-title > span' => 'padding-top: {{val[0]}}px !important; padding-right: {{val[1]}}px !important; padding-bottom: {{val[2]}}px !important; padding-left: {{val[3]}}px !important;'],
        ),
        'hmargin' => array(
            'type' => 'padding',
            'label' => __pl('margin'),
            'step' => 1,
            'max' => 60,
            'default' => '0,0,0,0',
            'css' => ['{{element}} .documentor-archive-list-item .documentor-archive-list-item-title > span ' => 'margin-top: {{val[0]}}px !important; margin-right: {{val[1]}}px !important; margin-bottom: {{val[2]}}px !important; margin-left: {{val[3]}}px !important'],
        ),

    ),
    'list_styles' => array(
        'ltypo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-archive-list  .documentor-archive-list-item li a'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'list_style' => array(
            'type' => 'select',
            'label' => __pl('list_style'),
            'np' => 1,
            'default' => 'none',
            'list' => array(
                'none' => __pl('none'),
                'circle' => __pl('list_list_type_circle'),
                'decimal' => __pl('decimal'),
                'square' => __pl('list_list_type_square'),
                'disc' => __pl('list_list_type_disc'),
                'inherit' => __pl('inherit'),
                'upper-roman' => __pl('upper_roman'),
                'upper-alpha' => __pl('upper_alpha'),
                'lower-roman' => __pl('lower_roman'),
                'lower-alpha' => __pl('lower_alpha'),
                '' => __pl('custom'),
            ),
            'css' => ['{{element}} .documentor-archive-list .home_page_cats li' => 'list-style-type: {{val}};']
        ),
        'icon' => array(
            'type' => 'icon',
            'label' => __pl('icon'),
            'default' => 'fas fa-bars',
            'req' => ['list_style'=> ''],
        ),
        'icon_color' => array(
            'type' => 'color',
            'label' => __pl('icon_color'),
            'css' => ['{{element}} .documentor-archive-list .home_page_cats li a i' => 'color:{{val}}'],
            'req' => ['list_style'=> ''],
        ),
        'icon_size' => array(
            'type' => 'slider',
            'label' => __pl('size'),
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list .home_page_cats li a i' => 'font-size: {{val}}px;'],
            'req' => ['list_style'=> ''],
        ),
        'icon_space' => array(
            'type' => 'slider',
            'label' => __pl('icon_spacing'),
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list .home_page_cats li a i' => 'padding-right: {{val}}px;'],
            'req' => ['list_style'=> ''],
        ),
        'padding' => array(
            'type' => 'padding',
            'label' => __pl('padding'),
            'default' => '0,0,0,0',
            'screen' => 1,
            'css' => ['{{element}} .documentor-archive-list .home_page_cats li' => 'padding-top: {{val[0]}}px !important; padding-right: {{val[1]}}px !important; padding-bottom: {{val[2]}}px !important; padding-left: {{val[3]}}px !important;'],
        ),
        'margin' => array(
            'type' => 'padding',
            'label' => __pl('margin'),
            'step' => 1,
            'max' => 60,
            'default' => '0,0,0,0',
            'css' => ['{{element}} .documentor-archive-list .home_page_cats li' => 'margin-top: {{val[0]}}px !important; margin-right: {{val[1]}}px !important; margin-bottom: {{val[2]}}px !important; margin-left: {{val[3]}}px !important'],
        ),
        'link_colors' => array(
            'type' => 'radio',	
            'label' => __pl('colors'),
            'list' => array(
                'normal' => __pl('normal'),
                'hover' => __pl('hover'),
            ),
        ),
        'link_color' => array(
            'type' => 'color',	
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-archive-list .home_page_cats a' => 'color:{{val}}',
                     '.documentor-archive-list .home_page_cats a:before ' => 'background-color:{{val}}'],
            'show' => [ 'link_colors' => 'normal'],
        ),
        'bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-archive-list > .documentor-archive-list-item .home_page_cats a'=> 'background-color:{{val}}'],
            'show' => [ 'link_colors' => 'normal'],
        ),
        'link_hover_color' => array(
            'type' => 'color',	
            'label' => __pl('hover_color'),
            'css' => ['{{element}} .documentor-archive-list .home_page_cats a:hover' => 'color:{{val}}',
                     '.documentor-archive-list .home_page_cats a:hover:before ' => 'background-color:{{val}}'],
            'show' => [ 'link_colors' => 'hover'],
        ),
        'bgcolor_hover' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-archive-list > .documentor-archive-list-item .home_page_cats a:hover'=> 'background-color:{{val}}'],
            'show' => [ 'link_colors' => 'hover'],
        ),
    ),
    'count_styles' => array(
        'ctypo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}}  .documentor-archive-list .home_page_cats a sup'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'count_style_bg' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}}  .documentor-archive-list .home_page_cats a sup' => 'background:{{val}}']
        ),
        'count_style_color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}}  .documentor-archive-list .home_page_cats a sup' => 'color:{{val}}']
        ),
    ),
    'styles' => array(
        'params' => __pl('archive_box'),
        'box_style' => __pl('box_style'),
        'category_style' => __pl('category_styles'),
        'heading_styles' => __pl('heading_styles'),
        'list_styles' => __pl('list_styles'),
        'count_styles' => __pl('count_styles'),
    ),

));

//Search Box
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_search_box', array(
    'name' => __pl('documentor_search'),
    'group' => 'documentor',
    'html' => '<div class="documentor-search-box documentor-archive">
    <div class="home_search" style="text-align:center;">
    <form role="search" method="get" class="documentor-search-form width_control" action="">
    <input type="search" class="documentor-search-field search_form_index" placeholder="'. esc_attr__( 'Type to search', 'documentor' ) .'" value="'. get_search_query() .'" name="s" autocomplete="off">
    <input type="hidden" name="post_type" value="docs">
    <div class="documentor-dual-ring"></div></form>
    <div class="documentor-search-form-result search_on_index"></div></div></div>',
    'params' => array(
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-search-box .documentor-search-form'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-search-box .documentor-search-form'=> 'background-color:{{val}}'],
        ),
        'color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-search-box .documentor-search-form '=> 'color:{{val}}'],
        ),
        'width' => array(
            'type' => 'slider',
            'label' => __pl('width'),
            'units' => ['%', 'px'],
            'min' => 0,
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-box .documentor-search-form' => 'width: {{val}} !important'],
        ),
        'height' => array(
            'type' => 'slider',
            'label' => __pl('height'),
            'units' => ['%', 'px'],
            'min' => 0,
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-box .documentor-search-form' => 'height: {{val}} !important'],
        ),
        'padding' => array(
            'type' => 'padding',
            'label' => __pl('padding'),
            'default' => '0,0,0,0',
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-box .documentor-search-form' => 'padding-top: {{val[0]}}px !important; padding-right: {{val[1]}}px !important; padding-bottom: {{val[2]}}px !important; padding-left: {{val[3]}}px !important;'],
        ),
        'margin' => array(
            'type' => 'padding',
            'label' => __pl('margin'),
            'step' => 1,
            'max' => 60,
            'default' => '0,0,0,0',
            'css' => ['{{element}} .documentor-search-box .documentor-search-form' => 'margin-top: {{val[0]}}px !important; margin-right: {{val[1]}}px !important; margin-bottom: {{val[2]}}px !important; margin-left: {{val[3]}}px !important'],
        ),
        'align' => array(
            'type' => 'select',
            'label' => __pl('align'),
            'css' => ['{{element}} .documentor-search-box .home_search'=> 'display:flex; flex-wrap: wrap; justify-content:{{val}};'],
            'list' => array(
                '' => __pl('Left'),
                'center' => __pl('center'),
                'right' => __pl('right '),
            ),
        ),
        'box_shadow' => array(
            'type' => 'box_shadow',
            'label' => __pl('box_shadow'),
            'css' => ['{{element}} .documentor-search-form' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
        ),
        'box_bor_hover' => array(
            'type' => 'radio',
            'label' => __pl('state'),
            'list' => array(
                '' => __pl('normal'),
                'hover' => __pl('hover'),
            )
        ),	
        'box_border_type' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-search-form' => 'border-style: {{val}} !important;',
                ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'box_bor_hover' => ''
            ),
        ),
        'box_border_color' => array(
            'type' => 'color',
            'label' => __pl('border_color_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-search-form' => 'border-color: {{val}} !important;'],
            'req' => array(
                '!box_border_type' => ''
            ),
            'show' => array(
                'box_bor_hover' => ''
            ),
        ),
        'box_border_width' => array(
            'type' => 'padding',
            'label' => __pl('border_width'),
            'screen' => 1,
            'default' => '1,1,1,1',
            'css' => ['{{element}} .documentor-search-form' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important'],
            'req' => [
                '!box_border_type' => ''
            ],
            'show' => array(
                'box_bor_hover' => ''
            ),
        ),
        'box_border_radius' => array(
            'type' => 'padding',
            'label' => __pl('border_radius'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-form' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'box_bor_hover' => '',
            ),
        ),
        'box_border_type_hover' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-search-form:hover' => 'border-style: {{val}} !important',	
            ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'box_bor_hover' => 'hover'
            ),
        ),
        'box_border_color_hover' => array(
            'type' => 'color',
            'label' => __pl('border_color_hover_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-search-form:hover' => 'border-color: {{val}} !important'],
            'req' => array(
                '!box_border_type_hover' => ''
            ),
            'show' => array(
                'box_bor_hover' => 'hover'
            ),
        ),
        'box_border_width_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_width_hover'),
            'default' => '1,1,1,1',
            'screen' => 1,
            'css' => [
                '{{element}} .documentor-search-form:hover' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important;'
            ],
            'req' => [
                '!box_border_type_hover' => ''
            ],
            'show' => array(
                'box_bor_hover' => 'hover'
            ),
        ),
        'box_border_radius_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_radius_hover'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-form:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'box_bor_hover' => 'hover',	
            ),
        ),
    ),
    'result_styles' => array(
        'search_bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-search-list'=> 'background-color:{{val}}'],
        ),
        'link_colors' => array(
            'type' => 'radio',	
            'label' => __pl('colors'),
            'list' => array(
                'normal' => __pl('normal'),
                'hover' => __pl('hover'),
            ),
        ),
        'link_color' => array(
            'type' => 'color',	
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-search-list li,.documentor-search-list li a' => 'color:{{val}}'],
            'show' => [ 'link_colors' => 'normal'],
        ),
        'link_mark_color' => array(
            'type' => 'color',	
            'label' => __pl('mark_color'),
            'css' => ['{{element}} .documentor-search-form-result mark' => 'color:{{val}}'],
            'show' => [ 'link_colors' => 'normal'],
        ),
        'link_bgcolor' => array(
            'type' => 'color',	
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-search-list li,.documentor-search-list li a' => 'background-color:{{val}}'],
            'show' => [ 'link_colors' => 'normal'],
        ),
        'link_hover_color' => array(
            'type' => 'color',	
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-search-list li:hover, .documentor-search-form-result .documentor-search-list-item > a:hover' => 'color:{{val}}'],
            'show' => [ 'link_colors' => 'hover'],
        ),
        'link_hover_mark_color' => array(
            'type' => 'color',	
            'label' => __pl('mark_color'),
            'css' => ['{{element}} .documentor-search-form-result .documentor-search-list-item > a:hover mark' => 'color:{{val}}'],
            'show' => [ 'link_colors' => 'hover'],
        ),
        'link_hover_bgcolor' => array(
            'type' => 'color',	
            'label' => __pl('bgcolor'),
            'css' => ['{{element}} .documentor-search-list li:hover,.documentor-search-list li a:hover' => 'background-color:{{val}}'],
            'show' => [ 'link_colors' => 'hover'],
        ),
        'rbox_shadow' => array(
            'type' => 'box_shadow',
            'label' => __pl('box_shadow'),
            'css' => ['{{element}} .documentor-search-form-result ul' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
        ),
        'rbox_bor_hover' => array(
            'type' => 'radio',
            'label' => __pl('state'),
            'list' => array(
                '' => __pl('normal'),
                'hover' => __pl('hover'),
            )
        ),	
        'rbox_border_type' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-search-form-result ul' => 'border-style: {{val}} !important;',
                ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'rbox_bor_hover' => ''
            ),
        ),
        'rbox_border_color' => array(
            'type' => 'color',
            'label' => __pl('border_color_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-search-form-result ul' => 'border-color: {{val}} !important;'],
            'req' => array(
                '!rbox_border_type' => ''
            ),
            'show' => array(
                'rbox_bor_hover' => ''
            ),
        ),
        'rbox_border_width' => array(
            'type' => 'padding',
            'label' => __pl('border_width'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-form-result ul' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important'],
            'req' => [
                '!rbox_border_type' => ''
            ],
            'show' => array(
                'rbox_bor_hover' => ''
            ),
        ),
        'rbox_border_radius' => array(
            'type' => 'padding',
            'label' => __pl('border_radius'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-form-result ul' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'rbox_bor_hover' => '',
            ),
        ),
        'rbox_border_type_hover' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-search-form-result ul:hover' => 'border-style: {{val}} !important',	
            ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'rbox_bor_hover' => 'hover'
            ),
        ),
        'rbox_border_color_hover' => array(
            'type' => 'color',
            'label' => __pl('border_color_hover_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-search-form-result ul:hover' => 'border-color: {{val}} !important'],
            'req' => array(
                '!rbox_border_type_hover' => ''
            ),
            'show' => array(
                'rbox_bor_hover' => 'hover'
            ),
        ),
        'rbox_border_width_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_width_hover'),
            'screen' => 1,
            'css' => [
                '{{element}} .documentor-search-form-result ul:hover' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important;'
            ],
            'req' => [
                '!rbox_border_type_hover' => ''
            ],
            'show' => array(
                'rbox_bor_hover' => 'hover'
            ),
        ),
        'rbox_border_radius_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_radius_hover'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-search-form-result ul:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'rbox_bor_hover' => 'hover',	
            ),
        ),
    ),
    'styles' => array(
        'params' => __pl('settings'),
        'result_styles' => __pl('result_style'),
    ),

));

//Table Content
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_table_content', array(
    'name' => __pl('documentor_table_content'),
    'group' => 'documentor',
    'html' => '<div class="documentor-table-content" title="{{title}}" toggle_child={{toggle_child}}></div>
    <div if={{toggle_icon}} class="toggle_icon_button"><i class="{{icon}} fa-2x"></i></div>',
    'params' => array(
        'title' => array(
            'type' => 'text',
            'label' => __pl('heading'),
        ),
        'toggle_child' => array(
            'type' => 'checkbox',
            'label' => __pl('toggle_child'),
            'addClass' => ['{{element}} .documentor-table-content' => 'documentor_toggle']
        ),
        'toggle_icon' => array(
            'type' => 'checkbox',
            'label' => __pl('toggle_icon'),
            'addClass' => ['{{element}} .documentor-table-content' => 'toggle_icon toggle_icon_toggles']
        ),
        'bottom_align' => array(
            'type' => 'slider',
            'label' => __pl('bottom_align'),
            'default' => 0,
            'screen' => 1,
            'css' => ['{{element}} .toggle_icon_button' => 'bottom:{{val}}px;',
            '{{element}} .documentor-table-content.toggle_icon' => 'bottom:calc({{icon_btnsize}}px + 20px + {{val}}px);'],
            'req' => ['!toggle_icon' => '']
        ),
        'right_align' => array(
            'type' => 'slider',
            'label' => __pl('right_align'),
            'default' => 10,
            'screen' => 1,
            'css' => ['{{element}} .toggle_icon_button' => 'right:{{val}}px;',
            '{{element}} .documentor-table-content.toggle_icon' => 'right:calc({{val}}px + 20px);'],
            'req' => ['!toggle_icon' => '']
        ),
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} .documentor-table-content, .documentor-table-content h3'=> 'font-family: {{val[0]}} !important; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-table-content h3'=> 'color:{{val}}'],
        ),
        'bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .documentor-table-content'=> 'background-color:{{val}}'],
        ),
        'list_style' => array(
            'type' => 'select',
            'label' => __pl('list_style'),
            'np' => 1,
            'default' => 'none',
            'list' => array(
                'none' => __pl('none'),
                'circle' => __pl('list_list_type_circle'),
                'decimal' => __pl('decimal'),
                'square' => __pl('list_list_type_square'),
                'disc' => __pl('list_list_type_disc'),
                'inherit' => __pl('inherit'),
                'upper-roman' => __pl('upper_roman'),
                'upper-alpha' => __pl('upper_alpha'),
                'lower-roman' => __pl('lower_roman'),
                'lower-alpha' => __pl('lower_alpha'),
            ),
            'css' => ['{{element}} .documentor-table-content li' => 'list-style-type: {{val}};']
        ),
        'link_colors' => array(
            'type' => 'radio',	
            'label' => __pl('colors'),
            'list' => array(
                'normal' => __pl('normal'),
                'hover' => __pl('hover'),
                'active' => __pl('active'),
            ),
        ),
        'link_color' => array(
            'type' => 'color',	
            'label' => __pl('color'),
            'css' => ['{{element}} .documentor-table-content li a, .documentor-table-content li' => 'color:{{val}}'],
            'show' => [ 'link_colors' => 'normal'],
        ),
        'link_hover_color' => array(
            'type' => 'color',	
            'label' => __pl('current_color'),
            'css' => ['{{element}} .documentor-table-content li:hover>a, .documentor-table-content li:hover' => 'color:{{val}}'],
            'show' => [ 'link_colors' => 'hover'],
        ),
        'link_current_color' => array(
            'type' => 'color',	
            'label' => __pl('current_color'),
            'css' => ['{{element}} .documentor-table-content li.active > a, .documentor-table-content li.active' => 'color:{{val}}'],
            'show' => [ 'link_colors' => 'active']
        ),
        'box_shadow' => array(
            'type' => 'box_shadow',
            'label' => __pl('box_shadow'),
            'css' => ['{{element}} .documentor-table-content' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
        ),
        'box_bor_hover' => array(
            'type' => 'radio',
            'label' => __pl('state'),
            'list' => array(
                '' => __pl('normal'),
                'hover' => __pl('hover'),
            )
        ),	
        'box_border_type' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-table-content' => 'border-style: {{val}} !important;',
                ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'box_bor_hover' => ''
            ),
        ),
        'box_border_color' => array(
            'type' => 'color',
            'label' => __pl('border_color_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-table-content' => 'border-color: {{val}} !important;'],
            'req' => array(
                '!box_border_type' => ''
            ),
            'show' => array(
                'box_bor_hover' => ''
            ),
        ),
        'box_border_width' => array(
            'type' => 'padding',
            'label' => __pl('border_width'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-table-content' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important'],
            'req' => [
                '!box_border_type' => ''
            ],
            'show' => array(
                'box_bor_hover' => ''
            ),
        ),
        'box_border_radius' => array(
            'type' => 'padding',
            'label' => __pl('border_radius'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-table-content' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'box_bor_hover' => '',
            ),
        ),
        'box_border_type_hover' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-table-content:hover' => 'border-style: {{val}} !important',	
            ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'box_bor_hover' => 'hover'
            ),
        ),
        'box_border_color_hover' => array(
            'type' => 'color',
            'label' => __pl('border_color_hover_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-table-content:hover' => 'border-color: {{val}} !important'],
            'req' => array(
                '!box_border_type_hover' => ''
            ),
            'show' => array(
                'box_bor_hover' => 'hover'
            ),
        ),
        'box_border_width_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_width_hover'),
            'screen' => 1,
            'css' => [
                '{{element}} .documentor-table-content:hover' => 'border-top-width: {{val[0]}}px !important; border-right-width: {{val[1]}}px !important; border-bottom-width: {{val[2]}}px !important; border-left-width: {{val[3]}}px !important;'
            ],
            'req' => [
                '!box_border_type_hover' => ''
            ],
            'show' => array(
                'box_bor_hover' => 'hover'
            ),
        ),
        'box_border_radius_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_radius_hover'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-table-content:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'show' => array(
                'box_bor_hover' => 'hover',	
            ),
        ),
    ),
    'icon_style' =>[
        'icon' => array(
            'type' => 'icon',
            'label' => __pl('icon'),
            'default' => 'fas fa-bars'
        ),
        'icon_color' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} .toggle_icon_button i' => 'color:{{val}}'],
        ),
        'icon_bgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} .toggle_icon_button' => 'background-color:{{val}}'],
        ),
        'icon_size' => array(
            'type' => 'slider',
            'label' => __pl('size'),
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'screen' => 1,
            'css' => ['{{element}} .toggle_icon_button i' => 'font-size: {{val}}px;']
        ),
        'icon_btnsize' => array(
            'type' => 'slider',
            'label' => __pl('btn_size'),
            'min' => 0,
            'max' => 100,
            'step' => 1,
            'screen' => 1,
            'css' => ['{{element}} .toggle_icon_button ' => 'height: {{val}}px; width: {{valb}}px']
        ),
    ],
    'styles' => [
        'icon_style' => __pl('icon_style')
    ]


));

// Code
pagelayer_add_shortcode(PAGELAYER_SC_PREFIX.'_dm_code', array(
    'name' => __pl('code'),
    'group' => 'documentor',
    'innerHTML' => 'text',
    'html' => '<div class="documentor-code-holder"><pre><code>{{code}}</code></pre><i class="far fa-copy" label="copy code snippet"></i></div>',
    'params' => array(
        'code' => array(
            'type' => 'code',
            'label' => __pl('edit_code'),
            'default' => 'Enter the code here....',
            'rows' => '15',
            'desc' => __pl('write the code you want to show'),
            //'edit' => '.documentor-code-holder pre code'
        )
    ),
    'box_style' => array(
        'theme' => array(
            'type' => 'select',
            'label' => __pl('highlight_theme'),
            'addClass' =>  'documentor-hljs-{{val}}',
            'list' => array(
                '' => __pl('default'),
                'dark' => __pl('Dark'),
                'light' => __pl('Light'),
                'xt256'	=> __pl('XT256')
            ),
        ),
        'typo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} code'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
        ),
        'box_shadow' => array(
            'type' => 'box_shadow',
            'label' => __pl('box_shadow'),
            'css' => ['{{element}} .documentor-code-holder pre code' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
        ),
        'code_bor_hover' => array(
            'type' => 'radio',
            'label' => __pl('state'),
            'list' => array(
                '' => __pl('normal'),
                'hover' => __pl('hover'),
            )
        ),	
        'code_border_type' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-code-holder pre code' => 'border-style: {{val}};',
                ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'code_bor_hover' => ''
            ),
        ),
        'code_border_color' => array(
            'type' => 'color',
            'label' => __pl('border_color_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-code-holder pre code' => 'border-color: {{val}};'],
            'req' => array(
                '!code_border_type' => ''
            ),
            'show' => array(
                'code_bor_hover' => ''
            ),
        ),
        'code_border_width' => array(
            'type' => 'padding',
            'label' => __pl('border_width'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-code-holder pre code' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px'],
            'req' => [
                '!code_border_type' => ''
            ],
            'show' => array(
                'code_bor_hover' => ''
            ),
        ),
        'code_border_radius' => array(
            'type' => 'padding',
            'label' => __pl('border_radius'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-code-holder pre code' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'req' => array(
                '!code_border_type' => '',
            ),
            'show' => array(
                'code_bor_hover' => '',
            ),
        ),
        'code_border_type_hover' => array(
            'type' => 'select',
            'label' => __pl('border_type'),
            'css' => [
                '{{element}} .documentor-code-holder pre code:hover' => 'border-style: {{val}}',	
            ],
            'list' => [
                '' => __pl('none'),
                'solid' => __pl('solid'),
                'double' => __pl('double'),
                'dotted' => __pl('dotted'),
                'dashed' => __pl('dashed'),
                'groove' => __pl('groove'),
            ],
            'show' => array(
                'code_bor_hover' => 'hover'
            ),
        ),
        'code_border_color_hover' => array(
            'type' => 'color',
            'label' => __pl('border_color_hover_label'),
            'default' => '',
            'css' => ['{{element}} .documentor-code-holder pre code:hover' => 'border-color: {{val}};'],
            'req' => array(
                '!code_border_type_hover' => ''
            ),
            'show' => array(
                'code_bor_hover' => 'hover'
            ),
        ),
        'code_border_width_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_width_hover'),
            'screen' => 1,
            'css' => [
                '{{element}} .documentor-code-holder pre code:hover' => 'border-top-width: {{val[0]}}px; border-right-width: {{val[1]}}px; border-bottom-width: {{val[2]}}px; border-left-width: {{val[3]}}px;'
            ],
            'req' => [
                '!code_border_type_hover' => ''
            ],
            'show' => array(
                'code_bor_hover' => 'hover'
            ),
        ),
        'code_border_radius_hover' => array(
            'type' => 'padding',
            'label' => __pl('border_radius_hover'),
            'screen' => 1,
            'css' => ['{{element}} .documentor-code-holder pre code:hover' => 'border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px; -webkit-border-radius:  {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;-moz-border-radius: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[3]}}px;'],
            'req' => array(
                '!code_border_type_hover' => '',
            ),
            'show' => array(
                'code_bor_hover' => 'hover',	
            ),
        ),
    ),
    'tooltip_style' => array(
        'hide_copy' => array(
            'type' => 'checkbox',
            'label' => __pl('hide_copy'),
            'default' => 'true',
            'css' => ['{{element}} .fa-copy' => 'display:none;'],
        ),
        'hide_tooltip' => array(
            'type' => 'checkbox',
            'label' => __pl('hide_tooltip'),
            'default' => 'true',
            'css' => ['{{element}} .fa-copy:hover::after' => 'display:none;'],
            'req' => ['hide_copy' => ''],
        ),
        'talign' => array(
            'type' => 'dimension',
            'label' => __pl('align'),
            'css' => ['{{element}} .fa-copy:hover::after'=> 'transform:translate(calc(-90% + {{val[0]}}px), {{val[1]}}px)'],
            'req' => ['hide_tooltip' => '','hide_copy' => ''],
        ),
        'ttypo' => array(
            'type' => 'typography',
            'label' => __pl('typography'),
            'css' => ['{{element}} i::after'=> 'font-family: {{val[0]}}; font-size: {{val[1]}}px !important; font-style: {{val[2]}} !important; font-weight: {{val[3]}} !important; font-variant: {{val[4]}} !important; text-decoration-line: {{val[5]}} !important; text-decoration-style: {{val[6]}} !important; line-height: {{val[7]}}em !important; text-transform: {{val[8]}} !important; letter-spacing: {{val[9]}}px !important; word-spacing: {{val[10]}}px !important;'],
            'req' => ['hide_tooltip' => '','hide_copy' => ''],
        ),
        'tbox_shadow' => array(
            'type' => 'box_shadow',
            'label' => __pl('box_shadow'),
            'css' => ['{{element}}  i::after' => 'box-shadow: {{val[0]}}px {{val[1]}}px {{val[2]}}px {{val[4]}}px {{val[3]}} {{val[5]}} !important;'],
            'req' => ['hide_tooltip' => '','hide_copy' => ''],
        ),
        'tcolor' => array(
            'type' => 'color',
            'label' => __pl('color'),
            'css' => ['{{element}} i::after'=> 'color:{{val}}'],
            'req' => ['hide_tooltip' => '','hide_copy' => ''],
        ),
        'tbgcolor' => array(
            'type' => 'color',
            'label' => __pl('bg_color'),
            'css' => ['{{element}} i::after'=> 'background-color:{{val}}'],
            'req' => ['hide_tooltip' => '','hide_copy' => ''],
        ),
    ),
    'styles' => array(
        'params' => __pl('code'),
        'box_style' => __pl('Style'),
        'tooltip_style' => __pl('tooltip_style'),
    )
));