
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soplanning15500`
--

-- --------------------------------------------------------

--
-- Table structure for table `planning_audit`
--

CREATE TABLE `planning_audit` (
  `audit_id` int(11) NOT NULL AUTO_INCREMENT,
  `date_modif` datetime NOT NULL,
  `user_modif` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `type` varchar(2) COLLATE latin1_general_ci DEFAULT NULL,
  `user_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `projet_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `periode_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `lieu_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `ressource_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `statut_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `equipe_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `groupe_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `anciennes_valeurs` text COLLATE latin1_general_ci,
  `nouvelles_valeurs` text COLLATE latin1_general_ci,
  `nbmodifs` int(11) DEFAULT NULL,
  `informations` text COLLATE latin1_general_ci,
  PRIMARY KEY (`audit_id`),
  KEY `user_id` (`user_id`),
  KEY `projet_id` (`projet_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `planning_config`
--

CREATE TABLE `planning_config` (
  `cle` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `valeur` varchar(1024) COLLATE latin1_general_ci DEFAULT NULL,
  `commentaire` text COLLATE latin1_general_ci,
  PRIMARY KEY (`cle`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `planning_config`
--

INSERT INTO `planning_config` VALUES
('CONTACT_FORM_DEACTIVATE', '', 'Put 1 to deactivate the display of the small button/popin (contact form)'),
('CURRENT_VERSION', '1.55.00', 'Internal key for auto upgrade control'),
('DEFAULT_NB_DAYS_DISPLAYED', '2', 'Default number of days displayed in the planning view by day'),
('DEFAULT_NB_MONTHS_DISPLAYED', '2', 'Default number of months displayed in the planning'),
('DEFAULT_NB_ROWS_DISPLAYED', '100', 'Default number of rows displayed in the planning'),
('DEFAULT_PERIOD_LINK', '', 'Default value for link in a period'),
('DURATION_AM', '04:00', 'Morning duration when calculating worked hours'),
('DURATION_DAY', '09:00', 'Duration when only one day is selected'),
('DURATION_PM', '05:00', 'Afternoon duration when calculating worked hours'),
('GOOGLE_2FA_ACTIVE', '0', ''),
('GOOGLE_OAUTH_ACTIVE', '0', ''),
('GOOGLE_OAUTH_CLIENT_ID', '', ''),
('GOOGLE_OAUTH_CLIENT_SECRET', '', ''),
('HOURS_DISPLAYED', '8,9,10,11,14,15,16,17', 'List of hours displayed in the day view'),
('LOGOUT_REDIRECT', '', 'Optional redirect url after logout (for exemple to return on your own intranet). ex : http://www.google.com'),
('NOTIFICATION_EMAIL_COCHE', '1', 'Default state for notification checkbox in task form'),
('PASSWORD_COMPLEXITY', '0', '1 for CNIL rules'),
('PLANNING_AFFICHAGE_STATUS', 'aucun', 'Show status'),
('PLANNING_CELL_FONTSIZE', '0', 'Cell Font size'),
('PLANNING_CODE_WIDTH', '5', 'Code width'),
('PLANNING_CODE_WIDTH_LARGE', '5', 'Code width large mode'),
('PLANNING_COL_WIDTH', '25', 'Planning col width'),
('PLANNING_COL_WIDTH_LARGE', '130', 'Planning col width large mode'),
('PLANNING_COULEUR_TACHE', '0', 'Task Color'),
('PLANNING_DATE_FORMAT', '1', 'Date Format'),
('PLANNING_DAYS_OF_WEEK_DISPLAY', '{"1": {"inclus" : "1", "affiche" : "1", "grise" : "0"},"2": {"inclus" : "1", "affiche" : "1", "grise" : "0"},"3": {"inclus" : "1", "affiche" : "1", "grise" : "0"},"4": {"inclus" : "1", "affiche" : "1", "grise" : "0"},"5": {"inclus" : "1", "affiche" : "1", "grise" : "0"},"6": {"inclus" : "0", "affiche" : "1", "grise" : "1"},"7": {"inclus" : "0", "affiche" : "1", "grise" : "1"}}', 'Define how each day is display (normal, grey, hidden)'),
('PLANNING_DIFFERENCIE_TACHE_COMMENTAIRE', '0', 'Task comment'),
('PLANNING_DIFFERENCIE_TACHE_LIEN', '1', 'Task link'),
('PLANNING_DIFFERENCIE_TACHE_PARTIELLE', '1', 'Half Task '),
('PLANNING_DUREE_CRENEAU_HORAIRE', '30', 'Time duration'),
('PLANNING_HIDE_WEEKEND_TASK', '0', 'Hide weekend task'),
('PLANNING_LINE_HEIGHT', '', 'Default line height in the planning. If not specified, it fits the username height'),
('PLANNING_MASQUER_FERIES', '0', 'Hide holidays'),
('PLANNING_ONE_ASSIGNMENT_MAX_PER_DAY', '0', 'Option to display only one assignment/task per cell/day in the planning (put "1" to activite this option)'),
('PLANNING_PAGES', '1,5,10,20,50,100', 'rows per page in the planning'),
('PLANNING_REPEAT_HEADER', '0', 'If > 0, repeat header (days/months) in the planning each x lines'),
('PLANNING_TEXTE_TACHES_LIEU', 'code_projet', 'Cell text location'),
('PLANNING_TEXTE_TACHES_PERSONNE', 'code_projet', 'Cell text user'),
('PLANNING_TEXTE_TACHES_PROJET', 'code_personne', 'Cell text project'),
('PLANNING_TEXTE_TACHES_RESSOURCE', 'code_projet', 'Cell text resource'),
('PROJECT_COLORS_POSSIBLE', '', 'color choice limitation for planner (empty for no limit). Exemple :#ff0000,#aa8811,#446622'),
('REFRESH_TIMER', '600', 'refresh time for the planning page (time in second)'),
('SECURE_KEY', '[[SECURE_KEY]]', 'String used only for security matters'),
('SEMAPHORE_ACTIVATED', '0', 'Activated in order to avoid periode_id crossing when creating a lot of tasks at the same time'),
('SMTP_FROM', 'notification@yourdomain.com', ''),
('SMTP_HOST', 'localhost', ''),
('SMTP_LOGIN', '', ''),
('SMTP_PASSWORD', '', ''),
('SMTP_PORT', '', ''),
('SMTP_SECURE', '', ''),
('SOPLANNING_API_KEY_NAME', 'SOPLANNING-API', ''),
('SOPLANNING_API_KEY_VALUE', UUID(), ''),
('SOPLANNING_LOGO', '', 'Logo'),
('SOPLANNING_OPTION_ACCES', '0', 'Public access'),
('SOPLANNING_OPTION_AUDIT', '1', 'Audit module'),
('SOPLANNING_OPTION_AUDIT_CONNEXIONS', '1', 'Audit connexion'),
('SOPLANNING_OPTION_AUDIT_EQUIPES', '1', 'Audit team'),
('SOPLANNING_OPTION_AUDIT_GROUPES', '1', 'Audit project group'),
('SOPLANNING_OPTION_AUDIT_LIEUX', '1', 'Audit location'),
('SOPLANNING_OPTION_AUDIT_PROJETS', '1', 'Audit project'),
('SOPLANNING_OPTION_AUDIT_RESSOURCES', '1', 'Audit ressource'),
('SOPLANNING_OPTION_AUDIT_RETENTION', '30', 'Audit retention'),
('SOPLANNING_OPTION_AUDIT_STATUTS', '1', 'Audit status'),
('SOPLANNING_OPTION_AUDIT_TACHES', '1', 'Audit tasks'),
('SOPLANNING_OPTION_AUDIT_UTILISATEURS', '1', 'Audit users'),
('SOPLANNING_OPTION_LIEUX', '1', 'Location Option'),
('SOPLANNING_OPTION_RESSOURCES', '1', 'Ressource Option'),
('SOPLANNING_OPTION_TACHES', '1', 'Task Option'),
('SOPLANNING_OPTION_VISITEUR', '0', 'Visitor can add or update task'),
('SOPLANNING_THEME', 'soplanning.css', 'Default theme'),
('SOPLANNING_TITLE', 'SOPlanning', 'Change the title of Soplanning for integration in extranet'),
('SOPLANNING_URL', '', 'Your SOPlanning instance url, to be able to send email with links'),
('TIMEZONE', 'Europe/Paris', 'Timezone'),
('WHITELIST_UPLOAD', 'pdf,docx,doc,xls,xlsx,png,jpg,jpeg,gif', 'File extension allowed for upload');

-- --------------------------------------------------------

--
-- Table structure for table `planning_ferie`
--

CREATE TABLE `planning_ferie` (
  `date_ferie` date NOT NULL,
  `libelle` varchar(50) COLLATE latin1_general_ci DEFAULT NULL,
  `couleur` varchar(6) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`date_ferie`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `planning_filtre_perso`
--

CREATE TABLE `planning_filtre_perso` (
  `filtre_perso_id` int(11) NOT NULL,
  `filtre_perso_nom` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `filtre_perso_contenu` text COLLATE latin1_general_ci,
  `module` varchar(50) COLLATE latin1_general_ci NOT NULL,
  `user_id` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `date_creation` datetime NOT NULL,
  `date_modif` datetime DEFAULT NULL,
  PRIMARY KEY (`filtre_perso_id`),
  KEY `filtre_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `planning_groupe`
--

CREATE TABLE `planning_groupe` (
  `groupe_id` int(11) NOT NULL,
  `nom` varchar(30) COLLATE latin1_general_ci NOT NULL,
  `ordre` int(11) DEFAULT NULL,
  PRIMARY KEY (`groupe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `planning_groupe`
--

INSERT INTO `planning_groupe` VALUES
(1, 'Project 1', NULL),
(2, 'Project 2', NULL),
(3, 'Project 3', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `planning_lieu`
--

CREATE TABLE `planning_lieu` (
  `lieu_id` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `nom` varchar(50) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `commentaire` text COLLATE latin1_general_ci,
  `exclusif` tinyint(4) DEFAULT '0',
  `couleur` varchar(6) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`lieu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `planning_periode`
--

CREATE TABLE `planning_periode` (
  `periode_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT NULL,
  `projet_id` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `user_id` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `link_id` varchar(25) COLLATE latin1_general_ci DEFAULT NULL,
  `date_debut` date NOT NULL DEFAULT '2000-01-01',
  `date_fin` date DEFAULT NULL,
  `duree` time DEFAULT NULL,
  `duree_details` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `titre` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `notes` text COLLATE latin1_general_ci,
  `lien` text COLLATE latin1_general_ci,
  `statut_tache` varchar(10) COLLATE latin1_general_ci NOT NULL DEFAULT 'a_faire',
  `livrable` enum('oui','non') COLLATE latin1_general_ci NOT NULL DEFAULT 'non',
  `lieu_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `ressource_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `fichiers` text COLLATE latin1_general_ci,
  `createur_id` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `date_creation` datetime DEFAULT NULL,
  `modifier_id` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `date_modif` datetime DEFAULT NULL,
  `custom` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `pause` time DEFAULT NULL,
  `duree_reelle` float DEFAULT NULL,
  PRIMARY KEY (`periode_id`),
  KEY `projet_id` (`projet_id`),
  KEY `user_id` (`user_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `planning_periode`
--

INSERT INTO `planning_periode` VALUES
(1, NULL, 'test1', 'user1', '187428067768fb4e03d4736', '2025-10-26', '2025-11-04', NULL, NULL, 'Exemple task', NULL, NULL, 'todo', 'non', NULL, NULL, NULL, 'ADM', '[[regtime]]', NULL, NULL, NULL, NULL, NULL),
(2, NULL, 'test2', 'user1', '75270534868fb4e03d63b7', '2025-10-29', '2025-11-02', NULL, NULL, 'Another exemple task', NULL, NULL, 'progress', 'non', NULL, NULL, NULL, 'ADM', '[[regtime]]', NULL, NULL, NULL, NULL, NULL),
(3, NULL, 'test1', 'user2', '43285893268fb4e03d7bbd', '2025-10-25', NULL, '04:55:00', '08:35:00;13:30:00', NULL, NULL, NULL, 'done', 'non', NULL, NULL, NULL, 'ADM', '[[regtime]]', NULL, NULL, NULL, NULL, NULL),
(4, NULL, 'test3', 'user2', '95954916568fb4e03d9221', '2025-10-25', NULL, '00:20:00', '15:00:00;15:20:00', NULL, NULL, NULL, 'todo', 'non', NULL, NULL, NULL, 'ADM', '[[regtime]]', NULL, NULL, NULL, NULL, NULL),
(5, NULL, 'test3', 'user3', '26096518868fb4e03da97a', '2025-10-28', NULL, '04:00:00', 'AM', NULL, NULL, NULL, 'progress', 'non', NULL, NULL, NULL, 'ADM', '[[regtime]]', NULL, NULL, NULL, NULL, NULL),
(6, NULL, 'test2', 'user3', '188642593768fb4e03dc1ce', '2025-10-28', '2025-11-01', NULL, NULL, NULL, NULL, NULL, 'todo', 'non', NULL, NULL, NULL, 'ADM', '[[regtime]]', NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `planning_projet`
--

CREATE TABLE `planning_projet` (
  `projet_id` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `nom` varchar(50) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `iteration` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `couleur` varchar(6) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `livraison` date DEFAULT NULL,
  `lien` text COLLATE latin1_general_ci,
  `statut` varchar(10) COLLATE latin1_general_ci NOT NULL DEFAULT 'a_faire',
  `groupe_id` int(11) DEFAULT NULL,
  `createur_id` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `budget_montant` float DEFAULT NULL,
  `budget_temps` float DEFAULT NULL,
  `montant_consomme` float DEFAULT NULL,
  `temps_consomme` float DEFAULT NULL,
  `montant_restant` float DEFAULT NULL,
  `temps_restant` float DEFAULT NULL,
  PRIMARY KEY (`projet_id`),
  KEY `groupe_id` (`groupe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `planning_projet`
--

INSERT INTO `planning_projet` VALUES
('test1', 'Test project 1', NULL, 'ff784e', NULL, NULL, 'todo', 1, 'ADM', NULL, NULL, NULL, NULL, NULL, NULL),
('test2', 'Test project 2', NULL, '5bf3d0', NULL, NULL, 'progress', 1, 'ADM', NULL, NULL, NULL, NULL, NULL, NULL),
('test3', 'Test project 3', NULL, 'e6c843', NULL, NULL, 'todo', 2, 'ADM', NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `planning_projet_user_tarif`
--

CREATE TABLE `planning_projet_user_tarif` (
  `projet_user_tarif_id` int(255) NOT NULL,
  `user_id` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `projet_id` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `tarif_horaire` float DEFAULT NULL,
  PRIMARY KEY (`projet_user_tarif_id`) USING BTREE,
  KEY `put_projet_id` (`projet_id`) USING BTREE,
  KEY `put_user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `planning_ressource`
--

CREATE TABLE `planning_ressource` (
  `ressource_id` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `nom` varchar(50) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `commentaire` text COLLATE latin1_general_ci,
  `exclusif` tinyint(4) DEFAULT '0',
  `couleur` varchar(6) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`ressource_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `planning_right_on_projet`
--

CREATE TABLE `planning_right_on_projet` (
  `right_id` int(11) NOT NULL,
  `owner_id` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `allowed_id` varchar(20) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`right_id`) USING BTREE,
  KEY `owner_id` (`owner_id`) USING BTREE,
  KEY `allowed_id` (`allowed_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `planning_right_on_user`
--

CREATE TABLE `planning_right_on_user` (
  `right_id` int(11) NOT NULL,
  `owner_id` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `allowed_id` varchar(20) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`right_id`),
  KEY `owner_id` (`owner_id`),
  KEY `allowed_id` (`allowed_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `planning_status`
--

CREATE TABLE `planning_status` (
  `status_id` varchar(10) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `nom` varchar(30) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `commentaire` text COLLATE latin1_general_ci,
  `affichage` varchar(2) COLLATE latin1_general_ci DEFAULT 'tp',
  `barre` varchar(2) COLLATE latin1_general_ci DEFAULT '0',
  `gras` varchar(2) COLLATE latin1_general_ci DEFAULT '0',
  `italique` varchar(2) COLLATE latin1_general_ci DEFAULT '0',
  `souligne` varchar(2) COLLATE latin1_general_ci DEFAULT '0',
  `defaut` varchar(2) COLLATE latin1_general_ci DEFAULT '1',
  `affichage_liste` varchar(2) COLLATE latin1_general_ci DEFAULT '1',
  `pourcentage` tinyint(4) NOT NULL DEFAULT '0',
  `couleur` varchar(6) COLLATE latin1_general_ci DEFAULT NULL,
  `priorite` tinyint(4) NOT NULL DEFAULT '5',
  `inclure_dans_calcul` enum('oui','non') COLLATE latin1_general_ci NOT NULL DEFAULT 'oui',
  PRIMARY KEY (`status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `planning_status`
--

INSERT INTO `planning_status` VALUES
('abort', 'Abandoned', NULL, 'tp', NULL, NULL, '1', NULL, '1', '1', 0, 'ff0f0f', 4, 'oui'),
('archive', 'Archived', NULL, 'tp', '1', NULL, '1', NULL, '1', '1', 100, '865ece', 5, 'oui'),
('done', 'Done / Completed', NULL, 'tp', '1', NULL, NULL, NULL, '1', '1', 100, '1fcb27', 3, 'oui'),
('progress', 'Active', NULL, 'tp', NULL, '1', NULL, '1', '1', '1', 50, 'ffeb3b', 2, 'oui'),
('todo', 'To do', NULL, 'tp', NULL, NULL, NULL, NULL, '1', '1', 0, '4dabf5', 1, 'oui');

-- --------------------------------------------------------

--
-- Table structure for table `planning_user`
--

CREATE TABLE `planning_user` (
  `user_id` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `user_groupe_id` int(11) DEFAULT NULL,
  `nom` varchar(50) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `login` varchar(100) COLLATE latin1_general_ci DEFAULT NULL,
  `password` varchar(50) COLLATE latin1_general_ci DEFAULT NULL,
  `email` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `visible_planning` enum('oui','non') COLLATE latin1_general_ci NOT NULL DEFAULT 'oui',
  `couleur` varchar(6) COLLATE latin1_general_ci DEFAULT NULL,
  `droits` text COLLATE latin1_general_ci,
  `cle` varchar(40) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `notifications` enum('oui','non') COLLATE latin1_general_ci NOT NULL DEFAULT 'non',
  `adresse` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `telephone` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `mobile` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `metier` varchar(50) COLLATE latin1_general_ci DEFAULT NULL,
  `commentaire` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `date_dernier_login` datetime DEFAULT NULL,
  `preferences` text COLLATE latin1_general_ci,
  `login_actif` enum('oui','non') COLLATE latin1_general_ci NOT NULL DEFAULT 'oui',
  `google_2fa` enum('setup','ok') COLLATE latin1_general_ci NOT NULL DEFAULT 'setup',
  `date_creation` datetime DEFAULT NULL,
  `date_modif` datetime DEFAULT NULL,
  `tutoriel` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `tarif_horaire_defaut` float DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  KEY `user_groupe_id` (`user_groupe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `planning_user`
--

INSERT INTO `planning_user` VALUES
('ADM', NULL, 'admin', 'admin', '[[admin_pass]]', NULL, 'non', '000000', '["users_manage_all", "projects_manage_all", "projectgroups_manage_all", "tasks_modify_all", "tasks_view_all_projects", "lieux_all", "ressources_all", "parameters_all", "stats_users", "stats_projects", "audit_restore", "stats_roi_projects"]', '[[cle]]', 'oui', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'oui', 'setup', '[[regtime]]', NULL, NULL, NULL),
('publicspl', NULL, 'Guest', NULL, NULL, NULL, 'non', '000000', NULL, '15b87ce3313a2bc732f39defb118a26d', 'non', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'oui', 'setup', '[[regtime]]', NULL, NULL, NULL),
('user1', 1, 'Test people 1', NULL, NULL, NULL, 'oui', 'ffeb3b', '["","","","tasks_readonly","tasks_view_all_projects","tasks_view_all_users","","","","","",""]', '0e2521c10b37187b94ed92ba27807f8c', 'oui', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'oui', 'setup', '[[regtime]]', NULL, NULL, NULL),
('user2', 1, 'Test people 2', NULL, NULL, NULL, 'oui', '4dabf5', '["","","","tasks_readonly","tasks_view_all_projects","tasks_view_all_users","","","","","",""]', '7efb82786c9e30382a49be23d6f6a056', 'oui', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'oui', 'setup', '[[regtime]]', NULL, NULL, NULL),
('user3', 2, 'Test people 3', NULL, NULL, NULL, 'oui', '1fcb27', '["","","","tasks_readonly","tasks_view_all_projects","tasks_view_all_users","","","","","",""]', 'a251b30bf636e7e18cc9d231ab325f4f', 'oui', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'oui', 'setup', '[[regtime]]', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `planning_user_groupe`
--

CREATE TABLE `planning_user_groupe` (
  `user_groupe_id` int(11) NOT NULL,
  `nom` varchar(150) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`user_groupe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

--
-- Dumping data for table `planning_user_groupe`
--

INSERT INTO `planning_user_groupe` VALUES
(1, 'Team 1'),
(2, 'Team 2');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `planning_filtre_perso`
--
ALTER TABLE `planning_filtre_perso`
  ADD CONSTRAINT `filtre_user_id` FOREIGN KEY (`user_id`) REFERENCES `planning_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `planning_periode`
--
ALTER TABLE `planning_periode`
  ADD CONSTRAINT `planning_periode_ibfk_1` FOREIGN KEY (`projet_id`) REFERENCES `planning_projet` (`projet_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `planning_periode_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `planning_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `planning_projet`
--
ALTER TABLE `planning_projet`
  ADD CONSTRAINT `planning_projet_ibfk_1` FOREIGN KEY (`groupe_id`) REFERENCES `planning_groupe` (`groupe_id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `planning_projet_user_tarif`
--
ALTER TABLE `planning_projet_user_tarif`
  ADD CONSTRAINT `put_projet_id` FOREIGN KEY (`projet_id`) REFERENCES `planning_projet` (`projet_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `put_user_id` FOREIGN KEY (`user_id`) REFERENCES `planning_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `planning_right_on_projet`
--
ALTER TABLE `planning_right_on_projet`
  ADD CONSTRAINT `planning_right_on_projet_ibfk_1` FOREIGN KEY (`allowed_id`) REFERENCES `planning_projet` (`projet_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `planning_right_on_projet_ibfk_2` FOREIGN KEY (`owner_id`) REFERENCES `planning_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `planning_right_on_user`
--
ALTER TABLE `planning_right_on_user`
  ADD CONSTRAINT `planning_fk_rou_allowed_id` FOREIGN KEY (`allowed_id`) REFERENCES `planning_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `planning_fk_rou_owner_id` FOREIGN KEY (`owner_id`) REFERENCES `planning_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `planning_user`
--
ALTER TABLE `planning_user`
  ADD CONSTRAINT `planning_user_ibfk_1` FOREIGN KEY (`user_groupe_id`) REFERENCES `planning_user_groupe` (`user_groupe_id`) ON DELETE SET NULL ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
