<?php
// Version: 2.1.3; Install

// These should be the same as those in index.language.php.
$txt['lang_character_set'] = 'UTF-8';
$txt['lang_rtl'] = '0';

$txt['install_step_welcome'] = 'Velkommen';
$txt['install_step_writable'] = 'Sjekker skrivetilgangen';
$txt['install_step_forum'] = 'Forum innstillinger';
$txt['install_step_databaseset'] = 'Databaseinnstillinger';
$txt['install_step_databasechange'] = 'Setter opp databasen';
$txt['install_step_admin'] = 'Administrator konto';
$txt['install_step_delete'] = 'Avslutter installasjonen';

$txt['smf_installer'] = 'Installasjonsprogram for SMF';
$txt['installer_language'] = 'Språk';
$txt['installer_language_set'] = 'Sett';
$txt['congratulations'] = 'Gratulerer! Installasjonen er nå fullført!';
$txt['congratulations_help'] = 'Hvis du på noe tidspunkt trenger hjelp, eller at SMF ikke fungerer korrekt, kan du besøke <a href="https://www.simplemachines.org/community/index.php">Simple Machines sitt forum</a> og be om hjelp hvis du trenger det.';
$txt['still_writable'] = 'Installasjonsmappen din er fremdeles skrivbar. Det er gjerne en god idé å endre rettighetene for den mappen sånn at den ikke er skrivbar av hensyn til sikkerheten.';
$txt['delete_installer'] = 'Klikk her for å slette filen install.php';
$txt['delete_installer_maybe'] = '<em>(fungerer ikke på alle servere.)</em>';
$txt['go_to_your_forum'] = 'Nå kan du gå inn og se på <a href="%1$s">ditt helt nye forum</a> som er klar til bruk. Du bør først logge inn, slik at du får tilgang til å utføre Administratoroppgaver.';
$txt['good_luck'] = 'Lykke til!<br>Simple Machines';

$txt['install_welcome'] = 'Velkommen';
$txt['install_welcome_desc'] = 'Velkommen til SMF. Dette skriptet vil veilede deg gjennom prosessen for installasjon av %1$s. Vi vil samle noen detaljer om forumet ditt i de neste trinnene, og etter et par minutter vil forumet være klar for bruk.';
$txt['install_no_https'] = 'Miljøet ditt støtter ikke https-strømmer. Enkelte funksjoner, for eksempel motta oppdateringer fra SimpleMachines.org, vil ikke fungere.
';
$txt['install_no_mbstring'] = 'Miljøet ditt støtter ikke det nødvendige mbstring-biblioteket. Aktiver mbstring og prøv igjen.';
$txt['install_no_fileinfo'] = 'Miljøet ditt støtter ikke det nødvendige fileinfo-biblioteket. Aktiver fileinfo og prøv igjen.';
$txt['install_all_lovely'] = 'Vi har gjennomført noen innledende tester på serveren din og alt ser ut til å være i orden. Bare klikk på knappen &quot;Fortsett&quot; nedenfor for å komme i gang.';

$txt['user_refresh_install'] = 'Forum oppdatert';
$txt['user_refresh_install_desc'] = 'Under installering fant scriptet ut (med detaljer du har lagt ved) at en eller flere tabeller som skulle opprettes allerede eksisterte.<br>Tabeller som manglet i din installasjon er blitt laget, men ingen data er blitt fjernet fra eksisterende tabeller.';

$txt['default_topic_subject'] = 'Velkommen til SMF!';
$txt['default_topic_message'] = 'Velkommen til Simple Machines Forum!<br><br>Vi håper du vil trives med ditt forum. Dersom du har noen problemer, ta gjerne kontakt og [url=https://www.simplemachines.org/community/index.php]spør oss om assistanse[/url].<br><br>Takk!<br>Simple Machines';
$txt['default_board_name'] = 'Generelt';
$txt['default_board_description'] = 'Diskuter alt mulig i dette forumet.';
$txt['default_category_name'] = 'Generell kategori';
$txt['default_time_format'] = '%d.%m.%Y, %H:%i:%s';
$txt['default_news'] = 'SMF - Nylig installert!';
$txt['default_reserved_names'] = 'Admin\nWebmaster\nGjest\nroot';
$txt['default_fugue_smileyset_name'] = 'Fugue\'s smilefjes';
$txt['default_alienine_smileyset_name'] = 'Alienine sitt sett
';
$txt['default_aaron_smileyset_name'] = 'Aaron\'s sett';
$txt['default_akyhne_smileyset_name'] = 'Akyhne\'s sett';
$txt['default_legacy_smileyset_name'] = '2.0 Standard';
$txt['default_theme_name'] = 'SMF Standard design - Curve2';

$txt['default_administrator_group'] = 'Administrator';
$txt['default_global_moderator_group'] = 'Global moderator';
$txt['default_moderator_group'] = 'Moderator';
$txt['default_newbie_group'] = 'Nybegynner';
$txt['default_junior_group'] = 'Juniormedlem';
$txt['default_full_group'] = 'Medlem';
$txt['default_senior_group'] = 'Seniormedlem';
$txt['default_hero_group'] = 'Supermedlem';

$txt['default_smiley_smiley'] = 'Smiler';
$txt['default_wink_smiley'] = 'Blunker';
$txt['default_cheesy_smiley'] = 'Osteaktig';
$txt['default_grin_smiley'] = 'Gliser';
$txt['default_angry_smiley'] = 'Sint';
$txt['default_sad_smiley'] = 'Trist';
$txt['default_shocked_smiley'] = 'Sjokkert';
$txt['default_cool_smiley'] = 'Kult';
$txt['default_huh_smiley'] = 'Hææ?';
$txt['default_roll_eyes_smiley'] = 'Øyerulling';
$txt['default_tongue_smiley'] = 'Rekke tunge';
$txt['default_embarrassed_smiley'] = 'Flaut';
$txt['default_lips_sealed_smiley'] = 'Hemmelig';
$txt['default_undecided_smiley'] = 'Tvilende';
$txt['default_kiss_smiley'] = 'Kysser';
$txt['default_cry_smiley'] = 'Gråter';
$txt['default_evil_smiley'] = 'Ondskapsfull';
$txt['default_azn_smiley'] = 'Djevelsk';
$txt['default_afro_smiley'] = 'Afro';
$txt['default_laugh_smiley'] = 'Ler';
$txt['default_police_smiley'] = 'Politi';
$txt['default_angel_smiley'] = 'Engel';

$txt['error_message_click'] = 'Klikk her';
$txt['error_message_try_again'] = 'for å prøve dette steget en gang til.';
$txt['error_message_bad_try_again'] = 'for å installere uansett, men merk at du er <em>sterkt</em> frarådet fra å gjøre det.';

$txt['install_settings'] = 'Vanlige innstillinger';
$txt['install_settings_info'] = 'Noen småting du må skrive inn ;).';
$txt['install_settings_name'] = 'Navn på forumet';
$txt['install_settings_name_info'] = 'Dette er navnet på forumet ditt, eks. &quot;Mitt SMF-forum&quot;.';
$txt['install_settings_name_default'] = 'Mitt SMF-forum';
$txt['install_settings_url'] = 'Nettadressen til forumet';
$txt['install_settings_url_info'] = 'Dette er adressen til forumet ditt <strong>uten \'/\' på slutten!</strong>.<br>I de fleste tilfellene trenger du ikke å redigere denne boksen, da det som står der fra før, normalt er korrekt.';
$txt['install_settings_reg_mode'] = 'Registreringsmodus';
$txt['install_settings_reg_modes'] = 'Registreringsmoduser';
$txt['install_settings_reg_immediate'] = 'Umiddelbar registrering';
$txt['install_settings_reg_email'] = 'E-postaktivering';
$txt['install_settings_reg_admin'] = 'Admin godkjenning';
$txt['install_settings_reg_disabled'] = 'Registrering deaktivert';
$txt['install_settings_reg_mode_info'] = 'Dette feltet lar deg endre modus for registrering ved installering for å hindre uønskede registreringer.';
$txt['install_settings_compress'] = 'Gzip utdata';
$txt['install_settings_compress_title'] = 'Komprimerer utdata for å spare båndbredde.';
// In this string, you can translate the word "PASS" to change what it says when the test passes.
$txt['install_settings_compress_info'] = 'Denne funksjonen fungerer ikke på alle servere, men du kan spare mye båndbredde på dette.<br>Klikk <a href="install.php?obgz=1&amp;pass_string=GODKJENT" onclick="return reqWin(this.href, 200, 60);" target="_blank" rel="noopener">her</a> for å teste om det fungerer. (Det skal bare stå "GODKJENT".)';
$txt['install_settings_dbsession'] = 'Database-baserte sesjoner';
$txt['install_settings_dbsession_title'] = 'Lagre sessjoner i databasen i stedet for i filer.';
$txt['install_settings_dbsession_info1'] = 'Dette er nesten alltid det beste, fordi det gjør bruk av sesjoner mer pålitelig.';
$txt['install_settings_dbsession_info2'] = 'Dette er nesten alltid det beste, men det vil kanskje ikke virke på denne serveren.';
$txt['install_settings_stats'] = 'Tillat henting av statistikk data';
$txt['install_settings_stats_title'] = 'La Simple Machines hente inn enkle statistiske data hver måned';
$txt['install_settings_stats_info'] = 'Hvis dette er aktivert vil det tillate Simple Machines å besøke ditt nettsted en gang i måneden for å hente enkle statistiske data. Dette vil hjelpe oss å forbedre hva slags konfigurajoner SMF støtter. For mer informasjon vennligst besøk vår <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">informasjonsside</a>.';
$txt['install_settings_proceed'] = 'Fortsett';

$txt['db_settings'] = 'Database serverinnstillinger';
$txt['db_settings_info'] = 'Dette er innstillingene skal brukes til databaseserveren. Hvis du ikke kjenner verdiene, bør du spørre din leverandør hva de er.';
$txt['db_settings_type'] = 'Databasetype';
$txt['db_settings_type_info'] = 'Flere typer databaser ble oppdaget – hvilken type ønsker du å bruke.';
$txt['db_settings_server'] = 'Servernavn';
$txt['db_settings_server_info'] = 'Dette er oftest localhost - så om du ikke vet, prøv localhost.';
$txt['db_settings_username'] = 'Brukernavn';
$txt['db_settings_username_info'] = 'Skriv inn brukernavnet du trenger for å koble til databasen.<br>Dersom du ikke vet hva det er, prøv brukernavnet til FTP-kontoen din. Oftest er disse to like.';
$txt['db_settings_password'] = 'Passord';
$txt['db_settings_password_info'] = 'Her skal du skrive inn passordet du trenger for å koble til databasen.<br>Dersom du ikke vet hva det er, prøv passordet du bruker på FTP-kontoen din.';
$txt['db_settings_database'] = 'Databasenavn';
$txt['db_settings_database_info'] = 'Skriv inn navnet på databasen du vil bruke som SMF kan lagre sine data i.';
$txt['db_settings_database_info_note'] = 'Om databasen ikke eksisterer, vil dette installasjonsprogrammet prøve å opprette databasen.';
$txt['db_settings_port'] = 'Database port
';
$txt['db_settings_port_info'] = 'La være tomt for å bruke standardinnstillingen';
$txt['db_settings_prefix'] = 'Tabellprefiks';
$txt['db_settings_prefix_info'] = 'Prefiksen for hver tabell i databasen. <strong>Ikke installer to fora med samme prefiks!</strong><br>Denne verdien muliggjør flere installasjoner i én database.';
$txt['db_populate'] = 'Setter opp databasen';
$txt['db_populate_info'] = 'Innstillingene er nå lagret og databasen installert med alle data som kreves for å få forumet oppe og gå. Oppsummering av installasjonen:';
$txt['db_populate_info2'] = 'Klikk &quot;Fortsett&quot; for å gå videre til siden for opprettelse av administrator kontoen.';
$txt['db_populate_inserts'] = 'Satt inn %1$d rader.';
$txt['db_populate_tables'] = 'Opprettet %1$d tabeller.';
$txt['db_populate_insert_dups'] = 'Ignorert %1$d dupliserte innsettelser.';
$txt['db_populate_table_dups'] = 'Ignorert %1$d dupliserte tabeller.';

$txt['user_settings'] = 'Opprett konto';
$txt['user_settings_info'] = 'Dette installasjonsprogrammet vil nå opprette en ny administratorkonto for deg.';
$txt['user_settings_username'] = 'Ditt brukernavn';
$txt['user_settings_username_info'] = 'Velg et brukernavn du vil logge inn med.<br>Dette kan ikke endres senere, men du kan endre ditt visningsnavn.';
$txt['user_settings_password'] = 'Passord';
$txt['user_settings_password_info'] = 'Skriv inn ditt foretrukne passord her, og husk godt på det!';
$txt['user_settings_again'] = 'Passord';
$txt['user_settings_again_info'] = '(bare for bekreftelse).';
$txt['user_settings_admin_email'] = 'Administrator e-postadresse
';
$txt['user_settings_admin_email_info'] = 'Angi e-postadressen din. Dette må være en gyldig e-postadresse!';
$txt['user_settings_server_email'] = 'Webmaster e-postadresse';
$txt['user_settings_server_email_info'] = 'Oppgi <strong> e-postadressen som SMF vil bruke til å sende e-post </strong>. Dette må være en gyldig e-postadresse!';
$txt['user_settings_database'] = 'Passord for databasen';
$txt['user_settings_database_info'] = 'Av sikkerhetsgrunner krever installasjonsprogrammet at du oppgir databasepassordet for å opprette en administratorkonto.';
$txt['user_settings_skip'] = 'Hopp over';
$txt['user_settings_skip_sure'] = 'Er du sikker på at du ønsker å oppe over opprettelse av admin-kontoen';
$txt['user_settings_proceed'] = 'Fullfør';

$txt['ftp_checking_writable'] = 'Kontrollerer at filene er skrivbare';
$txt['ftp_setup'] = 'Informasjon for FTP-tilkobling';
$txt['ftp_setup_info'] = 'Dette installasjonsprogrammet kan koble til med FTP for å rette på filene som må være skrivbare, men som ikke allerede er det. Dersom dette ikke fungerer for deg, må du selv gå inn og manuelt gjøre filene skrivbare. Merk at denne funksjonen ikke støtter SSL-tilgang for øyeblikket.';
$txt['ftp_setup_why'] = 'Hva er dette steget godt for?';
$txt['ftp_setup_why_info'] = 'Noen filer må være skrivbare for at SMF skal fungere ordentlig. Dette steget lar innstalleringsskriptet gjøre disse filens skrivbare. I noen tilfeller vil ikke dette virke - i så fall sett følgende filer til 777 (skrivbare, 755 på noen servere):';
$txt['ftp_setup_again'] = 'for å på nytt teste om disse filene er skrivbare.';

$txt['error_missing_files'] = 'Kunne ikke finne viktige installasjonsfiler i samme mappe som dette scriptet!<br><br>Kontroller at du lastet opp alle filene i installasjonspakken, inklusive sql-filen, og gjør så et nytt forsøk.';
$txt['error_session_save_path'] = 'Informer din leverandør om at følgende streng i php.ini er ugyldig: <strong>session.save_path</strong>. Den må endres til en mappe som <strong>eksisterer</strong> og er <strong>skrivbar</strong> for brukeren PHP kjører som.<br>';
$txt['error_windows_chmod'] = 'Du er på en Windows-server og noen av de viktigste filene er ikke skrivbare. Snakk med din leverandør og be dem ta av <strong>Skrivebeskyttelsen</strong> for brukeren som PHP kjører som. Følgende mapper og filer må være skrivbare:';
$txt['settings_error'] = 'Ditt oppsett kunne ikke lagres til Settings.php.';
$txt['error_ftp_no_connect'] = 'Kunne ikke koble til FTP-serveren med den informasjonen du skrev inn.';
$txt['error_db_file'] = 'Kan ikke finne kilden til databaseskriptet! Vennligst sjekk at filen %1$s is er i rot mappen på forumet.';
$txt['error_db_connect'] = 'Kan ikke koble til database-serveren med de oppgitte dataene.<br><br>Dersom du ikke er sikker på hva som skal skrives inn, vennligst kontakt din leverandør.';
$txt['error_db_connect_settings'] = 'Kan ikke koble til databaseserveren. <br> <br> Kontroller at databasens informasjonsvariabler er riktige i Settings.php.';
$txt['error_db_database'] = 'Installasjonsprogrammet kunne ikke få tilgang til &quot;<em>%1$s</em>&quot; databasen. På noen servere må du opprette databasen i administratorpanelet før SMF kan bruke den. Noen legger gjerne til noen prefikser, som f. eks. brukernavnet ditt til navn på databasene.';
$txt['error_db_queries'] = 'Noen av spørringene ble ikke kjørt korrekt. Dette kan være forårsaket av ikke støttet (utvikling eller gamle) versjonen av databaseprogramvaren.<br><br>Teknisk informasjon om spørringene:';
$txt['error_db_queries_line'] = 'Linje nr.';
$txt['error_db_missing'] = 'Installasjonsprogrammet kunne ikke oppdage noen database støtte i PHP. Spør din leverandør for å sikre at PHP er kompilert med den ønskede databasen, eller at de ønskede utvidelsene blir lastet.';
$txt['error_db_script_missing'] = 'Installasjonsprogrammet fant ingen installasjonsskriptfiler for den oppdagede databasen. Vennligst sjekk at du har lastet de nødvendige installasjonsskriptfilene til forum mappen, for eksempel &quot;%1$s&quot;';
$txt['error_session_missing'] = 'Installasjonsprogrammet kunne ikke finne støtte for sesjoner i serverens PHP-installasjon. Vennligst be din leverandør om å forsikre seg om at PHP ble kompilert med støtte for sesjoner (faktisk må det kompileres eksplisitt for å ikke støtte det.)';
$txt['error_user_settings_again_match'] = 'Du skrev inn to helt forskjellige passord!';
$txt['error_user_settings_no_password'] = 'Passordet ditt må være minst 4 tegn langt.';
$txt['error_user_settings_taken'] = 'Beklager, et medlem har allerede registrert seg med det brukernavnet og/eller passordet.<br><br>En ny konto har ikke blitt opprettet.';
$txt['error_user_settings_query'] = 'En database-feil oppstod under opprettelsen av administratorkontoen. Denne feilen var:';
$txt['error_sourcefile_missing'] = 'Kunne ikke finne filen Sources/%1$s  . Forsikre deg om at den ble lastet opp ordentlig, og prøv deretter på nytt.';
$txt['error_db_alter_priv'] = 'Databasekontoen du har oppgitt har ikke tillatelse til ALTER, CREATE, og/eller DROP tabeller i databasen, dette er nødvendig for SMF skal fungere korrekt.';
$txt['error_versions_do_not_match'] = 'Installasjonsprogrammet har oppdaget at en annen versjon av SMF er allerede installert med denne informasjonen. Dersom du heller vil oppgradere, må du bruke oppgraderingsprogrammet, og ikke installasjonsprogrammet.<br><br>Om ikke, fyll ut en annen informasjon eller opprett en sikkerhetskopi for deretter å slette alle data i databasen.';
$txt['error_mod_security'] = 'Installasjonsprogrammet oppdaget at mod_security er installert på serveren. Denne funksjonen vil blokkere utfyllingsformer før SMF får sagt noe. SMF har en innebygget kontrollør som vil fungere mer effektivt enn mod_security og vil ikke blokkere utfyllingsformene.<br><br><a href="https://www.simplemachines.org/redirect/mod_security">Mer informasjon om deaktivering av mod_security</a> (området er på engelsk)';
$txt['error_mod_security_no_write'] = 'Installasjonsprogrammet har oppdaget at modulen mod_security er installert på nettserveren din. Mod_security vil blokkere sendte skjemaer før SMF rekker å reagere. SMF har en innebygd sikkerhetsskanner som arbeider mer effektivt enn mod_security og som ikke blokkerer sending av skjemaer.<br /><br /><a href="http://www.simplemachines.org/redirect/mod_security">For mer informasjon om deaktivering av mod_security</a><br><br>Alternativt kan du bruke en ftp-klient til å chmod filen .htaccess i forummappen til å være skrivbar (777), og deretter friske opp denne siden.';
$txt['error_utf8_version'] = 'Den gjeldende versjonen av din database støtter ikke bruk av UTF-8 tegnsett. Du kan fortsatt installere SMF uten problemer, men da uten støtte for UTF-8. Hvis du ønsker å bytte over til UTF-8 i fremtiden (for eksempel etter at databaseserveren for forumet ditt har blitt oppgradert til versjon >= %1$s), kan du konvertere forumet til UTF-8 gjennom administrator panelet.';
$txt['error_valid_admin_email_needed'] = 'Du har ikke angitt en gyldig e-postadresse for din administrator-konto.';
$txt['error_valid_server_email_needed'] = 'Du har ikke angitt en gyldig webmaster e-postadresse.';
$txt['error_already_installed'] = 'Installasjonsprogrammet har oppdaget at du allerede har SMF installert. Det anbefales på det sterkeste at du <strong>IKKE</strong> forsøker å overskrive en eksisterende installasjon. Fortsetter du med installasjonen <strong>kan det resultere i tap eller skade på eksisterende data</strong>.<br><br>Dersom du ønsker å oppgradere kan du gå til <a href="https://www.simplemachines.org">Simple Machines</a> og laste ned <em>oppgraderings</em> pakken.<br><br>Dersom du ønsker å overskrive eksisterende installasjon, inkludert alle data, anbefales det at du sletter eksisterende databasetabeller og erstatte settings.php og prøv igjen.';
$txt['error_warning_notice'] = 'Advarsel!';
$txt['error_script_outdated'] = 'Dette installasjonsskriptet er utdatert! Den gjeldende versjonen av SMF er %1$s, men dette installasjonsskriptet er for %2$s.<br><br> Det anbefales at du går til <a href="https://www.simplemachines.org">Simple Machines</a> nettside for å sikre at du installerer den nyeste versjonen.';
$txt['error_db_prefix_numeric'] = 'Den valgte databasetype støtter ikke bruk av numeriske prefikser.';
$txt['error_pg_scs'] = 'PostgreSQL er satt opp feil. Vær vennlig å slå på standard_conforming_strings konfigurasjonsparameter.';
$txt['error_invalid_characters_username'] = 'Ugyldig tegn benyttet i brukernavn.';
$txt['error_username_too_long'] = 'Brukernavnet må være mindre enn 25 tegn langt.';
$txt['error_username_left_empty'] = 'Feltet med brukernavn er ikke fylt ut.';
$txt['error_db_prefix_reserved'] = 'Prefikset som du skrev er et reservert prefiks. Vennligst skriv inn et annet prefiks.';
$txt['error_utf8_support'] = 'Databasen du prøver å bruke bruker ikke UTF8-tegnsett';

$txt['ftp_login'] = 'Din FTP koblingsinformasjon';
$txt['ftp_login_info'] = 'Denne web-installatøren trenger din FTP-informasjon for å automatisere installasjonen for deg. Vær oppmerksom på at denne informasjonen ikke lagres i installasjonen, den brukes bare til å sette opp SMF.';
$txt['ftp_server'] = 'Tjener';
$txt['ftp_server_info'] = 'Dette skal være servernavn og portnummer for FTP-serveren.';
$txt['ftp_port'] = 'Port';
$txt['ftp_username'] = 'Brukernavn';
$txt['ftp_username_info'] = 'Brukernavnet som brukes til innlogging. <em>Dette vil ikke lagres noe sted.</em>';
$txt['ftp_password'] = 'Passord';
$txt['ftp_password_info'] = 'Passordet som brukes til innlogging. <em>Dette vil ikke lagres noe sted.</em>';
$txt['ftp_path'] = 'Installasjons-sti';
$txt['ftp_path_info'] = 'Dette er den <em>relative</em> stien du bruker på din FTP-server. <a href="\' . $_SERVER[\'PHP_SELF\'] . \'?ftphelp" onclick="window.open(this.href, \\\'\\\', \\\'width=450,height=250\\\');return false;" target="_blank" rel="noopener">(mer hjelp)</a>';
$txt['ftp_path_found_info'] = 'Stien i feltet ovenfor ble automatisk funnet.';
$txt['ftp_path_help'] = 'Din FTP sti er stien du ser når du logger inn i din FTP-klient. Den starter vanligvis med &quot;<pre>www</pre>&quot;, &quot;<pre>public_html</pre>&quot;, eller &quot;<pre>httpdocs</pre>&quot; - men den må også inkludere katalogen SMF er i, som &quot;/public_html/forum&quot;. Den er forskjellig fra URL og full sti.<br><br>Filer i denne stien kan bli overskrevet, så forsikre deg om at det er rett.';
$txt['ftp_path_help_close'] = 'Lukk';
$txt['ftp_connect'] = 'Koble til';

$txt['force_ssl'] = 'Aktivèr SSL';
$txt['force_ssl_label'] = 'Fremtving SSL i hele forumet';
$txt['force_ssl_info'] = 'Forsikre deg om at SSL og HTTPS er støttet i hele forumet - ellers kan forumet bli utilgjengelig.';

$txt['chmod_linux_info'] = 'Hvis du har en (unix) kommando-linje konto, kan nedenstående kommando korrigere tilgang til disse filene.';

// The upgrader needs text strings too!
$txt['upgrade_step_login'] = 'Logg inn';
$txt['upgrade_step_options'] = 'Oppgraderingsvalg';
$txt['upgrade_step_backup'] = 'Sikkerhetskopi';
$txt['upgrade_step_database'] = 'Database endringer';
$txt['upgrade_step_convertutf'] = 'Konverter til UTF-8';
$txt['upgrade_step_convertjson'] = 'Konverter serialiserte strenger til JSON
';
$txt['upgrade_step_delete'] = 'Slett Upgrade.php';

$txt['upgrade_upgrade_utility'] = 'SMF oppgraderingsverktøy';
$txt['upgrade_warning'] = 'Advarsel!';
$txt['upgrade_critical_error'] = 'Kritisk feil!';
$txt['upgrade_continue'] = 'Fortsett';
$txt['upgrade_skip'] = 'Hopp over';
$txt['upgrade_note'] = 'Merk!';
$txt['upgrade_step'] = 'Steg';
$txt['upgrade_steps'] = 'Steg';
$txt['upgrade_progress'] = 'Fremdrift';
$txt['upgrade_overall_progress'] = 'Samlet fremdrift';
$txt['upgrade_step_progress'] = 'Gjeldende fremdrift';
$txt['upgrade_time_elapsed'] = 'Tid brukt';
$txt['upgrade_time_mins'] = 'minutter';
$txt['upgrade_time_secs'] = 'sekunder';
$txt['upgrade_username'] = 'Brukernavn:';
$txt['upgrade_wrong_username'] = 'Feil brukernavn';
$txt['upgrade_password'] = 'Passord:';
$txt['upgrade_wrong_password'] = 'Feil passord';
$txt['upgrade_script_timeout_minutes'] = 'Dette oppgraderingsskriptet kan ikke kjøres før %1$s har vært inaktiv i minst %2$d minutter';
$txt['upgrade_script_timeout_seconds'] = 'Dette oppgraderingsskriptet kan ikke kjøres før %1$s har vært inaktiv i minst %2$d sekunder';

$txt['upgrade_wait'] = 'Vent mens en sikkerhetskopi blir opprettet. For store fora kan dette ta litt tid!
';
$txt['upgrade_wait2'] = 'Vent mens databasen din blir konvertert til UTF-8. For store fora kan dette ta litt tid!';
$txt['upgrade_sec_login'] = 'For sikkerhets skyld logg inn med admin-kontoen din for å fortsette med oppgraderingen.';
$txt['upgrade_incomplete'] = 'Ufullstendig';
$txt['upgrade_not_quite_done'] = 'Ikke helt ferdig ennå!';
$txt['upgrade_paused_overload'] = 'Oppgraderingen er satt på pause for å unngå overbelastning på serveren. Ikke bekymre deg, ingenting er galt - bare klikk på knappen <label for="contbutt">fortsette</label> nedenfor for å fortsette.';
$txt['upgrade_continue_step'] = 'Fortsett fra der du var under siste utførelse av oppgraderingsskriptet.
';
$txt['upgrade_bypass'] = '<strong> Merk: </strong> Om nødvendig kan ovennevnte sikkerhetskontroll omgås for brukere som kan administrere en server, men som ikke har administratorrettigheter på forumet. For å omgå sjekken ovenfor, åpner du ganske enkelt &quot;upgrade.php&quot; i en teksteditor og erstatter &quot;$disable_security = false;&quot; med &quot;$disable_security = true;&quot; og last denne siden på nytt.';
$txt['upgrade_areyouready'] = 'Vennligst gjennomgå alternativene nedenfor før oppgraderingen er i gang, - og trykk på &quot;fortsett&quot; når du er klar til å begynne.';
$txt['upgrade_backup_table'] = 'Sikkerhetskopier tabeller i databasen din med prefikset';
$txt['upgrade_backup_complete'] = 'Sikkerhetskopiering fullført! Klikk på Fortsett for å gå videre.';
$txt['upgrade_recommended'] = 'anbefalt!';
$txt['upgrade_maintenance'] = 'Sett forumet i "vedlikeholdsmodus" under oppgraderingen.';
$txt['upgrade_maintenance_title'] = 'Vedlikehold tittel:';
$txt['upgrade_maintenance_message'] = 'Vedlikehold - melding:';
$txt['upgrade_customize'] = 'Tilpass';
$txt['upgrade_debug_info'] = 'Vis ekstra debug info.';
$txt['upgrade_empty_errorlog'] = 'Tøm feil-logg før oppgradering.';
$txt['upgrade_delete_karma'] = 'Slett alle karmainnstillinger og info fra DB';
$txt['upgrade_reprocess_attachments'] = 'Kjør konvertering av filvedlegg igjen';
$txt['upgrade_stats_collection'] = 'Tillat Simple Machines å samle inn basis-statistikk månedlig.';
$txt['upgrade_stats_info'] = 'Hvis dette er aktivert, vil Simple Machines tillates å besøke nettstedet ditt en gang i måneden for å samle grunnleggende statistikk. Dette vil hjelpe oss å ta beslutninger om hvilke konfigurasjoner vi skal optimalisere programvaren for. For mer informasjon, besøk <a href="%1$s" target="_blank" rel="noopener"> infosiden </a>.';
$txt['upgrade_migrate_settings_file'] = 'Migrèr til ny Settings-fil.';
$txt['upgrade_db_changes'] = 'Utfør database-endringer';
$txt['upgrade_db_patient'] = 'Vær tålmodig - dette kan ta litt tid på store fora. Tiden som er gått vises fra server for å vise at arbeidet går fremover.';
$txt['upgrade_db_complete'] = '1 databaseoppdateringer fullført! Klikk på "Fortsett" for å fortsette.';
$txt['upgrade_db_complete2'] = 'Databaseoppdateringer fullført! Klikk på "Fortsett" for å fortsette.';
$txt['upgrade_script'] = 'Kjører oppgraderingsskript';
$txt['upgrade_error'] = 'Feil!';
$txt['upgrade_unknown_error'] = 'Ukjent feil!';
/* Same sentence, 3 different strings */
$txt['upgrade_completed'] = 'Fullført';
$txt['upgrade_outof'] = 'tomt for';
$txt['upgrade_tables'] = 'tabeller';

$txt['upgrade_run_script'] = 'Vi anbefaler at du ikke kjører dette skriptet, med mindre du er sikker på at';
$txt['upgrade_run_script2'] = 'har fullført oppgradering.';
$txt['upgrade_run'] = 'Du kan velge å enten kjøre oppgraderingen igjen fra begynnelsen - eller alternativt fortsette fra det siste trinnet som ble nådd under den siste oppgraderingen.';

$txt['upgrade_completed_table'] = 'Fullført Tabell:';
$txt['upgrade_current_table'] = 'Nåværende Tabell:';
$txt['upgrade_fulltext'] = 'Vær oppmerksom på at fulltekstindeksen ble droppet for å lette konverteringen, og at den må gjenskapes i administratorområdet etter at oppgraderingen er fullført.';
$txt['upgrade_conversion_proceed'] = 'Konvertering fullført!  Klikk "Fortsett" for å gå videre.';
$txt['upgrade_convert_datajson'] = 'Konverterer data fra serialisering til JSON ...';
$txt['upgrade_json_completed'] = 'Konverterer til JSON fullført! Klikk "Fortsett" for å gå videre.';
$txt['upgrade_executing'] = 'Utfører:';
$txt['upgrade_of'] = 'av';
$txt['upgrade_admin_login'] = 'Admin Login:
';
$txt['upgrade_admin_disabled'] = '(Ikke tilgjengelig)';
$txt['upgrade_done'] = 'Oppgraderingen er fullført. Nå er du klar til å bruke <a href="%1$s/index.php"> installasjonen av SMF </a>. Håper du liker den!';

$txt['upgrade_delete_now'] = 'Slett "upgrade.php" and dens data filer nå';
$txt['upgrade_delete_server'] = '(fungerer ikke på alle servere).';
$txt['upgrade_problems'] = 'Hvis du hadde noen problemer med denne oppgraderingen, eller har problemer med å bruke SMF, ikke nøl med å <a href="%1$s"> se til oss for å få hjelp </a>.';
$txt['upgrade_luck'] = 'Lykke til,';

$txt['upgrade_ftp_login'] = 'Informasjon om din FTP-forbindelse';
$txt['upgrade_ftp_perms'] = 'Oppgraderingsprogrammet kan løse eventuelle problemer med filtillatelser for å gjøre oppgradering så enkel som mulig. Bare skriv inn tilkoblingsinformasjonen din nedenfor, eller alternativt klikk <a href="#" onclick="warning_popup();"> her </a> for en liste over filer som må endres.';
$txt['upgrade_ftp_warning'] = 'Advarsel';
$txt['upgrade_ftp_files'] = 'Følgende filer må gjøres skrivbare for å fortsette:';
$txt['upgrade_ftp_shell'] = 'Hvis du har kommando-linje konto (unix shell-account), kan den enkle kommandoen nedenfor korrigere tilgang til disse filene';
$txt['upgrade_ftp_error'] = 'Følgende feil oppstod under forsøk på å koble til:';

$txt['upgrade_ready_proceed'] = 'Takk for at du velger å oppgradere til SMF %1$s. Alle filer ser ut til å være på plass, og vi er klar til å fortsette.';
$txt['upgrade_error_script_js'] = 'Oppgraderingsskriptet kan ikke finne filen script.js eller den er utdatert. Sjekk at stien til mappen Theme er riktige. Du kan laste ned et verktøy for å sjekke innstillingene fra <a href="https://www.simplemachines.org">Simple Machines nettside</a>';
$txt['upgrade_warning_lots_data'] = 'Oppgraderingsskriptet har oppdaget at Forumet inneholder store mengder av data som trenger oppgradering. Denne prosessen kan ta ganske lang tid avhengig av server og størrelsen på forumet, og for veldig store fora (~ 300 000 meldinger) kan det ta flere timer å fullføre.';
$txt['upgrade_warning_out_of_date'] = 'Dette oppgraderingsskriptet er utdatert! Den gjeldende versjonen av SMF er <em id="smfVersion" style="white-space: nowrap;">??</em> men dette oppgraderingsskriptet er for <em id="yourVersion" style="white-space: nowrap;">%1$s</em>.<br><br>Det anbefales at du går til <a href="https://www.simplemachines.org">Simple Machines</a> nettsted for å sikre at du oppgraderer til nyeste versjon. ';

$txt['upgrade_forumdir_settings'] = 'Det <em>kan</em> se ut til at dine forum katalog-innstillinger er feil Din forums-katalog er &quot; %1$s &quot; men burde antagelig være &quot; %2$s &quot;. Settings.php forteller at dine stier er:';
$txt['upgrade_forumdir'] = 'Forum-katalog:';
$txt['upgrade_sourcedir'] = 'Kilde-katalog:';
$txt['upgrade_cachedir'] = 'Buffer-katalog:';
$txt['upgrade_incorrect_settings'] = 'Hvis disse virker feil, kan du åpne Settings.php i en teksteditor før du fortsetter med denne oppgraderingen. Hvis de er feil på grunn av at du flytter forumet ditt til et nytt sted, kan du laste ned og utføre <a href="https://download.simplemachines.org/?tools"> Reparasjonsinnstillinger </a> -verktøyet fra nettstedet Simple Machines før du fortsetter.';

$txt['upgrade_fulltext_error'] = 'Fullteksts søkeindeks ble droppet for å lette konverteringen. Du må gjenskape den.';
$txt['upgrade_writable_files'] = 'Følgende filer må skrives for å fortsette oppgraderingen. Sørg for at Windows-rettighetene er riktig innstilt slik at dette tillater:';
$txt['upgrade_time_user'] = '&quot; %1$s &quot; kjører oppgraderingsskriptet.	';

// We represent the time here in backwards variables, as it makes the code easier.
$txt['upgrade_time_hms'] = 'Oppgraderingsskriptet har kjørt de siste %3$d timer, %2$d minutter og %1$d sekunder.';
$txt['upgrade_time_ms'] = 'Oppgraderingsskriptet har kjørt de siste %2$d minutter og %1$d sekunder.';
$txt['upgrade_time_s'] = 'Oppgraderingsskriptet har kjørt de siste %1$d sekunder.';
$txt['upgrade_time_updated_hms'] = 'Oppgraderingsskriptet var sist oppdatert for %3$d timer, %2$d minutter og %1$d sekunder siden.';
$txt['upgrade_time_updated_hm'] = 'Oppgraderingsskriptet var sist oppdatert for  %2$d minutter og %1$d sekunder siden.';
$txt['upgrade_time_updated_s'] = 'Oppgraderingsskriptet var sist oppdatert for %1$d sekunder siden.';
$txt['upgrade_completed_time_hms'] = 'Oppgraderingsskriptet fullførte etter %3$d timer, %2$d minutter og %1$d sekunder.';
$txt['upgrade_completed_time_ms'] = 'Oppgraderingsskriptet fullførte etter %2$d minutter og %1$d sekunder.';
$txt['upgrade_completed_time_s'] = 'Oppgraderingsskriptet fullførte etter %1$d sekunder.';
$txt['upgrade_success_time_db'] = 'Suksess! Database oppgradering fullførte etter %3$d timer, %2$d minutter og %1$d sekunder.';

$txt['upgrade_unsuccessful'] = 'Mislykket!';
$txt['upgrade_thisquery'] = 'Denne spørringen:';
$txt['upgrade_causerror'] = 'Forårsaket feilen: ';
$txt['upgrade_completedtables_outof'] = 'Fullført  <span id="tab_done">%1$d</span> av %2$d tabeller.
';
$txt['upgrade_success'] = 'Suksessfylt!';
$txt['upgrade_loop'] = 'Oppgraderingsskriptet ser ut til å gå i en loop - steg:';
$txt['upgrade_respondtime'] = 'Tjeneren har ikke respondert siste %1$d sekunder. Det kan være vel verd å vente litt til før du prøver igjen.';
$txt['upgrade_respondtime_clickhere'] = 'Klikk her for å forsøke igjen.';
$txt['mtitle'] = 'Oppgraderer forum...';
$txt['mmessage'] = 'Ikke bekymre deg, forumet ditt vil bli oppdatert snart. Det tar bare et øyeblikk ;).';

// Upgrader error messages
// argument(s): template name (if applicable)
$txt['error_unexpected_template_call'] = 'Feil: Uventet kall for å bruke malen %1$s. Kopier og lim inn all teksten over og besøk SMF supportforum for å la utviklerne vite at det er en feil slik at de kan fikse den og få deg i gang igjen.';
$txt['error_invalid_template'] = 'Oppgradering avbrutt! Ugyldig mal:  template_%1$s';
$txt['error_lang_index_missing'] = 'Oppgraderingsskriptet kunne ikke finne språkfiler for valgt språk, %1$s.<br>SMF vil ikke virke med dette språket uten filene installert.<br><br>Installèr dem, eller <a href="%2$s?step=0;lang=english">forsøk engelsk istedenfor</a>.';
$txt['error_upgrade_files_missing'] = 'Oppgradereren kunne ikke finne noen viktige filer. <br> <br> Forsikre deg om at du lastet opp alle filene som er inkludert i pakken, inkludert temaer, kilder og andre kataloger.';
$txt['error_upgrade_old_files'] = 'Oppgradereren fant noen gamle eller utdaterte filer. <br> <br> Forsikre deg om at du lastet opp de nye versjonene av alle filene som er inkludert i pakken.';
$txt['error_upgrade_old_lang_files'] = 'Oppgradereren fant noen gamle eller utdaterte språkfiler for det valgte språket,%1$s. <br> <br> Vær sikker på at du lastet opp de nye versjonene av alle filene som er inkludert i pakken, til og med tema- og språkfiler for standardtema. <br>&nbsp;&nbsp;&nbsp;[<a href="%2$s?skiplang">SKIP</a>] [<a href="%2$s?lang=english">Forsøk engelsk</a>]';
$txt['error_php_too_low'] = 'Advarsel! Det ser ut som du har en PHP-versjon installert på webserveren som <strong>ikke møter SMFs minimumskrav</strong>.<br>Dersom du ikke er leverandøren av nettserveren, må du be din leverandør om å oppgradere, eller bruke en annen leverandør - uansett, bør den oppgraderes til en nyere versjon.<br><br>Dersom du vet at du faktisk bruker en PHP-versjon som er tilstrekkelig, må du gjerne fortsette. Men du er sterkt frarådet fra å gjøre det.';
$txt['error_db_too_low'] = 'Versjonen på databaseserver er svært gammel, og oppfyller ikke SMF minimumskrav.<br><br>Spør din server leverandør om å oppgradere.';
$txt['error_db_privileges'] = 'Brukeren %1$s satt i Settings.php har ikke nok rettigheter.<br><br>Be din serveradmin om å gi denne brukeren rettigheter til ALTER, CREATE, og DROP i databasen.';
$txt['error_dir_not_writable'] = 'Katalogen: %1$s må være skrivbar for å fortsette oppgraderingen. Korriger rettighetene og forsøk igjen.
';
$txt['error_cache_not_found'] = 'Buffer katalogen kunne ikke finnes.<br><br> Se til at du har en katalog kalt &quot;cache&quot; i forum-katalogen og prøv igjen.
';
$txt['error_agreement_not_writable'] = 'Oppgradereren kunne ikke få skrivetilgang til Agreement.txt. <br> <br> Hvis du bruker en linux- eller unix-basert server, må du forsikre deg om at filen er chmod\'d til 777, eller hvis den ikke eksisterer at katalogen denne oppgradereren er i er 777. <br> Hvis serveren din kjører Windows, må du forsikre deg om at internettgjestkontoen har de riktige rettighetene på den eller mappen.';
$txt['error_not_admin'] = 'Du må være en administrator for å oppgradere.';

$txt['warning_lang_old'] = 'Språkfilene for det valgte språket ditt,%1$s, er ikke oppdatert til den nyeste versjonen. Oppgraderingen fortsetter med forumets standard %2$s.';
$txt['warning_lang_missing'] = 'Oppgradereren kunne ikke finne språkinstallasjonen "Install" for det valgte språket ditt, %1$s. Oppgraderingen fortsetter med forumets standard %2$s.';

// Attachment & Avatar folder checks
$txt['warning_av_missing'] = 'Advarsel! Avatar katalog ikke funnet. Det kan være utrygt å fortsette. Vennligst bekreft katalog-oppsett før du fortsetter.';
$txt['warning_custom_av_missing'] = 'Advarsel! Avatar katalog for egne avatarer ikke funnet. Det kan være utrygt å fortsette. Vennligst bekreft katalog-oppsett før du fortsetter.';
$txt['warning_att_dir_missing'] = 'Advarsel! En eller flere kataloger for filvedlegg ikke funnet. Det kan være utrygt å fortsette. Vennligst bekreft katalog-oppsett før du fortsetter.';

// Page titles
$txt['updating_smf_installation'] = 'Oppdaterer SMF installasjonen din!';
$txt['upgrade_options'] = 'Oppgraderingsvalg';
$txt['backup_database'] = 'Sikkerhetskopierer database';
$txt['database_changes'] = 'Database-endringer';
$txt['upgrade_complete'] = 'Oppgradering fullført';
$txt['converting_utf8'] = 'Konverterer til UTF-8';
$txt['converting_json'] = 'Konverterer til JSON';

?>