<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Bun venit pe {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Mulțumim că te-ai înregistrat pe {FORUMNAME}. Numele tău de utilizator este {USERNAME}. Dacă ai uitat parola, poți sa o resetezi accesând {FORGOTPASSWORDLINK}.

Înainte de a te putea autentifica, trebuie mai întâi să activezi contul apăsând pe următorul link:

{ACTIVATIONLINK}

Dacă ai probleme cu activarea, te rog vizitează {ACTIVATIONLINKWITHOUTCODE} și introdu codul "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Bun venit pe {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Bună {REALNAME}, cererea ta de înregistrate pe {FORUMNAME} a fost primită.

Numele de utilizator cu care te-ai înregistrat a fost {USERNAME}.

Înainte de a te putea autentifica și să începi să utilizezi forumul, solicitarea ta este nevoie sa fie examinată și aprobată.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Aprobare pentru calitatea de membru al grupului';
$txt['mc_group_approve_body'] = '{USERNAME},

Ne face plăcere să anunțăm că cererea ta de a te alătura grupului "{GROUPNAME}" grup pe {FORUMNAME} a fost acceptată, iar contul tău a fost actualizat pentru a include acest nou grup de membri.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Respingerea calității de membru al grupului';
$txt['mc_group_reject_body'] = '{USERNAME},

Ne pare rău să te anunțăm dar cererea de a te alătura grupului "{GROUPNAME}" grup pe {FORUMNAME} a fost respinsă.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Respingerea calității de membru al grupului';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

Ne pare rău să te anunțăm dar cererea de a te alătura grupului "{GROUPNAME}" grup pe {FORUMNAME} a fost respinsă.

Acest lucru se datorează următorului motiv: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Bun venit pe {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Bun venit, {NAME}

Contul tău a fost activat manual de către un administrator iar acum te poți autentifica. Numele tău de utilizator este: {USERNAME}. Dacă ai uitat parola, o poți schimba accesând următorul link {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Bun venit pe {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Bun venit, {USERNAME}!

Contul tău pe {FORUMNAME} a fost aprobat de administratorul forumului. Înainte de a te putea autentifica, trebuie mai întâi să activezi contul accesând următorul link:

{ACTIVATIONLINK}

Dacă ai probleme cu activarea, te rugăm să accesezi {ACTIVATIONLINKWITHOUTCODE} și să introduci codul "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Înregistrare Respinsă';
$txt['admin_approve_reject_body'] = '{USERNAME},

Din păcate, cererea ta de înscriere pe {FORUMNAME} a fost respinsă.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Cont Șters';
$txt['admin_approve_delete_body'] = '{USERNAME},

Contul tău de pe {FORUMNAME} a fost șters. Acest lucru se poate datora faptului că nu ai activat contul, caz în care acum este nevoie să te înregistrezi din nou.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Reamintire Înregistrare';
$txt['admin_approve_remind_body'] = '{USERNAME},
Contul tău pe {FORUMNAME} încă nu este activat.

Te rugăm să accesezi linkul de mai jos pentru activarea contului:
{ACTIVATIONLINK}

Dacă ai probleme cu activarea contului, te rugăm să accesezi {ACTIVATIONLINKWITHOUTCODE} și introdu codul "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Bun venit pe {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Mulțumim că te-ai înregistrat pe {FORUMNAME}. Numele tău de utilizator este {USERNAME} iar parola este {PASSWORD}.

Înainte de a te putea autentifica, trebuie mai întâi să activezi contul accesând următorul link:

{ACTIVATIONLINK}

Dacă ai probleme cu activarea, te rugăm să accesezi {ACTIVATIONLINKWITHOUTCODE} și introdu codul "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Bun venit pe {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Mulțumim că te-ai înregistrat pe {FORUMNAME}. Numele tău de utilizator este {USERNAME}, iar parola este {PASSWORD} și link-ul către forum este: {SCRIPTURL}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Anunț nou: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

Poți vedea anunțul complet accesează următorul link:
{TOPICLINK}

Pentru a te dezabona de la aceste anunțuri, accesează următorul link:
{UNSUBSCRIBELINK}

Pentru mai mult control asupra notificărilor pe care le primești prin e-mail, conectează-te pe forum și accesează zona Notificări din profilul tău.

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Subiect nou: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Un subiect nou, \'{TOPICSUBJECT}\', a fost creat într-o secțiune pe care o urmărești.

Poți vedea subiectul accesând următorul link:
{TOPICLINK}

Pot fi postate mai multe subiecte, dar nu vei primi mai multe notificări prin e-mail pentru acestă secțiune până când nu vei reveni la forum să citești unele dintre ele.

Textul subiectului este prezentat mai jos:
{MESSAGE}

Dezabonează-te de la subiectele noi de pe acest forum accesând următorul link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Subiect nou: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Un subiect nou, \'{TOPICSUBJECT}\', a fost creat într-o secțiune pe care o urmărești.

Poți vedea subiectul accesând următorul link:
{TOPICLINK}

Pot fi postate mai multe subiecte, dar nu vei primi mai multe notificări prin e-mail pentru acestă secțiune până când nu vei reveni la forum să citești unele dintre ele.

Dezabonează-te de la subiectele noi de pe acest forum accesând următorul link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Subiect nou: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Un subiect nou, \'{TOPICSUBJECT}\', a fost creat într-o secțiune pe care o urmărești.

Poți vedea subiectul accesând următorul link:
{TOPICLINK}

Textul subiectului este prezentat mai jos:
{MESSAGE}

Dezabonează-te de la subiectele noi de pe acest forum accesând următorul link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Subiect nou: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Un subiect nou, \'{TOPICSUBJECT}\', a fost creat într-o secțiune pe care o urmărești.

Poți vedea subiectul accesând următorul link:
{TOPICLINK}

Dezabonează-te de la subiectele noi de pe acest forum accesând următorul link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Răspuns subiect: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'A reply has been posted in \'{SUBJECT}\' by {POSTERNAME}.

You can see it at
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'New Unapproved Attachment in: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'Un nou atașament a fost făcut în \'{SUBJECT}\' care trebuie aprobat.

Poți aproba sau respinge acest atașament accesând linkul de mai jos, care te va duce la mesajul din care face parte.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Postare Nou Neaprobată: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'A fost făcută o nouă postare care trebuie aprobată: \'{SUBJECT}\'

Poți aproba sau respinge această postare accesând linkul de mai jos:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'New Unapproved Topic: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'A fost creat un nou subiect care trebuie aprobat: \'{SUBJECT}\'

Poți aproba sau respinge acest subiect accesând linkul de mai jos:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Aplicație pentru Grup nou';
$txt['request_membership_body'] = '{RECPNAME},

{APPLYNAME} has requested membership to the "{GROUPNAME}" group. The user has given the following reason:

{REASON}

You can approve or reject this application by using the link below:

{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Abonament pe cale să expire la {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Your subscription at {FORUMNAME} is about to expire. If you have elected to auto-renew, you do not need to take action; otherwise, you may wish to consider subscribing once more. Details are below:

Subscription Name: {SUBSCRIPTION}
Expires: {END_DATE}

To edit your subscriptions visit the following URL:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Bine ai revenit pe {FORUMNAME}';
$txt['activate_reactivate_body'] = 'Contul tău a fost dezactivat, pentru a revalida adresa de e-mail accesează următorul link pentru activarea contului din nou:
{ACTIVATIONLINK}

Dacă ai probleme cu activarea, te rugăm să accesezi {ACTIVATIONLINKWITHOUTCODE} și folosește codul "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Noua parolă pentru {FORUMNAME}';
$txt['forgot_password_body'] = 'Dragă {REALNAME},
Acest e-mail a fost trimis deoarece funcția \'am uitat parola\' a fost aplicată acestui cont. Pentru a seta o nouă parolă, accesează următorul link:
{REMINDLINK}

IP: {IP}
Nume: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Postare raportată: {TOPICSUBJECT} de {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Postarea următoare, "{TOPICSUBJECT}" în {POSTERNAME} a fost raportată de {REPORTERNAME} într-o secțiune pe care tu o moderezi:

Subiectul: {TOPICLINK}
Centrul de moderare: {REPORTLINK}

Utilizatorul apelant a făcut următorul comentariu:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Follow-up to reported post: {TOPICSUBJECT} by {POSTERNAME}';
$txt['reply_to_moderator_body'] = 'Previously, "{TOPICSUBJECT}" was reported to moderators.

Since then, {COMMENTERNAME} has added a comment to the report. More information can be found on the forum.

The topic: {TOPICLINK}
Moderation center: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Profilul raportat: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'Profilul lui "{MEMBERNAME}" a fost raportat de {REPORTERNAME}.

Profilul: {PROFILELINK}
Centrul de moderare: {REPORTLINK}

Utilizatorul apelant a făcut următorul comentariu:
{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Follow-up to reported profile: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = 'Anterior, profilul lui {MEMBERNAME} a fost raportat.

De atunci, {COMMENTERNAME} a adăugat un comentariu la raportare. Mai multe informații pot fi găsite pe forum.

Profilul: {PROFILELINK}
Centrul de moderare: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Detalii parolă nouă';
$txt['change_password_body'] = 'Dragă {USERNAME},

Detaliile de conectare pe {FORUMNAME} au fost modificate și parola a fost resetata. Mai jos sunt noile tale detalii de conectare.

Numele de utilizator este "{USERNAME}" si parola este "{PASSWORD}".

Le poți schimba după ce te conecttezi accesând pagina de profil sau vizitând această pagină după ce te conectezi:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Bun venit pe {FORUMNAME}';
$txt['register_activate_body'] = 'Thank you for registering at {FORUMNAME}. Your username is {USERNAME}. If you forget your password, you can reset it by visiting {FORGOTPASSWORDLINK}.

Before you can log in, you first need to activate your account. To do so, please follow this link:

{ACTIVATIONLINK}

Should you have any problems with activation, please visit {ACTIVATIONLINKWITHOUTCODE} and use the code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Bun venit pe {FORUMNAME}';
$txt['register_coppa_body'] = 'Thank you for registering at {FORUMNAME}. Your username is {USERNAME}. If you forget your password, you can change it at {FORGOTPASSWORDLINK}

Before you can log in, the admin requires consent from your parent/guardian for you to join the community. You can obtain more information at the link below:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Bun venit pe {FORUMNAME}';
$txt['register_immediate_body'] = 'Mulțumim că te-ai înregistrat pe {FORUMNAME}. Numele tău de utilizator este {USERNAME}. Dacă ai uitat parola, o poți schimba accesând {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Bun venit pe {FORUMNAME}';
$txt['register_pending_body'] = 'Hello {REALNAME}, your registration request at {FORUMNAME} has been received.

The username you want to register with was {USERNAME}. If you forget your password, you can change it at {FORGOTPASSWORDLINK}.

Before you can log in and start using the forum, your request will be reviewed and approved.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Răspuns subiect: {TOPICSUBJECT}';
$txt['notification_reply_body'] = 'In a topic you are watching, a reply has been posted by {POSTERNAME}.

View the reply at: {TOPICLINK}

Unsubscribe from this topic by using this link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Răspuns subiect: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = 'In a topic you are watching, a reply has been posted by {POSTERNAME}.

View the reply at: {TOPICLINK}

Unsubscribe from this topic by using this link: {UNSUBSCRIBELINK}

The text of the reply is shown below:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Răspuns subiect: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = 'In a topic you are watching, a reply has been posted by {POSTERNAME}.

View the reply at: {TOPICLINK}

Unsubscribe from this topic by using this link: {UNSUBSCRIBELINK}

More replies may be posted, but you won\'t receive any more notifications for this topic until you visit it.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Răspuns subiect: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = 'In a topic you are watching, a reply has been posted by {POSTERNAME}.

View the reply at: {TOPICLINK}

Unsubscribe from this topic by using this link: {UNSUBSCRIBELINK}

The text of the reply is shown below:
{MESSAGE}

More replies may be posted, but you won\'t receive any more notifications for this topic until you visit it.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Subiect stickat: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'A topic you are watching has been marked as a sticky topic.

View the topic at: {TOPICLINK}

Unsubscribe from this topic by using this link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Topic locked: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'A topic you are watching has been locked.

View the topic at: {TOPICLINK}

Unsubscribe from this topic by using this link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Subiect deblocat: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'A topic you are watching has been unlocked.

View the topic at: {TOPICLINK}

Unsubscribe from this topic by using this link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Topic removed: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Un subiect pe care îl urmărești a fost eliminat.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Topic moved: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'A topic you are watching has been moved to another board.

View the topic at: {TOPICLINK}

Unsubscribe from this topic by using this link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Subiectul îmbinat: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'A topic you are watching has been merged with another topic.

View the new merged topic at: {TOPICLINK}

Unsubscribe from this topic by using this link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Divizare subiect: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'A topic you are watching has been split into two or more topics.

View what remains of this topic at: {TOPICLINK}

Unsubscribe from this topic by using this link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'S-a alăturat unui nou membru';
$txt['admin_notify_body'] = '{USERNAME} tocmai s-a înscris ca membru nou al forumului tău. Accesează linkul de mai jos pentru a vedea profilul.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'S-a alăturat unui nou membru';
$txt['admin_notify_approval_body'] = '{USERNAME} tocmai s-a înscris ca membru nou al forumului tău. Accesează linkul de mai jos pentru a vedea profilul.
{PROFILELINK}

Înainte ca acest membru să poată începe să posteze, trebuie mai întâi ca contul să fie aprobat. Accesează linkul de mai jos pentru a merge la secțiunea de aprobare.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Urgent! Directorul atașamentelor este aproape plin';
$txt['admin_attachments_full_body'] = '{REALNAME},

The attachments directory at {FORUMNAME} is almost full. Please visit the forum to resolve this problem.

Once the attachments directory reaches its maximum permitted size users will not be able to continue to post attachments or upload custom avatars (if enabled).

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Abonament Plătit Rambursat';
$txt['paid_subscription_refund_body'] = '{REALNAME},

Un membru a primit o rambursare pentru un abonament plătit. Mai jos sunt detaliile acestui abonament:

	Abonament: {NAME}
	Nume utilizator: {REFUNDNAME} ({REFUNDUSER})
	Data: {DATE}

Poți vedea profilul membrului accesând link-ul de mai jos:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Abonament nou plătit';
$txt['paid_subscription_new_body'] = '{REALNAME},

Un membru a încheiat un nou abonament plătit. Mai jos sunt detaliile acestui abonament:

	Abonament: {NAME}
	Nume utilizator: {SUBNAME} ({SUBUSER})
	Email utilizator: {SUBEMAIL}
	Preț: {PRICE}
	Data: {DATE}

Poți vedea profilul membrului accesând link-ul de mai jos:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Eroare de abonare plătită';
$txt['paid_subscription_error_body'] = 'Dragă {REALNAME},

Următoarea eroare a apărut la procesarea unui abonament plătit
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Mesaj Personal nou: {SUBJECT}';
$txt['new_pm_body'] = 'Tocmai ți-a trimis un mesaj personal {SENDER} pe {FORUMNAME}.

IMPORTANT: Aceasta este doar o notificare. Te rugăm să nu răspunzi la acest e-mail.

Citește acest mesaj personal aici: {READLINK}

Răspunde la acest mesaj personal aici: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Mesaj personal nou: {SUBJECT}';
$txt['new_pm_body_body'] = 'Tocmai ți-a trimis un mesaj personal {SENDER} pe {FORUMNAME}.

IMPORTANT: Aceasta este doar o notificare. Te rugăm să nu răspunzi la acest e-mail.

Mesajul este: 

{MESSAGE}

Răspunde la acest mesaj personal aici: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Mesaj personal nou: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'You and {TOLIST} have just been sent a personal message by {SENDER} on {FORUMNAME}.

IMPORTANT: Remember, this is just a notification. Please do not reply to this email.

Read this Personal Message here: {READLINK}

Reply to this Personal Message (to the sender only) here: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Mesaj Personal nou: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'You and {TOLIST} have just been sent a personal message by {SENDER} on {FORUMNAME}.

IMPORTANT: Remember, this is just a notification. Please do not reply to this email.

The message they sent you was:

{MESSAGE}

Reply to this Personal Message (to the sender only) here: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Ați fost citat în post: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Bună {MEMBERNAME},

Postarea ta a fost citată în "{CONTENTSUBJECT}" de {QUOTENAME}, poți vedea postarea accesând următorul link:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Ați fost menționat în post: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Bună {MEMBERNAME},

Numele tău a fost menționat în "{CONTENTSUBJECT}" de {MENTIONNAME}, poți vedea postarea accesând următorul link:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'La mulți ani de la {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Dragă {REALNAME},

Noi {FORUMNAME} îți urăm un călduros La mulți ani! Fie ca această zi și anul ce urmează să îți fie pline de bucurie si împlinire.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'La ziua de naştere...';
$txtBirthdayEmails['karlbenson1_body'] = 'We could have sent you a birthday card. We could have sent you some flowers or a cake.

But we didn\'t.

We could have even sent you one of those automatically generated messages to wish you happy birthday where we don\'t even have to replace INSERT NAME.

But we didn\'t.

We wrote this birthday greeting just for you.

We would like to wish you a very special birthday.

{REGARDS}

//:: This message was automatically generated :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'La mulți ani!';
$txtBirthdayEmails['nite0859_body'] = 'Prietenii tăi de pe {FORUMNAME} iși doresc să îți rupă un moment din timpul tău pentru a-ți ura La mulți ani, {REALNAME}. Dacă nu ai făcut deja acest lucru, te rugăm să vizitezi comunitatea noastră pentru ca ceilalți să aibă ocazia să-ți transmită salutările călduroase.

Chiar dacă astăzi este ziua ta, {REALNAME}, dorim să îți reamintim că calitatea ta de membru al comunității noastre este cel mai bun cadou pentru noi de până acum.

Cele mai bune gânduri,
Comunitatea {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Data nașterii Dorește lui {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Dragă {REALNAME},

A mai trecut un an din viața ta. Noi {FORUMNAME} sperăm că a fost plin de fericire și îți dorim noroc în cea ce urmează să faci.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'La mulți ani, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Știi la cine e ziua de naștere azi, {REALNAME}?

Noi știm... A TA!

La mulți ani!

Acum ești cu un an mai mare, și sperăm că ești mult mai fericit decât anul trecut.

Bucură-te de ziua ta astăzi, {REALNAME}!

- Din partea familiei {FORUMNAME}';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Felicitarea de ziua ta';
$txtBirthdayEmails['karlbenson2_body'] = 'Sperăm ca ziua ta să fie cea mai bună din toate timpurile; înnorat, însorit sau indiferent de vreme.
Să ai un tort mare de aniversare și distracție pe cinste, te așteptăm sa ne spui cum ai petrecut.

Sperăm ca acest mesaj să îți aducă bucurie care să dureze, până în același timp, în același loc, anul viitor.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>