<?php
// Version: 2.1.3; Install

// These should be the same as those in index.language.php.
$txt['lang_character_set'] = 'UTF-8';
$txt['lang_rtl'] = '0';

$txt['install_step_welcome'] = 'Välkommen';
$txt['install_step_writable'] = 'Kontroll av skrivrättigheter';
$txt['install_step_forum'] = 'Foruminställningar';
$txt['install_step_databaseset'] = 'Databasinställningar';
$txt['install_step_databasechange'] = 'Databaspopulation';
$txt['install_step_admin'] = 'Administratörskonto';
$txt['install_step_delete'] = 'Slutför installation';

$txt['smf_installer'] = 'SMF installationsguide';
$txt['installer_language'] = 'Språk';
$txt['installer_language_set'] = 'Ställ in';
$txt['congratulations'] = 'Grattis, installationen har slutförts!';
$txt['congratulations_help'] = 'Om du vid något tillfälle behöver support, eller om SMF inte fungerar som det ska, kom ihåg att det finns <a href="https://www.simplemachines.org/community/index.php" target="_blank" rel="noopener">hjälp att tillgå</a> om du behöver det.';
$txt['still_writable'] = 'Din installationskatalog är fortfarande skrivbar. Av säkerhetsskäl är det en bra idé att ändra rättigheterna (CHMOD), så att katalogen inte längre är skrivbar.';
$txt['delete_installer'] = 'Klicka här för att ta bort install.php';
$txt['delete_installer_maybe'] = '<em>(fungerar inte på alla servrar.)</em>';
$txt['go_to_your_forum'] = 'Nu kan du se <a href="%1$s">ditt färdiginstallerade forum</a> och börja använda det. Du bör först se till att du är inloggad, sen kan du komma åt administrationscentret.';
$txt['good_luck'] = 'Lycka till!<br>Simple Machines';

$txt['install_welcome'] = 'Välkommen';
$txt['install_welcome_desc'] = 'Välkommen till SMF. Detta skript kommer att guida dig genom installationen av %1$s. Vi kommer samla in en del information om ditt forum och efter några minuter kommer ditt forum vara klart för användning.';
$txt['install_no_https'] = 'Din miljö stödjer inte https-strömmar. Vissa funktioner, t.ex. att ta emot uppdateringar från SimleMachines.org, kommer inte att fungera.';
$txt['install_no_mbstring'] = 'Din miljö stödjer inte det nödvändiga biblioteket mbstring. Vänligen aktivera mbstring och försök igen.';
$txt['install_no_fileinfo'] = 'Din miljö stödjer inte det nödvändiga biblioteket fileinfo. Vänligen aktivera fileinfo och försök igen.';
$txt['install_all_lovely'] = 'Vi har utfört några inledande tester av din server och allt verkar vara i sin ordning. Klicka bara på "Fortsätt" för att börja.';

$txt['user_refresh_install'] = 'Forumet uppdaterat';
$txt['user_refresh_install_desc'] = 'Under installationen upptäckte installationsguiden att (med uppgifterna du angett) en eller flera av tabellerna som skulle skapas, redan finns på servern.<br>Eventuella saknade tabeller i din installation har återskapats med standarddata, men ingenting har tagits bort eller ändrats från dina befintliga tabeller.';

$txt['default_topic_subject'] = 'Välkommen till SMF!';
$txt['default_topic_message'] = 'Välkommen till detta Simple Machines-forum!<br><br>Vi hoppas du kommer att tycka om att använda forumet.&nbsp; Om du har problem, är du välkommen att [url=https://www.simplemachines.org/community/index.php]be oss om hjälp[/url].<br><br>Tack!<br>Simple Machines';
$txt['default_board_name'] = 'Generell diskussion';
$txt['default_board_description'] = 'Känn dig fri att prata om vad som helst på denna tavla.';
$txt['default_category_name'] = 'Allmänn kategori';
$txt['default_time_format'] = '%e %B %Y kl. %H:%M';
$txt['default_news'] = 'SMF - Precis installerat!';
$txt['default_reserved_names'] = 'Administratör\nWebmaster\nGäst\nroot';
$txt['default_fugue_smileyset_name'] = 'Fugues uppsättning';
$txt['default_alienine_smileyset_name'] = 'Alienines uppsättning';
$txt['default_aaron_smileyset_name'] = 'Aarons uppsättning';
$txt['default_akyhne_smileyset_name'] = 'Akyhnes uppsättning';
$txt['default_legacy_smileyset_name'] = '2.0 Standard';
$txt['default_theme_name'] = 'SMF Standardtema - Curve2';

$txt['default_administrator_group'] = 'Administratör';
$txt['default_global_moderator_group'] = 'Global moderator';
$txt['default_moderator_group'] = 'Moderator';
$txt['default_newbie_group'] = 'Nybörjare';
$txt['default_junior_group'] = 'Juniormedlem';
$txt['default_full_group'] = 'Fullvärdig medlem';
$txt['default_senior_group'] = 'Seniormedlem';
$txt['default_hero_group'] = 'Hjältemedlem';

$txt['default_smiley_smiley'] = 'Smiley';
$txt['default_wink_smiley'] = 'Med glimten i ögat';
$txt['default_cheesy_smiley'] = 'Glad';
$txt['default_grin_smiley'] = 'Skrattande';
$txt['default_angry_smiley'] = 'Arg';
$txt['default_sad_smiley'] = 'Ledsen';
$txt['default_shocked_smiley'] = 'Chockad';
$txt['default_cool_smiley'] = 'Iskall';
$txt['default_huh_smiley'] = 'Va?';
$txt['default_roll_eyes_smiley'] = 'Rullande ögon (ironi)';
$txt['default_tongue_smiley'] = 'Tunga';
$txt['default_embarrassed_smiley'] = 'Generad';
$txt['default_lips_sealed_smiley'] = 'Läpparna förseglade';
$txt['default_undecided_smiley'] = 'Obeslutsam';
$txt['default_kiss_smiley'] = 'Kyss';
$txt['default_cry_smiley'] = 'Gråta';
$txt['default_evil_smiley'] = 'Ond';
$txt['default_azn_smiley'] = 'Asiat';
$txt['default_afro_smiley'] = 'Afro';
$txt['default_laugh_smiley'] = 'Skrattande';
$txt['default_police_smiley'] = 'Polis';
$txt['default_angel_smiley'] = 'Ängel';

$txt['error_message_click'] = 'Klicka här';
$txt['error_message_try_again'] = 'för att försöka att göra om detta steg.';
$txt['error_message_bad_try_again'] = 'för att försöka att installera i alla fall, men observera att vi <em>avråder starkt</em> från detta.';

$txt['install_settings'] = 'Foruminställningar';
$txt['install_settings_info'] = 'På denna sida kan du ställa in några grundläggande inställningar för ditt forum. SMF har automatiskt hittat vissa av inställningarna åt dig.';
$txt['install_settings_name'] = 'Forumnamn';
$txt['install_settings_name_info'] = 'Detta är namnet på ditt forum, t.ex. "Testforumet".';
$txt['install_settings_name_default'] = 'Mitt forum';
$txt['install_settings_url'] = 'Forumets adress';
$txt['install_settings_url_info'] = 'Detta är Internetadressen till ditt forum <strong>utan avslutande \'/\'!</strong>.<br>I de flesta fall kan du lämna detta fält orört då standardvärdet oftast är rätt.';
$txt['install_settings_reg_mode'] = 'Registreringsläge';
$txt['install_settings_reg_modes'] = 'Registreringslägen';
$txt['install_settings_reg_immediate'] = 'Direktregistrering';
$txt['install_settings_reg_email'] = 'E-postaktivering';
$txt['install_settings_reg_admin'] = 'Administratör måste godkänna';
$txt['install_settings_reg_disabled'] = 'Registrering avstängd';
$txt['install_settings_reg_mode_info'] = 'Detta fält låter dig bestämma registreringsläge för att motverka oönskade registreringar.';
$txt['install_settings_compress'] = 'Komprimering med Gzip';
$txt['install_settings_compress_title'] = 'Komprimera data för att spara bandbredd.';
// In this string, you can translate the word "PASS" to change what it says when the test passes.
$txt['install_settings_compress_info'] = 'Denna funktion fungerar inte på alla servrar, men kan spara mycket bandbredd.<br>Klicka <a href="install.php?obgz=1&amp;pass_string=OK" onclick="return reqWin(this.href, 200, 60);" target="_blank" rel="noopener">här</a> för att testa det. (är allt som det ska, så ska det bara stå "OK".)';
$txt['install_settings_dbsession'] = 'Databassessioner';
$txt['install_settings_dbsession_title'] = 'Använd databasen för att lagra sessioner, istället för att använda filer.';
$txt['install_settings_dbsession_info1'] = 'Denna funktion är nästan alltid bäst att ha påslagen, då det gör sessioner mer pålitliga.';
$txt['install_settings_dbsession_info2'] = 'Denna funktion är som regel en bra idé, men det kanske inte fungerar som det ska på denna server.';
$txt['install_settings_stats'] = 'Tillåt statistikinsamling';
$txt['install_settings_stats_title'] = 'Tillåt Simple Machines att samla in allmän statistik månadsvis';
$txt['install_settings_stats_info'] = 'Detta tillåter Simple Machines att besöka ditt forum en gång i månaden, för att samla in allmän statistik. Detta hjälper oss att fatta beslut om vilka konfigurationer som vi ska optimera forumprogramvaran för. För mer information, vänligen besök vår <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">informationssida</a> (endast på engelska).';
$txt['install_settings_proceed'] = 'Fortsätt';

$txt['db_settings'] = 'Databasserver-inställningar';
$txt['db_settings_info'] = 'Det här är inställningarna för din databasserver. Om du inte vet vad som ska stå här, bör du fråga ditt webbhotell.';
$txt['db_settings_type'] = 'Databastyp';
$txt['db_settings_type_info'] = 'Flera databastyper hittades - välj vilken du vill använda. Notera att det inte går att använda pre-SMF 2.0 RC3 tillsammans med nyare SMF-versioner i samma PostgreSQL-databas. Isåfall behöver du uppgradera din gamla installation.';
$txt['db_settings_server'] = 'Servernamn';
$txt['db_settings_server_info'] = 'Detta är nästan alltid localhost - så om du inte vet, prova med localhost.';
$txt['db_settings_username'] = 'Användarnamn';
$txt['db_settings_username_info'] = 'Ange det användarnamn du behöver för att ansluta till databasen här.<br>Om du inte vet, prova med användarnamnet till ditt FTP-konto, i många fall är de samma.';
$txt['db_settings_password'] = 'Lösenord';
$txt['db_settings_password_info'] = 'Ange det lösenord du behöver för att ansluta till databasen.<br>Om du inte vet, prova med lösenordet till ditt FTP-konto.';
$txt['db_settings_database'] = 'Databasnamn';
$txt['db_settings_database_info'] = 'Fyll namet på databasen du vill att SMF ska använda för att lagra data i.';
$txt['db_settings_database_info_note'] = 'Om inte denna databas finns kommer installationsguiden försöka skapa den.';
$txt['db_settings_port'] = 'Databasport';
$txt['db_settings_port_info'] = 'Lämna tomt för att använda standardvärdet';
$txt['db_settings_prefix'] = 'Tabellprefix';
$txt['db_settings_prefix_info'] = 'Detta prefix kommer att läggas till i början av alla tabellnamn i databasen. <strong>Installera inte två forum med samma prefix!</strong><br>Detta värde gör det möjligt att installera flera forum i samma databas.';
$txt['db_populate'] = 'Fyll databas';
$txt['db_populate_info'] = 'Dina inställningar har nu sparats och databasen har fyllts med all data som krävs för att få igång ditt forum. Sammanfattning av databasändringar:';
$txt['db_populate_info2'] = 'Klicka på "Fortsätt" för att gå vidare till sidan där du skapar ett administratörskonto.';
$txt['db_populate_inserts'] = 'Lade till %1$d rader.';
$txt['db_populate_tables'] = 'Skapade %1$d tabeller.';
$txt['db_populate_insert_dups'] = 'Ignorerade %1$d dubbletter.';
$txt['db_populate_table_dups'] = 'Ignorerade %1$d dubbla tabeller.';

$txt['user_settings'] = 'Skapa ditt konto';
$txt['user_settings_info'] = 'Installationsguiden kommer nu skapa ett administratörskonto åt dig.';
$txt['user_settings_username'] = 'Ditt användarnamn';
$txt['user_settings_username_info'] = 'Välj det namn du vill logga in med.<br>Detta kan ändras senare.';
$txt['user_settings_password'] = 'Lösenord';
$txt['user_settings_password_info'] = 'Ange det lösenord du vill använda här, och se till att komma ihåg det!';
$txt['user_settings_again'] = 'Lösenordet igen';
$txt['user_settings_again_info'] = '(endast för verifiering).';
$txt['user_settings_admin_email'] = 'E-postadress till administratören';
$txt['user_settings_admin_email_info'] = 'Din e-postadress. Detta måste vara en giltig e-postadress!';
$txt['user_settings_server_email'] = 'E-postadress till webmaster';
$txt['user_settings_server_email_info'] = 'Ange <strong>e-postadressen som SMF ska använda för att skicka e-post</strong>. Detta måste vara en giltig e-postadress!';
$txt['user_settings_database'] = 'Databaslösenord';
$txt['user_settings_database_info'] = 'Av säkerhetsskäl kräver installationsprogrammet att du anger lösenordet till databasen för att skapa ett administratörskonto.';
$txt['user_settings_skip'] = 'Hoppa över';
$txt['user_settings_skip_sure'] = 'Vill du verkligen hoppa över skapandet av ett administratörskonto?';
$txt['user_settings_proceed'] = 'Avsluta';

$txt['ftp_checking_writable'] = 'Kontrollerar att filer är skrivbara';
$txt['ftp_setup'] = 'FTP-anslutningsinformation';
$txt['ftp_setup_info'] = 'Installationsguiden kan ansluta till din server via FTP, för att automatiskt kunna ställa in rättigheter på filer som behöver vara skrivbara. Om detta inte fungerar för dig, måste du ställa in dessa rättigheter manuellt. Observera att denna funktion i dagsläget inte stödjer säkra FTP-anslutningar via SSL.';
$txt['ftp_setup_why'] = 'Vad behövs detta för?';
$txt['ftp_setup_why_info'] = 'End del filer måste vara skrivbara, för att SMF ska fungera korrekt. Detta steg låter installationsguiden göra dem skrivbara åt dig. Denna funktion fungerar dock inte för alla - om så är fallet för dig, vänligen gör följande filer skrivbara (CHMOD 777 eller i vissa fall CHMOD 755):';
$txt['ftp_setup_again'] = 'för att testa om filerna är skrivbara igen.';

$txt['error_missing_files'] = 'Det gick inte att hitta viktiga installationsfiler i katalogen som detta skript körs från!<br><br>Se till så att du laddat upp samtliga filer som ingick i installationspaketet, inklusive SQL-filen, och försök sedan igen.';
$txt['error_session_save_path'] = 'Var vänlig och meddela ditt webbhotell att variabeln <strong>session.save_path som anges i php.ini</strong> inte är giltig! Den måste peka på en katalog som <strong>existerar</strong> och som är <strong>skrivbar</strong> av användaren som PHP körs som.<br>';
$txt['error_windows_chmod'] = 'Du kör på en Windows-server och vissa viktiga filer är inte skrivbara. Var vänlig och kontakta ditt webbhotell och be dem att ge <strong>skrivrättigheter</strong> för den användare som PHP körs som till filerna i SMF-installationen. Följande filer och kataloger måste vara skrivbara:';
$txt['settings_error'] = 'Dina inställningar kunde inte sparas till Settings.php.';
$txt['error_ftp_no_connect'] = 'Det gick inte att ansluta till FTP-servern med dessa anslutningsuppgifter.';
$txt['error_db_file'] = 'Kan inte hitta källfilen för databasen! Kontrollera att filen %1$s finns i ditt forums källkatalog.';
$txt['error_db_connect'] = 'Det gick inte ansluta till databasservern med de angivna uppgifterna.<br><br>Om du inte är säker på vad du ska ange, vänligen kontakta ditt webbhotell.';
$txt['error_db_connect_settings'] = 'Det gick inte att ansluta till databasservern.<br><br>Kontrollera att inställningarna är rätt i Settings.php';
$txt['error_db_database'] = 'Installationsguiden lyckades inte ansluta till databasen "<em>%1$s</em>". Med vissa webbhotell måste du själv skapa databasen från webbhotellets administrationsgränssnitt innan SMF kan använda sig av den. Somliga webbhotell lägger också till prefix i början av databasnamnet, exempelvis ditt användarnamn.';
$txt['error_db_queries'] = 'Några av databasfrågorna kunde inte utföras korrekt. Det kan tänkas bero på att versionen av din databasmotor inte stödjs.<br><br>Teknisk information om frågorna:';
$txt['error_db_queries_line'] = 'Rad #';
$txt['error_db_missing'] = 'Installationsguiden kunde inte hitta något databasstöd i PHP. Vänligen be ditt webbhotell att se till så att PHP kompileras med önskad databas, eller att rätt tilläggsmoduler laddas.';
$txt['error_db_script_missing'] = 'Installationsguiden kunde inte hitta några installationsfiler för den funna databastypen. Vänligen kontrollera att du har laddat upp de nödvändiga installationsfilerna till din forumkatalog, till exempel "%1$s"';
$txt['error_session_missing'] = 'Installationsguiden kunde inte detektera stöd för sessioner på din servers installation av PHP. Vänligen be ditt webbhotell att säkerställa att PHP har kompilerats med sessionsstöd (det måste faktiskt explicit kompileras utan det.)';
$txt['error_user_settings_again_match'] = 'Du skrev in två olika lösenord!';
$txt['error_user_settings_no_password'] = 'Ditt lösenord måste vara minst fyra tecken långt.';
$txt['error_user_settings_taken'] = 'Beklagar, en medlem finns redan med det användarnamnet och/eller e-postadressen.<br><br>Ett nytt konto har inte skapats.';
$txt['error_user_settings_query'] = 'Ett databasfel uppstod när administratörskontot försökte skapas. Felet var:';
$txt['error_sourcefile_missing'] = 'Det gick inte att hitta källfilen Sources/%1$s. Kontrollera att den har laddats upp och försök sedan igen.';
$txt['error_db_alter_priv'] = 'Databaskontot du angav har inte rättigheter för databasfunktionerna ALTER (ändra tabell), CREATE (skapa tabell) och/eller DROP (ta bort tabell). Detta är nödvändigt för att SMF ska fungera korrekt.';
$txt['error_versions_do_not_match'] = 'Installationsguiden har upptäckt en annan version av SMF som redan finns installerad med angiven information. Om du försöker att uppgradera den versionen, ska du använda uppgraderaren, inte installationsguiden.<br><br>Annars kan du välja att använda andra uppgifter, eller att säkerhetskopiera alla data och sen radera allting i databasen.';
$txt['error_mod_security'] = 'Installationsguiden har upptäckt att modulen mod_security finns installerat på din webbserver. Mod_security kommer att blockera inskickade formulär innan SMF har något att säga till om. SMF har en inbyggd säkerhetskontroll, som är mer effektiv än mod_security och som inte blockerar formulär.<br><br><a href="https://www.simplemachines.org/redirect/mod_security">Mer information om hur man stänger av mod_security</a>';
$txt['error_mod_security_no_write'] = 'Installationsguiden har upptäckt att tilläggsmodulen mod_security finns installerat på din webbserver. Mod_security blockerar vissa inskickade formulär utifrån dess innehåll innan SMF har något att säga till om. SMF har en inbyggd säkerhetskontroll som är mycket mer effektiv än mod_security och som inte stoppar formulär.<br><br><a href="https://www.simplemachines.org/redirect/mod_security">Mer information om hur du stänger av mod_security (på engelska)</a><br><br>Alternativt kan du använda ditt FTP-program för att ändra rättigheterna på filen .htaccess i forumkatalogen så att den blir skrivbar (CHMOD 777), och sen uppdatera den här sidan.';
$txt['error_utf8_version'] = 'Den nuvarande versionen av din databas stödjer inte teckentabellen UTF-8. Du kan fortfarande installera SMF utan problem, men bara med stöd för UTF-8 avslaget. Om du i framtiden vill byta och använda UTF-8 på forumet (exempelvis efter att databasservern uppgraderats till en senare version än >= %1$s), kan du senare göra om forumet till UTF-8 genom administrationsgränssnittet.';
$txt['error_valid_admin_email_needed'] = 'Du har inte angett en giltig e-postadress för ditt administratörskonto.';
$txt['error_valid_server_email_needed'] = 'Du har inte angett en giltig e-postadress till webmastern.';
$txt['error_already_installed'] = 'Installationsguiden har upptäckt att du redan har installerat SMF. Det är rekommenderat att du <strong>inte</strong> försöker skriva över en existerande installation. Om du fortsätter med installationen kan du <strong>förlora eller skada existerande data</strong>.<br><br>Om du vill uppgradera din existerande installation kan du besöka <a href="https://www.simplemachines.org">Simple Machines hemsida</a> och ladda ner det senaste <em>uppdaterings</em>-paketet.<br><br>Om du vill skriva över din nuvarande installation, inklusive all data, är det rekommenderat att du raderar alla tabeller i databasen och ersätter Settings.php och försöker igen.';
$txt['error_warning_notice'] = 'Varning!';
$txt['error_script_outdated'] = 'Detta installationsskript gäller inte längre! Den nuvarande versionen av SMF är %1$s men installationsskriptet är för %2$s.<br><br> Det rekommenderas att du besöker <a href="https://www.simplemachines.org">Simple Machines</a> hemsida för att säkerställa att du installerar den senaste versionen.';
$txt['error_db_prefix_numeric'] = 'Den valda databastypen stödjer inte användandet av numeriska prefix.';
$txt['error_pg_scs'] = 'PostgreSQL är felaktigt konfigurerad. Vänligen aktivera konfigurationsparametern standard_conforming_strings.';
$txt['error_invalid_characters_username'] = 'Ett ogiltigt tecken användes i användarnamnet.';
$txt['error_username_too_long'] = 'Användarnamnet måste vara kortare än 25 tecken.';
$txt['error_username_left_empty'] = 'Fältet för användarnamn lämnades tomt.';
$txt['error_db_prefix_reserved'] = 'Prefixet du angav är ett reserverat prefix. Vänligen ange ett annat prefix.';
$txt['error_utf8_support'] = 'Databasen som du försöker använda använder inte UTF8-teckenuppsättning';

$txt['ftp_login'] = 'Din FTP-anslutningsinformation';
$txt['ftp_login_info'] = 'Installationsguiden behöver din FTP-information för att automatiskt hjälpa dig med installationen. Notera att inget av informationen sparas, den används bara för att installera SMF.';
$txt['ftp_server'] = 'Server';
$txt['ftp_server_info'] = 'Adress (ofta localhost) och port till din FTP-server.';
$txt['ftp_port'] = 'Port';
$txt['ftp_username'] = 'Användarnamn';
$txt['ftp_username_info'] = 'Användarnamn att logga in med med. <em>Detta kommer inte att sparas någonstans.</em>';
$txt['ftp_password'] = 'Lösenord';
$txt['ftp_password_info'] = 'Lösenord att logga in med. <em>Detta kommer inte att spara någonstans.</em>';
$txt['ftp_path'] = 'Installationssökväg';
$txt['ftp_path_info'] = 'Detta är den <em>relativa</em> sökvägen till din FTP-klient.';
$txt['ftp_path_found_info'] = 'Sökvägen ovan hittades automatiskt.';
$txt['ftp_path_help'] = 'Din FTP-sökväg är sökvägen du ser när du loggar in med ditt FTP-program. Den börjar vanligtvis med "<pre>www</pre>", "<pre>public_html</pre>" eller "<pre>httpdocs</pre>", men den ska också innehålla katalogen som SMF är installerat i, t.ex. "/public_html/forum". Det är inte samma som din webbadress.<br><br>Filer under denna sökväg kan bli överskrivna, så se till att den är korrekt.';
$txt['ftp_path_help_close'] = 'Stäng';
$txt['ftp_connect'] = 'Anslut';

$txt['force_ssl'] = 'Aktivera SSL';
$txt['force_ssl_label'] = 'Tvinga SSL för hela forumet';
$txt['force_ssl_info'] = 'Kontrollera att SSL och HTTPS stödjs genom hela forumet, annars kan ditt forum bli otillgängligt';

$txt['chmod_linux_info'] = 'Om du har ett kommandopromptskonto, kommandot nedan kan automatiskt rätta rättigheterna på dessa filer';

// The upgrader needs text strings too!
$txt['upgrade_step_login'] = 'Logga in';
$txt['upgrade_step_options'] = 'Uppgraderingsalternativ';
$txt['upgrade_step_backup'] = 'Säkerhetskopiera';
$txt['upgrade_step_database'] = 'Databasändringar';
$txt['upgrade_step_convertutf'] = 'Konvertera till UTF-8';
$txt['upgrade_step_convertjson'] = 'Konvertera serialiserad sträng till JSON';
$txt['upgrade_step_delete'] = 'Radera Upgrade.php';

$txt['upgrade_upgrade_utility'] = 'SMF uppgraderingssfunktion';
$txt['upgrade_warning'] = 'Varning!';
$txt['upgrade_critical_error'] = 'Kritiskt fel!';
$txt['upgrade_continue'] = 'Fortsätt';
$txt['upgrade_skip'] = 'Hoppa över';
$txt['upgrade_note'] = 'Notera!';
$txt['upgrade_step'] = 'Steg';
$txt['upgrade_steps'] = 'Steg';
$txt['upgrade_progress'] = 'Steg';
$txt['upgrade_overall_progress'] = 'Avklarat totalt';
$txt['upgrade_step_progress'] = 'Avklarat i detta steg';
$txt['upgrade_time_elapsed'] = 'Tidsåtgång';
$txt['upgrade_time_mins'] = 'minuter';
$txt['upgrade_time_secs'] = 'sekunder';
$txt['upgrade_username'] = 'Användarnamn:';
$txt['upgrade_wrong_username'] = 'Felaktigt användarnamn';
$txt['upgrade_password'] = 'Lösenord:';
$txt['upgrade_wrong_password'] = 'Felaktigt lösenord';
$txt['upgrade_script_timeout_minutes'] = 'Detta uppgraderingsskript kan inte köras innan %1$s har varit inaktiverat i minst %2$d minuter';
$txt['upgrade_script_timeout_seconds'] = 'Detta uppgraderingsskript kan inte köras innan %1$s har varit inaktiverat i minst %2$d sekunder';

$txt['upgrade_wait'] = 'Vänligen vänta medans en säkerhetskopia skapas. För stora forum kan det ta lite tid!';
$txt['upgrade_wait2'] = 'Vänligen vänta medans din databas konverteras till UTF-8. För stora forum kan det ta en stund!';
$txt['upgrade_sec_login'] = 'Av säkehetsskäl ber vi dig logga in med ditt administratörskonto för att fortsätta med uppgraderingen.';
$txt['upgrade_incomplete'] = 'Ej färdigt';
$txt['upgrade_not_quite_done'] = 'Inte riktigt klart än!';
$txt['upgrade_paused_overload'] = 'Uppgraderingen har pausats för att undvika att överbelasta din server. Men oroa dig inte, ingenting är fel. Bara klicka på <label for="contbutt">fortsätt-knappen</label> för att fortsätta.';
$txt['upgrade_continue_step'] = 'Fortsätt från där du slutade förra gången du körde uppgraderingsskriptet.';
$txt['upgrade_bypass'] = '<strong>Notera:</strong> Om nödvändigt kan säkerhetskontrollen ovan kringgås för användare som administrerar en server men som kanske inte har administratörsrättigheter på forumet. För att kringgå kontrollen ovan öppnar du bara "upgrade.php" i en texteditor och ersätter "$disable_security = false;" med "$disable_security = true;" och laddar om denna sida.';
$txt['upgrade_areyouready'] = 'Innan uppgraderingen startar, kontrollera alternativen nedan - tryck på "Fortsätt" när du är redo att börja.';
$txt['upgrade_backup_table'] = 'Säkerhetskopiera tabeller i din databas med prefixet';
$txt['upgrade_backup_complete'] = 'Säkerhetskopieringen slutförd! Klicka på fortsätt för att fortsätta.';
$txt['upgrade_recommended'] = 'rekommenderas!';
$txt['upgrade_maintenance'] = 'Sätt forumet i underhållsläge under uppgraderingen.';
$txt['upgrade_maintenance_title'] = 'Underhållstitel';
$txt['upgrade_maintenance_message'] = 'Underhållsmeddelande';
$txt['upgrade_customize'] = 'Anpassa';
$txt['upgrade_debug_info'] = 'Skriv ut extra felsökningsinformation.';
$txt['upgrade_empty_errorlog'] = 'Töm felloggen innan uppgradering.';
$txt['upgrade_delete_karma'] = 'Radera alla karma-inställningar och information från databasen';
$txt['upgrade_reprocess_attachments'] = 'Kör bilagekonvertering igen';
$txt['upgrade_stats_collection'] = 'Tillåt Simple Machines att samla in allmän statistik månadsvis.';
$txt['upgrade_stats_info'] = 'Detta tillåter Simple Machines att besöka ditt forum en gång i månaden, för att samla in allmän statistik. Detta hjälper oss att fatta beslut om vilka konfigurationer som vi ska optimera forumprogramvaran för. För mer information, vänligen besök vår <a href="%1$s" target="_blank" rel="noopener">informationssida</a> (endast på engelska).';
$txt['upgrade_migrate_settings_file'] = 'Byt till en ny inställningsfil.';
$txt['upgrade_db_changes'] = 'Utför databasändringar';
$txt['upgrade_db_patient'] = 'Vänligen ha tålamod - detta kan ta lite tid på stora forum. Tiden som går räknas upp från servern för att visa progressen som görs.';
$txt['upgrade_db_complete'] = '1 databasuppgradering avslutad! Klicka på fortsätt för att fortsätta.';
$txt['upgrade_db_complete2'] = 'Databasuppgraderingen avslutad! Klicka på fortsätt för att fortsätta.';
$txt['upgrade_script'] = 'Kör uppgraderingsskript';
$txt['upgrade_error'] = 'Fel!';
$txt['upgrade_unknown_error'] = 'Okänt fel!';
/* Same sentence, 3 different strings */
$txt['upgrade_completed'] = 'Klar';
$txt['upgrade_outof'] = 'slut på';
$txt['upgrade_tables'] = 'tabeller.';

$txt['upgrade_run_script'] = 'Vi rekommenderar att du inte kör detta skript om du inte är säker på att';
$txt['upgrade_run_script2'] = 'har avslutat sin uppgradering.';
$txt['upgrade_run'] = 'Du kan välja antingen att köra uppgraderingen igen från början eller fortsätta från det sista steget från den senaste uppgraderingen.';

$txt['upgrade_completed_table'] = 'Klar tabell:';
$txt['upgrade_current_table'] = 'Nuvarande tabell:';
$txt['upgrade_fulltext'] = 'Vänligen notera att din fulltext-indexering togs bort för att underlätta konverteringen och behöver återskapas i administratörscentret efter att uppgraderingen avslutats.';
$txt['upgrade_conversion_proceed'] = 'Konverteringen avslutad! Klicka på fortsätt för att fortsätta.';
$txt['upgrade_convert_datajson'] = 'Konverterar data från serialiserad till JSON...';
$txt['upgrade_json_completed'] = 'Konvertering till JSON avslutad! Klicka på fortsätt för att fortsätta.';
$txt['upgrade_executing'] = 'Kör:';
$txt['upgrade_of'] = 'av';
$txt['upgrade_admin_login'] = 'Administratörsinloggning:';
$txt['upgrade_admin_disabled'] = '(INAKTIVERAD)';
$txt['upgrade_done'] = 'Uppgraderingen är klar. Nu kan du börja använda <a href="%1$s/index.php">din installation av SMF</a>. Hoppas du gillar det!';

$txt['upgrade_delete_now'] = 'Radera upgrade.php och dess datafiler nu';
$txt['upgrade_delete_server'] = '(fungerar inte på alla servrar).';
$txt['upgrade_problems'] = 'Om du hade några problem med denna uppgradering, eller har några problem med att använda SMF, tveka inte att <a href="%1$s">be oss om hjälp</a>.';
$txt['upgrade_luck'] = 'Lycka till,';

$txt['upgrade_ftp_login'] = 'Din FTP-anslutningsinformation';
$txt['upgrade_ftp_perms'] = 'Uppgraderingsguiden kan fixa problemen med filrättigheterna för att göra uppgraderingen så enkel som möjligt. Ange bara din anslutningsinformationen nedan eller alternativt klicka <a href="#" onclick="warning_popup();">här</a> för en lista med filer som behöver ändras.';
$txt['upgrade_ftp_warning'] = 'Varning';
$txt['upgrade_ftp_files'] = 'Följande filer måste göras skrivbara för att fortsätta:';
$txt['upgrade_ftp_shell'] = 'Om du har ett shell-konto kan du använda kommandot nedan för att automatiskt korrigera rättigheterna för dessa filer';
$txt['upgrade_ftp_error'] = 'Följande fel uppstod under anslutningsförsöket:';

$txt['upgrade_ready_proceed'] = 'Tack för att du väljer att uppgradera till SMF %1$s. Alla filer verkar finnas på plats och vi är klara att börja.';
$txt['upgrade_error_script_js'] = 'Uppgraderingsskriptet kan inte hitta script.js eller så är det föråldrat. Kontrollera att sökvägarna till ditt tema är korrekta. Du kan ladda ner ett verktyg för att kontrollera inställningarna från <a href="%1$s">Simple Machines hemsida</a>';
$txt['upgrade_warning_lots_data'] = 'Detta uppgraderingsskript har detekterat att ditt forum innehåller mycket data som behöver uppgraderas. Denna process kan ta ganska lång tid beroende på din server och storleken på ditt forum, och för väldigt stora forum (ca 300 000 meddelande) kan det ta flera timmar att avsluta.';
$txt['upgrade_warning_out_of_date'] = 'Detta uppgraderingsskript är föråldrat! Den nuvarande versionen av SMF är <em id="smfVersion" style="white-space: nowrap;">??</em> med detta uppgraderingsskript är för <em id="yourVersion" style="white-space: nowrap;">%1$s</em>.<br><br>Det rekommenderas att du besöker <a href="%2$s">Simple Machines hemsida</a> för att säkerställa att du uppgradera till den senaste versionen.';

$txt['upgrade_forumdir_settings'] = 'Det ser ut som att inställningen av din forumkatalog <em>kan tänkas</em> vara fel. Din forumkatalog är för nuvarande satt till &quot;%1$s&quot;, men ska troligtvis vara &quot;%2$s&quot;. Settings.php visar för tillfället din sökväg som:';
$txt['upgrade_forumdir'] = 'Forumets rot-katalog:';
$txt['upgrade_sourcedir'] = 'Källkodskatalog:';
$txt['upgrade_cachedir'] = 'Cache-katalog:';
$txt['upgrade_incorrect_settings'] = 'Om dessa verkar felaktiga öppnar du Settings.php i en texteditor innan du fortsätter med uppgraderingen. Om de är felaktiga på grund av att du flyttar ditt forum till en ny sökväg, vänligen ladda ner och kör verktyget <a href="https://download.simplemachines.org/?tools">Repair Settings</a> från Simple Machines hemsida innan du fortsätter.';

$txt['upgrade_fulltext_error'] = 'Ditt fulltext-sökindex togs bort för att underlätta konverteringen. Du kommer behöver återskapa det.';
$txt['upgrade_writable_files'] = 'Följande filer måste vara skrivbara för att fortsätta uppgraderingen. Säkerställ att Windowsrättigheter är korrekt satta för att tillåta detta:';
$txt['upgrade_time_user'] = '"%1$s" kör uppgraderingsskriptet.';

// We represent the time here in backwards variables, as it makes the code easier.
$txt['upgrade_time_hms'] = 'Uppgraderingsskriptet har kört i %3$d timmar, %2$d minuter och %1$d sekunder.';
$txt['upgrade_time_ms'] = 'Uppgraderingsskriptet har kört i %2$d minuter och %1$d sekunder.';
$txt['upgrade_time_s'] = 'Uppgraderingsskriptet har kört i %1$d sekunder.';
$txt['upgrade_time_updated_hms'] = 'Uppgraderingsskriptet uppdaterades senast för %3$d timmar, %2$d minuter och %1$d sekunder sedan.';
$txt['upgrade_time_updated_hm'] = 'Uppgraderingsskriptet uppdaterades senaste för %2$d minuter och %1$d sekunder sedan.';
$txt['upgrade_time_updated_s'] = 'Uppgraderingsskriptet uppdaterades senast för %1$d sekunder sedan.';
$txt['upgrade_completed_time_hms'] = 'Uppgraderingen avslutades på %3$d timmar, %2$s minuter och %1$s sekunder';
$txt['upgrade_completed_time_ms'] = 'Uppgraderingen avslutades på %2$s minuter och %1$s sekunder';
$txt['upgrade_completed_time_s'] = 'Uppgraderingen avslutades på %1$s sekunder';
$txt['upgrade_success_time_db'] = 'Lyckades! Databasuppgraderingen avslutades på %3$d timmar, %2$d minuter och %1$d sekunder.';

$txt['upgrade_unsuccessful'] = 'Misslyckades!';
$txt['upgrade_thisquery'] = 'Denna fråga:';
$txt['upgrade_causerror'] = 'Orsakade felet:';
$txt['upgrade_completedtables_outof'] = 'Avslutat <span id="tab_done">%1$d</span> av %2$d tabeller.';
$txt['upgrade_success'] = 'Lyckades!';
$txt['upgrade_loop'] = 'Uppgraderingsskriptet verkar ha hamnat i en loop - steg:';
$txt['upgrade_respondtime'] = 'Servern har inte svarat på %1$d sekunder. Det kan löna sig att vänta lite längre innan du försöker igen.';
$txt['upgrade_respondtime_clickhere'] = 'Klicka här för att försöka igen.';
$txt['mtitle'] = 'Uppgraderar forumet...';
$txt['mmessage'] = 'Oroa dig inte, ditt forum kommer snart att uppdateras. Det kommer bara ta någon minut ;).';

// Upgrader error messages
// argument(s): template name (if applicable)
$txt['error_unexpected_template_call'] = 'Fel: Oväntat anrop för att använda mallen %1$s. Vänligen kopiera och klistra in all text ovan och besök SMFs hjälpforum för att låta utvecklarna veta att det finns en bugg.';
$txt['error_invalid_template'] = 'Uppgraderingen avbröts! Ogiltig mall: template_%1$s';
$txt['error_lang_index_missing'] = 'Uppgraderingsguiden kunde inte hitta språkfiler för det valda språket, %1$s.<br>SMF kommer inte fungera på detta språk utan att språkfilerna är installerade.<br><br>Vänligen installera dem eller <a href="%2$s?step=0;lang=english">använd engelska istället</a>.';
$txt['error_upgrade_files_missing'] = 'Uppgraderingsguiden kunde inte hitta vissa nödvändiga filer.<br><br>Kontrollera att du har laddat upp alla filer som fanns i paketet, inkluderat Themes, Sources och andra kataloger.';
$txt['error_upgrade_old_files'] = 'Uppgraderingsguiden hittade några gamla eller föråldrade filer.<br><br>Kontrollera att du har laddat upp de nya versionerna av alla filer som fanns i paketet.';
$txt['error_upgrade_old_lang_files'] = 'Uppgraderingsguiden hittade några gamla eller föråldrade språkfiler för det valda språket, %1$s.<br><br>Kontrollera att du laddade upp nya versioner av alla filer inkluderade i paketet, även tema- och språkfiler för standardtemat.<br>&nbsp;&nbsp;&nbsp;[<a href="%2$s?skiplang">HOPPA ÖVER</a>] [<a href="%2$s?lang=english">Använd engelska</a>]';
$txt['error_php_too_low'] = 'Varning! Den version av PHP som är installerad på servern möter inte SMF:s lägsta systemkrav.<br><br>Vänligen be ditt webhotell att upgradera.';
$txt['error_db_too_low'] = 'Din %1$s version uppfyller inte minimikravet för SMF.<br><br>Vänligen be ditt webbhotell att uppgradera.';
$txt['error_db_privileges'] = 'Användaren för %1$s som du har angett i Settings.php har inte lämpliga rättigheter.<br><br>Vänligen be ditt webhotell att ge denna användaren rättigheter att ändra, skapa och ta bort tabeller (ALTER, CREATE och DROP).';
$txt['error_dir_not_writable'] = 'Katalogen: %1$s behöver vara skrivbar för att forsätta uppgraderingen. Kontrollera att rättigheterna är rätt satta för att tillåta detta.';
$txt['error_cache_not_found'] = 'Cache-katalogen kunde inte hittas.<br><br>Kontrollera att att du har katalogen "cache" i din forumkatalog innan du fortsätter.';
$txt['error_agreement_not_writable'] = 'Uppgraderingsguiden kunde inte få skrivrättigheter till agreement.txt<br><br>Om du använder en linux- eller unixbaserad server, säkerställ att filens rättigheter är 777 eller om den inte existerar, att katalogen som denna uppgraderingsguide finns i har rättigheterna 777.<br>Om din server kör Windows, säkerställ att internbetgästkontot har lämpliga rättigheter samt dess katalog.';
$txt['error_not_admin'] = 'Du måste vara administratör för att genomföra en uppgradering!';

$txt['warning_lang_old'] = 'Språkfilen för ditt valda språk, %1$s, har inte uppdaterats till den senaste versionen. Uppgraderingen kommer fortsätta med forumets standard, %2$s.';
$txt['warning_lang_missing'] = 'Uppgraderingsguiden kunde inte hitta språkfilen "Install" för ditt valda språk, %1$s. Uppgraderingen kommer fortsätta med forumets standard, %2$s.';

// Attachment & Avatar folder checks
$txt['warning_av_missing'] = 'Varning! Profilbildskatalogen hittades inte. Kontrollera kataloginställningarna innan du fortsätter.';
$txt['warning_custom_av_missing'] = 'Varning! Profilbildskatalogen hittades inte. Kontrollera kataloginställningarna innan du fortsätter.';
$txt['warning_att_dir_missing'] = 'Varning! En eller flera kataloger för bilagor hittades inte. Kontrollera kataloginställningarna innan du fortsätter.';

// Page titles
$txt['updating_smf_installation'] = 'Uppdaterar din SMF-installation!';
$txt['upgrade_options'] = 'Uppgraderingsalternativ';
$txt['backup_database'] = 'Säkerhetskopiera databas';
$txt['database_changes'] = 'Databasändringar';
$txt['upgrade_complete'] = 'Uppgraderingen avslutad';
$txt['converting_utf8'] = 'Konverterar till UTF-8';
$txt['converting_json'] = 'Konverterar till JSON';

?>