<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'Čeština';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'cs_CZ';
$txt['lang_dictionary'] = 'cs';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'cs';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1 234,00';

$txt['days_title'] = 'dnů';
$txt['days'] = array('Neděle', 'Pondělí', 'Úterý', 'Středa', 'Čtvrtek', 'Pátek', 'Sobota');
$txt['days_short'] = array('Ne', 'Po', 'Út', 'St', 'Čt', 'Pá', 'So');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = 'měsíců';
$txt['months'] = array(1 => 'Leden', 2 => 'Únor', 3 => 'Březen', 4 => 'Duben', 5 => 'Květen', 6 => 'Červen', 7 => 'Červenec', 8 => 'Srpen', 9 => 'Září', 10 => 'Říjen', 11 => 'Listopad', 12 => 'Prosinec');
$txt['months_titles'] = array(1 => 'Leden', 2 => 'Únor', 3 => 'Březen', 4 => 'Duben', 5 => 'Květen', 6 => 'Červen', 7 => 'Červenec', 8 => 'Srpen', 9 => 'Září', 10 => 'Říjen', 11 => 'Listopad', 12 => 'Prosinec');
$txt['months_short'] = array(1 => 'Led', 2 => 'Úno', 3 => 'Bře', 4 => 'Dub', 5 => 'Kvě', 6 => 'Črn', 7 => 'Črv', 8 => 'Srp', 9 => 'Zář', 10 => 'Říj', 11 => 'Lis', 12 => 'Pro');
$txt['prev_month'] = 'Předchozí měsíc';
$txt['next_month'] = 'Další měsíc';
$txt['start'] = 'Začátek';
$txt['end'] = 'Konec';
$txt['starts'] = 'Začíná';
$txt['ends'] = 'Končí';
$txt['none'] = 'Nic';

$txt['minutes_label'] = 'Minut';
$txt['hours_label'] = 'Hodin';
$txt['years_title'] = 'Roků';

$txt['time_am'] = 'dop.';
$txt['time_pm'] = 'odp.';

// Short form of minutes
$txt['minutes_short'] = 'min';
// Short form of hour
$txt['hour_short'] = 'h';
// Short form of hours
$txt['hours_short'] = 'hod';
// Decimal sign
$txt['decimal_sign'] = ',';

$txt['admin'] = 'Administrace';
$txt['moderate'] = 'Moderace';

$txt['save'] = 'Uložit';
$txt['reset'] = 'Obnovit';
$txt['upload'] = 'Nahrát';
$txt['upload_all'] = 'Nahrát vše';
$txt['processing'] = 'Zpracovává se...';

$txt['modify'] = 'Změnit';
$txt['forum_index'] = '%1$s - Hlavní stránka';
$txt['members'] = 'Uživatelé';
$txt['board_name'] = 'Jméno diskuse';
$txt['posts'] = 'Příspěvků';

$txt['member_postcount'] = 'Příspěvků';
$txt['no_subject'] = '(Bez předmětu)';
$txt['view_profile'] = 'Zobrazit profil';
$txt['guest_title'] = 'Host';
$txt['author'] = 'Autor';
$txt['on'] = 'kdy';
$txt['remove'] = 'Smazat';
$txt['start_new_topic'] = 'Založit nové téma';

$txt['login'] = 'Přihlásit';
// Use numeric entities in the below string.
$txt['username'] = 'Jméno';
$txt['password'] = 'Heslo';

$txt['username_no_exist'] = 'Uživatelské jméno neexistuje.';
$txt['no_user_with_email'] = 'Neexistují žádná uživatelská jména spojená s tímto emailem.';

$txt['board_moderator'] = 'Moderátor diskuse';
$txt['remove_topic'] = 'Smazat téma';
$txt['topics'] = 'Témat';
$txt['modify_msg'] = 'Změnit zprávu';
$txt['name'] = 'Název';
$txt['email'] = 'Email';
$txt['user_email_address'] = 'Emailová adresa';
$txt['subject'] = 'Předmět';
$txt['message'] = 'Zpráva';
$txt['redirects'] = 'Přesměrování';
$txt['quick_modify'] = 'Upravit';
$txt['quick_modify_message'] = 'Úspěšně jste upravil tuto zprávu.';
$txt['reason_for_edit'] = 'Důvod úpravy';

$txt['choose_pass'] = 'Zvolte heslo';
$txt['verify_pass'] = 'Ověřte heslo';
$txt['notify_announcements'] = 'Povolit administrátorům, aby mi posílali důležité zprávy emailem';

$txt['position'] = 'Pozice';

// argument(s): username
$txt['view_profile_of_username'] = 'Zobrazit profil uživatele %1$s';
$txt['total'] = 'Celkem';
$txt['website'] = 'Web';
$txt['register'] = 'Zaregistrovat se';
$txt['warning_status'] = 'Status varování';
$txt['user_warn_watch'] = 'Uživatel je pod dohledem moderátorů';
$txt['user_warn_moderate'] = 'Uživatelovy příspěvky procházejí schvalováním';
$txt['user_warn_mute'] = 'Uživatel má zákaz psát příspěvky';
$txt['warn_watch'] = 'Pod dohledem';
$txt['warn_moderate'] = 'Moderován';
$txt['warn_mute'] = 'Umlčen';

$txt['message_index'] = 'Seznam témat';
$txt['news'] = 'Novinky';
$txt['home'] = 'Domů';
$txt['page'] = 'Strana';
$txt['prev'] = 'Předchozí strana';
$txt['next'] = 'Následující strana';

$txt['lock_unlock'] = 'Zamknout/odemknout téma';
$txt['post'] = 'Poslat';
$txt['error_occured'] = 'Nastala chyba';
$txt['at'] = 'v';
$txt['by'] = 'od';
$txt['logout'] = 'Odhlásit se';
$txt['started_by'] = 'Založil';
$txt['topic_started_by'] = 'Založil <strong>%1$s</strong> v: <em>%2$s</em>';
$txt['replies'] = 'Příspěvky';
$txt['last_post'] = 'Poslední příspěvek';
$txt['first_post'] = 'První příspěvek';
$txt['last_poster'] = 'Naposledy přispěl:';
$txt['last_post_message'] = '<strong>Poslední příspěvek: </strong>%3$s <span class="postby">%2$s od: %1$s</span>';
$txt['last_post_topic'] = '%1$s<br>od: %2$s';
$txt['post_by_member'] = '<strong>%1$s</strong> od: <strong>%2$s</strong><br>';
$txt['boardindex_total_posts'] = '%1$s příspěvků v %2$s tématech od %3$s uživatelů';
$txt['show'] = 'Ukázat';
$txt['hide'] = 'Skrýt';

$txt['admin_login'] = 'Přihlášení administrátora';
// Use numeric entities in the below string.
$txt['topic'] = 'Téma';
$txt['help'] = 'Nápověda';
$txt['terms_and_rules'] = 'Podmínky a pravidla';
$txt['watch_board'] = 'Sledovat tuto diskusi';
$txt['unwatch_board'] = 'Nesledovat tuto diskusi';
$txt['watch_topic'] = 'Sledovat toto téma';
$txt['unwatch_topic'] = 'Nesledovat toto téma';
$txt['watching_topic'] = 'Témata, která sledujete';
$txt['watching_this_topic'] = 'Sledujete toto téma a budete dostávat oznámení.';
$txt['notify'] = 'Upozorňovat';
$txt['unnotify'] = 'Neupozorňovat';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'S pozdravem,
tým %1$s.';

$txt['notify_replies'] = 'Upozornění na odpovědi';
$txt['move_topic'] = 'Přemístit téma';
$txt['move_to'] = 'Přemístit kam';
$txt['pages'] = 'Stran';
$txt['users_active'] = 'Uživatelé aktivní v posledních %1$d minutách';
$txt['personal_messages'] = 'Soukromé zprávy';
$txt['reply_quote'] = 'Odpověď s citací';
$txt['reply'] = 'Odpověď';
$txt['reply_noun'] = 'Odpověď';
$txt['reply_number'] = 'Odpověď #%1$s%2$s';
$txt['approve'] = 'Schválit';
$txt['unapprove'] = 'Neschválit';
$txt['approve_all'] = 'Schválit vše';
$txt['issue_warning'] = 'Varovat uživatele';
$txt['awaiting_approval'] = 'Čeká na schválení';
$txt['attach_awaiting_approve'] = 'Přílohy čekající na schválení';
$txt['post_awaiting_approval'] = 'Tento příspěvek čeká na schválení moderátorem.';
$txt['there_are_unapproved_topics'] = 'Existuje %1$s témat a %2$s příspěvků, které čekají na schválení. Klikněte <a href="%3$s">sem</a> pro jejich zobrazení.';
$txt['send_message'] = 'Poslat zprávu';

$txt['msg_alert_no_messages'] = 'nemáte žádné zprávy';
$txt['msg_alert_one_message'] = 'máš <a href="%1$s">1 zprávu</a>';
$txt['msg_alert_many_message'] = 'máš <a href="%1$s">%2$d zpráv</a>';
$txt['msg_alert_one_new'] = 'Jedna je nová';
$txt['msg_alert_many_new'] = 'Nové: %1$d';
$txt['new_alert'] = 'Nové upozornění';
$txt['remove_message'] = 'Smazat příspěvek';
$txt['remove_message_question'] = 'Smazat příspěvek?';

$txt['topic_alert_none'] = 'Žádné zprávy...';
$txt['pm_alert_none'] = 'Žádné zprávy...';
$txt['no_messages'] = 'Žádné zprávy';

$txt['online_users'] = 'Uživatelů online';
$txt['jump_to'] = 'Přejít na';
$txt['go'] = 'Vpřed!';
$txt['are_sure_remove_topic'] = 'Opravdu chcete smazat toto téma?';
$txt['yes'] = 'Ano';
$txt['no'] = 'Ne';

$txt['search_end_results'] = 'Konec výsledků';
$txt['search_on'] = 'kdy';

$txt['search'] = 'Vyhledávání';
$txt['all'] = 'Vše';
$txt['search_entireforum'] = 'Celé fórum';
$txt['search_thisboard'] = 'Tato diskuse';
$txt['search_thistopic'] = 'Toto téma';
$txt['search_members'] = 'Uživatelé';

$txt['back'] = 'Zpět';
$txt['continue'] = 'Pokračovat';
$txt['password_reminder'] = 'Připomínka hesla';
$txt['topic_started'] = 'Téma založeno';
$txt['title'] = 'Název';
$txt['post_by'] = 'Přispěvatel';
$txt['memberlist_searchable'] = 'Seznam registrovaných uživatelů.';
$txt['welcome_newest_member'] = 'Přivítejme našeho nejnovějšího uživatele: %1$s.';
$txt['admin_center'] = 'Centrum administrace';
$txt['last_edit_by'] = '<span class="lastedit">Poslední úprava</span>: %1$s od: %2$s';
$txt['last_edit_reason'] = '<span id="reason" class="lastedit">Důvod</span>: %1$s';
$txt['notify_deactivate'] = 'Chtěli byste zrušit oznámení pro toto téma?';
$txt['modified_time'] = 'Naposledy upraveno';
$txt['modified_by'] = 'Upravil/a';

$txt['recent_posts'] = 'Poslední příspěvky';

$txt['location'] = 'Místo';
$txt['location_desc'] = 'Zeměpisné umístění.';
$txt['gender'] = 'Pohlaví';
$txt['gender_0'] = 'Žádné';
$txt['gender_1'] = 'Mužské';
$txt['gender_2'] = 'Ženské';
$txt['gender_desc'] = 'Vaše pohlaví.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'Toto je vaše číslo ICQ.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'Uživatelské jméno Skype';
$txt['personal_text'] = 'Osobní text';
$txt['date_registered'] = 'Datum registrace';

$txt['recent_view'] = 'Zobrazit nejnovější příspěvky na tomto fóru.';
$txt['recent_updated'] = 'je naposledy změněné téma';
$txt['is_recent_updated'] = '%1$s je naposledy změněné téma';

$txt['male'] = 'Mužské';
$txt['female'] = 'Ženské';

$txt['error_invalid_characters_username'] = 'V uživatelském jménu byl použit nesprávný znak.';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Vítejte na fóru <strong>%1$s</strong>. Prosím, <a href="%2$s" onclick="%3$s">přihlašte se</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Vítejte na fóru <strong>%1$s</strong>. Prosím, <a href="%2$s" onclick="%3$s">přihlašte se</a> nebo <a href="%4$s">se zaregistrujte</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Nedostal jsi aktivační email?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Ještě nemáte účet? <a href="%1$s?action=signup">Zaregistrujte se</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Vítejte na fóru <strong>%1$s</strong>.';

// @todo the following to sprintf
$txt['hello_member'] = 'Ahoj';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Vítejte,';
$txt['select_destination'] = 'Prosím vyberte cíl';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Poslal';

$txt['icon_smiley'] = 'Úsměv';
$txt['icon_angry'] = 'Hněv';
$txt['icon_cheesy'] = 'Smích';
$txt['icon_laugh'] = 'Řehot';
$txt['icon_sad'] = 'Smutek';
$txt['icon_wink'] = 'Mrknutí';
$txt['icon_grin'] = 'Škleb';
$txt['icon_shocked'] = 'Šok';
$txt['icon_cool'] = 'Super';
$txt['icon_huh'] = 'Co???';
$txt['icon_rolleyes'] = 'Kroutím očima';
$txt['icon_tongue'] = 'Vyplazuji jazyk';
$txt['icon_embarrassed'] = 'Jsem v rozpacích';
$txt['icon_lips'] = 'Neřeknu nic';
$txt['icon_undecided'] = 'Nerozhodný';
$txt['icon_kiss'] = 'Polibek';
$txt['icon_cry'] = 'Pláč';

$txt['moderator'] = 'Moderátor';
$txt['moderators'] = 'Moderátoři';

$txt['views'] = 'Zhlédnutí';
$txt['new'] = 'Nové';

$txt['view_all_members'] = 'Zobrazit všechny uživatele';
$txt['view'] = 'Zobrazit';

$txt['viewing_members'] = 'Zobrazení uživatelé %1$s do %2$s';
$txt['of_total_members'] = 'z celkového počtu %1$s uživatelů';

$txt['forgot_your_password'] = 'Zapomněli jste heslo?';

$txt['date'] = 'Datum';
// Use numeric entities in the below string.
$txt['from'] = 'Od';
$txt['check_new_messages'] = 'Zkontrolovat nové zprávy';
$txt['to'] = 'Komu';

$txt['board_topics'] = 'Témata';
$txt['members_title'] = 'Uživatelé';
$txt['members_list'] = 'Seznam uživatelů';
$txt['new_posts'] = 'Nových příspěvků';
$txt['old_posts'] = 'Žádné nové příspěvky';
$txt['redirect_board'] = 'Přesměrovávací diskuse';

$txt['sendtopic_send'] = 'Poslat';
$txt['report_sent'] = 'Oznámení bylo v pořádku odesláno.';
$txt['post_becomes_unapproved'] = 'Váš příspěvek nebyl schválen, protože byl poslán do neschváleného tématu. Jakmile bude téma schváleno, bude schválen i příspěvek.';

$txt['time_offset'] = 'Časový posun';
$txt['or'] = 'nebo';

$txt['no_matches'] = 'Lituji, ale nic nebylo nalezeno';

$txt['notification'] = 'Oznámení';

$txt['your_ban'] = 'Lituji, %1$d, ale na tomto fóru máte zákaz!';
$txt['your_ban_expires'] = 'Váš zákaz vyprší %1$s.';
$txt['your_ban_expires_never'] = 'Váš zákaz má neomezenou dobu platnosti.';
$txt['ban_continue_browse'] = 'Můžete pokračovat v prohlížení fóra jako host.';

$txt['mark_as_read'] = 'Označit vše jako přečteno';

$txt['locked_topic'] = 'Zamčené téma';
$txt['normal_topic'] = 'Normální téma';
$txt['participation_caption'] = 'Téma s Vaším příspěvkem';
$txt['moved_topic'] = 'Přesunuté téma';

$txt['go_caps'] = 'Vpřed!';

$txt['print'] = 'Tisk';
$txt['profile'] = 'Profil';
$txt['topic_summary'] = 'Shrnutí tématu';
$txt['not_applicable'] = 'N/A';
$txt['name_in_use'] = 'Toto jméno již používá jiný uživatel.';

$txt['total_members'] = 'Celkem uživatelů';
$txt['total_posts'] = 'Celkem příspěvků';
$txt['total_topics'] = 'Celkem témat';

$txt['time_logged_in'] = 'Jak dlouho zůstat přihlášen';

$txt['preview'] = 'Prohlédnout';
$txt['always_logged_in'] = 'nastálo';

$txt['logged'] = 'IP zaznamenána';
$txt['show_ip'] = 'Ukázat IP adresu';
// Use numeric entities in the below string.
$txt['ip'] = 'IP adresa';
$txt['url'] = 'URL adresa';
$txt['www'] = 'WWW adresa';

$txt['hours'] = 'hodin';
$txt['minutes'] = 'minut';
$txt['seconds'] = 'vteřin';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Hodina';
$txt['days_word'] = 'dnů';

$txt['search_for'] = 'Hledat podle';
$txt['search_match'] = 'Způsob hledání';

$txt['forum_in_maintenance'] = 'Vaše fórum je v režimu údržby. Mohou se přihlásit pouze administrátoři.';
$txt['maintenance_page'] = 'Mód údržby lze vypnout v <a href="%1$s">Nastavení serveru</a>.';

$txt['read_one_time'] = 'Přečteno jednou';
$txt['read_many_times'] = 'Přečteno %1$d krát';

$txt['forum_stats'] = 'Statistiky fóra';
$txt['latest_member'] = 'Nejnovější uživatel';
$txt['total_cats'] = 'Celkem kategorií';
$txt['latest_post'] = 'Poslední příspěvek';

$txt['total_boards'] = 'Celkem diskusí';

$txt['print_page'] = 'Tisknout stránku';
$txt['print_page_text'] = 'Pouze text';
$txt['print_page_images'] = 'Text a obrázky';

$txt['valid_email'] = 'Musí obsahovat platnou emailovou adresu.';

$txt['geek'] = 'Jsem geek!!';
$txt['info_center_title'] = '%1$s - Informační centrum';

$txt['watch'] = 'Sledovat';
$txt['unwatch'] = 'Přestat sledovat';

$txt['check_all'] = 'Vybrat vše';

// Use numeric entities in the below string.
$txt['database_error'] = 'Chyba databáze';
$txt['try_again'] = 'Prosím, zkuste to znovu. Pokud opět uvidíte tuto chybu, nahlašte ji moderátorovi.';
$txt['file'] = 'Soubor';
$txt['line'] = 'Řádek';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'SMF odhalilo a automaticky se pokusilo opravit chybu v databázi. Pokud budou problémy pokračovat, nebo budeš dostávat tyto emaily, kontaktuj svého provozovatele.';
$txt['database_error_versions'] = '<strong>Upozornění:</strong> Vypadá to, že databáze by <em>možná</em> potřebovala upgrade. Soubory fóra mají verzi %1$s, kdežto databáze je pro verzi %2$s. Chyba výše by mohla zmizet, po spuštění poslední verze upgrade.php.';
$txt['template_parse_error'] = 'Chyba procházení šablony!';
$txt['template_parse_error_message'] = 'Vypadá to, že se něco pokazilo v systému šablon. Tento problém by měl být pouze dočasný, takže se zkuste vrátit později a zkuste to znovu. Pokud nadále uvidíte toto hlášení, kontaktujte prosím administrátora.<br><br>Můžete taky zkusit <a href="javascript:location.reload();">obnovit tuto stránku</a>.';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'Nastala chyba při načítání šablony nebo jazykového souboru <pre><strong>%1$s</strong></pre>. Zkontrolujte syntaxi souboru a zkuste to znovu - nezapomeňte, že jednoduché uvozovky (<pre>\'</pre>) musí být často uvozeny zpětným lomítkem (<pre>\\</pre>). Abyste viděli přesnější chybu PHP, zkuste <a href="%2$s%1$s">přistoupit k souboru přímo</a>.<br><br>Také můžete zkusit <a href="javascript:location.reload();">obnovit tuto stránku</a> nebo <a href="%3$s?theme=1">použít výchozí motiv</a>.';
$txt['template_parse_errmsg'] = 'Bohužel v současné době není více informací o příčině problému.';

$txt['today'] = '<strong>Dnes</strong> v ';
$txt['yesterday'] = '<strong>Včera</strong> v ';
$txt['new_poll'] = 'Nová anketa';
$txt['poll_question'] = 'Otázka';
$txt['poll_vote'] = 'Hlasovat';
$txt['poll_total_voters'] = 'Celkem hlasů';
$txt['poll_results'] = 'Zobrazit výsledky';
$txt['poll_lock'] = 'Pozastavit hlasování';
$txt['poll_unlock'] = 'Obnovit hlasování';
$txt['poll_edit'] = 'Změnit anketu';
$txt['poll'] = 'Anketa';
$txt['one_hour'] = '1 hodina';
$txt['one_day'] = '1 den';
$txt['one_week'] = '1 týden';
$txt['two_weeks'] = '2 týdny';
$txt['one_month'] = '1 měsíc';
$txt['two_months'] = '2 měsíce';
$txt['forever'] = 'napořád';
$txt['moved'] = 'PŘESUNUTO';
$txt['move_why'] = 'Prosím vyplňte stručně důvod,<br>proč bylo téma přemístěno.';
$txt['board'] = 'Diskuse';
$txt['in'] = 'v';
$txt['sticky_topic'] = 'Připíchnuté téma';

$txt['delete'] = 'Smazat';
$txt['no_change'] = 'Beze změn';

$txt['your_pms'] = 'Vaše soukromé zprávy';

$txt['kilobyte'] = 'kB';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[Více statistik]';

// Use numeric entities in the below three strings.
$txt['code'] = 'Kód';
$txt['code_select'] = '[Vybrat]';
$txt['code_expand'] = 'Rozbalit';
$txt['code_shrink'] = 'Sbalit';
$txt['quote_from'] = 'Citace od';
$txt['quote'] = 'Citace';
$txt['quote_action'] = 'Citace';
$txt['quote_selected_action'] = 'Citovat vybraný text';
$txt['fulledit'] = 'Plná&nbsp;úprava';
$txt['edit'] = 'Změnit';
$txt['quick_edit'] = 'Rychlá úprava';
$txt['post_options'] = 'Více...';

$txt['merge_to_topic_id'] = 'ID cílového tématu';
$txt['split'] = 'Rozdělit téma';
$txt['merge'] = 'Sloučit témata';
$txt['target_id'] = 'Vybrat cíl podle ID tématu';
$txt['target_below'] = 'Vybrat cíl z následujícího seznamu';
$txt['subject_new_topic'] = 'Předmět pro nové téma';
$txt['split_this_post'] = 'Oddělit pouze tento příspěvek.';
$txt['split_after_and_this_post'] = 'Oddělit tento příspěvek a všechny za ním.';
$txt['select_split_posts'] = 'Vyber příspěvky k rozdělení.';
$txt['new_topic'] = 'Nové téma';
$txt['split_successful'] = 'Téma bylo úspěšně rozděleno.';
$txt['origin_topic'] = 'Původní téma';
$txt['please_select_split'] = 'Prosím, vyber příspěvky k rozdělení.';
$txt['merge_successful'] = 'Témata úspěšně sloučena.';
$txt['new_merged_topic'] = 'Nové sloučené téma';
$txt['topic_to_merge'] = 'Témata k sloučení';
$txt['target_board'] = 'Cílová diskuse';
$txt['target_topic'] = 'Cílové téma';
$txt['merge_desc'] = 'Tato funkce sloučí příspěvky dvou témat do jednoho. Příspěvky budou setříděny podle data poslání.';

$txt['set_sticky'] = 'Připíchnout téma';
$txt['set_nonsticky'] = 'Odpíchnout téma';
$txt['set_lock'] = 'Zamknout téma';
$txt['set_unlock'] = 'Odemknout téma';

$txt['search_advanced'] = 'Pokročilé vyhledávání';

$txt['security_risk'] = 'ZÁVAŽNÁ BEZPEČNOSTNÍ CHYBA:';
$txt['not_removed'] = 'Neodstranili jste ';
$txt['not_removed_extra'] = '%1$s je záloha %2$s, která nebyla vyvolána SMF. Může se jednat o pokus k získání neoprávněného přístupu k vašemu forum. Měli byste to ihned smazat.';
$txt['generic_warning'] = 'Varování';
$txt['agreement_missing'] = 'Vyžadujete po uživatelích souhlas s registračním ujednáním, jenže soubor (agreement.txt) neexistuje.';
$txt['policy_agreement_missing'] = 'Vyžadujete po uživatelích souhlas se Zásadami ochrany osobních údajů, jenže soubor je prázdný.';
$txt['auth_secret_missing'] = 'Nelze nastavit autentikační klíč v Settings.php. Oslabuje to bezpečnost fóra a zvyšuje riziko útoků. Změňte oprávnění souboru Settings.php, aby do něj mohlo SMF zapisovat.';

$txt['cache_writable'] = 'Do adresáře, který využívá cache, nelze zapisovat - to bude mít nepříznivý vliv na výkon fóra.';

$txt['page_created_full'] = 'Vytvoření stránky: čas: %1$.3f vteřin / dotazů: %2$d.';

$txt['report_to_mod_func'] = 'Tato funkce slouží k informování moderátorů a administrátorů o nevhodných nebo problematických příspěvcích.';
$txt['report_profile_func'] = 'Použijte tuto funkci k upozornění administrátorů na obtěžující obsah profilu, například spam nebo nevhodné obrázky.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s je online';
$txt['offline'] = 'Offline';
$txt['member_is_offline'] = '%1$s je offline';
$txt['pm_online'] = 'Soukromá zpráva (Online)';
$txt['pm_offline'] = 'Soukromá zpráva (Offline)';
$txt['status'] = 'Stav';

$txt['go_up'] = 'Nahoru';
$txt['go_down'] = 'Dolů';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title="Licence" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = 'Narozeniny:';
$txt['events'] = 'Události:';
$txt['birthdays_upcoming'] = 'Blížící se narozeniny:';
$txt['events_upcoming'] = 'Blížící se události:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Svátky:';
$txt['calendar_month'] = 'Měsíc';
$txt['calendar_year'] = 'Rok';
$txt['calendar_day'] = 'Den';
$txt['calendar_event_title'] = 'Jméno události';
$txt['calendar_event_options'] = 'Nastavení události';
$txt['calendar_post_in'] = 'Přispět do:';
$txt['calendar_edit'] = 'Upravit událost';
$txt['calendar_export'] = 'Exportuj událost';
$txt['calendar_view_week'] = 'Zobraz týden';
$txt['event_delete_confirm'] = 'Smazat tuto událost?';
$txt['event_delete'] = 'Smazat událost';
$txt['calendar_post_event'] = 'Přidat událost';
$txt['calendar'] = 'Kalendář';
$txt['calendar_link'] = 'Propojit s kalendářem';
$txt['calendar_upcoming'] = 'Kalendář';
$txt['calendar_today'] = 'Kalendář pro dnešek';
$txt['calendar_week'] = 'Týden';
$txt['calendar_week_title'] = 'Týden %1$d z %2$d';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = 'Týden začínající %2$s.%1$s.%3$s';
$txt['calendar_numb_days'] = 'Počet dní:';
$txt['calendar_how_edit'] = 'jak upravit tyto události?';
$txt['calendar_link_event'] = 'Propojit událost s příspěvkem';
$txt['calendar_confirm_delete'] = 'Opravdu chcete smazat tuto událost?';
$txt['calendar_linked_events'] = 'Propojené události';
$txt['calendar_click_all'] = 'klikněte pro zobrazení všech %1$s';
$txt['calendar_allday'] = 'Celý den';
$txt['calendar_timezone'] = 'Časové pásmo';
$txt['calendar_list'] = 'Seznam';
$txt['calendar_empty'] = 'Neexistují žádné události k zobrazení.';

$txt['movetopic_change_subject'] = 'Změnit název tématu';
$txt['movetopic_new_subject'] = 'Nový předmět';
$txt['movetopic_change_all_subjects'] = 'Změnit předmět všech zpráv';
$txt['move_topic_unapproved_js'] = 'Upozornění! Toto téma nebylo dosud schváleno.\n\nNení doporučeno vytvářet přesměrovací téma pokud nemáte v úmyslu téma schválit.';
$txt['movetopic_auto_board'] = '[DISKUSE]';
$txt['movetopic_auto_topic'] = '[ODKAZ NA TÉMA]';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'Toto téma bylo přemístěno do %1$s.

%2$s';

$txt['movetopic_redirect'] = 'Přesměrování na přesunuté téma';

$txt['post_redirection'] = 'Poslat přesměrovávací příspěvek';
$txt['redirect_topic_expires'] = 'Automaticky odstranit přesměrovávací téma';
$txt['mergetopic_redirect'] = 'Přesměrovat na sloučené téma';
$txt['merge_topic_unapproved_js'] = 'Pozor! Toto téma nebylo ještě schváleno.\n\nNení doporučeno vytvářet přesměrovávací téma, pokud tedy neplánujete schválit příspěvek okamžitě po sloučení.';

$txt['theme_template_error'] = 'Nemohu načíst šablonu \'%1$s\'.';
$txt['theme_language_error'] = 'Nemohu načíst jazykový soubor \'%1$s\'.';

$txt['sub_boards'] = 'Pod-diskuse';
$txt['restricted_board'] = 'Omezená diskuse';

$txt['smtp_no_connect'] = 'Nemůžu se spojit se serverem SMTP';
$txt['smtp_port_ssl'] = 'Nastavení SMTP portu je nesprávné, pro SSL servery by to mělo být 465. Hostname může protřebovat prefix ssl://';
$txt['smtp_bad_response'] = 'Nemohu zjistit kódy odpovědí mailového serveru';
$txt['smtp_error'] = 'Při posílání emailu nastaly problémy. Chyba: ';
$txt['mail_send_unable'] = 'Nebylo možno zaslat emaily na adresy \'%1$s\'';

$txt['mlist_search'] = 'Hledat uživatele';
$txt['mlist_search_again'] = 'Hledat znovu';
$txt['mlist_search_filter'] = 'Možnosti vyhledávání';
$txt['mlist_search_email'] = 'Hledat email';
$txt['mlist_search_messenger'] = 'Hledat podle přezdívky messengeru';
$txt['mlist_search_group'] = 'Hledat podle pozice';
$txt['mlist_search_name'] = 'Hledat podle jména';
$txt['mlist_search_website'] = 'Hledat podle webu';
$txt['mlist_search_results'] = 'Prohledávat výsledky na';
$txt['mlist_search_by'] = 'Vyhledávání podle %1$s';
$txt['mlist_menu_view'] = 'Prohlížet seznam uživatelů';

$txt['attach_downloaded'] = 'staženo %1$d krát';
$txt['attach_viewed'] = 'prohlédnuto %1$d krát';

$txt['settings'] = 'Nastavení';
$txt['never'] = 'Nikdy';
$txt['more'] = 'více';
$txt['etc'] = 'atd.';

$txt['hostname'] = 'Název serveru';
$txt['you_are_post_banned'] = 'Promiňte %1$s, ale máte na tomto fóru zákaz přispívat novými příspěvky a posílat soukromé zprávy.';
$txt['ban_reason'] = 'Důvod';
$txt['select_item_check'] = 'Zvolte aspoň jednu položku ze seznamu';

$txt['tables_optimized'] = 'Tabulky databáze optimalizovány';

$txt['add_poll'] = 'Přidat anketu';
$txt['poll_options_limit'] = 'Můžete vybrat nejvýše %1$s možností.';
$txt['poll_remove'] = 'Smazat anketu';
$txt['poll_remove_warn'] = 'Opravdu chcete odstranit tuto anketu z tématu?';
$txt['poll_results_expire'] = 'Výsledky budou zobrazeny, až hlasování skončí';
$txt['poll_expires_on'] = 'Hlasování skončí';
$txt['poll_expired_on'] = 'Hlasování ukončeno';
$txt['poll_change_vote'] = 'Odebrat hlas';
$txt['poll_return_vote'] = 'Nastavení hlasování';
$txt['poll_cannot_see'] = 'V této chvíli nemůžete vidět výsledky této ankety.';

$txt['quick_mod_approve'] = 'Schválit vybrané';
$txt['quick_mod_remove'] = 'Smazat vybrané';
$txt['quick_mod_lock'] = 'Zamknout/odemknout vybrané';
$txt['quick_mod_sticky'] = 'Připíchnout/odpíchnout vybrané';
$txt['quick_mod_move'] = 'Přemístit vybrané do';
$txt['quick_mod_merge'] = 'Sloučit vybrané';
$txt['quick_mod_markread'] = 'Označit vybrané jako přečtené';
$txt['quick_mod_markunread'] = 'Označit vybrané jako nepřečtené';
$txt['quick_mod_selected'] = 'S vybranými možnostmi proveď';
$txt['quick_mod_go'] = 'Hop!';
$txt['quickmod_confirm'] = 'Opravdu to chcete udělat?';

$txt['spell_check'] = 'Zkontrolovat pravopis';

$txt['quick_reply'] = 'Rychlá odpověď';
$txt['quick_reply_warning'] = 'Varování: Toto téma je zamčené, pouze administrátoři a moderátoři mohou odpovídat.';
$txt['quick_reply_verification'] = 'Po odeslání budete přesměrování na ověřovací stránku příspěvku %1$s.';
$txt['quick_reply_verification_guests'] = '(požadované pro všechny hosty)';
$txt['quick_reply_verification_posts'] = '(požadované pro všechny uživatele s méně než %1$d příspěvky)';
$txt['wait_for_approval'] = 'Poznámka: tento příspěvek se nezobrazí, dokud nebude schválen moderátorem.';

$txt['notification_enable_board'] = 'Opravdu chcete zapnout oznámení pro nová témata v této diskusi?';
$txt['notification_disable_board'] = 'Opravdu chcete vypnout oznámení pro nová témata v této diskusi?';
$txt['notification_enable_topic'] = 'Opravdu chcete zapnout oznámení pro nové příspěvky v tomto tématu?';
$txt['notification_disable_topic'] = 'Opravdu chcete vypnout oznámení pro nové příspěvky v tomto tématu?';

// Mentions
$txt['mentions'] = 'Zmínky';

// Likes
$txt['likes'] = 'Lajky';
$txt['like'] = 'Lajk';
$txt['unlike'] = 'Odlajkovat';
$txt['like_success'] = 'Váš obsah byl úspěšně lajkován.';
$txt['like_delete'] = 'Váš obsah byl úspěšně smazán.';
$txt['like_insert'] = 'Váš obsah byl úspěšně vložen.';
$txt['like_error'] = 'Chyba při zpracování požadavku.';
$txt['like_disable'] = 'Funkce lajkování je vypnutá.';
$txt['not_valid_like_type'] = 'Tento typ lajku je neplatný.';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = '<a href="%1$s">%2$s osobě</a> se toto líbí.';
$txt['likes_n'] = '<a href="%1$s">%2$s lidem</a> se to líbí.';
$txt['you_likes_0'] = 'Vám se to líbí.';
$txt['you_likes_1'] = 'Vám a <a href="%1$s">%2$s další osobě</a> se toto líbí.';
$txt['you_likes_n'] = 'Vám a <a href="%1$s">%2$s dalším lidem</a> se toto líbí.';

$txt['report_to_mod'] = 'Oznámit moderátorům';
$txt['report_profile'] = 'Nahlásit profil %1$s';

$txt['unread_topics_visit'] = 'Nepřečtená témata';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'Žádná nepřečtená témata od vaší poslední návštěvy. <a href="%1$s?action=unread;all">Klikněte sem pro všechna nepřečtená témata</a>.';
$txt['updated_topics_visit_none'] = 'Žádná aktualizovaná témata od vaší poslední návštěvy.';
$txt['unread_topics_all'] = 'Všechna nepřečtená témata';
$txt['unread_replies'] = 'Aktualizovaná témata';

$txt['who_title'] = 'Kdo je online';
$txt['who_and'] = ' a ';
$txt['who_viewing_topic'] = ' prohlíží toto téma.';
$txt['who_viewing_board'] = ' prohlíží tuto diskusi.';
$txt['who_member'] = 'Uživatel';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Poháněno PHP';
$txt['powered_by_mysql'] = 'Poháněno MySQL';
$txt['valid_css'] = 'Validní CSS';

$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'Host';
$txt['guests'] = 'Hosté';
$txt['user'] = 'Uživatel';
$txt['users'] = 'Uživatelé';
$txt['hidden'] = 'Skrytý';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'Skrytý';
$txt['buddy'] = 'Přítel(kyně)';
$txt['buddies'] = 'Přátel';
$txt['most_online_ever'] = 'Nejvíc online';
$txt['most_online_today'] = 'Nejvíc online (dnes)';

$txt['merge_select_target_board'] = 'Vybrat cílovou diskusi pro sloučené téma';
$txt['merge_select_poll'] = 'Vybrat, kterou anketu bude mít sloučené téma';
$txt['merge_topic_list'] = 'Vybrat témata k sloučení';
$txt['merge_select_subject'] = 'Vybrat předmět sloučeného tématu';
$txt['merge_custom_subject'] = 'Jiný předmět';
$txt['merge_include_notifications'] = 'Včetně oznámení?';
$txt['merge_check'] = 'Sloučit?';
$txt['merge_no_poll'] = 'Žádná anketa';
$txt['merge_why'] = 'Prosím vyplňte stručně důvod, proč byla témata sloučena.';
$txt['merged_subject'] = '[SLOUČENO] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'Téma bylo vloučeno do tématu %2$s.';

$txt['response_prefix'] = 'Re:';
$txt['current_icon'] = 'Aktuální ikona';
$txt['message_icon'] = 'Ikona zpráv';

$txt['smileys_current'] = 'Aktuální sada emotikonů';
$txt['smileys_none'] = 'Žádné emotikony';
$txt['smileys_forum_board_default'] = 'Výchozí nastavení fóra';

$txt['search_results'] = 'Výsledky hledání';
$txt['search_no_results'] = 'Je mi líto, ale nic nebylo nalezeno';

$txt['total_time_logged_days'] = ' dnů, ';
$txt['total_time_logged_hours'] = ' hodin a ';
$txt['total_time_logged_minutes'] = ' minut';
$txt['total_time_logged_d'] = 'd ';
$txt['total_time_logged_h'] = 'h ';
$txt['total_time_logged_m'] = 'm';

$txt['approve_members_waiting'] = 'očekávající schválení';

$txt['activate_code'] = 'Váš aktivační kód je';

$txt['find_members'] = 'Hledat uživatele';
$txt['find_username'] = 'Jméno, uživatelské jméno nebo emailová adresa';
$txt['find_buddies'] = 'Ukázat jen přátele?';
$txt['find_wildcards'] = 'Povolené žolíky: *, ?';
$txt['find_no_results'] = 'Žádné výsledky';
$txt['find_results'] = 'Výsledky';
$txt['find_close'] = 'Ukončit';

$txt['unread_since_visit'] = 'Nepřečtená témata od poslední návštěvy.';
$txt['show_unread_replies'] = 'Nepřečtená aktualizovaná témata.';

$txt['change_color'] = 'Změnit barvu';

$txt['quickmod_delete_selected'] = 'Smazat vybrané';
$txt['quickmod_split_selected'] = 'Rozdělit označené';

$txt['show_personal_messages_heading'] = 'Nové zprávy';
$txt['show_personal_messages'] = 'Máte <strong>%1$s</strong> nepřečtených soukromých zpráv.<br><br><a href="%2$s">Doručené zprávy</a>';

$txt['help_popup'] = 'Nejasnosti? Vysvětlím:';

$txt['previous_next_back'] = 'Předchozí téma';
$txt['previous_next_forward'] = 'Další téma';

$txt['mark_unread'] = 'Nepřečteno';

$txt['ssi_not_direct'] = 'Prosím nepřistupujte k SSI.php přímo pomocí URL adresy; Můžete použít buď cestu (%1$s) nebo přidat ?ssi_function=something.';
$txt['ssi_session_broken'] = 'SSI.php nebylo schopno načíst relaci! To může znamenat problém s odhlášením a dalšími funkcemi - ujistěte se, že SSI.php je vloženo jako první ve Vašich skriptech!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Prohlédnout příspěvek';
$txt['preview_fetch'] = 'Zobrazuji náhled...';
$txt['preview_new'] = 'Nový příspěvek';
$txt['pm_error_while_submitting'] = 'Nastala tato chyba při odesílání soukromé zprávy:';
$txt['error_while_submitting'] = 'Při odesílání příspěvku nastala následující chyba:';
$txt['error_old_topic'] = 'Upozornění: do tohoto tématu bylo naposledy přispěno před %1$d dny.<br />Zvažte prosím založení nového tématu.';

$txt['split_selected_posts'] = 'Vybrané příspěvky';
$txt['split_selected_posts_desc'] = 'Příspěvky níže utvoří nové téma po rozdělení.';
$txt['split_reset_selection'] = 'vymazat výběr';

$txt['modify_cancel'] = 'Storno';
$txt['modify_cancel_all'] = 'Zrušit vše';
$txt['mark_read_short'] = 'Označit jako přečteno';

$txt['alerts'] = 'Upozornění';

$txt['pm_short'] = 'Moje zprávy';
$txt['pm_menu_read'] = 'Číst zprávy';
$txt['pm_menu_send'] = 'Poslat zprávu';

$txt['unapproved_posts'] = 'Neschválené příspěvky (Témat: %1$d, Příspěvků: %2$d)';

$txt['ajax_in_progress'] = 'Nahrávám...';

$txt['mod_reports_waiting'] = 'Nahlášené příspěvky';

$txt['view_unread_category'] = 'Nepřečtené příspěvky';
$txt['new_posts_in_category'] = 'Klikněte sem pro nové příspěvky v %1$s';
$txt['verification'] = 'Ověření';
$txt['visual_verification_hidden'] = 'Prosím nechte toto pole prázdné';
$txt['visual_verification_description'] = 'Zadejte znaky zobrazené na obrázku';
$txt['visual_verification_sound'] = 'Poslechnout obrázek';
$txt['visual_verification_request_new'] = 'Požádat o jiný obrázek';

// Sub menu labels
$txt['summary'] = 'Shrnutí';
$txt['account'] = 'Nastavení účtu';
$txt['theme'] = 'Vzhled a rozložení';
$txt['forumprofile'] = 'Profil na fóru';
$txt['activate_changed_email_title'] = 'Emailová adresa byla změněna';
$txt['activate_changed_email_desc'] = 'Změnil jste emailovou adresu. Pro ověření obdržíte email, klikněte na odkaz v něm, aby vám byl reaktivován účet.';
$txt['modSettings_title'] = 'Funkce a nastavení';
$txt['package'] = 'Správce balíčků';
$txt['errorlog'] = 'Protokol chyb';
$txt['edit_permissions'] = 'Práva';
$txt['mc_unapproved_attachments'] = 'Neschválené přílohy';
$txt['mc_unapproved_poststopics'] = 'Neschválená témata a příspěvky';
$txt['mc_reported_posts'] = 'Nahlášené příspěvky';
$txt['mc_reported_members'] = 'Nahlášení uživatelé';
$txt['modlog_view'] = 'Protokol moderace';
$txt['calendar_menu'] = 'Zobrazit kalendář';

// @todo Send email strings - should move?
$txt['send_email'] = 'Odeslat email';

$txt['ignoring_user'] = 'Ignorujete tohoto uživatele.';
$txt['show_ignore_user_post'] = 'Zobrazit příspěvek.';

$txt['spider'] = 'Vyhledávač';
$txt['spiders'] = 'Vyhledávače';

$txt['downloads'] = 'Staženo';
$txt['filesize'] = 'Velikost';

// Restore topic
$txt['restore_topic'] = 'Obnovit téma';
$txt['restore_message'] = 'Obnovit';
$txt['quick_mod_restore'] = 'Obnovit označené';

// Editor prompt.
$txt['prompt_text_email'] = 'Prosím zadejte svou emailovou adresu.';
$txt['prompt_text_ftp'] = 'Prosím zadejte svou FTP adresu.';
$txt['prompt_text_url'] = 'Prosím zadejte URL adresu, ze které chcete vytvořit odkaz.';
$txt['prompt_text_img'] = 'Zadejte umístění obrázku';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Odstranit položku';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Šablony: ';
$txt['debug_subtemplates'] = 'Sub šablony: ';
$txt['debug_language_files'] = 'Jazykové soubory: ';
$txt['debug_stylesheets'] = 'Styly: ';
$txt['debug_files_included'] = 'Soubory: ';
$txt['debug_memory_use'] = 'Využitá paměť: ';
$txt['debug_kb'] = 'kB.';
$txt['debug_show'] = 'ukázat';
$txt['debug_cache_hits'] = 'Přístupy do cache: ';
$txt['debug_cache_misses'] = 'Neúspěšné přístupy do cache: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s bytů';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss for %2$s bytů';
$txt['debug_queries_used'] = 'Dotazů: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'dotazů: %1$d, %2$d varování.';
$txt['debug_query_in_line'] = 'v <em>%1$s</em> řádka <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'za %1$s vteřin.';
$txt['debug_query_which_took_at'] = 'který provedl za %1$s vteřin, %2$s dotazů.';
$txt['debug_show_queries'] = '[Zobrazit dotazy]';
$txt['debug_hide_queries'] = '[Skrýt dotazy]';
$txt['debug_tokens'] = 'Tokeny: ';
$txt['debug_browser'] = 'ID prohlížeče: ';
$txt['debug_hooks'] = 'Zavoláno hooků: ';
$txt['debug_instances'] = 'Vytvořeno instancí: ';
$txt['are_sure_mark_read'] = 'Opravdu chcete označit zprávy jako přečtené?';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Přílohy jsou vypnuté';
$txt['attachments_no_data_loaded'] = 'Neplatné ID přílohy.';
$txt['attachments_not_allowed_to_see'] = 'Nemůžete vidět tuto přílohu.';
$txt['attachments_no_msg_associated'] = 'Žádná zpráva není spojena s touto přílohou.';
$txt['attachments_unapproved'] = 'Příloha čeká na schválení.';

// Accessibility
$txt['hide_category'] = 'Skrýt kategorii';
$txt['show_category'] = 'Zobrazit kategorii';
$txt['hide_infocenter'] = 'Skrýt Informační centrum';
$txt['show_infocenter'] = 'Zobrazit Informační centrum';

// Notification post control
$txt['notify_topic_0'] = 'Nesledujete';
$txt['notify_topic_1'] = 'Žádná upozornění nebo emaily';
$txt['notify_topic_2'] = 'Dostávat upozornění';
$txt['notify_topic_3'] = 'Dostávat emaily a upozornění';
$txt['notify_topic_0_desc'] = 'Nebudete dostávat emaily ani upozornění pro toto téma, ani se vám nebude ukazovat v nepřečtených odpovědích nebo tématech. Budete ale nadále dostávat @zmínky pro toto téma.';
$txt['notify_topic_1_desc'] = 'Nebudete dostávat emaily ani upozornění, jen @zmínky od jiných uživatelů.';
$txt['notify_topic_2_desc'] = 'Budete dostávat upozornění pro toto téma.';
$txt['notify_topic_3_desc'] = 'Budete dostávat upozornění i emaily pro toto téma.';
$txt['notify_board_1'] = 'Bez upozornění a emailů';
$txt['notify_board_2'] = 'Budete dostávat upozornění';
$txt['notify_board_3'] = 'Budete dostávat emaily a upozornění';
$txt['notify_board_1_desc'] = 'Nebudete dostávat ani emaily ani upozornění na nová témata';
$txt['notify_board_2_desc'] = 'Budete dostávat upozornění pro tuto diskusi.';
$txt['notify_board_3_desc'] = 'Budete dostávat upozornění i emaily pro tuto diskusi.';

$txt['notify_board_prompt'] = 'Chcete upozornit vždy, když někdo pošle nové téma do této diskuse?';
$txt['notify_board_subscribed'] = '%1$s je přihlášen k oznámením na nová témata v této diskusi.';
$txt['notify_board_unsubscribed'] = '%1$s je odhlášen od oznámení na nová témata v této diskusi.';

$txt['notify_topic_prompt'] = 'Chcete dostat oznámení, když někdo odpoví na toto téma?';
$txt['notify_topic_subscribed'] = '%1$s je přihlášen k oznámením na nové odpovědi v tomto tématu.';
$txt['notify_topic_unsubscribed'] = '%1$s je odhlášen od oznámení na nové příspěvky v tomto tématu.';

$txt['notify_announcements_prompt'] = 'Chcete dostávat bulletiny, oznámení a důležitá upozornění emailem?';
$txt['notify_announcements_subscribed'] = '%1$s je přihlášen k bulletinům, oznámením a důležitým upozorněním.';
$txt['notify_announcements_unsubscribed'] = '%1$s je odhlášen od bulletinů, oznámení a upozornění.';

$txt['unsubscribe_announcements_plain'] = 'Pro odhlášení od bulletinů, oznámení a upozornění, přejděte na tento odkaz: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small"><a href="%1$s">Odhlášení</a> od bulletinů, oznámení a upozornění.</span>';
$txt['unsubscribe_announcements_manual'] = 'Pro odhlášení od bulletinů, oznámení a upozornění, kontaktujte nás zde %1$s se svojí žádostí.';

// Mobile Actions
$txt['mobile_action'] = 'Uživatelské akce';
$txt['mobile_moderation'] = 'Moderace';
$txt['mobile_user_menu'] = 'Hlavní nabídka';
$txt['mobile_generic_menu'] = 'Nabídka %1$s';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1} a {-1}';
$txt['sentence_list_format'][3] = '{series}, a {-1}';
$txt['sentence_list_format'][4] = '{series}, a {-1}';
$txt['sentence_list_format'][5] = '{series}, a {-1}';
$txt['sentence_list_format']['n'] = '{series}, a {-1}';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ', ';
$txt['sentence_list_separator_alt'] = '; ';

?>