<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Willkommen im Forum „{FORUMNAME}“';
$txt['resend_activate_message_body'] = 'Danke für deine Registrierung im Forum „{FORUMNAME}“. Dein Benutzername ist „{USERNAME}“. Falls du dein Passwort vergisst, kannst du es über folgenden Link zurücksetzen: {FORGOTPASSWORDLINK}.

Bevor du dich einloggen kannst, musst du dein Benutzerkonto zunächst aktivieren, indem du den folgenden Link klickst:

{ACTIVATIONLINK}

Solltest du jegliche Probleme mit der Aktivierung haben, besuche bitte {ACTIVATIONLINKWITHOUTCODE} und gib den Code „{ACTIVATIONCODE}“ ein.

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Willkommen im Forum „{FORUMNAME}“';
$txt['resend_pending_message_body'] = 'Hallo {REALNAME},

deine Registrierungsanfrage im Forum „{FORUMNAME}“ wurde empfangen.

Der von dir registrierte Benutzername lautet „{USERNAME}“.

Bevor du dich einloggen und das Forum benutzen kannst, muss deine Anfrage überprüft und genehmigt werden.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Genehmigung der Gruppenmitgliedschaft';
$txt['mc_group_approve_body'] = '{USERNAME},

wir freuen uns, dir mitteilen zu können, dass dein Antrag, der Gruppe „{GROUPNAME}“ im Forum „{FORUMNAME}“ beizutreten, akzeptiert wurde und dein Benutzerkonto dementsprechend aktualisiert wurde.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Ablehnung der Gruppenmitgliedschaft';
$txt['mc_group_reject_body'] = '{USERNAME},

es tut uns leid, dir mitteilen zu müssen, dass dein Antrag, der Gruppe „{GROUPNAME}“ im Forum „{FORUMNAME}“ beizutreten, abgelehnt wurde.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Ablehnung der Gruppenmitgliedschaft';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

es tut uns leid, dir mitteilen zu müssen, dass dein Antrag, der Gruppe „{GROUPNAME}“ im Forum „{FORUMNAME}“ beizutreten, abgelehnt wurde.

Dies hat folgenden Grund: {REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Willkommen im Forum „{FORUMNAME}“';
$txt['admin_approve_accept_body'] = 'Willkommen, {NAME}

dein Benutzerkonto wurde von einem Administrator manuell aktiviert und du kannst dich nun einloggen und Beiträge verfassen. Dein Benutzername ist: „{USERNAME}“. Falls du dein Passwort vergisst, kannst du es über folgenden Link ändern: {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Willkommen im Forum „{FORUMNAME}“';
$txt['admin_approve_activation_body'] = 'Willkommen, {USERNAME}!

Dein Benutzerkonto im Forum "{FORUMNAME}" wurde von einem Administrator des Forums genehmigt. Bevor du dich einloggen kannst, musst du zunächst dein Benutzerkonto aktivieren, indem du den folgenden Link anklickst:

{ACTIVATIONLINK}

Solltest du jegliche Probleme mit der Aktivierung haben, besuche bitte {ACTIVATIONLINKWITHOUTCODE} und gib den Code "{ACTIVATIONCODE}" ein.

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registrierung abgelehnt';
$txt['admin_approve_reject_body'] = '{USERNAME},

bedauerlicherweise wurde dein Antrag, dem Forum „{FORUMNAME}“ beizutreten, abgelehnt.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Benutzerkonto gelöscht';
$txt['admin_approve_delete_body'] = '{USERNAME},

dein Benutzerkonto im Forum „{FORUMNAME}“ wurde gelöscht. Dies kann den Grund haben, dass du deinen Account niemals aktiviert hast. Falls dies der Fall ist, kannst du dich erneut registrieren.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Registrierungserinnerung';
$txt['admin_approve_remind_body'] = '{USERNAME},

du hast dein Benutzerkonto im Forum „{FORUMNAME}“ noch nicht aktiviert.

Bitte benutze den Link unterhalb, um dies zu tun:
{ACTIVATIONLINK}

Solltest du jegliche Probleme mit der Aktivierung haben, besuche bitte {ACTIVATIONLINKWITHOUTCODE} und gib den Code „{ACTIVATIONCODE}“ ein.

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Willkommen im Forum „{FORUMNAME}“';
$txt['admin_register_activate_body'] = 'Danke für deine Registrierung im Forum „{FORUMNAME}“. Dein Benutzername ist „{USERNAME}“ und dein Passwort ist „{PASSWORD}“.

Bevor du dich einloggen kannst, musst du zunächst dein Benutzerkonto aktivieren, indem du folgenden Link klickst:

{ACTIVATIONLINK}

Solltest du jegliche Probleme mit der Aktivierung haben, besuche bitte {ACTIVATIONLINKWITHOUTCODE} und gib den Code „{ACTIVATIONCODE}“ ein.

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Willkommen im Forum „{FORUMNAME}“';
$txt['admin_register_immediate_body'] = 'Danke für deine Registrierung im Forum „{FORUMNAME}“. Dein Benutzername ist „{USERNAME}“, dein Passwort ist „{PASSWORD}“ und die Forums-URL ist: {SCRIPTURL}.

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Neue Ankündigung: „{TOPICSUBJECT}“';
$txt['new_announcement_body'] = '{MESSAGE}

Du kannst die vollständige Ankündigung lesen, indem du diesem Link folgst:
{TOPICLINK}

Um derartige Ankündigungen abzubestellen, folge diesem Link:
{UNSUBSCRIBELINK}

Für mehr Kontrolle über deine E-Mail-Benachrichtigungen logge dich im Forum ein und besuche die Benachrichtigungseinstellungen in deinem Profil.

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Neues Thema: „{TOPICSUBJECT}“';
$txt['notify_boards_once_body_body'] = 'Ein neues Thema, „{TOPICSUBJECT}“, wurde in einem Board angelegt, das du beobachtest.

Du kannst es ansehen unter
{TOPICLINK}

Du wirst in diesem Board für zukünftige neue Themen keine Benachrichtigungen erhalten, bis du ins Board zurückkehrst und einige Themen liest.

Der Text des Themas wird unterhalb angezeigt:
„{MESSAGE}“

Um die Themenbenachrichtigungen in diesem Board abzubestellen, verwende diesen Link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Neues Thema: „{TOPICSUBJECT}“';
$txt['notify_boards_once_body'] = 'Ein neues Thema, „{TOPICSUBJECT}“, wurde in einem Board angelegt, das du beobachtest.

Du kannst es ansehen unter
{TOPICLINK}

Du wirst in diesem Board für zukünftige neue Themen keine Benachrichtigungen erhalten, bis du ins Board zurückkehrst und einige Themen liest.

Um die Themenbenachrichtigungen in diesem Board abzubestellen, verwende diesen Link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Neues Thema: „{TOPICSUBJECT}“';
$txt['notify_boards_body_body'] = 'Ein neues Thema, „{TOPICSUBJECT}“, wurde in einem Board angelegt, das du beobachtest.

Du kannst es ansehen unter
{TOPICLINK}

Der Text des Themas wird unterhalb angezeigt:
„{MESSAGE}“

Um die Themenbenachrichtigungen in diesem Board abzubestellen, verwende diesen Link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Neues Thema: „{TOPICSUBJECT}“';
$txt['notify_boards_body'] = 'Ein neues Thema, „{TOPICSUBJECT}“, wurde in einem Board erstellt, das du beobachtest.

Du kannst es ansehen unter
{TOPICLINK}

Um die Themenbenachrichtigungen in diesem Board abzubestellen, verwende diesen Link:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Themenantwort: „{SUBJECT}“';
$txt['alert_unapproved_reply_body'] = 'Eine Antwort zum Thema „{SUBJECT}“ wurde von „{POSTERNAME}“ geschrieben.

Du kannst es ansehen unter
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Neuer ungenehmigter Dateianhang in: „{SUBJECT}“';
$txt['unapproved_attachment_body'] = 'Ein neuer zu genehmigender Dateianhang wurde in „{SUBJECT}“ erstellt.

Der folgende Link bringt dich zur Nachricht, an die die Datei angehängt werden soll. Du kannst den Anhang dort genehmigen oder ablehnen.

{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Neuer ungenehmigter Beitrag: „{SUBJECT}“';
$txt['alert_unapproved_post_body'] = 'Ein neuer zu genehmigender Beitrag wurde geschrieben: „{SUBJECT}“

Du kannst ihn über den folgenden Link genehmigen oder ablehnen:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Neues ungenehmigtes Thema: „{SUBJECT}“';
$txt['alert_unapproved_topic_body'] = 'Ein neues zu genehmigendes Thema wurde erstellt: „{SUBJECT}“

Du kannst es über den folgenden Link genehmigen oder ablehnen:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Neuer Gruppenantrag';
$txt['request_membership_body'] = '{RECPNAME},

„{APPLYNAME}“ hat eine Mitgliedschaft in der Gruppe „{GROUPNAME}“ beantragt. Der Benutzer hat folgenden Grund angegeben:

„{REASON}“

Du kannst diesen Antrag über den folgenden Link genehmigen oder ablehnen:

{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Abonnement im Forum „{FORUMNAME}“ endet bald';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Dein Abonnement bei „{FORUMNAME}“ läuft in Kürze ab. Wenn du dich für eine automatische Verlängerung entschieden hast, musst du nichts zu unternehmen; andernfalls solltest du dir überlegen, ob du ein weiteres Abonnement abschließen möchtest. Details findest du unten:

Name des Abonnements: {SUBSCRIPTION}
Läuft ab: {END_DATE}

Um deine Abonnements zu bearbeiten, besuche die folgende URL:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Willkommen zurück im Forum „{FORUMNAME}“';
$txt['activate_reactivate_body'] = 'Um deine E-Mail-Adresse erneut zu validieren, wurde dein Benutzerkonto deaktiviert. Klicke den folgenden Link, um es wieder zu aktivieren:
{ACTIVATIONLINK}

Solltest du jegliche Probleme mit der Aktivierung haben, besuche bitte {ACTIVATIONLINKWITHOUTCODE} und benutze den Code „{ACTIVATIONCODE}“.

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Neues Passwort für das Forum „{FORUMNAME}“';
$txt['forgot_password_body'] = 'Sehr geehrte(r) {REALNAME},
du erhältst diese E-Mail, weil die „Passwort vergessen“-Funktion für dein Benutzerkonto verwendet wurde. Um ein neues Passwort zu setzen, klicke den folgenden Link:
{REMINDLINK}

IP: {IP}
Benutzername: {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Gemeldeter Beitrag: „{TOPICSUBJECT}“ von „{POSTERNAME}“';
$txt['report_to_moderator_body'] = 'Der folgende Beitrag, „{TOPICSUBJECT}“ von „{POSTERNAME}“, wurde von „{REPORTERNAME}“ in einem Board gemeldet, das du moderierst:

Das Thema: {TOPICLINK}
Moderationszentrum: {REPORTLINK}

Der meldende Benutzer gab folgenden Kommentar ab:
„{COMMENT}“

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Folgemitteilung zu gemeldetem Beitrag: „{TOPICSUBJECT}“ von „{POSTERNAME}“';
$txt['reply_to_moderator_body'] = 'Vorangehend wurde „{TOPICSUBJECT}“ den Moderatoren gemeldet.

Seitdem wurde ein Kommentar von „{COMMENTERNAME}“ zur Meldung hinzugefügt. Weitere Informationen kannst du im Forum finden.

Das Thema: {TOPICLINK}
Moderationszentrum: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Gemeldetes Profil: „{MEMBERNAME}“';
$txt['report_member_profile_body'] = 'Das Profil von „{MEMBERNAME}“ wurde von „{REPORTERNAME}“ gemeldet.

Das Profil: {PROFILELINK}
Moderationszentrum: {REPORTLINK}

Der meldende Benutzer gab folgenden Kommentar ab:
„{COMMENT}“

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Folgemitteilung zu gemeldetem Profil: „{MEMBERNAME}“';
$txt['reply_to_member_report_body'] = 'Vorangehend wurde das Profil von „{MEMBERNAME}“ gemeldet.

Seitdem wurde ein Kommentar von „{COMMENTERNAME}“ zur Meldung hinzugefügt. Weitere Informationen kannst du im Forum finden.

Das Profil: {PROFILELINK}
Moderationszentrum: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Angaben zum neuen Passwort';
$txt['change_password_body'] = 'Sehr geehrte(r) {USERNAME},

deine Login-Daten im Forum „{FORUMNAME}" wurden geändert und dein Passwort zurückgesetzt. Unterhalb sind deine neuen Daten.

Dein Benutzername ist "{USERNAME}“ und dein Passwort ist „{PASSWORD}“.

Du kannst es nach dem Einloggen ändern, indem du auf deine Profilseite gehst oder indem du nach dem Einloggen diese Seite besuchst:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Willkommen im Forum „{FORUMNAME}“';
$txt['register_activate_body'] = 'Danke für deine Registrierung im Forum „{FORUMNAME}“. Dein Benutzername ist „{USERNAME}“. Falls du dein Passwort vergisst, kannst du es zurücksetzen, indem du {FORGOTPASSWORDLINK} besuchst.

Bevor du dich einloggen kannst, musst du zuerst dein Benutzerkonto aktivieren. Um dies zu tun, folge bitte diesem Link:

{ACTIVATIONLINK}

Solltest du jegliche Probleme mit der Aktivierung haben, besuche bitte {ACTIVATIONLINKWITHOUTCODE} und benutze den Code "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Willkommen im Forum „{FORUMNAME}“';
$txt['register_coppa_body'] = 'Danke für deine Registrierung im Forum „{FORUMNAME}“. Dein Benutzername ist „{USERNAME}“. Falls du dein Passwort vergisst, kannst du es ändern unter {FORGOTPASSWORDLINK}

Bevor du dich einloggen kannst, benötigt der Admin das Einverständnis eines Elternteils/Erziehungsberechtigten zum Beitreten des Forums. Du kannst weitere Informationen unter folgendem Link erhalten:

{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Willkommen im Forum „{FORUMNAME}“';
$txt['register_immediate_body'] = 'Danke für deine Registrierung im Forum „{FORUMNAME}“. Dein Benutzername ist „{USERNAME}“. Falls du dein Passwort vergisst, kannst du es ändern unter {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Willkommen im Forum „{FORUMNAME}“';
$txt['register_pending_body'] = 'Hallo {REALNAME},

deine Registrierungsanfrage im Forum „{FORUMNAME}“ wurde empfangen.

Der Benutzername, mit dem du dich registriert hast, ist „{USERNAME}“. Falls du dein Passwort vergisst, kannst du es ändern unter {FORGOTPASSWORDLINK}.

Bevor du dich einloggen und das Forum benutzen kannst, muss deine Anfrage überprüft und genehmigt werden.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Themenantwort: „{TOPICSUBJECT}“';
$txt['notification_reply_body'] = 'In einem Thema, das du beobachtest, wurde eine Antwort von „{POSTERNAME}“ geschrieben.

Sieh dir die Antwort an unter: {TOPICLINK}

Um dieses Thema abzubestellen, verwende diesen Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Themenantwort: „{TOPICSUBJECT}“';
$txt['notification_reply_body_body'] = 'In einem Thema, das du beobachtest, wurde eine Antwort von „{POSTERNAME}“ geschrieben.

Sieh dir die Antwort an unter: {TOPICLINK}

Um dieses Thema abzubestellen, verwende diesen Link: {UNSUBSCRIBELINK}

Der Antworttext ist unterhalb zu sehen:
„{MESSAGE}“

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Themenantwort: „{TOPICSUBJECT}“';
$txt['notification_reply_once_body'] = 'In einem Thema, das du beobachtest, wurde eine Antwort von „{POSTERNAME}“ geschrieben.

Sieh dir die Antwort an unter: {TOPICLINK}

Um dieses Thema abzubestellen, verwende diesen Link: {UNSUBSCRIBELINK}

Du wirst für dieses Thema keine weiteren Benachrichtigungen erhalten, bis du es liest.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Themenantwort: „{TOPICSUBJECT}“';
$txt['notification_reply_body_once_body'] = 'In einem Thema, das du beobachtest, wurde eine Antwort von „{POSTERNAME}“ geschrieben.

Sieh dir die Antwort an unter: {TOPICLINK}

Um dieses Thema abzubestellen, verwende diesen Link: {UNSUBSCRIBELINK}

Der Antworttext ist unterhalb zu sehen:
„{MESSAGE}“

Du wirst für dieses Thema keine weiteren Benachrichtigungen erhalten, bis du es liest.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Thema angeheftet: „{TOPICSUBJECT}“';
$txt['notification_sticky_body'] = 'Ein Thema, das du beobachtest, wurde als angeheftetes Thema markiert.

Sieh dir das Thema an unter: {TOPICLINK}

Um dieses Thema abzubestellen, verwende diesen Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Thema gesperrt: „{TOPICSUBJECT}“';
$txt['notification_lock_body'] = 'Ein Thema, das du beobachtest, wurde gesperrt.

Sieh dir das Thema an unter: {TOPICLINK}

Um dieses Thema abzubestellen, verwende diesen Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Thema entsperrt: „{TOPICSUBJECT}“';
$txt['notification_unlock_body'] = 'Ein Thema, das du beobachtest, wurde entsperrt.

Sie dir das Thema an unter: {TOPICLINK}

Um dieses Thema abzubestellen, verwende diesen Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Thema entfernt: „{TOPICSUBJECT}“';
$txt['notification_remove_body'] = 'Ein Thema, das du beobachtest, wurde entfernt.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Thema verschoben: „{TOPICSUBJECT}“';
$txt['notification_move_body'] = 'Ein Thema, das du beobachtest, wurde in ein anderes Board verschoben.

Sieh dir das Thema an unter: {TOPICLINK}

Um dieses Thema abzubestellen, verwende diesen Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Thema zusammengeführt: „{TOPICSUBJECT}“';
$txt['notification_merge_body'] = 'Ein Thema, das du beobachtest, wurde mit einem anderen Thema zusammengefasst.

Sieh dir das zusammengefasste Thema an unter: {TOPICLINK}

Um dieses Thema abzubestellen, verwende diesen Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Thema aufgeteilt: „{TOPICSUBJECT}“';
$txt['notification_split_body'] = 'Ein Thema, das du beobachtest, wurde in zwei oder mehr Themen aufgeteilt.

Sieh dir das verbleibende Thema an unter: {TOPICLINK}

Um dieses Thema abzubestellen, verwende diesen Link: {UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Ein neues Mitglied ist beigetreten';
$txt['admin_notify_body'] = '„{USERNAME}“ hat sich gerade als neues Mitglied deines Forums registriert. Klicke den folgenden Link, um das Benutzerprofil anzusehen.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Ein neues Mitglied ist beigetreten';
$txt['admin_notify_approval_body'] = '„{USERNAME}“ hat sich gerade als neues Mitglied deines Forums registriert. Klicke den folgenden Link, um das Benutzerprofil anzusehen.
{PROFILELINK}

Bevor dieses Mitglied das Forum nutzen kann, muss das Benutzerkonto zunächst genehmigt werden. Klicke den Link unterhalb, um die Genehmigungs-Ansicht aufzurufen.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Dringend! Dateianhänge-Verzeichnis fast voll';
$txt['admin_attachments_full_body'] = '{REALNAME},

das Dateianhänge-Verzeichnis im Forum „{FORUMNAME}“ ist fast voll. Bitte besuche das Forum, um dieses Problem zu lösen.

Sobald das Dateianhänge-Verzeichnis seine maximal erlaubte Größe erreicht, werden Benutzer keine Dateianhänge oder benutzerdefinierte Profilbilder mehr hochladen können (falls dies aktiviert ist).

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Bezahl-Abonnement zurückerstattet';
$txt['paid_subscription_refund_body'] = '{REALNAME},

einem Mitglied wurde ein bezahltes Abonnement zurückerstattet. Unterhalb siehst du die Details dieses Abonnements:

	Abonnement: {NAME}
	Benutzername: {REFUNDNAME} ({REFUNDUSER})
	Datum: {DATE}

Du kannst das Mitgliedsprofil über folgenden Link ansehen:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Neues Bezahl-Abonnement';
$txt['paid_subscription_new_body'] = '{REALNAME},

ein Mitglied hat ein bezahltes Abonnement abgeschlossen. Unterhalb siehst du die Details dieses Abonnements:

	Abonnement: {NAME}
	Benutzername: {SUBNAME} ({SUBUSER})
	Benutzer-E-Mail: {SUBEMAIL}
	Preis: {PRICE}
	Datum: {DATE}

Du kannst das Mitgliedsprofil über folgenden Link ansehen:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Fehler bei Bezahl-Abonnement';
$txt['paid_subscription_error_body'] = 'Sehr geehrte(r) {REALNAME},

Der folgende Fehler ist bei der Bearbeitung eines Bezahl-Abonnements aufgetreten:
---------------------------------------------------------------
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Neue persönliche Mitteilung: „{SUBJECT}“';
$txt['new_pm_body'] = 'Dir wurde soeben eine persönliche Mitteilung von „{SENDER}“ im Forum „{FORUMNAME}“ gesendet.

WICHTIG: Vergiss nicht, dies ist nur eine Benachrichtigung. Bitte antworte nicht auf diese E-Mail.

Lies diese persönliche Mitteilung hier: {READLINK}

Antworte auf diese persönliche Mitteilung hier: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Neue persönliche Mitteilung: „{SUBJECT}“';
$txt['new_pm_body_body'] = 'Dir wurde soeben eine persönliche Mitteilung von „{SENDER}“ im Forum „{FORUMNAME}“ gesendet.

WICHTIG: Vergiss nicht, dies ist nur eine Benachrichtigung. Bitte antworte nicht auf diese E-Mail.

Die Mitteilung ist folgende:

„{MESSAGE}“

Antworte auf diese persönliche Mitteilung hier: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Neue persönliche Mitteilung: „{SUBJECT}“';
$txt['new_pm_tolist_body'] = 'Dir und {TOLIST} wurde soeben eine persönliche Mitteilung von „{SENDER}“ im Forum „{FORUMNAME}“ gesendet.

WICHTIG: Vergiss nicht, dies ist nur eine Benachrichtigung. Bitte antworte nicht auf diese E-Mail.

Lies diese persönliche Mitteilung hier: {READLINK}

Antworte (nur dem Absender) auf diese persönliche Mitteilung hier: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Neue persönliche Mitteilung: „{SUBJECT}“';
$txt['new_pm_body_tolist_body'] = 'Dir und {TOLIST} wurde soeben eine persönliche Mitteilung von „{SENDER}“ im Forum „{FORUMNAME}“ gesendet.

WICHTIG: Vergiss nicht, dies ist nur eine Benachrichtigung. Bitte antworte nicht auf diese E-Mail.

Die Mitteilung ist folgende:

„{MESSAGE}“

Antworte (nur dem Absender) auf diese persönliche Mitteilung hier: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Du wurdest zitiert im Beitrag: „{CONTENTSUBJECT}“';
$txt['msg_quote_body'] = 'Hallo {MEMBERNAME},

du wurdest zitiert im Beitrag mit dem Titel „{CONTENTSUBJECT}“ von „{QUOTENAME}“. Du kannst den Beitrag hier sehen:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Du wurdest erwähnt im Beitrag: „{CONTENTSUBJECT}“';
$txt['msg_mention_body'] = 'Hallo {MEMBERNAME},

du wurdest erwähnt im Beitrag mit dem Titel „{CONTENTSUBJECT}“ von „{MENTIONNAME}“. Du kannst den Beitrag hier sehen:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Herzlichen Glückwunsch vom Forum „{FORUMNAME}“.';
$txtBirthdayEmails['happy_birthday_body'] = 'Sehr geehrte(r) {REALNAME},

wir im Forum „{FORUMNAME}“ möchten dir einen herzlichen Glückwunsch zum Geburtstag wünschen. Mögen dieser Tag und das kommende Jahr voller Freude für dich sein.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'Zu deinem Geburtstag…';
$txtBirthdayEmails['karlbenson1_body'] = 'Wir hätten dir eine Geburtstagskarte schicken können. Wir hätten dir Blumen oder eine Torte schicken können.

Haben wir aber nicht.

Wir hätten dir sogar eine dieser automatisch generierten Geburtstagsnachrichten schicken können, bei denen wir nicht mal NAME HIER EINFÜGEN ersetzen müssen.

Haben wir aber nicht.

Wir haben diesen Geburtstagsgruß nur für dich geschrieben.

Wir möchten dir einen ganz besonderen Geburtstag wünschen.

{REGARDS}

//:: Diese Nachricht wurde automatisch generiert :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Herzlichen Glückwunsch zum Geburtstag!';
$txtBirthdayEmails['nite0859_body'] = 'Deine Freunde im Forum „{FORUMNAME}“ möchten einen Moment deiner Zeit stehlen, um dir herzlich zum Geburtstag zu gratulieren, {REALNAME}. Falls nicht kürzlich geschehen, besuche bitte unser Forum, damit auch andere die Möglichkeit haben, ihre Glückwünsche auszusprechen.

Obwohl heute dein Geburtstag ist, {REALNAME}, möchten wir dich erinnern, dass für uns deine Mitgliedschaft in unserem Forum das bisher beste Geschenk war.

Beste Grüße,
das Team des Forums „{FORUMNAME}“';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Geburtstagsgrüße für {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Sehr geehrter {REALNAME},

ein weiteres Jahr in deinem Leben ist vergangen. Wir im Forum „{FORUMNAME}“ hoffen, es war erfüllt von Glück und wünschen dir selbiges im kommenden Lebensjahr.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Herzlichen Glückwunsch, {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Weisst du, wessen Geburtstag heute ist, {REALNAME}?

Wir schon… DEINER!

Herzlichen Glückwunsch!

Du bist nun ein Jahr älter, aber wir hoffen, dass du wesentlich glücklicher bist als im letzten Jahr.

Genieße deinen heutigen Tag, {REALNAME}!

– Von deiner „{FORUMNAME}“-Familie';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Dein Geburtstagsgruß';
$txtBirthdayEmails['karlbenson2_body'] = 'Wir hoffen dein Geburtstag ist der beste, den wir jemals hatten, egal ob Regen, Sonne oder Schatten.
Erleuchte jede Menge Geburtstagskerzen und genieß deinen Ehrentag mit Freunden und Scherzen.

Wir hoffen, diese Nachricht bringt dir anhaltende Freude, bis zum nächsten Jahr im selben Gebäude.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>