import { __ } from '@wordpress/i18n';
import { useInnerBlocksProps, InnerBlocks } from '@wordpress/block-editor';
import { useMemo, memo, useEffect, useState } from '@wordpress/element';
import { select, dispatch } from '@wordpress/data';
import { __experimentalBlockVariationPicker as BlockVariationPicker } from '@wordpress/block-editor';
import { createBlocksFromInnerBlocksTemplate } from '@wordpress/blocks';

const Render = (props) =>{
	
	const { _props, data } = props;
	const { clientId, isSelected, setAttributes } = _props;
	const { atts, tmp, id, tag} = data;
		
	const sc = 'pagelayer/pl-col';
	const ALLOWED = [sc];
	const { getBlocks } = select( 'core/block-editor' );
	
	const hasChildrens = getBlocks( clientId );
	const currentChildCount = hasChildrens.length;
	
	const [initialChild, setInitialChild] = useState(currentChildCount);
	
	// Function to update child block attributes
	const updateChildAttributes = (childClientId, newAttributes) => {
		dispatch('core/block-editor').updateBlockAttributes(childClientId, newAttributes);
	};
	
	// Rearrange columns
	useEffect(() => {
		
		if(currentChildCount == initialChild){
			return;
		}
		
		setInitialChild(currentChildCount);
		
		var cols = Math.floor(12 / (currentChildCount));
		var obj = {col: cols};
				
		// Find out the number of cols of other cols
		hasChildrens.map((child) => {				
			// Set the att
			updateChildAttributes( child.clientId, {...obj, 'col_width':''} );
		});
	}, [currentChildCount]);
	
	// Create group array
	const getGroupTemplate = useMemo( () => {
		return [
			[sc]
		];
	}, [sc]);		
	
	var InnerBlocksProps = {
		template: getGroupTemplate,
		templateLock: false,
		renderAppender: false,
		allowedBlocks: ALLOWED,
		orientation:"horizontal"
	};
	
	var newProps = {
		className:`pagelayer-row-holder pagelayer-row pagelayer-auto pagelayer-width-${atts.width_content}`,
	};
	const innerProps = useInnerBlocksProps(newProps, InnerBlocksProps);
	
	const blockVariationPickerOnSelect = ( nextVariation ) => {
		
		// Replace exiting content with new columns blocks
		if ( nextVariation.innerBlocks ) {
			setInitialChild(nextVariation.innerBlocks.length);
			dispatch( 'core/block-editor' ).replaceInnerBlocks(clientId, createBlocksFromInnerBlocksTemplate( nextVariation.innerBlocks ) );			
		}
    
	};

	return (
		<>
			{ currentChildCount == 0 ? (
				<div className="pagelayer-variation-div">
				<BlockVariationPicker
					icon={(
						<svg version="1.0" xmlns="http://www.w3.org/2000/svg"
							width="25.000000pt" height="23.000000pt" viewBox="0 0 25.000000 23.000000"
							preserveAspectRatio="xMidYMid meet">
							<g>
								<path d="M4 6H20M4 12H20M4 18H20" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
							</g>
						</svg>
					)}
					label={ __( 'Row' ) }
					variations={ Varitions() }
					instructions={ __('Please select a column layout.') }
					onSelect={ ( nextVariation ) => blockVariationPickerOnSelect( nextVariation ) }
				/>
				</div>
			):(
				<>
					{ atts?.bg_video_src && (
						<div className="pagelayer-background-video" dangerouslySetInnerHTML={{ __html: atts.vid_src}}/>
					) }
					{ atts?.bg_slider && (
						<div className="pagelayer-bgimg-slider" dangerouslySetInnerHTML={{ __html: atts.slider}}/>
					)}
					{ atts?.parallax_img && (
						<div className="pagelayer-parallax-window">
							<img className="pagelayer-img" src={atts.parallax_img_src}  title={tmp['parallax_img-title']} alt={tmp['parallax_img-alt']} />
						</div>
					)}
					{ atts?.row_shape_position && (
						<div className="pagelayer-row-shape">
							<div className="pagelayer-row-svg">
								{ atts?.row_shape_type_top && (<svg className="pagelayer-svg-top">{atts.svg_top}</svg>) }
								{ atts?.row_shape_type_bottom && (<svg className="pagelayer-svg-bottom">{atts.svg_bottom}</svg>) }					
							</div>
						</div>
					)}
					{ atts?.overlay_type && (<div className="pagelayer-background-overlay"></div>)}
					<div {...innerProps} />
					{isSelected && (
						<div className="pagelayer-block-appender">
							<InnerBlocks.ButtonBlockAppender />
						</div>
					)}
				</>
			)}
		</>
	);
}
const Varitions = () => {
	
	const sc = 'pagelayer/pl-col';

	return [
	{
		name: 'one-column',
		icon: (
			<svg				
				width="100"
				height="50"
				xmlns="https://www.w3.org/2000/svg"
				viewBox="0 0 100 54.54"
			>
				<path 
					d="M385,133.37v54.54H285V133.37Z" 
					transform="translate(-285 -133.37)" 
				/>
			</svg>
		),
		label: __('One Column'),
		innerBlocks: [ [ sc, { col: 12 } ] ],
		scope: [ 'block' ],
	},
	{
		name: 'two-column-equal',
		icon: (
			<svg
				width="100"
				height="50"
				xmlns="https://www.w3.org/2000/svg"
				viewBox="0 0 100 54.54"
			>
				<path 
					d="M461,133.37v54.54H412V133.37Zm51,0v54.54H463V133.37Z" 
					transform="translate(-412 -133.37)" 
				/>
			</svg>
		),
		label: __('Two columns equal split'),
		isDefault: true,
		innerBlocks: [
			[ sc, { col: 6} ],
			[ sc, { col: 6} ],
		],
		scope: [ 'block' ],
	},
	{
		name: '75_25-column-split',
		icon: (
			<svg
				width="100"
				height="50"
				viewBox="0 0 114 60" 
				fill="none"
				xmlns="http://www.w3.org/2000/svg">
				<path
					fillRule="evenodd"
					clipRule="evenodd"
					d="M2.00001 0C0.895439 0 7.62939e-06 0.895447 7.62939e-06 2V58C7.62939e-06 59.1046 0.895439 60 2.00001 60H73C74.1046 60 75 59.1046 75 58V2C75 0.895447 74.1046 0 73 0H2.00001ZM79 0C77.8954 0 77 0.895447 77 2V58C77 59.1046 77.8954 60 79 60H112C113.105 60 114 59.1046 114 58V2C114 0.895447 113.105 0 112 0H79Z"
					fill="inherit"
				/>
			</svg>
		),
		label: __('Seventy five tweenty five columns split'),
		innerBlocks: [
			[ sc, { col: 9 } ],
			[ sc, { col: 3 } ],
		],
		scope: [ 'block' ],
	},
	{
		name: '25_75-column-split',
		icon: (
			<svg
				width="100"
				height="50"
				viewBox="0 0 114 60" 
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<path
					fillRule="evenodd"
					clipRule="evenodd"
					d="M35 60C36.1046 60 37 59.1046 37 58L37 2C37 0.895447 36.1046 0 35 0H2.00002C0.895447 0 1.52588e-05 0.895447 1.52588e-05 2L7.62939e-06 58C7.62939e-06 59.1046 0.895439 60 2.00001 60H35ZM112 60C113.105 60 114 59.1046 114 58V2C114 0.895447 113.105 0 112 0H41C39.8954 0 39 0.895447 39 2L39 58C39 59.1046 39.8954 60 41 60H112Z"
					fill="inherit"
				/>
			</svg>
		),
		label: __('Tweenty five seventy five columns split'),
		innerBlocks: [
			[ sc, { col: 3 } ],
			[ sc, { col: 9 } ],
		],
		scope: [ 'block' ],
	},
	{
		name: 'three-column-equal',
		icon: (
			<svg
				width="100"
				height="50"
				viewBox="0 0 114 60" 
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M0 2C0 0.895447 0.895432 0 2 0H35C36.1046 0 37 0.895447 37 2V58C37 59.1046 36.1046 60 35 60H2C0.895432 60 0 59.1046 0 58V2ZM39 2C39 0.895447 39.8954 0 41 0H73C74.1046 0 75 0.895447 75 2V58C75 59.1046 74.1046 60 73 60H41C39.8954 60 39 59.1046 39 58V2ZM79 0C77.8954 0 77 0.895447 77 2V58C77 59.1046 77.8954 60 79 60H112C113.105 60 114 59.1046 114 58V2C114 0.895447 113.105 0 112 0H79Z"
				fill="inherit"
			/>
		</svg>
		),
		label: __('Three columns equal split'),
		innerBlocks: [
			[ sc, { col: 4 } ],
			[ sc, { col: 4 } ],
			[ sc, { col: 4 } ],
		],
		scope: [ 'block' ],
	},
	{
		name: 'four-column-equal',
		icon: (
			<svg
				width="100"
				height="50"
				viewBox="0 0 114 60" 
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<path
					fillRule="evenodd"
					clipRule="evenodd"
					d="M2 0C0.895416 0 0 0.895447 0 2V58C0 59.1046 0.895416 60 2 60H25C26.1046 60 27 59.1046 27 58V2C27 0.895447 26.1046 0 25 0H2ZM31 0C29.8954 0 29 0.895447 29 2V58C29 59.1046 29.8954 60 31 60H54C55.1046 60 56 59.1046 56 58V2C56 0.895447 55.1046 0 54 0H31ZM89 0C87.8954 0 87 0.895447 87 2V58C87 59.1046 87.8954 60 89 60H112C113.105 60 114 59.1046 114 58V2C114 0.895447 113.105 0 112 0H89ZM58 2C58 0.895447 58.8954 0 60 0H83C84.1046 0 85 0.895447 85 2V58C85 59.1046 84.1046 60 83 60H60C58.8954 60 58 59.1046 58 58V2Z"
					fill="inherit"
				/>
			</svg>
		),
		label: __('Four columns equal split'),
		innerBlocks: [
			[ sc, { col: 3 } ],
			[ sc, { col: 3 } ],
			[ sc, { col: 3 } ],
			[ sc, { col: 3 } ],
		],
		scope: [ 'block' ],
	}];
}
	
export const RenderRowBlock = memo( Render );