/**
 * External dependencies
 */
import { withRestApiHydration } from '@kkart/block-hocs';
import { StoreNoticesProvider } from '@kkart/base-context';
import { renderFrontend } from '@kkart/base-utils';

/**
 * Internal dependencies
 */
import Block from './block';

/**
 * Wrapper component to supply the notice provider.
 *
 * @param {*} props
 */
const AllProductsFrontend = ( props ) => {
	return (
		<StoreNoticesProvider context="kkart/all-products">
			<Block { ...props } />
		</StoreNoticesProvider>
	);
};

const getProps = ( el ) => ( {
	attributes: JSON.parse( el.dataset.attributes ),
} );

renderFrontend( {
	selector: '.wp-block-kkart-all-products',
	Block: withRestApiHydration( AllProductsFrontend ),
	getProps,
} );
