/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import PropTypes from 'prop-types';
import SortSelect from '@kkart/base-components/sort-select';

/**
 * Internal dependencies
 */
import './style.scss';

const ReviewSortSelect = ( { defaultValue, onChange, readOnly, value } ) => {
	return (
		<SortSelect
			className="kkart-block-review-sort-select kkart-block-components-review-sort-select"
			defaultValue={ defaultValue }
			label={ __( 'Order by', 'kkart' ) }
			onChange={ onChange }
			options={ [
				{
					key: 'most-recent',
					label: __( 'Most recent', 'kkart' ),
				},
				{
					key: 'highest-rating',
					label: __(
						'Highest rating',
						'kkart'
					),
				},
				{
					key: 'lowest-rating',
					label: __(
						'Lowest rating',
						'kkart'
					),
				},
			] }
			readOnly={ readOnly }
			screenReaderLabel={ __(
				'Order reviews by',
				'kkart'
			) }
			value={ value }
		/>
	);
};

ReviewSortSelect.propTypes = {
	defaultValue: PropTypes.oneOf( [
		'most-recent',
		'highest-rating',
		'lowest-rating',
	] ),
	onChange: PropTypes.func,
	readOnly: PropTypes.bool,
	value: PropTypes.oneOf( [
		'most-recent',
		'highest-rating',
		'lowest-rating',
	] ),
};

export default ReviewSortSelect;
