/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import Label from '@kkart/base-components/label';

/**
 * Internal dependencies
 */
import './style.scss';

const FilterSubmitButton = ( {
	className,
	disabled,
	// translators: Submit button text for filters.
	label = __( 'Go', 'kkart' ),
	onClick,
	screenReaderLabel = __( 'Apply filter', 'kkart' ),
} ) => {
	return (
		<button
			type="submit"
			className={ classNames(
				'kkart-block-filter-submit-button',
				'kkart-block-components-filter-submit-button',
				className
			) }
			disabled={ disabled }
			onClick={ onClick }
		>
			<Label label={ label } screenReaderLabel={ screenReaderLabel } />
		</button>
	);
};

FilterSubmitButton.propTypes = {
	className: PropTypes.string,
	/**
	 * Is the button disabled?
	 */
	disabled: PropTypes.bool,
	/**
	 * On click callback.
	 */
	onClick: PropTypes.func.isRequired,
	label: PropTypes.string,
	screenReaderLabel: PropTypes.string,
};

FilterSubmitButton.defaultProps = {
	disabled: false,
};

export default FilterSubmitButton;
