<?php
/**
 * Kkart Admin Mobile App Note Provider.
 *
 * Adds a note to the merchant's inbox showing the benefits of the mobile app.
 */

namespace Automattic\Kkart\Admin\Notes;

defined( 'ABSPATH' ) || exit;

/**
 * Mobile_App
 */
class MobileApp {
	/**
	 * Note traits.
	 */
	use NoteTraits;

	/**
	 * Name of the note for use in the database.
	 */
	const NOTE_NAME = 'kkart-admin-mobile-app';

	/**
	 * Get the note.
	 *
	 * @return Note
	 */
	public static function get_note() {
		// We want to show the mobile app note after day 2.
		$two_days_in_seconds = 2 * DAY_IN_SECONDS;
		if ( ! self::kkart_admin_active_for( $two_days_in_seconds ) ) {
			return;
		}

		$content = __( 'Install the Kkart mobile app to manage orders, receive sales notifications, and view key metrics — wherever you are.', 'kkart' );

		$note = new Note();
		$note->set_title( __( 'Install Woo mobile app', 'kkart' ) );
		$note->set_content( $content );
		$note->set_content_data( (object) array() );
		$note->set_type( Note::E_KKART_ADMIN_NOTE_INFORMATIONAL );
		$note->set_name( self::NOTE_NAME );
		$note->set_source( 'kkart-admin' );
		$note->add_action( 'learn-more', __( 'Learn more', 'kkart' ), 'https://kkart.com/mobile/' );
		return $note;
	}
}
