/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { Placeholder, Button } from 'wordpress-components';
import { Icon, truck } from '@kkart/icons';
import { ADMIN_URL } from '@kkart/settings';

/**
 * Internal dependencies
 */
import './style.scss';

const NoShippingPlaceholder = () => {
	return (
		<Placeholder
			icon={ <Icon srcElement={ truck } /> }
			label={ __( 'Shipping options', 'kkart' ) }
			className="kkart-block-checkout__no-shipping-placeholder"
		>
			<span className="kkart-block-checkout__no-shipping-placeholder-description">
				{ __(
					'Your store does not have any Shipping Options configured. Once you have added your Shipping Options they will appear here.',
					'kkart'
				) }
			</span>
			<Button
				isDefault
				href={ `${ ADMIN_URL }admin.php?page=kkart-settings&tab=shipping` }
				target="_blank"
				rel="noopener noreferrer"
			>
				{ __(
					'Configure Shipping Options',
					'kkart'
				) }
			</Button>
		</Placeholder>
	);
};

export default NoShippingPlaceholder;
