<?php

//////////////////////////////////////////////////////////////
//===========================================================
// template.php
//===========================================================
// KKART
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Pulkit Gupta
// Date:       23rd Jan 2017
// Time:       23:00 hrs
// Site:       http://kkart.com/wordpress (KKART)
// ----------------------------------------------------------
// Please Read the Terms of use at http://kkart.com/tos
// ----------------------------------------------------------
//===========================================================
// (c)Kkart Team
//===========================================================
//////////////////////////////////////////////////////////////

// Are we being accessed directly ?
if(!defined('KKART_VERSION')) {
	exit('Hacking Attempt !');
}

//add_action('init', 'kkart_template_builder', 99999);
function kkart_template_builder($builder){
	global $pagelayer;
	
	$condition = [];
	$post_type = 'product';
	$label = __('Products');
	
	$condition[$label] = [ //TC: Need to change the name of variable 
		$post_type =>  array(
			'label' => $label,
			'check_conditions' => function ( $args = null ) use ($post_type){
				return is_shop();
			},
			'no_id_section' => 1, // Id select section not required
		),
	];
		
	$taxonomies = get_object_taxonomies( $post_type, 'objects' );
	$post_taxonomies = wp_filter_object_list( $taxonomies, [
		'public' => true,
		'show_in_nav_menus' => true,
	] );
	
	foreach ( $post_taxonomies as $slug => $object ) {
		
		$condition[$label] += [
			$object->name =>  array(
				'label' => sprintf( __( '%s' ), $object->label ),
				'check_conditions' => function ( $args = null ) use ($object){
					$taxonomy = $object->name;
					$id = (int) $args['id'];

					if ( 'category' === $taxonomy ) {
						return is_category( $id );
					}

					if ( 'post_tag' === $taxonomy ) {
						return is_tag( $id );
					}

					return is_tax( $taxonomy, $id );
				},
				'filter_type' => 'taxonomy',
				'object_type' => $object->name,
			),
		];

	}
	
	$pagelayer->builder['shop_archives_templates'] = $condition;
	$pagelayer->builder['type']['shop_archive'] = array(
		'label' => __('Shop Archive'),
		'need_selection' => 'shop_archives',
	);
	$pagelayer->builder['dispay_on']['shop_archives'] = array(
		'label' => __('Shop Archives'),
		'check_conditions' => function ( $args = null ){ 
			return is_shop();
		},
	);
	
	// Set Pagelayer template Id
	add_action('pagelayer_builder_template_redirect', 'kkart_builder_template_redirect');
}

// Set template post
function kkart_builder_template_redirect(){
	global $pagelayer;
	
	$shop_archive = pagelayer_builder_try_to_apply('shop_archive');
	
	if(!is_shop() || empty($shop_archive)){
		return;
	}
	
	$pagelayer->template_post = $shop_archive;
}