import { useState} from '@wordpress/element';
import { dispatch } from '@wordpress/data';

export const RenderScreenIcons = (props) =>{
	
	const { deviceType } = props;
	const [activeMode, setActiveMode] = useState(deviceType || 'desktop');
	const [visibleMode, setVisibleMode] = useState(false);
	
	const modes = {
		desktop: 'Desktop',
		tablet: 'Tablet',
		mobile: 'Mobile'
	};
		
	const handleModeChange = (mode) => {
		if ( null !== dispatch( 'core/edit-post' ) ) {
			const { __experimentalSetPreviewDeviceType: setPreviewDeviceType } = dispatch( 'core/edit-post' );
			setPreviewDeviceType(modes[mode]);
		}
		setActiveMode(mode);
		setVisibleMode( !visibleMode );
	};
	
	return (
		<>
			<div className="pagelayer-elp-screen">
				{Object.keys(modes).map((mode) => (
					<i
					key={mode}
					className={`pli pli-${mode} ${visibleMode ? 'open' : ''}`}
					onClick={() => handleModeChange(mode)}
					></i>
				))}
				<i className={`pagelayer-prop-screen pli pli-${activeMode}`} onClick={() => setVisibleMode( !visibleMode ) } ></i>
			</div>
		</>
	);	
}
