/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { Icon, reader } from '@kkart/icons';
import { getBlockMap } from '@kkart/atomic-utils';

export const BLOCK_NAME = 'kkart/single-product';
export const BLOCK_TITLE = __(
	'Single Product',
	'kkart'
);
export const BLOCK_ICON = <Icon srcElement={ reader } />;
export const BLOCK_DESCRIPTION = __(
	'Display a single product.',
	'kkart'
);

export const DEFAULT_INNER_BLOCKS = [
	[
		'core/columns',
		{},
		[
			[
				'core/column',
				{},
				[ [ 'kkart/product-image', { showSaleBadge: false } ] ],
			],
			[
				'core/column',
				{},
				[
					[ 'kkart/product-sale-badge' ],
					[ 'kkart/product-title', { headingLevel: 2 } ],
					[ 'kkart/product-rating' ],
					[ 'kkart/product-price' ],
					[ 'kkart/product-summary' ],
					[ 'kkart/product-stock-indicator' ],
					[
						'kkart/product-add-to-cart',
						{ showFormElements: true },
					],
					[ 'kkart/product-sku' ],
					[ 'kkart/product-category-list' ],
					[ 'kkart/product-tag-list' ],
				],
			],
		],
	],
];

export const ALLOWED_INNER_BLOCKS = [
	'core/columns',
	'core/column',
	...Object.keys( getBlockMap( BLOCK_NAME ) ),
];
