<?php
/**
 * Settings for PayPal Standard Gateway.
 *
 * @package Kkart\Classes\Payment
 */

defined( 'ABSPATH' ) || exit;

return array(
	'enabled'               => array(
		'title'   => __( 'Enable/Disable', 'kkart' ),
		'type'    => 'checkbox',
		'label'   => __( 'Enable PayPal Standard', 'kkart' ),
		'default' => 'no',
	),
	'title'                 => array(
		'title'       => __( 'Title', 'kkart' ),
		'type'        => 'text',
		'description' => __( 'This controls the title which the user sees during checkout.', 'kkart' ),
		'default'     => __( 'PayPal', 'kkart' ),
		'desc_tip'    => true,
	),
	'description'           => array(
		'title'       => __( 'Description', 'kkart' ),
		'type'        => 'text',
		'desc_tip'    => true,
		'description' => __( 'This controls the description which the user sees during checkout.', 'kkart' ),
		'default'     => __( "Pay via PayPal; you can pay with your credit card if you don't have a PayPal account.", 'kkart' ),
	),
	'email'                 => array(
		'title'       => __( 'PayPal email', 'kkart' ),
		'type'        => 'email',
		'description' => __( 'Please enter your PayPal email address; this is needed in order to take payment.', 'kkart' ),
		'default'     => get_option( 'admin_email' ),
		'desc_tip'    => true,
		'placeholder' => 'you@youremail.com',
	),
	'advanced'              => array(
		'title'       => __( 'Advanced options', 'kkart' ),
		'type'        => 'title',
		'description' => '',
	),
	'testmode'              => array(
		'title'       => __( 'PayPal sandbox', 'kkart' ),
		'type'        => 'checkbox',
		'label'       => __( 'Enable PayPal sandbox', 'kkart' ),
		'default'     => 'no',
		/* translators: %s: URL */
		'description' => sprintf( __( 'PayPal sandbox can be used to test payments. Sign up for a <a href="%s">developer account</a>.', 'kkart' ), 'https://developer.paypal.com/' ),
	),
	'debug'                 => array(
		'title'       => __( 'Debug log', 'kkart' ),
		'type'        => 'checkbox',
		'label'       => __( 'Enable logging', 'kkart' ),
		'default'     => 'no',
		/* translators: %s: URL */
		'description' => sprintf( __( 'Log PayPal events, such as IPN requests, inside %s Note: this may log personal information. We recommend using this for debugging purposes only and deleting the logs when finished.', 'kkart' ), '<code>' . KKART_Log_Handler_File::get_log_file_path( 'paypal' ) . '</code>' ),
	),
	'ipn_notification'      => array(
		'title'       => __( 'IPN Email Notifications', 'kkart' ),
		'type'        => 'checkbox',
		'label'       => __( 'Enable IPN email notifications', 'kkart' ),
		'default'     => 'yes',
		'description' => __( 'Send notifications when an IPN is received from PayPal indicating refunds, chargebacks and cancellations.', 'kkart' ),
	),
	'receiver_email'        => array(
		'title'       => __( 'Receiver email', 'kkart' ),
		'type'        => 'email',
		'description' => __( 'If your main PayPal email differs from the PayPal email entered above, input your main receiver email for your PayPal account here. This is used to validate IPN requests.', 'kkart' ),
		'default'     => '',
		'desc_tip'    => true,
		'placeholder' => 'you@youremail.com',
	),
	'identity_token'        => array(
		'title'       => __( 'PayPal identity token', 'kkart' ),
		'type'        => 'text',
		'description' => __( 'Optionally enable "Payment Data Transfer" (Profile > Profile and Settings > My Selling Tools > Website Preferences) and then copy your identity token here. This will allow payments to be verified without the need for PayPal IPN.', 'kkart' ),
		'default'     => '',
		'desc_tip'    => true,
		'placeholder' => '',
	),
	'invoice_prefix'        => array(
		'title'       => __( 'Invoice prefix', 'kkart' ),
		'type'        => 'text',
		'description' => __( 'Please enter a prefix for your invoice numbers. If you use your PayPal account for multiple stores ensure this prefix is unique as PayPal will not allow orders with the same invoice number.', 'kkart' ),
		'default'     => 'KKART-',
		'desc_tip'    => true,
	),
	'send_shipping'         => array(
		'title'       => __( 'Shipping details', 'kkart' ),
		'type'        => 'checkbox',
		'label'       => __( 'Send shipping details to PayPal instead of billing.', 'kkart' ),
		'description' => __( 'PayPal allows us to send one address. If you are using PayPal for shipping labels you may prefer to send the shipping address rather than billing. Turning this option off may prevent PayPal Seller protection from applying.', 'kkart' ),
		'default'     => 'yes',
	),
	'address_override'      => array(
		'title'       => __( 'Address override', 'kkart' ),
		'type'        => 'checkbox',
		'label'       => __( 'Enable "address_override" to prevent address information from being changed.', 'kkart' ),
		'description' => __( 'PayPal verifies addresses therefore this setting can cause errors (we recommend keeping it disabled).', 'kkart' ),
		'default'     => 'no',
	),
	'paymentaction'         => array(
		'title'       => __( 'Payment action', 'kkart' ),
		'type'        => 'select',
		'class'       => 'kkart-enhanced-select',
		'description' => __( 'Choose whether you wish to capture funds immediately or authorize payment only.', 'kkart' ),
		'default'     => 'sale',
		'desc_tip'    => true,
		'options'     => array(
			'sale'          => __( 'Capture', 'kkart' ),
			'authorization' => __( 'Authorize', 'kkart' ),
		),
	),
	'page_style'            => array(
		'title'       => __( 'Page style', 'kkart' ),
		'type'        => 'text',
		'description' => __( 'Optionally enter the name of the page style you wish to use. These are defined within your PayPal account. This affects classic PayPal checkout screens.', 'kkart' ),
		'default'     => '',
		'desc_tip'    => true,
		'placeholder' => __( 'Optional', 'kkart' ),
	),
	'image_url'             => array(
		'title'       => __( 'Image url', 'kkart' ),
		'type'        => 'text',
		'description' => __( 'Optionally enter the URL to a 150x50px image displayed as your logo in the upper left corner of the PayPal checkout pages.', 'kkart' ),
		'default'     => '',
		'desc_tip'    => true,
		'placeholder' => __( 'Optional', 'kkart' ),
	),
	'api_details'           => array(
		'title'       => __( 'API credentials', 'kkart' ),
		'type'        => 'title',
		/* translators: %s: URL */
		'description' => sprintf( __( 'Enter your PayPal API credentials to process refunds via PayPal. Learn how to access your <a href="%s">PayPal API Credentials</a>.', 'kkart' ), 'https://developer.paypal.com/webapps/developer/docs/classic/api/apiCredentials/#create-an-api-signature' ),
	),
	'api_username'          => array(
		'title'       => __( 'Live API username', 'kkart' ),
		'type'        => 'text',
		'description' => __( 'Get your API credentials from PayPal.', 'kkart' ),
		'default'     => '',
		'desc_tip'    => true,
		'placeholder' => __( 'Optional', 'kkart' ),
	),
	'api_password'          => array(
		'title'       => __( 'Live API password', 'kkart' ),
		'type'        => 'password',
		'description' => __( 'Get your API credentials from PayPal.', 'kkart' ),
		'default'     => '',
		'desc_tip'    => true,
		'placeholder' => __( 'Optional', 'kkart' ),
	),
	'api_signature'         => array(
		'title'       => __( 'Live API signature', 'kkart' ),
		'type'        => 'password',
		'description' => __( 'Get your API credentials from PayPal.', 'kkart' ),
		'default'     => '',
		'desc_tip'    => true,
		'placeholder' => __( 'Optional', 'kkart' ),
	),
	'sandbox_api_username'  => array(
		'title'       => __( 'Sandbox API username', 'kkart' ),
		'type'        => 'text',
		'description' => __( 'Get your API credentials from PayPal.', 'kkart' ),
		'default'     => '',
		'desc_tip'    => true,
		'placeholder' => __( 'Optional', 'kkart' ),
	),
	'sandbox_api_password'  => array(
		'title'       => __( 'Sandbox API password', 'kkart' ),
		'type'        => 'password',
		'description' => __( 'Get your API credentials from PayPal.', 'kkart' ),
		'default'     => '',
		'desc_tip'    => true,
		'placeholder' => __( 'Optional', 'kkart' ),
	),
	'sandbox_api_signature' => array(
		'title'       => __( 'Sandbox API signature', 'kkart' ),
		'type'        => 'password',
		'description' => __( 'Get your API credentials from PayPal.', 'kkart' ),
		'default'     => '',
		'desc_tip'    => true,
		'placeholder' => __( 'Optional', 'kkart' ),
	),
);
