<?php
/**
 * Deprecated filter hooks
 *
 * @package Kkart\Abstracts
 * @since   3.0.0
 * @version 3.3.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Handles deprecation notices and triggering of legacy filter hooks
 */
class KKART_Deprecated_Filter_Hooks extends KKART_Deprecated_Hooks {

	/**
	 * Array of deprecated hooks we need to handle.
	 * Format of 'new' => 'old'.
	 *
	 * @var array
	 */
	protected $deprecated_hooks = array(
		'kkart_structured_data_order'          => 'kkart_email_order_schema_markup',
		'kkart_add_to_cart_fragments'          => 'add_to_cart_fragments',
		'kkart_add_to_cart_redirect'           => 'add_to_cart_redirect',
		'kkart_product_get_width'              => 'kkart_product_width',
		'kkart_product_get_height'             => 'kkart_product_height',
		'kkart_product_get_length'             => 'kkart_product_length',
		'kkart_product_get_weight'             => 'kkart_product_weight',
		'kkart_product_get_sku'                => 'kkart_get_sku',
		'kkart_product_get_price'              => 'kkart_get_price',
		'kkart_product_get_regular_price'      => 'kkart_get_regular_price',
		'kkart_product_get_sale_price'         => 'kkart_get_sale_price',
		'kkart_product_get_tax_class'          => 'kkart_product_tax_class',
		'kkart_product_get_stock_quantity'     => 'kkart_get_stock_quantity',
		'kkart_product_get_attributes'         => 'kkart_get_product_attributes',
		'kkart_product_get_gallery_image_ids'  => 'kkart_product_gallery_attachment_ids',
		'kkart_product_get_review_count'       => 'kkart_product_review_count',
		'kkart_product_get_downloads'          => 'kkart_product_files',
		'kkart_order_get_currency'             => 'kkart_get_currency',
		'kkart_order_get_discount_total'       => 'kkart_order_amount_discount_total',
		'kkart_order_get_discount_tax'         => 'kkart_order_amount_discount_tax',
		'kkart_order_get_shipping_total'       => 'kkart_order_amount_shipping_total',
		'kkart_order_get_shipping_tax'         => 'kkart_order_amount_shipping_tax',
		'kkart_order_get_cart_tax'             => 'kkart_order_amount_cart_tax',
		'kkart_order_get_total'                => 'kkart_order_amount_total',
		'kkart_order_get_total_tax'            => 'kkart_order_amount_total_tax',
		'kkart_order_get_total_discount'       => 'kkart_order_amount_total_discount',
		'kkart_order_get_subtotal'             => 'kkart_order_amount_subtotal',
		'kkart_order_get_tax_totals'           => 'kkart_order_tax_totals',
		'kkart_get_order_refund_get_amount'    => 'kkart_refund_amount',
		'kkart_get_order_refund_get_reason'    => 'kkart_refund_reason',
		'default_checkout_billing_country'           => 'default_checkout_country',
		'default_checkout_billing_state'             => 'default_checkout_state',
		'default_checkout_billing_postcode'          => 'default_checkout_postcode',
		'kkart_system_status_environment_rows' => 'kkart_debug_posting',
		'kkart_credit_card_type_labels'        => 'wocommerce_credit_card_type_labels',
		'kkart_settings_tabs_advanced'         => 'kkart_settings_tabs_api',
		'kkart_settings_advanced'              => 'kkart_settings_api',
	);

	/**
	 * Array of versions on each hook has been deprecated.
	 *
	 * @var array
	 */
	protected $deprecated_version = array(
		'kkart_email_order_schema_markup'      => '3.0.0',
		'add_to_cart_fragments'                      => '3.0.0',
		'add_to_cart_redirect'                       => '3.0.0',
		'kkart_product_width'                  => '3.0.0',
		'kkart_product_height'                 => '3.0.0',
		'kkart_product_length'                 => '3.0.0',
		'kkart_product_weight'                 => '3.0.0',
		'kkart_get_sku'                        => '3.0.0',
		'kkart_get_price'                      => '3.0.0',
		'kkart_get_regular_price'              => '3.0.0',
		'kkart_get_sale_price'                 => '3.0.0',
		'kkart_product_tax_class'              => '3.0.0',
		'kkart_get_stock_quantity'             => '3.0.0',
		'kkart_get_product_attributes'         => '3.0.0',
		'kkart_product_gallery_attachment_ids' => '3.0.0',
		'kkart_product_review_count'           => '3.0.0',
		'kkart_product_files'                  => '3.0.0',
		'kkart_get_currency'                   => '3.0.0',
		'kkart_order_amount_discount_total'    => '3.0.0',
		'kkart_order_amount_discount_tax'      => '3.0.0',
		'kkart_order_amount_shipping_total'    => '3.0.0',
		'kkart_order_amount_shipping_tax'      => '3.0.0',
		'kkart_order_amount_cart_tax'          => '3.0.0',
		'kkart_order_amount_total'             => '3.0.0',
		'kkart_order_amount_total_tax'         => '3.0.0',
		'kkart_order_amount_total_discount'    => '3.0.0',
		'kkart_order_amount_subtotal'          => '3.0.0',
		'kkart_order_tax_totals'               => '3.0.0',
		'kkart_refund_amount'                  => '3.0.0',
		'kkart_refund_reason'                  => '3.0.0',
		'default_checkout_country'                   => '3.0.0',
		'default_checkout_state'                     => '3.0.0',
		'default_checkout_postcode'                  => '3.0.0',
		'kkart_debug_posting'                  => '3.0.0',
		'wocommerce_credit_card_type_labels'         => '3.0.0',
		'kkart_settings_tabs_api'              => '3.4.0',
		'kkart_settings_api'                   => '3.4.0',
	);

	/**
	 * Hook into the new hook so we can handle deprecated hooks once fired.
	 *
	 * @param string $hook_name Hook name.
	 */
	public function hook_in( $hook_name ) {
		add_filter( $hook_name, array( $this, 'maybe_handle_deprecated_hook' ), -1000, 8 );
	}

	/**
	 * If the old hook is in-use, trigger it.
	 *
	 * @param  string $new_hook          New hook name.
	 * @param  string $old_hook          Old hook name.
	 * @param  array  $new_callback_args New callback args.
	 * @param  mixed  $return_value      Returned value.
	 * @return mixed
	 */
	public function handle_deprecated_hook( $new_hook, $old_hook, $new_callback_args, $return_value ) {
		if ( has_filter( $old_hook ) ) {
			$this->display_notice( $old_hook, $new_hook );
			$return_value = $this->trigger_hook( $old_hook, $new_callback_args );
		}
		return $return_value;
	}

	/**
	 * Fire off a legacy hook with it's args.
	 *
	 * @param  string $old_hook          Old hook name.
	 * @param  array  $new_callback_args New callback args.
	 * @return mixed
	 */
	protected function trigger_hook( $old_hook, $new_callback_args ) {
		return apply_filters_ref_array( $old_hook, $new_callback_args );
	}
}
