<?php
/**
 * Tax settings.
 *
 * @package Kkart\Admin\Settings.
 */

defined( 'ABSPATH' ) || exit;

$settings = array(

	array(
		'title' => __( 'Tax options', 'kkart' ),
		'type'  => 'title',
		'desc'  => '',
		'id'    => 'tax_options',
	),

	array(
		'title'    => __( 'Prices entered with tax', 'kkart' ),
		'id'       => 'kkart_prices_include_tax',
		'default'  => 'no',
		'type'     => 'radio',
		'desc_tip' => __( 'This option is important as it will affect how you input prices. Changing it will not update existing products.', 'kkart' ),
		'options'  => array(
			'yes' => __( 'Yes, I will enter prices inclusive of tax', 'kkart' ),
			'no'  => __( 'No, I will enter prices exclusive of tax', 'kkart' ),
		),
	),

	array(
		'title'    => __( 'Calculate tax based on', 'kkart' ),
		'id'       => 'kkart_tax_based_on',
		'desc_tip' => __( 'This option determines which address is used to calculate tax.', 'kkart' ),
		'default'  => 'shipping',
		'type'     => 'select',
		'class'    => 'kkart-enhanced-select',
		'options'  => array(
			'shipping' => __( 'Customer shipping address', 'kkart' ),
			'billing'  => __( 'Customer billing address', 'kkart' ),
			'base'     => __( 'Shop base address', 'kkart' ),
		),
	),

	'shipping-tax-class' => array(
		'title'    => __( 'Shipping tax class', 'kkart' ),
		'desc'     => __( 'Optionally control which tax class shipping gets, or leave it so shipping tax is based on the cart items themselves.', 'kkart' ),
		'id'       => 'kkart_shipping_tax_class',
		'css'      => 'min-width:150px;',
		'default'  => 'inherit',
		'type'     => 'select',
		'class'    => 'kkart-enhanced-select',
		'options'  => array( 'inherit' => __( 'Shipping tax class based on cart items', 'kkart' ) ) + kkart_get_product_tax_class_options(),
		'desc_tip' => true,
	),

	array(
		'title'   => __( 'Rounding', 'kkart' ),
		'desc'    => __( 'Round tax at subtotal level, instead of rounding per line', 'kkart' ),
		'id'      => 'kkart_tax_round_at_subtotal',
		'default' => 'no',
		'type'    => 'checkbox',
	),

	array(
		'title'     => __( 'Additional tax classes', 'kkart' ),
		'desc_tip'  => __( 'List additional tax classes you need below (1 per line, e.g. Reduced Rates). These are in addition to "Standard rate" which exists by default.', 'kkart' ),
		'id'        => 'kkart_tax_classes',
		'css'       => 'height: 65px;',
		'type'      => 'textarea',
		'default'   => '',
		'is_option' => false,
		'value'     => implode( "\n", KKART_Tax::get_tax_classes() ),
	),

	array(
		'title'   => __( 'Display prices in the shop', 'kkart' ),
		'id'      => 'kkart_tax_display_shop',
		'default' => 'excl',
		'type'    => 'select',
		'class'   => 'kkart-enhanced-select',
		'options' => array(
			'incl' => __( 'Including tax', 'kkart' ),
			'excl' => __( 'Excluding tax', 'kkart' ),
		),
	),

	array(
		'title'   => __( 'Display prices during cart and checkout', 'kkart' ),
		'id'      => 'kkart_tax_display_cart',
		'default' => 'excl',
		'type'    => 'select',
		'class'   => 'kkart-enhanced-select',
		'options' => array(
			'incl' => __( 'Including tax', 'kkart' ),
			'excl' => __( 'Excluding tax', 'kkart' ),
		),
	),

	array(
		'title'       => __( 'Price display suffix', 'kkart' ),
		'id'          => 'kkart_price_display_suffix',
		'default'     => '',
		'placeholder' => __( 'N/A', 'kkart' ),
		'type'        => 'text',
		'desc_tip'    => __( 'Define text to show after your product prices. This could be, for example, "inc. Vat" to explain your pricing. You can also have prices substituted here using one of the following: {price_including_tax}, {price_excluding_tax}.', 'kkart' ),
	),

	array(
		'title'    => __( 'Display tax totals', 'kkart' ),
		'id'       => 'kkart_tax_total_display',
		'default'  => 'itemized',
		'type'     => 'select',
		'class'    => 'kkart-enhanced-select',
		'options'  => array(
			'single'   => __( 'As a single total', 'kkart' ),
			'itemized' => __( 'Itemized', 'kkart' ),
		),
		'autoload' => false,
	),

	array(
		'type' => 'sectionend',
		'id'   => 'tax_options',
	),

);

if ( ! kkart_shipping_enabled() ) {
	unset( $settings['shipping-tax-class'] );
}

return apply_filters( 'kkart_tax_settings', $settings );
