<?php
/**
 * Product general data panel.
 *
 * @package Kkart\Admin
 */

defined( 'ABSPATH' ) || exit;

?>
<div id="general_product_data" class="panel kkart_options_panel">

	<div class="options_group show_if_external">
		<?php
		kkart_wp_text_input(
			array(
				'id'          => '_product_url',
				'value'       => is_callable( array( $product_object, 'get_product_url' ) ) ? $product_object->get_product_url( 'edit' ) : '',
				'label'       => __( 'Product URL', 'kkart' ),
				'placeholder' => 'https://',
				'description' => __( 'Enter the external URL to the product.', 'kkart' ),
			)
		);

		kkart_wp_text_input(
			array(
				'id'          => '_button_text',
				'value'       => is_callable( array( $product_object, 'get_button_text' ) ) ? $product_object->get_button_text( 'edit' ) : '',
				'label'       => __( 'Button text', 'kkart' ),
				'placeholder' => _x( 'Buy product', 'placeholder', 'kkart' ),
				'description' => __( 'This text will be shown on the button linking to the external product.', 'kkart' ),
			)
		);
		?>
	</div>

	<div class="options_group pricing show_if_simple show_if_external hidden">
		<?php
		kkart_wp_text_input(
			array(
				'id'        => '_regular_price',
				'value'     => $product_object->get_regular_price( 'edit' ),
				'label'     => __( 'Regular price', 'kkart' ) . ' (' . get_kkart_currency_symbol() . ')',
				'data_type' => 'price',
			)
		);

		kkart_wp_text_input(
			array(
				'id'          => '_sale_price',
				'value'       => $product_object->get_sale_price( 'edit' ),
				'data_type'   => 'price',
				'label'       => __( 'Sale price', 'kkart' ) . ' (' . get_kkart_currency_symbol() . ')',
				'description' => '<a href="#" class="sale_schedule">' . __( 'Schedule', 'kkart' ) . '</a>',
			)
		);

		$sale_price_dates_from_timestamp = $product_object->get_date_on_sale_from( 'edit' ) ? $product_object->get_date_on_sale_from( 'edit' )->getOffsetTimestamp() : false;
		$sale_price_dates_to_timestamp   = $product_object->get_date_on_sale_to( 'edit' ) ? $product_object->get_date_on_sale_to( 'edit' )->getOffsetTimestamp() : false;

		$sale_price_dates_from = $sale_price_dates_from_timestamp ? date_i18n( 'Y-m-d', $sale_price_dates_from_timestamp ) : '';
		$sale_price_dates_to   = $sale_price_dates_to_timestamp ? date_i18n( 'Y-m-d', $sale_price_dates_to_timestamp ) : '';

		echo '<p class="form-field sale_price_dates_fields">
				<label for="_sale_price_dates_from">' . esc_html__( 'Sale price dates', 'kkart' ) . '</label>
				<input type="text" class="short" name="_sale_price_dates_from" id="_sale_price_dates_from" value="' . esc_attr( $sale_price_dates_from ) . '" placeholder="' . esc_html( _x( 'From&hellip;', 'placeholder', 'kkart' ) ) . ' YYYY-MM-DD" maxlength="10" pattern="' . esc_attr( apply_filters( 'kkart_date_input_html_pattern', '[0-9]{4}-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])' ) ) . '" />
				<input type="text" class="short" name="_sale_price_dates_to" id="_sale_price_dates_to" value="' . esc_attr( $sale_price_dates_to ) . '" placeholder="' . esc_html( _x( 'To&hellip;', 'placeholder', 'kkart' ) ) . '  YYYY-MM-DD" maxlength="10" pattern="' . esc_attr( apply_filters( 'kkart_date_input_html_pattern', '[0-9]{4}-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])' ) ) . '" />
				<a href="#" class="description cancel_sale_schedule">' . esc_html__( 'Cancel', 'kkart' ) . '</a>' . kkart_help_tip( __( 'The sale will start at 00:00:00 of "From" date and end at 23:59:59 of "To" date.', 'kkart' ) ) . '
			</p>';

		do_action( 'kkart_product_options_pricing' );
		?>
	</div>

	<div class="options_group show_if_downloadable hidden">
		<div class="form-field downloadable_files">
			<label><?php esc_html_e( 'Downloadable files', 'kkart' ); ?></label>
			<table class="widefat">
				<thead>
					<tr>
						<th class="sort">&nbsp;</th>
						<th><?php esc_html_e( 'Name', 'kkart' ); ?> <?php echo kkart_help_tip( __( 'This is the name of the download shown to the customer.', 'kkart' ) ); ?></th>
						<th colspan="2"><?php esc_html_e( 'File URL', 'kkart' ); ?> <?php echo kkart_help_tip( __( 'This is the URL or absolute path to the file which customers will get access to. URLs entered here should already be encoded.', 'kkart' ) ); ?></th>
						<th>&nbsp;</th>
					</tr>
				</thead>
				<tbody>
					<?php
					$downloadable_files = $product_object->get_downloads( 'edit' );
					if ( $downloadable_files ) {
						foreach ( $downloadable_files as $key => $file ) {
							include __DIR__ . '/html-product-download.php';
						}
					}
					?>
				</tbody>
				<tfoot>
					<tr>
						<th colspan="5">
							<a href="#" class="button insert" data-row="
							<?php
								$key  = '';
								$file = array(
									'file' => '',
									'name' => '',
								);
								ob_start();
								require __DIR__ . '/html-product-download.php';
								echo esc_attr( ob_get_clean() );
								?>
							"><?php esc_html_e( 'Add File', 'kkart' ); ?></a>
						</th>
					</tr>
				</tfoot>
			</table>
		</div>
		<?php
		kkart_wp_text_input(
			array(
				'id'                => '_download_limit',
				'value'             => -1 === $product_object->get_download_limit( 'edit' ) ? '' : $product_object->get_download_limit( 'edit' ),
				'label'             => __( 'Download limit', 'kkart' ),
				'placeholder'       => __( 'Unlimited', 'kkart' ),
				'description'       => __( 'Leave blank for unlimited re-downloads.', 'kkart' ),
				'type'              => 'number',
				'custom_attributes' => array(
					'step' => '1',
					'min'  => '0',
				),
			)
		);

		kkart_wp_text_input(
			array(
				'id'                => '_download_expiry',
				'value'             => -1 === $product_object->get_download_expiry( 'edit' ) ? '' : $product_object->get_download_expiry( 'edit' ),
				'label'             => __( 'Download expiry', 'kkart' ),
				'placeholder'       => __( 'Never', 'kkart' ),
				'description'       => __( 'Enter the number of days before a download link expires, or leave blank.', 'kkart' ),
				'type'              => 'number',
				'custom_attributes' => array(
					'step' => '1',
					'min'  => '0',
				),
			)
		);

		do_action( 'kkart_product_options_downloads' );
		?>
	</div>

	<?php if ( kkart_tax_enabled() ) : ?>
		<div class="options_group show_if_simple show_if_external show_if_variable">
			<?php
			kkart_wp_select(
				array(
					'id'          => '_tax_status',
					'value'       => $product_object->get_tax_status( 'edit' ),
					'label'       => __( 'Tax status', 'kkart' ),
					'options'     => array(
						'taxable'  => __( 'Taxable', 'kkart' ),
						'shipping' => __( 'Shipping only', 'kkart' ),
						'none'     => _x( 'None', 'Tax status', 'kkart' ),
					),
					'desc_tip'    => 'true',
					'description' => __( 'Define whether or not the entire product is taxable, or just the cost of shipping it.', 'kkart' ),
				)
			);

			kkart_wp_select(
				array(
					'id'          => '_tax_class',
					'value'       => $product_object->get_tax_class( 'edit' ),
					'label'       => __( 'Tax class', 'kkart' ),
					'options'     => kkart_get_product_tax_class_options(),
					'desc_tip'    => 'true',
					'description' => __( 'Choose a tax class for this product. Tax classes are used to apply different tax rates specific to certain types of product.', 'kkart' ),
				)
			);

			do_action( 'kkart_product_options_tax' );
			?>
		</div>
	<?php endif; ?>

	<?php do_action( 'kkart_product_options_general_product_data' ); ?>
</div>
